unit Errors;

interface

//   
const
ercNoError        = 0;
ercGeneralError   = -100;
ercParamError     = -2;
ercCreateError    = -3;
ercOpenError      = -4;
ercCloseError     = -5;
ercSeekError      = -6;
ercWriteModeError = -10;
ercReadModeError  = -11;
ercWriteError     = -20;
ercReadError      = -21;
ercCompressError  = -40;
ercDecompressError= -41;
ercConvertError   = -42;
ercDeconvertError = -43;
ercCRC32CalcError = -44;
ercCRC32Error     = -45;

resourcestring
strGeneralError   = 'Error';
strParamError     = 'Error reading parameter(s)';
strCreateError    = 'Error creating file';
strOpenError      = 'Error opening file';
strCloseError     = 'Error closing file';
strSeekError      = 'Seek error';
strWriteModeError ='File not opened for write';
strReadModeError  = 'File not opened for read';
strWriteError     = 'Error writing file';
strReadError      = 'Error reading file';
strCompressError  = 'Compression error';
strDecompressError= 'Decompression error';
strConvertError   = 'Convert 256->192 error';
strDeconvertError ='Convert 192->256 error';
strCRC32CalcError ='CRC32 calculation error';
strCRC32Error     = 'CRC32 check error';

function GetErrorDescription(ErrCode: Integer): string;

implementation

function GetErrorDescription(ErrCode: Integer): string;
  begin
    case ErrCode of
      ercNoError        : Result:= '';
      ercGeneralError   : Result:= strGeneralError;
      ercParamError     : Result:= strParamError;
      ercCreateError    : Result:= strCreateError;
      ercOpenError      : Result:= strOpenError;
      ercCloseError     : Result:= strCloseError;
      ercSeekError      : Result:= strSeekError;
      ercWriteModeError : Result:= strWriteModeError;
      ercReadModeError  : Result:= strReadModeError;
      ercWriteError     : Result:= strWriteError;
      ercReadError      : Result:= strReadError;
      ercCompressError  : Result:= strCompressError;
      ercDecompressError: Result:= strDecompressError;
      ercConvertError   : Result:= strConvertError;
      ercDeconvertError : Result:= strDeconvertError;
      ercCRC32CalcError : Result:= strCRC32CalcError;
      ercCRC32Error     : Result:= strCRC32Error;
      else Result:= strGeneralError;
    end;
  end;
end.
