// This file contains functions for managing a list of "Port names".

#include <windows.h>
#include <objbase.h>
#include "IExample5.h"
#include "IEnumVariant.h"

// The IENUMLIST for our "Port names"
static IENUMLIST	PortsList;

// This is just a helper function to allocate/initialize an IDispatch
// (really, a MyRealICollection) object for our PortsList.
IDispatch * allocPortsCollection(void)
{
	// Allocate/return a collection object (actually, a MyRealICollection) wrapping PortsList
	return(allocICollection(&PortsList));
}

// This is just a helper function to free up our PortsList. Called when our DLL unloads.
void freePortsCollection(void)
{
	// Free all IENUMITEMs in PortsList
	freeEnumList(&PortsList);
}

// This is just a helper function to initialize our Ports list.
// Called when our DLL first loads.
HRESULT initPortsCollection(void)
{
	VARIANT		value;
	IENUMITEM	*item;

	PortsList.head = 0;

	// Initially set the count to 1 so this list is kept until
	// we finally call freePortsCollection
	PortsList.count = 1;

	// Create a list with 3 IENUMITEMs with BSTR values of
	// "Port 1", "Port 2", and "Port 3"
	value.vt = VT_BSTR;
	if ((value.bstrVal = SysAllocString(L"Port 1")))
	{
		if ((PortsList.head = item = allocIENUMITEM(&value)))
		{
			if ((value.bstrVal = SysAllocString(L"Port 2")))
			{
				if ((item->next = allocIENUMITEM(&value)))
				{
					item = item->next;
					if ((value.bstrVal = SysAllocString(L"Port 3")))
					{
						if ((item->next = allocIENUMITEM(&value)))
						{
							item->next->next = 0;
							return(S_OK);
						}
					}
				}
			}
		}
	}

	freePortsCollection();
	return(E_FAIL);
}