// This is a C example that tests the IMultInterface COM component (in MultInterface.dll).

#include <windows.h>
#include <objbase.h>
#include <stdio.h>
#include "../IMultInterface/IMultInterface.h"

int main(int argc, char **argv)
{
	IUnknown	*myObj;
	IBase		*baseObj;
	ISub1		*sub1Obj;
	ISub2		*sub2Obj;
	HRESULT		hr;

	// We must initialize OLE before we do anything with COM objects
	if (!CoInitialize(0))
	{
		// Get MultInterface.DLL's IMultInterface's base object
		if ((hr = CoCreateInstance(&CLSID_IMultInterface, 0, CLSCTX_INPROC_SERVER, &IID_IMultInterface, &myObj)))
			MessageBox(0, "Can't get IMultInterface base object", "CoCreateInstance error", MB_OK|MB_ICONEXCLAMATION);
		else
		{
			// Specifically ask for its IBase sub-object. This should be the same pointer as
			// "myObj" because we know it's the base object
			if ((hr = myObj->lpVtbl->QueryInterface(myObj, &IID_IBase, &baseObj)))
			{
				myObj->lpVtbl->Release(myObj);
				MessageBox(0, "Can't get IBase sub-object", "QueryInterface error", MB_OK|MB_ICONEXCLAMATION);
			}
			else
			{
				long	value;

				if (baseObj != (IBase *)myObj)
					MessageBox(0, "IBase sub-object is not the base object", "Error", MB_OK|MB_ICONEXCLAMATION);

				// Release the base object. We don't need it now that we have the
				// IBase we want
				myObj->lpVtbl->Release(myObj);

				// Call Sum to add 1 + 1
				baseObj->lpVtbl->Sum(baseObj, 1, 1, &value);
				if (value != 2) MessageBox(0, "IBase sub-object's Sum() failed", "Sum() error", MB_OK|MB_ICONEXCLAMATION);

				// Get the ISub1 sub-object from IBase sub-object's QueryInterface
				if ((hr = baseObj->lpVtbl->QueryInterface(baseObj, &IID_ISub1, &sub1Obj)))
				{
					baseObj->lpVtbl->Release(baseObj);
					MessageBox(0, "Can't get ISub1 sub-object", "QueryInterface error", MB_OK|MB_ICONEXCLAMATION);
				}
				else
				{
					// Release the base object. We don't need it now that we have the
					// ISub1 we want
					baseObj->lpVtbl->Release(baseObj);

					// Call ShowMessage() to display "Hello world!"
					sub1Obj->lpVtbl->ShowMessage(sub1Obj, "Hello World");

					// Get the ISub2 sub-object from ISub1 sub-object's QueryInterface
					if ((hr = sub1Obj->lpVtbl->QueryInterface(sub1Obj, &IID_ISub2, &sub2Obj)))
					{
						sub1Obj->lpVtbl->Release(sub1Obj);
						MessageBox(0, "Can't get ISub2 sub-object", "QueryInterface error", MB_OK|MB_ICONEXCLAMATION);
					}
					else
					{
						// Release the ISub1 sub-object. We don't need it now that we have the
						// ISub2 we want
						sub1Obj->lpVtbl->Release(sub1Obj);

						// Call Increment() to increment ISub2's value
						sub2Obj->lpVtbl->Increment(sub2Obj);

						// Call GetValue() to retrieve ISub2's value
						sub2Obj->lpVtbl->GetValue(sub2Obj, &value);
						if (value != 1)
							MessageBox(0, "ISub2 GetValue() failed", "GetValue() error", MB_OK|MB_ICONEXCLAMATION);

						// Release the ISub2 now that we're done with it
						sub2Obj->lpVtbl->Release(sub2Obj);
					}
				}
			}
		}

		// When finally done with OLE, free it
		CoUninitialize();
	}
	else
		MessageBox(0, "Can't initialize COM", "CoInitialize error", MB_OK|MB_ICONEXCLAMATION);

	return(0);
}
