#ifndef _ISORT_H_
#define _ISORT_H_

#include <initguid.h>

// ISort object's GUID
// {619321BA-4907-4596-874A-AEFF082F0014}
DEFINE_GUID(CLSID_ISort, 0x619321ba, 0x4907, 0x4596, 0x87, 0x4a, 0xae, 0xff, 0x8, 0x2f, 0x0, 0x14);

// ISort VTable's GUID
// {4C9A7D40-D0ED-45ea-9520-1CB9095973F8}
DEFINE_GUID(IID_ISort, 0x4c9a7d40, 0xd0ed, 0x45ea, 0x95, 0x20, 0x1c, 0xb9, 0x9, 0x59, 0x73, 0xf8);

// ISort's VTable
#undef  INTERFACE
#define INTERFACE ISort
DECLARE_INTERFACE_ (INTERFACE, IUnknown)
{
	// IUnknown functions
	STDMETHOD  (QueryInterface)		(THIS_ REFIID, void **) PURE;
	STDMETHOD_ (ULONG, AddRef)		(THIS) PURE;
	STDMETHOD_ (ULONG, Release)		(THIS) PURE;
	// Extra functions
	STDMETHOD  (Sort)				(THIS_ void *, DWORD, DWORD) PURE;
};

// The ICompare object must be created by an application using ISort,
// and given to ISort's ICompare IConnectPoint object (via
// IConnectPoint's Advise function).

// ICompare VTable's GUID
// {4115B8E2-1823-4bbc-B10D-3D33AAA12ACF}
DEFINE_GUID(DIID_ICompare, 0x4115b8e2, 0x1823, 0x4bbc, 0xb1, 0xd, 0x3d, 0x33, 0xaa, 0xa1, 0x2a, 0xcf);

// ICompare's VTable
#undef  INTERFACE
#define INTERFACE ICompare
DECLARE_INTERFACE_ (INTERFACE, IUnknown)
{
	// IUnknown functions
	STDMETHOD  (QueryInterface)		(THIS_ REFIID, void **) PURE;
	STDMETHOD_ (ULONG, AddRef)		(THIS) PURE;
	STDMETHOD_ (ULONG, Release)		(THIS) PURE;
	// Extra functions
	STDMETHOD_ (long, Compare)		(THIS_ const void *, const void *) PURE;
};

#endif // _ISORT_H_