#ifndef _APPOBJECT_H
#define _APPOBJECT_H

#undef  INTERFACE
#define INTERFACE IDocument
DECLARE_INTERFACE_ (INTERFACE, IDispatch)
{
	// IUnknown functions
	STDMETHOD  (QueryInterface)		(THIS_ REFIID, void **) PURE;
	STDMETHOD_ (ULONG, AddRef)		(THIS) PURE;
	STDMETHOD_ (ULONG, Release)		(THIS) PURE;
	// IDispatch functions
	STDMETHOD_ (ULONG, GetTypeInfoCount)(THIS_ UINT *) PURE;
	STDMETHOD_ (ULONG, GetTypeInfo)		(THIS_ UINT, LCID, ITypeInfo **) PURE;
	STDMETHOD_ (ULONG, GetIDsOfNames)	(THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID *) PURE;
	STDMETHOD_ (ULONG, Invoke)			(THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT *) PURE;
	// Extra functions
	STDMETHOD  (WriteText)	(THIS_ BSTR) PURE;
};

// Since we need to add private data members to our IDocument
// object, we'll define a MyRealIDocument containing those
// private members. Our MyRealIDocument contains the
// IDocument.
// NOTE: If we had more such custom objects, as long as we
// make sure that the first member is the base object, the
// second member is a pointer to its VTable's ITypeInfo, and
// the third member is our RefCount, then our VTable can reuse
// the IDocument functions _QueryInterface, _AddRef,
// _GetTypeInfoCount, _GetTypeInfo, _GetIDsOfNames, and _Invoke
// as if they were generic functions useable with any of our custom
// objects. All we'd need to do is write the Release function, and
// any extra functions we add to the end of the VTable.
typedef struct {
	IDocument			iDocument;
	ITypeInfo			*TypeInfo;
	ULONG				RefCount;
	HWND				Hwnd;
	LPTSTR				Text;
} MyRealIDocument;

extern IUnknown *	getAppObject(void);
extern HRESULT		getAppObjectITypeInfo(ITypeInfo **);
extern void			initMyRealIAppObject(void);
extern void			freeMyRealIAppObject(void);
extern HRESULT		allocIDocument(MyRealIDocument **);

#endif