#! /usr/bin/env python
# -*- coding: utf-8 -*-

from PyQt4.QtGui import *
from PyQt4.QtCore import *
from PyQt4 import uic

formclass, baseclass = uic.loadUiType ( 'm_PopupCalendar.ui' )

class m_PopupCalendar ( baseclass, formclass ) :
    """
    """
    def __init__ ( self, parent = None ):
        baseclass.__init__ ( self, parent,  Qt.Popup )
        self.setupUi ( self )
        self.setLayout ( self.gridLayout )
        self.positionCalendarPopup ( parent )
        self.calendarWidget.setFocus ()
        
        today_format = QTextCharFormat ()
        today_format.setFontWeight ( QFont.Bold )
        today_format.setFontUnderline ( True )
        #today_format.setFontItalic ( True )
        self.calendarWidget.setDateTextFormat ( QDate.currentDate (), today_format ) # emphasize today date in calendar

        self.currentPageChanged ( self.calendarWidget.selectedDate().year (), self.calendarWidget.selectedDate().month () )
        self.selectionChanged ()
        
        self.calendarWidget.activated.connect ( self.accept )
        self.calendarWidget.clicked.connect ( self.accept )
        self.calendarWidget.currentPageChanged.connect ( self.currentPageChanged )
        self.calendarWidget.selectionChanged.connect ( self.selectionChanged )
        self.NextMonth.clicked.connect ( self.calendarWidget.showNextMonth )
        self.NextYear.clicked.connect ( self.calendarWidget.showNextYear )
        self.PrevMonth.clicked.connect ( self.calendarWidget.showPreviousMonth )
        self.PrevYear.clicked.connect ( self.calendarWidget.showPreviousYear )
        
    def selectionChanged ( self ) :
        self.labelSelectedDate.setText ( self.calendarWidget.selectedDate().toString ( "dd.MM.yyyy" ) )

    def currentPageChanged ( self, year,  month ) :
        self.Month.setText ( "{0} {1:#02d}".format( year, month ) )
        months_offset = ( year - self.calendarWidget.selectedDate().year () ) * 12 + month - self.calendarWidget.selectedDate().month ()
        self.calendarWidget.setSelectedDate ( self.calendarWidget.selectedDate().addMonths ( months_offset ) )

    def positionCalendarPopup ( self, parent ) : # taken from qdatetimeedit.cpp
        if parent is None : return
        pos = parent.rect().bottomLeft()
        pos2 = parent.rect().topLeft()
        pos = parent.mapToGlobal ( pos )
        pos2 = parent.mapToGlobal ( pos2 )
        screen = QApplication.desktop().availableGeometry(pos)
        if pos.x () + self.width () > screen.right () :
            pos.setX ( max ( screen.right () - self.width (), screen.left () ) )
        if pos.y () + self.height () > screen.bottom () :
            pos.setY ( pos2.y () - self.height () )
        if pos.y () < screen.top () :
            pos.setY ( screen.top () )
        if pos.y () + self.height () > screen.bottom () :
            pos.setY ( screen.bottom () - self.height () )
        self.move ( pos )
        
    def selectedDate ( self ) :
        return self.calendarWidget.selectedDate ()
    
    def keyPressEvent ( self, event ) :
        key = event.key ()
        if event.modifiers () == Qt.NoModifier :
            if key == Qt.Key_Insert :
                self.reject ()
                return # pressing againg Insert closes popup calendar
        baseclass.keyPressEvent ( self, event )

formclass, baseclass = uic.loadUiType ( 'm_DateEdit.ui' )
class m_DateEdit ( baseclass, formclass ) :
    """
    """
    def __init__ ( self, parent = None ) :
        baseclass.__init__ ( self,  parent )
        self.setupUi ( self )
        self.horizontalLayout.setMargin ( 0 )
        self.setLayout ( self.horizontalLayout )
        self.popup.clicked.connect ( self.popupCalendar )

    def keyPressEvent ( self, event ) :
        key = event.key ()
        if event.modifiers () == Qt.NoModifier :
            if key == Qt.Key_Insert :
                self.popupCalendar ()
                return
        baseclass.keyPressEvent ( self, event )

    def popupCalendar ( self ) :
        popup = m_PopupCalendar ( self )
        self.popup.setDown ( True )
        result = popup.exec_ ()
        self.popup.setDown ( False )
        if result == QDialog.Accepted :
            self.lineEdit.setText ( popup.selectedDate().toString ( "dd.MM.yyyy" ) )
        self.lineEdit.setFocus ()
