// dll_loader.cpp
#include "StdAfx.h"
#include "dll_loader.h"

class SDllAddin : public AddinImpl<null_type>
{
public:
	static SDllAddin* Create(HINSTANCE h, LPCSTR strPath)
	{
		CString fp(strPath), dun(fp.Mid(fp.ReverseFind('\\') + 1)), lp(CDllLoader::GetPrefix());
		return new SDllAddin(h, dun, dun, fp, lp);
	}
	SDllAddin(HINSTANCE h, cstr dn, cstr un, cstr fp, cstr lp)
		:base_type(dn, un, fp, lp), hInst(h)
	{
	}

	~SDllAddin()
	{
		FreeLibrary(hInst);
	}

protected:
	HINSTANCE hInst;
	//  IAddinHolder
	virtual DWORD GetImageIdx(CIconList& IcoList)
	{
		DWORD idx = IcoList.GetImageIdx(strFullPath, 0);
		if(-1 == idx)
			idx = IcoList.GetAssociatedIdx(strFullPath);
		return idx;
	}
};

Addin* CDllLoader::LoadAddin(LPCSTR strPath, AddinStore*& pStore)
{
	CString dllPath(strPath);
	dllPath.TrimLeft();
	dllPath.TrimRight();
	HINSTANCE hInst = LoadLibrary(dllPath);
	if(!hInst)
		hInst = LoadLibraryEx(dllPath, NULL, LOAD_WITH_ALTERED_SEARCH_PATH);
	if(!hInst)
		return NULL;
	char buf[MAX_PATH];
	GetModuleFileName(hInst, buf, MAX_PATH);
	pStore = addin_mgr::GetByFullPath(buf);
	if(pStore)
	{
		FreeLibrary(hInst);	//   
		return pStore->GetAddin();
	}
	Addin* (__stdcall *pFunc)() =
		(Addin* (__stdcall *)())GetProcAddress(hInst, "GetAddin");
	if(pFunc)
		return pFunc();
	return SDllAddin::Create(hInst, buf);
}
