// script_loader.cpp
#include "StdAfx.h"
#include "script_loader.h"
#include "../scripts/scriptimpl.h"
#include "../../common/common.h"

class CScriptAddin : public AddinImpl<type_list<
	AddinMacroses, type_list<
	AddinMenu, type_list<
	AddinObject, type_list<
	AddinUnload, type_list<
	AddinWindow, null_type> > > > >
	>
{
public:
	CScriptAddin(CScript* pScript)
		:base_type(pScript->GetDisplayName(), pScript->GetUniqueName(),
		pScript->GetPath(), CScriptLoader::GetPrefix()),  m_pScript(pScript)
	{
		//m_pScript->CScript::AddRef();
	}
	~CScriptAddin()
	{
		m_pScript->CloseScript();
	}
protected:
	CScript* m_pScript;
	// Addin
	virtual DWORD GetImageIdx(CIconList& IcoList)
	{
		return IcoList.GetAssociatedIdx(m_pScript->GetPath());
	}
	virtual void AfterRegister()
	{
		if(S_OK != m_pScript->m_pEngine->SetScriptState(SCRIPTSTATE_CONNECTED))
			DoMsgLine("    %s", mmRedErr, m_pScript->m_Path);
	}

	// AddinObject
	virtual void GetAddinObject(IDispatch** refObject)
	{
		m_pScript->GetScriptObject(refObject);
	}

	// AddinMacroses
	virtual void GetMacroses(CStringArray& names)
	{
		IDispatchPtr object;
		m_pScript->GetScriptObject(&object);
		ExtractMacroses(object, names);
	}
	virtual BOOL Invoke(cstr Macros)
	{
		IDispatchPtr object;
		m_pScript->GetScriptObject(&object);
		return InvokeMacros(object, Macros);
	}
	// AddinWindow
	virtual BOOL CanCreateWnd()
	{
		return m_pScript->GetForm() != NULL;
	}
	//     
	virtual void CreateWnd(CWnd* pParent)
	{
		CUserFormView* pView = new CUserFormView;
		pView->Create(m_pScript->GetForm(), pParent);
		pAddinWnd = pView;
	}
	virtual void FreeWnd()
	{
		m_pScript->FreeForm();
	}
	// AddinUnload
	virtual BOOL CanUnload() { return TRUE; }
	virtual BOOL CanReload() { return TRUE; }
		
	virtual void GetLoadString(CString& strLoad)
	{
		strLoad.Format("script:%s", m_pScript->GetPath());
	}
	virtual BOOL Unload()
	{
		m_pScript->CloseScript();
		return TRUE;
	}
	// AddinMenu
	virtual void PrepeareMenu(HMENU hMenu)
	{
		AppendMenu(hMenu, MF_STRING, 10, " ");
		if(m_pScript->m_pForm)
			AppendMenu(hMenu, MF_STRING, 11, " ");
	}
	virtual void InvokeMenu(UINT id)
	{
		if(id == 10)
		{
			CTemplate7* pTemp = CTemplate7::FromID(210);
			for(POSITION pos = pTemp->GetFirstDocPosition(); pos;)
			{
				CDocument* pDoc = pTemp->GetNextDoc(pos);
				if(!pDoc->GetPathName().CompareNoCase(m_pScript->GetPath()))
				{
					pos = pDoc->GetFirstViewPosition();
					pMainFrame->MDIActivate(pDoc->GetNextView(pos)->GetParentFrame());
					return;
				}
			}
			pTemp->OpenDocumentFile(m_pScript->GetPath(), TRUE);
		}
		else if(id == 11)
			CUserFormDoc::DesignForm(m_pScript->m_pForm->GetPathName());
	}
};

Addin* CScriptLoader::LoadAddin(LPCSTR strPath, AddinStore*& pStore)
{
	char buf[MAX_PATH];
	if(!SearchPath(NULL, strPath, NULL, MAX_PATH, buf, NULL))
		return NULL;
	pStore = addin_mgr::GetByFullPath(buf);
	if(pStore)
		return pStore->GetAddin();
	CScript* pScript = new CScript;
	if(pScript->Create(buf))
		return new CScriptAddin(pScript);
	else
		delete pScript;
	return NULL;
}

CScriptLoader::CScriptLoader()
{
	CScript::Init();
}