// pluginmgr.h
#pragma once

#include "../decl_import.h"
#include "../../common/common_api.h"
#include "../gui/iconlist.h"

/*
      (Addin)   ,
  .
    :
 -   (DisplayName)
 -   (UniqueName)
 -   (FullPath)
 -   (hIcon)

       .
        
  ,    //.

      :
 -  dll
 - dll,  IDispatch 
 -     ActiveScript 

     , 
  IAddinBase.     
  ,     .

 dll,  IDispatch ,  , IAddinBase
   ov7.dll
,    ,   
 ,   .  
       
GetAddinInterface   .

    :
 OpenV7,    ov7.dll,    
Enterprise, Configurator, Debug, Monitor,    
 1,     ov7x.dll
*/

enum AddinInterfaceTypes{
	aiObject,
	aiWindow,
	aiUnload,
	aiMacroses,
	aiUnknown,
	aiMenu,
};


class Addin
{
public:
	virtual ~Addin(){}
	virtual void* Cast(AddinInterfaceTypes type) = 0;
	virtual DWORD GetImageIdx(CIconList& IconList) = 0;
	virtual void AfterRegister(){}

	cstr DisplayName()	{ return strDisplayName; }
	cstr UniqueName()	{ return strUniqueName; }
	cstr FullPath()		{ return strFullPath; }

	Addin(cstr strDN, cstr strUN, cstr strFP, cstr strLP)
		:	strDisplayName(strDN),
			strUniqueName(strUN),
			strFullPath(strFP),
			strLoaderPrefix(strLP){ }
protected:
	CString strDisplayName,
		strUniqueName,
		strFullPath,
		strLoaderPrefix;
};

class AddinGroup;

class AddinStore
{
public:
	Addin* GetAddin()		{ return pAddin; }
	AddinGroup* GetGroup()	{ return pGroup; }
private:
	AddinStore(Addin* pa, AddinGroup* pg) : pAddin(pa), pGroup(pg) {}
	Addin* pAddin;
	AddinGroup* pGroup;
	friend class AddinStoreReal;
};

typedef CTypedPtrArray<CPtrArray, AddinStore*> AddinsArray;


class AddinGroup
{
public:
	cstr Name() { return m_name; }
	AddinGroup* Parent() { return parent; }
	AddinGroup* Child()	 { return child; }
	AddinGroup* Next()   { return next; }
	DWORD GetAddinsCount()	{ return m_Addins.GetSize(); }
	AddinStore* GetAddin(DWORD idx)	{ return m_Addins[idx]; }

	OV7_COMMON_API AddinGroup* CreateChild(LPCSTR strName);

private:
	friend class AddinGroupReal;
	AddinGroup(cstr Name, AddinGroup* p) : m_name(Name)
	{
		child = next = NULL;
		parent = p;
	}
	AddinGroup(cstr Name) : m_name(Name)
	{
		parent = child = next = NULL;
	}
	virtual ~AddinGroup()
	{
		AddinGroup* ptr = child;
		while(ptr)
		{
			AddinGroup* pDel = ptr;
			ptr = ptr->next;
			delete pDel;
		}
	}
	CString m_name;
	AddinGroup *parent, *child, *next;
	AddinsArray m_Addins;
};

//   IDispatch- 
//  ov7.dll     com-.
struct AddinObject
{
	enum{ait = aiObject};
	virtual void GetAddinObject(IDispatch** ppDisp) = 0;
};

//      
//  ov7.dll   IDispatch-,  IOleControl,
//  ,  .     
//    .

struct AddinWindow
{
	enum{ait = aiWindow};
	AddinWindow() : pAddinWnd(NULL){}
	CWnd* pAddinWnd;		//     
	//   ,     
	virtual BOOL CanCreateWnd() = 0;
	//     
	virtual void CreateWnd(CWnd* pParent) = 0;
	virtual void FreeWnd(){}
};

struct AddinMacroses
{
	enum{ait = aiMacroses};
	virtual void GetMacroses(CStringArray& names) = 0;
	virtual BOOL Invoke(cstr Macros) = 0;
};

struct AddinUnknown
{
	enum{ait = aiUnknown};
	virtual void GetIUnknown(void** ppUnk) = 0;
};

struct AddinUnload 
{
	enum{ait = aiUnload};
	virtual BOOL CanUnload() = 0;
	virtual BOOL CanReload() = 0;
	virtual BOOL Unload() = 0;
	virtual void GetLoadString(CString& strLoad) = 0;
};

struct AddinMenu 
{
	enum{ait = aiMenu};
	virtual void PrepeareMenu(HMENU hMenu) = 0;
	virtual void InvokeMenu(UINT id) = 0;
};


//   
struct null_type{typedef int type; typedef int tail;};

template<typename S, typename T>
struct type_list 
{
	typedef S type;
	typedef T tail;
};

template<typename TL, typename A = TL::type, typename B = TL::tail>
struct addin_cast : public A, public addin_cast<B>
{
	void* _Cast(AddinInterfaceTypes t)
	{
		if(t==static_cast<AddinInterfaceTypes>(A::ait))
			return static_cast<A*>(this);
		return static_cast<addin_cast<B>*>(this)->_Cast(t);
	}
};

template<>
struct addin_cast<null_type, int, int>
{
	void* _Cast(AddinInterfaceTypes t)
	{
		return NULL;
	}
};

template<typename TL>
struct AddinImpl : Addin, addin_cast<TL>
{
	AddinImpl(cstr strDN, cstr strUN, cstr strFP, cstr strLP)
		: Addin(strDN, strUN, strFP, strLP){}
	typedef AddinImpl<TL> base_type;
	
	virtual void* Cast(AddinInterfaceTypes aiType)
	{
		return static_cast<addin_cast<TL>*>(this)->_Cast(aiType);
	}
};


//   .
//   :
//    ,  
// :  
//  ov7.dll  :
// dll: ; com: ; script: ;
//       , 
//   IAddinLoader,     
//   
struct AddinLoader
{
	//  ,  .
	//      ,    pStore
	//   AddinStore  .
	virtual Addin* LoadAddin(LPCSTR strPath, AddinStore*& pStore) = 0;
};


namespace addin_mgr{

//   ov7x.dll   
OV7_COMMON_API void Init(Addin* pModeAddin);
//    
OV7_COMMON_API AddinStore* GetByUniqueName(LPCSTR strUniqueName);
OV7_COMMON_API AddinStore* GetByFullPath(LPCSTR strFullPath);
// ,  
OV7_COMMON_API AddinStore* Load(LPCSTR strPath, AddinGroup* pGroup);
OV7_COMMON_API BOOL Unload(AddinStore*& pStore, BOOL bReload);
//OV7_COMMON_API BOOL Unload(IAddinHolderPtr& addin, BOOL bReload);
//  
OV7_COMMON_API BOOL RegisterLoader(LPCSTR strPrefix, AddinLoader* pLoader);

extern OV7_COMMON_API AddinsArray Addins;
extern OV7_COMMON_API AddinGroup* pRootGroup;
}//namespace addin_mgr