// COMOpenV7.h
#pragma once
#include "dispimpl.hpp"
#include "../ov7.h"
#include "commontlb.h"

class CIWrapRefParam : public CDispImpl<CIWrapRefParam, com_type<IWrapRefParam> >
{
public:
	long value;
	STDMETHOD(get_value)(long *pVal)
	{
		if(!pVal)
			return E_POINTER;
		*pVal = value;
		return S_OK;
	}
	STDMETHOD(put_value)(long newVal)
	{
		value = newVal;
		return S_OK;
	}
};

class CCOMOpenV7 : public CDispImpl<CCOMOpenV7, CComEventsImpl<IOpenV7Events, CCOMOpenV7, IOpenV7, OpenV7> >
{
public:
	STDMETHOD(Run1CProcess)(/*[in]*/ long Mode);
	STDMETHOD(get_HotKeys)(IHotKeys** ppHK);
	STDMETHOD(DesignForm)(BSTR FormPath);
	STDMETHOD(get_Addins)(IAddinMgr* *pVal);
	STDMETHOD(SendCommand)(long cmdID, VARIANT_BOOL bWait)
	{
		if(pMainFrame)
		{
			if(bWait == VARIANT_TRUE)
				pMainFrame->SendMessage(WM_COMMAND, cmdID);
			else
				pMainFrame->PostMessage(WM_COMMAND, cmdID);
		}
		return S_OK;
	}
	STDMETHOD(Status)(BSTR text)
	{
		pBkEndUI->DoStatusLine(CString(text));
		return S_OK;
	}
	STDMETHOD(get_CommandLine)(BSTR *pVal)
	{
		if(!pVal)
			return E_POINTER;
		CString str(GetCommandLine());
		*pVal = str.AllocSysString();
		return S_OK;
	}
	STDMETHOD(get_BinDir)(BSTR *pVal)
	{
		if(!pVal)
			return E_POINTER;
		CString str;
		int len = GetModuleFileName(NULL, str.GetBuffer(MAX_PATH), MAX_PATH);
		str.ReleaseBuffer(len);
		str.GetBufferSetLength(str.ReverseFind('\\') + 1);
		*pVal = str.AllocSysString();
		return S_OK;
	}
	STDMETHOD(get_IBDir)(BSTR *pVal)
	{
		if(!pVal)
			return E_POINTER;
		*pVal = strInfos.strIBDirInCmdLine.AllocSysString();
		return S_OK;
	}
	STDMETHOD(Message)(BSTR Msg, MsgLineMarkers marker)
	{
		pBkEndUI->DoMessageLine(CString(Msg), MessageMarker(marker));
		return S_OK;
	}

	static void Init() {GetOne() = new CCOMOpenV7;}
	static CCOMOpenV7* Get(){return GetOne();}

	// DISPID 
	enum{
		idAllAddinsInit,
		idCreateSplashWnd,
		idCreateMainWnd,
		idDefineUserPanels,
		idIdle,
	};
	
	BEGIN_COM_MAP(CCOMOpenV7)
		COM_INTERFACE_ENTRY(IOpenV7)
		COM_INTERFACE_ENTRY(IConnectionPoint)
		COM_INTERFACE_ENTRY(IConnectionPointContainer)
	END_COM_MAP()

protected:
	CCOMOpenV7(){}
	static CCOMOpenV7*& GetOne(){static CCOMOpenV7* pOne; return pOne;}
};
