// com_addinmgr.cpp
#include "StdAfx.h"
#include "../ov7.h"
#include "com_addinmgr.h"
#include "../addin_work/addinmgrimpl.h"

static HRESULT inline AttachGroup(AddinGroup* pGroup, IAddinGroup **pVal)
{
	if(pGroup)
	{
		AddinGroupReal* pRealGroup = static_cast<AddinGroupReal*>(pGroup);
		if(pRealGroup->pComGroup)
		{
			*pVal = pRealGroup->pComGroup;
			pRealGroup->pComGroup->CIAddinGroup::AddRef();
		}
		else
			*pVal = new CIAddinGroup(pGroup);
	}
	else
		*pVal = NULL;
	return S_OK;
}

static inline HRESULT AttachAddin(AddinStore* pStore, IAddin **pVal)
{
	if(pStore)
	{
		AddinStoreReal* pRealStore = static_cast<AddinStoreReal*>(pStore);
		if(pRealStore->pComAddin)
		{
			*pVal = pRealStore->pComAddin;
			pRealStore->pComAddin->CIAddin::AddRef();
		}
		else
			*pVal = new CIAddin(pStore);
	}
	else
		*pVal = NULL;
	return S_OK;
}

CIAddin::CIAddin(AddinStore* pStore)
{
	m_pStore = pStore;
	static_cast<AddinStoreReal*>(pStore)->pComAddin = this;
}

CIAddin::~CIAddin()
{
	if(m_pStore)
		static_cast<AddinStoreReal*>(m_pStore)->pComAddin = NULL;
}

STDMETHODIMP CIAddin::get_DisplayName(BSTR *pVal)
{
	if(m_pStore)
	{
		*pVal = m_pStore->GetAddin()->DisplayName().AllocSysString();
		return S_OK;
	}
	return SetError(E_FAIL, "  ");
}

STDMETHODIMP CIAddin::get_UniqueName(BSTR *pVal)
{
	if(m_pStore)
	{
		*pVal = m_pStore->GetAddin()->UniqueName().AllocSysString();
		return S_OK;
	}
	return SetError(E_FAIL, "  ");
}

STDMETHODIMP CIAddin::get_FullPath(BSTR *pVal)
{
	if(m_pStore)
	{
		*pVal = m_pStore->GetAddin()->FullPath().AllocSysString();
		return S_OK;
	}
	return SetError(E_FAIL, "  ");
}

STDMETHODIMP CIAddin::get_Object(IDispatch **pVal)
{
	if(!m_pStore)
		return SetError(E_FAIL, "  ");
	AddinObject* pAddinObject = (AddinObject*)m_pStore->GetAddin()->Cast(aiObject);
	if(pAddinObject)
		pAddinObject->GetAddinObject(pVal);
	else
		*pVal = NULL;
	return S_OK;
}

STDMETHODIMP CIAddin::get_Macroses(VARIANT *pVal)
{
	if(!m_pStore)
		return SetError(E_FAIL, "  ");
	pVal->vt = VT_ARRAY | VT_VARIANT;
	CStringArray strMacroses;
	AddinMacroses* pAddinMacroses = (AddinMacroses*)m_pStore->GetAddin()->Cast(aiMacroses);
	if(pAddinMacroses)
		pAddinMacroses->GetMacroses(strMacroses);
	long s = strMacroses.GetSize();
	pVal->parray = SafeArrayCreateVector(VT_VARIANT, 0, s);
	VARIANT vt;
	vt.vt = VT_BSTR;
	for(long idx = 0; idx < s; idx++)
	{
		vt.bstrVal = strMacroses[idx].AllocSysString();
		SafeArrayPutElement(pVal->parray, &idx, &vt);
		SysFreeString(vt.bstrVal);
	}
	return S_OK;
}

STDMETHODIMP CIAddin::InvokeMacros(BSTR MacrosName, VARIANT_BOOL *Success)
{
	if(!m_pStore)
		return SetError(E_FAIL, "  ");
	AddinMacroses* pAddinMacroses = (AddinMacroses*)m_pStore->GetAddin()->Cast(aiMacroses);
	if(pAddinMacroses)
		*Success = pAddinMacroses->Invoke(CString(MacrosName)) ? VARIANT_TRUE : VARIANT_FALSE;
	else
		*Success = VARIANT_FALSE;
	return S_OK;
}

STDMETHODIMP CIAddin::get_Group(IAddinGroup **pVal)
{
	if(!m_pStore)
		return SetError(E_FAIL, "  ");
	return AttachGroup(m_pStore->GetGroup(), pVal);
}

STDMETHODIMP CIAddin::Unload(VARIANT_BOOL Reload)
{
	if(!m_pStore)
		return SetError(E_FAIL, "  ");
	BOOL bRes = addin_mgr::Unload(m_pStore, Reload != VARIANT_FALSE);
	if(m_pStore)
		static_cast<AddinStoreReal*>(m_pStore)->pComAddin = this;
	if(bRes)
		return S_OK;
	return SetOV7Error();
}

STDMETHODIMP CIAddinMgr::get_Count(long *pVal)
{
	*pVal = addin_mgr::Addins.GetSize();
	return S_OK;
}

STDMETHODIMP CIAddinMgr::get_ByUniqueName(BSTR UniqueName, IAddin **pVal)
{
	return AttachAddin(addin_mgr::GetByUniqueName(CString(UniqueName)), pVal);
}

STDMETHODIMP CIAddinMgr::get_ByFullPath(BSTR FullPath, IAddin **pVal)
{
	return AttachAddin(addin_mgr::GetByFullPath(CString(FullPath)), pVal);
}

STDMETHODIMP CIAddinMgr::get_ByIdx(long Idx, IAddin **pVal)
{
	if(addin_mgr::Addins.GetSize() <= (DWORD)Idx)
		return SetError(E_FAIL, " : %i", Idx);
	return AttachAddin(addin_mgr::Addins[Idx], pVal);
}

STDMETHODIMP CIAddinMgr::get_RootGroup(IAddinGroup **pVal)
{
	return AttachGroup(addin_mgr::pRootGroup, pVal);
}


STDMETHODIMP CIAddinGroup::get_Name(BSTR *pVal)
{
	*pVal = m_pGroup->Name().AllocSysString();
	return S_OK;
}

STDMETHODIMP CIAddinGroup::get_Parent(IAddinGroup **pVal)
{
	return AttachGroup(m_pGroup->Parent(), pVal);
}

STDMETHODIMP CIAddinGroup::get_FirstChild(IAddinGroup **pVal)
{
	return AttachGroup(m_pGroup->Child(), pVal);
}

STDMETHODIMP CIAddinGroup::get_Next(IAddinGroup **pVal)
{
	return AttachGroup(m_pGroup->Next(), pVal);
}

STDMETHODIMP CIAddinGroup::get_AddinCount(long *pVal)
{
	*pVal = m_pGroup->GetAddinsCount();
	return S_OK;
}

STDMETHODIMP CIAddinGroup::get_Addin(long Idx, IAddin **pVal)
{
	if(m_pGroup->GetAddinsCount() <= (DWORD)Idx)
		return SetError(ERROR_BAD_ARGUMENTS, " : %i", Idx);
	return AttachAddin(m_pGroup->GetAddin(Idx), pVal);
}

STDMETHODIMP CIAddinGroup::LoadAddin(BSTR AddinPath, IAddin** ppAddin)
{
	return AttachAddin(addin_mgr::Load(CString(AddinPath), m_pGroup), ppAddin);
}

CIAddinGroup::CIAddinGroup(AddinGroup* pGroup) : m_pGroup(pGroup)
{
	static_cast<AddinGroupReal*>(m_pGroup)->pComGroup = this;
}

CIAddinGroup::~CIAddinGroup()
{
	if(m_pGroup)
		static_cast<AddinGroupReal*>(m_pGroup)->pComGroup = NULL;
}

