// hotkeys.cpp
#include "StdAfx.h"
#include "hotkeys.h"
#include "../ov7.h"

STDMETHODIMP CIHotKey::get_Addin(BSTR *pVal)
{
	if(!m_pKey)
		return SetError(E_FAIL, "  ");
	*pVal = m_pKey->GetAddin().AllocSysString();
	return S_OK;
}

STDMETHODIMP CIHotKey::get_Macros(BSTR *pVal)
{
	if(!m_pKey)
		return SetError(E_FAIL, "  ");
	*pVal = m_pKey->GetMacros().AllocSysString();
	return S_OK;
}

STDMETHODIMP CIHotKey::get_KeyString(BSTR *pVal)
{
	if(!m_pKey)
		return SetError(E_FAIL, "  ");
	CString text;
	m_pKey->GetString(text);
	*pVal = text.AllocSysString();
	return S_OK;
}

STDMETHODIMP CIHotKey::SetCommand(BSTR Addin, BSTR Macros)
{
	if(!m_pKey)
		return SetError(E_FAIL, "  ");
	m_pKey->SetCommand(CString(Addin), CString(Macros));
	return S_OK;
}

STDMETHODIMP CIHotKey::get_Key(long* pVal)
{
	if(!m_pKey)
		return SetError(E_FAIL, "  ");
	*pVal = m_pKey->GetKey();
	return S_OK;
}

STDMETHODIMP CIHotKey::put_Key(long newVal)
{
	if(!m_pKey)
		return SetError(E_FAIL, "  ");
	if(!m_pKey->SetKey(newVal))
		return SetOV7Error();
	return S_OK;
}


STDMETHODIMP CIHotKeys::get_Count(long *pVal)
{
	*pVal = CHotKeyTrap::GetCount();
	return S_OK;
}

STDMETHODIMP CIHotKeys::get_Item(long Idx, IHotKey **pVal)
{
	if(CHotKeyTrap::GetCount() <= (DWORD)Idx)
		return SetError(E_FAIL, " : %i", Idx);
	CHotKeyTrap::SKeyData* pKey = CHotKeyTrap::GetKey(Idx);
	CIHotKey::Attach(pKey, pVal);
	return S_OK;
}

STDMETHODIMP CIHotKeys::Remove(long Idx)
{
	if(CHotKeyTrap::GetCount() <= (DWORD)Idx)
		return SetError(E_FAIL, " : %i", Idx);
	CHotKeyTrap::RemoveKey(Idx);
	return S_OK;
}

STDMETHODIMP CIHotKeys::Add(long Key, BSTR bAddin, BSTR Macros, IHotKey **pHotKey)
{
	CHotKeyTrap::SKeyData* pNewKey = CHotKeyTrap::AddKey(Key, CString(bAddin), CString(Macros));
	if(!pNewKey)
		return SetOV7Error();
	*pHotKey = new CIHotKey(pNewKey);
	return S_OK;
}

STDMETHODIMP CIHotKeys::ClearAll()
{
	CHotKeyTrap::ClearAll();
	return S_OK;
}

STDMETHODIMP CIHotKeys::get_Cancel(VARIANT_BOOL *pVal)
{
	*pVal = CHotKeyTrap::bCancelHotKey ? VARIANT_TRUE : VARIANT_FALSE;
	return S_OK;
}

STDMETHODIMP CIHotKeys::put_Cancel(VARIANT_BOOL newVal)
{
	CHotKeyTrap::bCancelHotKey = newVal != VARIANT_FALSE;
	return S_OK;
}

STDMETHODIMP CIHotKeys::FindByKey(long Key, IHotKey **ppKey)
{
	CHotKeyTrap::SKeyData* pKey = CHotKeyTrap::FindKey(Key);
	if(pKey)
		CIHotKey::Attach(pKey, ppKey);
	else
		*ppKey = NULL;
	return S_OK;
}
