// panelview.h
#pragma once
#include "../../addin_work/addinmgrimpl.h"
#include "../../gui/iconlist.h"

class CPanelView : public CView
{
public:
	CPanelView();
	~CPanelView();
protected:
	struct TabSite : AddinWndSite 
	{
		virtual void DestroyWnd();
		virtual BOOL CreateWnd(Addin* pAddin);
		CPanelView* pOwner;
		AddinWindow* pWnd;
		int idx;
	};
	friend struct TabSite;

	void RepositionControls();
	void UpdateTabSite(Addin* pAddin, TabSite* pSite);
	void DeleteTabSite(TabSite* pSite);

	DECLARE_DYNCREATE(CPanelView);
	
	CTypedPtrArray<CPtrArray, TabSite*> m_tabs;
	int m_ActiveTab;
	CTabCtrl* m_pTab;
	CIconList* m_pIcons;
	
	void OnSwitchTab(NMHDR *phdr, LRESULT *pRes);
	//{{AFX_VIRTUAL(CPanelView)
	public:
	virtual void OnInitialUpdate();
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	protected:
	virtual void OnDraw(CDC* pDC);      // overridden to draw this view
	//}}AFX_VIRTUAL
	//{{AFX_MSG(CPanelView)
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnSetFocus(CWnd* pOldWnd);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};
