// iconlist.cpp
#include "StdAfx.h"
#include "iconlist.h"

CIconList::CIconList()
{
	OSVERSIONINFO info;
	info.dwOSVersionInfoSize=sizeof(info);
	GetVersionEx(&info);
	if(info.dwPlatformId == VER_PLATFORM_WIN32_NT && info.dwMajorVersion >= 5)
	{
		SHFILEINFO fi;
		m_hList = ImageList_Duplicate((HIMAGELIST)SHGetFileInfo(NULL, 0, &fi, sizeof(fi),
			SHGFI_SYSICONINDEX|SHGFI_SMALLICON));
		ImageList_RemoveAll(m_hList);
	}
	else
		m_hList = ImageList_Create(16, 16, ILC_MASK | ILC_COLOR32, 0, 1);
}

CIconList::~CIconList()
{
	ImageList_Destroy(m_hList);
}

DWORD CIconList::GetImageIdx(cstr strFilePath, int iIconIdx)
{
	CString key;
	key.Format("%s|%i", strFilePath, iIconIdx);
	int fnd;
	if(m_IdxMap.Lookup(key, fnd))
		return fnd;
	HICON hIcon;
	if(1 == ExtractIconEx(strFilePath, iIconIdx, NULL, &hIcon, 1))
	{
		fnd = ImageList_AddIcon(m_hList, hIcon);
		m_IdxMap[key] = fnd;
		DestroyIcon(hIcon);
		return fnd;
	}
	return -1;
}

DWORD CIconList::GetAssociatedIdx(cstr strFilePath)
{
	CString ext = strFilePath.Mid(strFilePath.ReverseFind('.') + 1);
	int fnd;
	if(m_IdxMap.Lookup(ext, fnd))
		return fnd;
	SHFILEINFO info;
	SHGetFileInfo(strFilePath, 0, &info, sizeof(info), SHGFI_ICON | SHGFI_SMALLICON);
	fnd = ImageList_AddIcon(m_hList, info.hIcon);
	m_IdxMap[ext] = fnd;
	DestroyIcon(info.hIcon);
	return fnd;
}
