// bl_objects.h
#pragma once
#include "../common/common.h"
#include "../ov7/addin_work/addinmgr.h"
#include "../ov7/ov7.h"
#include "../../_1Common/addin.hpp"


struct CBLMyEx : public CBLExportContext
{
	long DispParamToValueEx(CValue** ppVal, DISPPARAMS* pDisp,unsigned int* pUI)
	{
		return DispParamToValue(ppVal, pDisp, pUI);
	}
};

class CBLOpenV7 : public CContextImpl<CBLOpenV7>
{
public:
	BL_BEGIN_CONTEXT("OpenV7", "OpenV7");

	BL_FUNC(GetLoadedAddins, "", 0)
	{
		CValueListContext* pVL = new CValueListContext;
		if(DWORD s = addin_mgr::Addins.GetSize())
		{
			pVL->m_pValueItemList->SetSize(s);
			CValueItem** ppItem = (CValueItem**)pVL->m_pValueItemList->GetData();
			for(int i=0 ; i<s; i++)
			{
				CValueItem* pItem = new CValueItem;
				*ppItem++ = pItem;
			}
		}
		retVal.AssignContext(pVL);
		pVL->CBLContext::DecrRef();
		return TRUE;
	}
	BL_FUNC(LoadAddin, "", 1)
	{
		AddinStore* pStore = addin_mgr::Load(ppParams[0]->GetString(), NULL);
		retVal =  pStore ? 1 : 0;
		return TRUE;
	}
	BL_FUNC_WITH_DEFVAL(GetVersion, "", 2)
	{
		CBLVersionInfo* pInfo = new CBLVersionInfo(ppParams[0]->GetString(),
			0 != ppParams[1]->GetNumeric());
		if(pInfo->IsLoaded())
			retVal.AssignContext(pInfo);
		else
			retVal.Reset();
		pInfo->CBLContext::DecrRef();
		return TRUE;
	}
	BL_DEFVAL_FOR(GetVersion)
	{
		if(nParam == 1)
		{
			if(pValue)
				*pValue = 1;
			return TRUE;
		}
		return FALSE;
	}
	
	BL_PROP_RO(UserIniDir, "")
	{
		value = strInfos.strStarterUserIniDir;
		return TRUE;
	}
	BL_PROP_RO(CommonIniDir, "")
	{
		value = strInfos.strStarterCmnIniDir;
		return TRUE;
	}
	BL_PROP_RO(OpenV7StarterPath, "")
	{
		value = strInfos.strPath2OpenV7Starter;
		return TRUE;
	}

	BL_END_CONTEXT();

private:
	
	class CBLVersionInfo : public CVersionInfo, public CContextImpl<CBLVersionInfo, no_init_done, FALSE>
	{
		mutable CString m_strVersion;
	public:
		CBLVersionInfo(cstr path, BOOL bFull) : CVersionInfo(path, bFull){}

		virtual LPCSTR GetCode()const
		{
			if(m_strVersion.IsEmpty())
				m_strVersion.Format("%i.%i.%i.%i", m_wFileVersion[0], m_wFileVersion[1],
					m_wFileVersion[2], m_wFileVersion[3]);
			return m_strVersion;
		}
		BL_BEGIN_CONTEXT("VersionInfo", "");
		
		BL_FUNC(FileVersionPart, "", 1)
		{
			retVal.Reset();
			DWORD dwIdx = ppParams[0]->GetNumeric();
			if(dwIdx < 4)
				retVal = m_wFileVersion[dwIdx];
			return TRUE;
		}
		BL_FUNC(ProdVersionPart, "", 1)
		{
			retVal.Reset();
			DWORD dwIdx = ppParams[0]->GetNumeric();
			if(dwIdx < 4)
				retVal = m_wProdVersion[dwIdx];
			return TRUE;
		}
		BL_PROP_RO(BlockCount, "")
		{
			value = m_blocks.GetSize();
			return TRUE;
		}
		BL_FUNC(Block, "", 1)
		{
			DWORD dwIdx = ppParams[0]->GetNumeric();
			if(--dwIdx < m_blocks.GetSize())
			{
				CBLBlockVersionInfo* pBlock = new CBLBlockVersionInfo(m_blocks[dwIdx]);
				retVal.AssignContext(pBlock);
				pBlock->CBLContext::DecrRef();
			}
			else
				retVal.Reset();
			return TRUE;
		}

		BL_END_CONTEXT();
	};
	class CBLBlockVersionInfo : public CContextImpl<CBLBlockVersionInfo, no_init_done, FALSE>
	{
		CString m_strLanguage;
		CStringArray m_vals;
		CStringArray m_names;
		friend CContextImpl<CBLBlockVersionInfo, no_init_done, FALSE>;
	public:
		CBLBlockVersionInfo(CVersionInfo::SBlockInfo* pBlock)
		{
			pBlock->GetStrLanguage(m_strLanguage);
			DWORD dwSize = pBlock->vals.GetSize();
			m_vals.SetSize(dwSize);
			m_names.SetSize(dwSize);
			for(DWORD i=0; i < dwSize; i++)
			{
				m_vals[i] = pBlock->vals.ElementAt(i);
				m_names[i] = pBlock->names.ElementAt(i);
			}
		}

		BL_BEGIN_CONTEXT("BlockVersionInfo", "");

		BL_PROP_RO(Language, "")
		{
			value = m_strLanguage;
			return TRUE;
		}
		BL_PROP_RO(FieldCount, "")
		{
			value = m_vals.GetSize();
			return TRUE;
		}
		BL_FUNC(Name, "", 1)
		{
			retVal.Reset();
			DWORD dwIdx = ppParams[0]->GetNumeric();
			if(--dwIdx < m_names.GetSize())
				retVal = m_names[dwIdx];
			return TRUE;
		}
		BL_FUNC(Value, "", 1)
		{
			retVal.Reset();
			DWORD dwIdx = ppParams[0]->GetNumeric();
			if(--dwIdx < m_vals.GetSize())
				retVal = m_vals[dwIdx];
			return TRUE;
		}
		BL_END_CONTEXT();
	};
};
