// ov7e.cpp : Defines the initialization routines for the DLL.
//

#include "stdafx.h"
#include <afxdllx.h>
#include "ov7e.h"
#include "../common/common.h"
#include "../ov7/addin_work/addinmgr.h"
#include "bl_objects.h"

class CEnterpriseAddin : public AddinImpl<type_list<
	AddinObject, null_type> >
{
public:
	CEnterpriseAddin()
		:base_type("", "Enterprise", "", "")
	{
		strFullPath.ReleaseBuffer(GetModuleFileName(hMyInst, strFullPath.GetBuffer(MAX_PATH), MAX_PATH));
	}
	~CEnterpriseAddin(){}
protected:
	IDispatchPtr m_pEnterprise;
	// AddinObject
	virtual void GetAddinObject(IDispatch** refObject)
	{
		*refObject = m_pEnterprise;
		if(m_pEnterprise)
			m_pEnterprise->AddRef();
	}
	// Addin
	virtual DWORD GetImageIdx(CIconList& IcoList)
	{
		return IcoList.GetImageIdx(strFullPath, 0);
	}
};

extern "C" int APIENTRY
DllMain(HINSTANCE hInstance, DWORD dwReason, LPVOID)
{
	if(DLL_PROCESS_ATTACH == dwReason)
	{
		hMyInst = hInstance;
		DisableThreadLibraryCalls(hInstance);
		addin_mgr::Init(new CEnterpriseAddin);
		context_obj::CContextBase::InitAllContextClasses();
	}
	else if(DLL_PROCESS_DETACH == dwReason)
	{
	}
	return 1;   // ok
}
