// Link2BaseDir.hpp
#pragma once
#include "linkinfo.hpp"

void GetNextArg(LPCSTR& lpCmdLine, CString& val);

//     
template<typename GUI>
class CLink2BaseDir: public CLink<GUI, CLink2BaseDir>
{
	friend CDataGuiItemImpl<GUI, CLink2BaseDir>;
	friend CLink<GUI, CLink2BaseDir>;
	friend CLink<GUI, CLink2BaseDir>::link_creator;

protected:
	enum	{IsBase = TRUE};
	WORD m_dwAllowedModes;

	CLink2BaseDir(DG_BaseType* parent, cstr t, cstr p, cstr p2d, cstr ca)
		:LinkBase(parent, t, p, p2d, ca), m_dwAllowedModes(0){}

	WORD GetAllowedModes()
	{
		if(!m_dwAllowedModes)
		{
			static LPCSTR keys[]={"enterprise", "/m", "config", "debug",  "monitor"};
		
			LPCSTR ptr = m_cmdArgs;
			CString arg, newArgs;
			for(;;)
			{
				GetNextArg(ptr, arg);
				if(arg.IsEmpty())
					break;
				for(int num = 0; num<5;num++)
				{
					if(!stricmp(arg, keys[num]))
						break;
				}
				if(num<5)
					m_dwAllowedModes |= 1<<num;
				else
					newArgs=newArgs + arg + " ";
			}
			if(!m_dwAllowedModes)
				m_dwAllowedModes = gui_base::idRunAll;
			newArgs.TrimRight();
			m_cmdArgs = newArgs;
		}
		return m_dwAllowedModes;
	}
	LPCSTR GetCmdLineArgs(){return m_cmdArgs;}
};
