//baselist.cpp
#include "StdAfx.h"
#include "baselist.h"
#include "settings.h"
#include "starterDlg.h"

#include "base_tree_nodes/BaseDir.hpp"
#include "base_tree_nodes/Link2BaseDir.hpp"
#include "base_tree_nodes/Link2BasesFolder.hpp"
#include "base_tree_nodes/Link2LinkFolder.hpp"
#include "base_tree_nodes/LinkFolder.hpp"

#include "InputDlg.h"

struct SFindParams
{
	IShellLinkAPtr pLink;
	IPersistFilePtr pFile;
	CNoCaseMap<BOOL> mapProcessedDirs;
};

template<typename GUI>
static void Process(GUI& gui, SFindParams* pParams, cstr path, int type, CDataGuiItem<GUI>* pParent)
{
	typedef CLinkFolder<GUI> link_folder;
	typedef CBaseDir<GUI> base_dir;
	typedef CLink2LinkFolder<GUI> l2lf;
	typedef CLink2BasesFolder<GUI> l2bsf;
	typedef CLink2BaseDir<GUI> l2bd;

	// type: 0 - link folder, 1 - bases folder
	WIN32_FIND_DATA fnd;
	HANDLE hFnd = FindFirstFile(path + "\\*", &fnd);
	if(hFnd != INVALID_HANDLE_VALUE)
	{
		do
		{
			CString fileName = fnd.cFileName;
			CString fullName = path + '\\' + fileName;
			if(fnd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)
			{
				//  
				if(fnd.cFileName[0]=='.' && (fnd.cFileName[1]==0 || (fnd.cFileName[1]=='.' && fnd.cFileName[2]==0)))
					continue;
				if(0==type)	//    
					Process(gui, pParams, fullName, 0, link_folder::Create(gui, pParent, fileName, fullName));
				else	//    
					base_dir::Create(gui, pParent, fileName, fullName);
			}
			else if(type == 0)	//      
			{
				if(0==fileName.Right(4).CompareNoCase(".lnk"))
				{
					SLinkInfo link(fullName, pParams->pLink, pParams->pFile);
					if(!link.path2dst.IsEmpty())
					{
						int typeOfLink = fileName[0]=='#' ? 1 : (fileName[0]=='@' ? 2 : 0);
						CString strTitle;
						if(typeOfLink)
						{
							if(fileName[1]=='=')
								strTitle = link.path2dst.Mid(link.path2dst.ReverseFind('\\')+1);
							else
								strTitle = fileName.Mid(1, fileName.GetLength() - 5);
						}
						else
							strTitle = fileName.Left(fileName.GetLength()-4);
						strTitle.TrimLeft();
						strTitle.TrimRight();
						if(typeOfLink)
						{
							if(!pParams->mapProcessedDirs.InsertExist(link.path2dst, TRUE))
							{
								Process(gui, pParams, link.path2dst, typeOfLink != 1,
									typeOfLink == 1 ?
									l2lf::Create(gui, pParent, strTitle, fullName, link)
									:l2bsf::Create(gui, pParent, strTitle, fullName, link));
							}
						}
						else
							l2bd::Create(gui, pParent, strTitle, fullName, link);
					}
				}
			}
		}while(FindNextFile(hFnd, &fnd));
		FindClose(hFnd);
	}
}

static BOOL CreateLink(cstr path, cstr dst, cstr descr)
{
	IShellLinkAPtr link;
	link.CreateInstance(CLSID_ShellLink);
	link->SetPath(dst);
	link->SetWorkingDirectory(dst);
	link->SetDescription(descr);
	IPersistFilePtr file = link;
	return S_OK == file->Save(_bstr_t((LPCSTR)path), TRUE);
}

static void ImportLinksFrom1C(cstr path)
{
	HKEY hKey;
	if(ERROR_SUCCESS == RegOpenKeyEx(HKEY_CURRENT_USER, "Software\\1C\\1Cv7\\7.7\\Titles",
		0, KEY_QUERY_VALUE, &hKey))
	{
		DWORD dwIdx = 0, dwSizeOfName, dwSizeOfValue, type;
		CString strValueName, strValue;
		for(;;)
		{
			dwSizeOfName = MAX_PATH;
			dwSizeOfValue = MAX_PATH;
			DWORD ret = RegEnumValue(hKey, dwIdx, strValueName.GetBuffer(MAX_PATH), &dwSizeOfName,
				NULL, &type, (LPBYTE)strValue.GetBuffer(MAX_PATH), &dwSizeOfValue);
			strValueName.ReleaseBuffer();
			strValue.ReleaseBuffer();

			if(ERROR_NO_MORE_ITEMS == ret)
				break;
			dwIdx++;
			if(ERROR_SUCCESS == ret && type == REG_SZ)
			{
				if(strValueName[strValueName.GetLength()-1]=='\\')
					strValueName.GetBufferSetLength(strValueName.GetLength()-1);
				if(FILE_ATTRIBUTE_DIRECTORY == (GetFileAttributes(strValueName) & (FILE_ATTRIBUTE_DIRECTORY|0x80000000)))
				{
					static const char chInvalidSymbols[]="/\\:*?\"><|";
					for(LPSTR ptr = const_cast<LPSTR>((LPCSTR)strValue); *ptr; ptr++)
						if(strchr(chInvalidSymbols, *ptr))
							*ptr = '_';
					IShellLinkAPtr link;
					link.CreateInstance(CLSID_ShellLink);
					link->SetPath(strValueName);
					link->SetWorkingDirectory(strValueName);
					link->SetDescription(strValueName);
					IPersistFilePtr file = link;
					CString fpath = path + strValue + ".lnk";
					HRESULT hr=file->Save(_bstr_t((LPCSTR)fpath), TRUE);
					if(S_OK!=hr)
					{
						fpath = path + strValueName.Mid(strValueName.ReverseFind('\\')+1) + ".lnk";
						file->Save(_bstr_t((LPCSTR)fpath), TRUE);
					}
				}
			}
		}
		RegCloseKey(hKey);
	}
}

template<typename GUI>
void CBaseList<GUI>::Load(GUI& gui)
{
	SFindParams params;
	if(S_OK != params.pLink.CreateInstance(CLSID_ShellLink))
		return;
	params.pFile = params.pLink;
	if(params.pFile == NULL)
		return;
	LinkPath(CSettings::GetSettings().GetIniDir(), "BasesList\\", m_strBaseListLocation);
	m_strBaseListLocation.GetBufferSetLength(m_strBaseListLocation.GetLength()-1);
	CreateDirs(m_strBaseListLocation);
	m_pBases = CLinkFolder<GUI>::Create(gui, NULL, " ", m_strBaseListLocation);
	Process(gui, &params, m_strBaseListLocation, 0, m_pBases);
	if(!m_pBases->Child())
	{
		//  .    .
		ImportLinksFrom1C(m_strBaseListLocation + '\\');
		Process(gui, &params, m_strBaseListLocation, 0, m_pBases);
	}
}

template<typename GUI, typename T>
void CreateDir(GUI& gui, CDataGuiItem<GUI>* pParent, cstr pParentPath, T&)
{
	CString strItemTitle, t;
	CInputDlg dlg;
	if(IDOK==dlg.InputData(SInputParam(" ", "", ftTitle, strItemTitle, "", ftNone, t, "", ftNone, t)))
	{
		char oldcd[MAX_PATH];
		BOOL bCreated = FALSE;
		GetCurrentDirectory(MAX_PATH, oldcd);
		if(SetCurrentDirectory(pParentPath))
		{
			char buf[MAX_PATH];
			if(GetFullPathName(strItemTitle, MAX_PATH, buf, NULL))
			{
				CString path(buf);
				if(path.Find(pParentPath)==0 && path.GetLength() > pParentPath.GetLength())
				{
					if(GetFileAttributes(path) == 0xFFFFFFFF)
					{
						if(CreateDirs(path))
						{
							CDataGuiItem<GUI>* pItem = T::Create(gui, pParent, strItemTitle, path);
							pItem->Insert(gui, pParent->m_guiItem);
							gui.OrderChild(pParent->m_guiItem);
							gui.SelectItem(pItem);
							bCreated = TRUE;
						}
					}
				}
			}
		}
		SetCurrentDirectory(oldcd);
		if(!bCreated)
		{
			CString text;
			text.Format("    \"%s\"", strItemTitle);
			AfxMessageBox(text);
		}
	}
}

template<typename GUI, typename T>
void CreateLink2(GUI& gui, CDataGuiItem<GUI>* pParent, cstr pParentPath, T&)
{
	CString strItemTitle, strPath2Dst, strDescription;

	CInputDlg dlg;
	if(IDOK==dlg.InputData(SInputParam(" ", "  ", ftPath, strPath2Dst,
		"", ftTitle, strItemTitle, "", ftText, strDescription)))
	{
		CString strFileName(strItemTitle);
		T::PrepeareFileName(strFileName, strItemTitle, strPath2Dst);
		
		char oldcd[MAX_PATH];
		BOOL bCreated = FALSE;
		GetCurrentDirectory(MAX_PATH, oldcd);
		if(SetCurrentDirectory(pParentPath))
		{
			char buf[MAX_PATH];
			if(GetFullPathName(strFileName + ".lnk", MAX_PATH, buf, NULL))
			{
				CString strPath2Link(buf);
				if(strPath2Link.Find(pParentPath)==0 && strPath2Link.GetLength() > pParentPath.GetLength())
				{
					if(CreateLink(strPath2Link, strPath2Dst, strDescription))
					{
						SFindParams params;
						params.pLink.CreateInstance(CLSID_ShellLink);
						params.pFile = params.pLink;

						SLinkInfo li(strPath2Link, params.pLink, params.pFile);
						CDataGuiItem<GUI>* pItem = T::Create(gui, pParent, strItemTitle, strPath2Link, li);
						if(T::IsProcess)
						{
							Process(gui, &params, strPath2Dst, T::ProcessType, pItem);
							gui.FillGroup(pItem, pParent->m_guiItem);
							gui.OrderTree(pItem->m_guiItem);
						}
						else
							pItem->Insert(gui, pParent->m_guiItem);
						gui.OrderChild(pParent->m_guiItem);
						gui.SelectItem(pItem);
						bCreated = TRUE;
					}
				}
			}
		}
		SetCurrentDirectory(oldcd);
		if(!bCreated)
		{
			CString text;
			text.Format("    \"%s\"", strItemTitle);
			AfxMessageBox(text);
		}
	}
}

template<typename GUI>
struct _CreateLinkFolder
{
	static CDataGuiItem<GUI>* Create(GUI& gui, CDataGuiItem<GUI>* pParent, cstr title, cstr path)
	{
		return CLinkFolder<GUI>::Create(gui, pParent, title, path);
	}
};

template<typename GUI>
struct _CreateBaseDir
{
	static CDataGuiItem<GUI>* Create(GUI& gui, CDataGuiItem<GUI>* pParent, cstr title, cstr path)
	{
		return CBaseDir<GUI>::Create(gui, pParent, title, path);
	}
};

template<typename GUI>
struct _CreateLink2LinkFolder
{
	enum{IsProcess = TRUE, ProcessType = 0};

	static void PrepeareFileName(CString& strFileName, cstr strItemTitle, cstr strPath2Dst)
	{
		strFileName.Insert(0, '#');
		if(!strItemTitle.CompareNoCase(strPath2Dst.Mid(strPath2Dst.ReverseFind('\\') + 1)))
			strFileName.Insert(1, '=');
	}
	
	static CDataGuiItem<GUI>* Create(GUI& gui, CDataGuiItem<GUI>* pParent,
		cstr strItemTitle, cstr strPath2Link, SLinkInfo& li)
	{
		return CLink2LinkFolder<GUI>::Create(gui, pParent, strItemTitle, strPath2Link, li);
	}
};

template<typename GUI>
struct _CreateLink2BasesFolder
{
	enum{IsProcess = TRUE, ProcessType = 1};

	static void PrepeareFileName(CString& strFileName, cstr strItemTitle, cstr strPath2Dst)
	{
		strFileName.Insert(0, '@');
		if(!strItemTitle.CompareNoCase(strPath2Dst.Mid(strPath2Dst.ReverseFind('\\') + 1)))
			strFileName.Insert(1, '=');
	}
	
	static CDataGuiItem<GUI>* Create(GUI& gui, CDataGuiItem<GUI>* pParent,
		cstr strItemTitle, cstr strPath2Link, SLinkInfo& li)
	{
		return CLink2BasesFolder<GUI>::Create(gui, pParent, strItemTitle, strPath2Link, li);
	}
};

template<typename GUI>
struct _CreateLink2BaseDir
{
	enum{IsProcess = FALSE, ProcessType = 0};

	static void PrepeareFileName(CString& strFileName, cstr strItemTitle, cstr strPath2Dst){}
	
	static CDataGuiItem<GUI>* Create(GUI& gui, CDataGuiItem<GUI>* pParent,
		cstr strItemTitle, cstr strPath2Link, SLinkInfo& li)
	{
		return CLink2BaseDir<GUI>::Create(gui, pParent, strItemTitle, strPath2Link, li);
	}
};

template<typename GUI>
void CBaseList<GUI>::CreateLinkFolder(GUI& gui, CDataGuiItem<GUI>* pParent, cstr pParentPath)
{
	CreateDir(gui, pParent, pParentPath, _CreateLinkFolder<GUI>());
}

template<typename GUI>
void CBaseList<GUI>::CreateLink2LinkFolder(GUI& gui, CDataGuiItem<GUI>* pParent, cstr pParentPath)
{
	CreateLink2(gui, pParent, pParentPath, _CreateLink2LinkFolder<GUI>());
}

template<typename GUI>
void CBaseList<GUI>::CreateLink2BasesFolder(GUI& gui, CDataGuiItem<GUI>* pParent, cstr pParentPath)
{
	CreateLink2(gui, pParent, pParentPath, _CreateLink2BasesFolder<GUI>());
}

template<typename GUI>
void CBaseList<GUI>::CreateLink2BaseDir(GUI& gui, CDataGuiItem<GUI>* pParent, cstr pParentPath)
{
	CreateLink2(gui, pParent, pParentPath, _CreateLink2BaseDir<GUI>());
}
template<typename GUI>
void CBaseList<GUI>::CreateBaseDir(GUI& gui, CDataGuiItem<GUI>* pParent, cstr pParentPath)
{
	CreateDir(gui, pParent, pParentPath, _CreateBaseDir<GUI>());
}

template class CBaseList<COCDlg>;