// starterDlg.h : header file
//

#if !defined(AFX_OPENCONF_EXEDLG_H__D1271D3D_08B1_4AAA_BE8E_A1B0368C0F03__INCLUDED_)
#define AFX_OPENCONF_EXEDLG_H__D1271D3D_08B1_4AAA_BE8E_A1B0368C0F03__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

/////////////////////////////////////////////////////////////////////////////
// COCDlg dialog
#include "resource.h"
#include "gui_utils/MyToolBar.h"
#include "gui_utils/CoolButton.h"
#include "iconlist.hpp"
#include "baselist.h"


class COCDlg : public CDialog
{
// Construction
public:
	void Run1C(WORD wMode);
	COCDlg(CWnd* pParent = NULL);	// standard constructor
	typedef HTREEITEM gui_item;		//       GUI    
	typedef CDataGuiItem<COCDlg> data_item;	//     
	enum { IDD = IDD_STARTER_DIALOG };
	
	//         
	enum RunModes
	{
		idRunEnterprise=1,
		idRunMonopole=2,
		idRunConfig=4,
		idRunDebug=8,
		idRunMonitor=16,
		idRunAll = idRunEnterprise | idRunMonopole | idRunConfig | idRunDebug | idRunMonitor, 
	};
	enum Operations
	{
		idCreateLinkFolder=1,
		idCreateLink2LinkFolder=2,
		idCreateLink2BasesDir=4,
		idCreateLink2BaseDir=8,
		idCreateBaseDir=16,
		idCreateAll = idCreateLinkFolder | idCreateLink2LinkFolder | idCreateLink2BasesDir | idCreateLink2BaseDir | idCreateBaseDir,
		idDeleteLink=32,
		idOpenObject=64,
	};

	// ,    
	CBaseList<COCDlg>* GetBaseList()
		{return m_pBases;}
	HWND GetHwnd()
		{return m_hWnd;}
	int GetIconIdx(cstr path, int iIconIdx, BOOL bIsBase)
		{return m_IconList.GetIdxFromPath(path, iIconIdx, bIsBase);}
	void SetComment(cstr comment)
		{m_status.SetWindowText(comment);}
	void DeleteItem(data_item* item)
		{m_baseTree.DeleteItem(item->m_guiItem);}

	void FillGroup(data_item* pGroup, HTREEITEM parent)
	{
		pGroup->Insert(*this, parent);
		for(data_item::iter it = pGroup->Child(); it ;++it)
			FillGroup(it, pGroup->m_guiItem);
	}
	
	void OrderTree(HTREEITEM hParent = TVI_ROOT);
	void OrderChild(HTREEITEM hParent = TVI_ROOT);
	
	void InsertItem(data_item* item, HTREEITEM& hItem, int iIcon, BOOL bIsBase, BOOL bIsLink, HTREEITEM parent)
	{
		cstr title = item->GetTitle();
		if(!bIsBase && m_bIsListMode)
			hItem = TVI_ROOT;
		else
		{
			BOOL bAdd = TRUE;
			if(m_bIsListMode)
			{
				CString ltitle(title);
				ltitle.MakeLower();
				CString* pStr = m_strFastFind.GetData();
				for(DWORD idx = m_strFastFind.GetSize();idx;pStr++)
				{
					if(ltitle.Find(*pStr)==-1)
					{
						bAdd = FALSE;
						break;
					}
					idx--;
				}
			}
			if(bAdd)
			{
				hItem = m_baseTree.InsertItem(title, iIcon, iIcon, parent);
				m_baseTree.SetItemData(hItem, reinterpret_cast<DWORD>(item));
				if(bIsLink)
					m_baseTree.SetItemState(hItem, INDEXTOOVERLAYMASK(1), TVIS_OVERLAYMASK);
			}
		}
	}
	
	void SelectItem(data_item* pItem)
	{
		m_baseTree.Select(pItem->m_guiItem, TVGN_CARET);
		m_baseTree.Select(pItem->m_guiItem, TVGN_FIRSTVISIBLE);
	}
	
	void SetOperation(WORD oper)
	{
		m_wEnabledOperations = oper;
		
		m_tlb.HideButton(ID_ADD_LINKFOLDER, 0==(oper & idCreateLinkFolder));
		m_tlb.HideButton(ID_ADD_LINK_LINKFOLDER, 0==(oper & idCreateLink2LinkFolder));
		m_tlb.HideButton(ID_ADD_LINK_BASEFOLDER, 0==(oper & idCreateLink2BasesDir));
		m_tlb.HideButton(ID_ADD_LINK_BASEDIR, 0==(oper & idCreateLink2BaseDir));
		m_tlb.HideButton(ID_ADD_BASEFOLDER, 0==(oper & idCreateBaseDir));
		m_tlb.HideButton(ID_DELETE_LIST_LINK, 0==(oper & idDeleteLink));
		m_tlb.HideButton(ID_OPEN_OBJECT, 0==(oper & idOpenObject));
	}
	void SetRunModes(WORD modes)
	{
		m_wEnabledModes = modes;
		m_brEnterprise.EnableWindow	(0 != (modes & idRunEnterprise));
		m_brMonopole.EnableWindow	(0 != (modes & idRunMonopole));
		m_brConfig.EnableWindow		(0 != (modes & idRunConfig));
		m_brDebug.EnableWindow		(0 != (modes & idRunDebug));
		m_brMonitor.EnableWindow	(0 != (modes & idRunMonitor));
	}

	void SetOperToolTip(Operations Oper, cstr strToolTip)
	{
		if(Oper == idOpenObject)
		{
			CString text;
			m_tlb.GetToolTip(ID_DELETE_LIST_OBJECT, text);
			int pos = text.Find('\n');
			if(pos>=0)
				text.GetBufferSetLength(pos + 1);
			else
				text+='\n';
			text += strToolTip;
			m_tlb.SetToolTip(ID_DELETE_LIST_OBJECT, text);
		}
	}
	
protected:
	BOOL FindDataItem(data_item* pParent, cstr strId, CString& buf);
	CBaseList<COCDlg>* m_pBases;
	DWORD m_bIsListMode;
	CStringArray m_strFastFind;
	WORD m_wEnabledOperations, m_wEnabledModes;
	HACCEL m_hAccel;
	HICON m_hIcon;
	CMyToolBar m_tlb;
	SIconList m_IconList;

// Dialog Data
	//{{AFX_DATA(COCDlg)
	CEdit	m_findbox;
	CCoolButton	m_brMonopole;
	CStatic	m_status;
	CTreeCtrl m_baseTree;
	CCoolButton	m_brMonitor;
	CCoolButton	m_brDebug;
	CCoolButton	m_brConfig;
	CCoolButton	m_brEnterprise;
	//}}AFX_DATA
	enum {IDM_ABOUTBOX = 0x0EE0};

// Implementation
	void FillTree(data_item* pCurItem = NULL);
	void LayoutControls();
	void OnOK();
	void OnCancel();
	data_item* GetCurrentItem();
	void InitAccelTable();
	void InitToolTips();
	static int CALLBACK CompareFunc(LPARAM lParam1, LPARAM lParam2, LPARAM lParamSort);

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(COCDlg)
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	//}}AFX_VIRTUAL
	
	// Generated message map functions
	//{{AFX_MSG(COCDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	afx_msg void OnDestroy();
	afx_msg void OnGetMinMaxInfo(MINMAXINFO FAR* lpMMI);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnSelchangedBasestree(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnDblClickBasestree(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnRunConfig();
	afx_msg void OnAddBasefolder();
	afx_msg void OnAddLinkBasedir();
	afx_msg void OnAddLinkBasefolder();
	afx_msg void OnAddLinkLinkfolder();
	afx_msg void OnAddLinkfolder();
	afx_msg void OnDeleteListLink();
	afx_msg void OnUpdateDeleteListLink(CCmdUI* pCmdUI);
	afx_msg void OnChangeFastFind();
	afx_msg void OnRunEnterprise();
	afx_msg void OnRunDebug();
	afx_msg void OnRunMonitor();
	afx_msg void OnRunMonopole();
	afx_msg void OnGetInfoTipBasestree(NMHDR* pNMHDR, LRESULT* pResult);
	afx_msg void OnUpdateAddLinkfolder(CCmdUI* pCmdUI);
	afx_msg void OnUpdateAddLinkLinkfolder(CCmdUI* pCmdUI);
	afx_msg void OnUpdateAddLinkBasefolder(CCmdUI* pCmdUI);
	afx_msg void OnUpdateAddLinkBasedir(CCmdUI* pCmdUI);
	afx_msg void OnUpdateAddBasefolder(CCmdUI* pCmdUI);
	afx_msg void OnRefresh();
	afx_msg void OnOpenBaselist();
	afx_msg void OnDeleteListLinkForce();
	afx_msg void OnOpenObject();
	afx_msg void OnUpdateOpenObject(CCmdUI* pCmdUI);
	afx_msg void OnOpenObjectProps();
	afx_msg void OnOpenLinkProps();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_OPENCONF_EXEDLG_H__D1271D3D_08B1_4AAA_BE8E_A1B0368C0F03__INCLUDED_)
