$NAME  - Markdown
/*===========================================================================
:  DocumentatorByMarkdownStyle.js (" - Markdown")
:  1.0.0.2
:    
E-mail:  PhoenixUSA@yandex.ru
ICQ UIN: 127-428-542
: 
	       Markdown
===========================================================================*/


var gDirTxt;
var gDirHtml;

function ShowHtmlExt(url,title)
{
	var objIE = new ActiveXObject("InternetExplorer.Application");
	objIE.Navigate(url);
	objIE.Visible = 1;
}

function reloadSelf(_)
{
	Scripts.Reload(SelfScript.Name);
}

function ShowHtmlInt(url)
{
	var wnd = null;
	if (!CommonScripts.FSO.FileExists(url)) {
		var f = CommonScripts.FSO.CreateTextFile(url, true);
		f.Write("");
		f.Close();
	}
	wnd = OpenOleForm("Shell.Explorer", "");
	SelfScript.AddNamedItem("pdoc", wnd, false);
	pdoc.Navigate2(url);
	reloadSelf("");
}

function JSTrim(vValue)
{
	return  vValue.replace(/(^\s*)|(\s*$)/g, "");
}

function JSLTrim(vValue)
{
	return  vValue.replace(/(^\s*)/g, "");
}

function CheckDoc(_) 
{
	var doc = CommonScripts.GetTextDocIfOpened(0);
	if (doc) 
	{
		return doc;
	}
	else 
	{
		return false;
	}
}

function GetWinName(wnd)
{
	if (!(wnd == null))
	{
		var WndName = wnd.Document.Name;
		if (WndName.substring(0,41)=="CWorkBookDoc:: () - ") 
		{
			var SaveFileName = WndName.substring(41,WndName.length);
			var fso, s = "";
			fso = new ActiveXObject("Scripting.FileSystemObject");
			s += fso.GetFileName(SaveFileName);
			return s;
		}
		else
		{
			return WndName;
		}
	}
}


function replace_tcolor(pStr)
{
	var lStr = "";
	if (pStr.indexOf("tcstart",0) != -1)
	{
		lStr = pStr.replace("tcstart","<table bgcolor");
		lStr+=">";
		lStr+= "<tr><td>";
	}
	
	if (pStr.indexOf("tcend",0) != -1)
	{
		lStr = pStr.replace("tcend","</td></tr></table>");
	}
	
	if (lStr == "")
	{
		lStr = pStr;
	}
	
	return lStr;
}

function replace_precode(pStr)
{
	lStr = pStr;
	lStr = lStr.replace("pre/","<pre>");
	lStr = lStr.replace("/pre","</pre>");
	lStr = lStr.replace("code/","<code>");
	lStr = lStr.replace("/code","</code>");
	return lStr;
}

function getTags(pTxt,pPreDoc,pTech)
{
	var lStrings = pTxt.split('\r').join('').split('\n');
	if (pTech)
	{
		var re = /\/\/(i|d|!|tech)(\s+.*|$)/i
	}
	else
	{
		var re = /\/\/(i|d|!)(\s+.*|$)/i
	}
	
	var lPreStr = "";
	var lListStr = "*-+><";
	var lStrForNew = "*-+";
	var lStrHdr = "===---";
	// var lStrCode = "pre/;code/";
	// var lStrCodeEnd = "/pre;/code";
	
	var lStrCode = "<pre><code>";
	var lStrCodeEnd = "</pre></code>";
	
	
	var lStrTech = "tech";
	var lStrTColor = "tcstart";
	var lStrTColorEnd = "tcend";
	
	var lStrCurrent = "";
	var lStrForTech = "";
	var lStrForInfo = "";
	
	var lIsPreCode = false;
	
	for(var i=0; i<lStrings.length; i++) 
	{
		lStrCurrent = "";
		lStr = lStrings[i];
		var matches = lStr.match(re);
		if (matches != null)
		{
			lDocStr = matches[2];
			//!   ,   ,   
			if (lDocStr.indexOf("#") != -1)
			{
				lDocStr = JSTrim(lDocStr);
			}
			//!    ,    
			lTStr = JSTrim(lDocStr);
			
			if (lPreStr != "")
			{
				//!    
				if (lListStr.indexOf(lTStr.substring(0,1)) != -1)
				{
					L = lPreStr.substring(0,1);
					if (lListStr.indexOf(L,0) == -1)
					{
						// lStrForInfo += "\r\n";
						lStrCurrent += "\r\n";
					}
				}
				//!     
				else
				{
					L = lPreStr.substring(0,1);
					lStrPr = JSTrim(lPreStr);
					if (lStrCode.indexOf(lStrPr,0) != -1)
					{
						lIsPreCode = true;
					}
					if (lStrCodeEnd.indexOf(lStrPr,0) != -1)
					{
						lIsPreCode = false;
					}
					if (lStrTColor.indexOf(lStrPr,0) != -1)
					{
						lIsPreCode = true;
					}
					if (lStrTColorEnd.indexOf(lStrPr,0) != -1)
					{
						lIsPreCode = false;
					}

					//!     -   
					if (lStrForNew.indexOf(L,0) != -1)
					{
							// lStrForInfo += "\r\n";
							lStrCurrent += "\r\n";
					}
					else if (lPreStr.substring(lPreStr.length-2,lPreStr.length) != "&&")
					{
						//!       1  2  -   
						if (!lIsPreCode)
						{
							// lStrForInfo += "\r\n";
							lStrCurrent += "\r\n";
						}
					}
				}
			}
			
			lDocStrR = replace_tcolor(lDocStr);
// 			lDocStrR = replace_tcolor(lStrCurrent);
			lDocStrR = lDocStrR.replace("&&","  ") + "\r\n";
			lDocStrR += lStrCurrent;
			// lDocStrR = replace_precode(lDocStrR);
			
			if (matches[1] == "tech")
			{
				
				lStrForTech += lDocStrR + "\r\n";
// 				lStrForTech += lDocStrR.replace("&&","  ") + "\r\n";
			}
			else
			{
				//!  &&  2 ,    
 				lStrForInfo += lDocStrR.replace("&&","  ") + "\r\n";
			}
			lPreStr = JSLTrim(lDocStr);
		}
	}
	
	pPreDoc.WriteLine(lStrForInfo);
	if (lStrForTech !="")
	{
		pPreDoc.WriteLine("## ");	
		pPreDoc.WriteLine(lStrForTech);		
	}
	
}

function generatePreDoc(pTech)
{
	lDoc = CheckDoc(1);
	if (lDoc == false)
	{
		Message("   !", mNone);
	}
	else
	{
		var fso = new ActiveXObject("Scripting.FileSystemObject");
		var pPreDoc = fso.CreateTextFile(gDirTxt+"tmp.txt",true);
		getTags(lDoc.Text, pPreDoc, pTech);
		pPreDoc.Close();
	}
}

function generateDocWithType(pTech,pShow)
{
	var shell = new ActiveXObject('WScript.Shell')  
	var fso = new ActiveXObject("Scripting.FileSystemObject");
	
	var lNameAddon = pTech ? "." : "";

	lNewNameL = GetWinName(Windows.ActiveWnd) + lNameAddon +'.html';
	lNewNameT = GetWinName(Windows.ActiveWnd) + lNameAddon +'.txt';
	
	generatePreDoc(pTech);
	
	var pPreDoc = fso.CreateTextFile("pl_1.bat",true,false);
	pPreDoc.WriteLine('Markdown.pl "'+ gDirTxt+'tmp.txt" >"' + gDirHtml+'tmp.html"');
	pPreDoc.Close();
	shell.Run("pl_1.bat", 1, true);	
	
	lFrom = gDirTxt+'tmp.txt';
	lTo = gDirTxt+lNewNameT;
	fso.CopyFile(lFrom, lTo, true);
	fso.DeleteFile(lFrom, true);

	lFrom = gDirHtml+'tmp.html';
	lTo = gDirHtml+lNewNameL;
	fso.CopyFile(lFrom, lTo, true);
	fso.DeleteFile(lFrom, true);

	if (pShow == 1)
	{
		ShowHtmlExt(lTo);
	}
	else if (pShow == 2)
	{
		ShowHtmlInt(lTo);
	}
}


function generateDocTech()
{
	generateDocWithType(true,0);
}


function generateDoc()
{
	generateDocWithType(false,0);
}

function generateDocAll()
{
	generateDocWithType(true,0);
	generateDocWithType(false,0);
}


function generateDocTechWithShowExt()
{
	generateDocWithType(true,1);
}
function generateDocTechWithShowInt()
{
	generateDocWithType(true,2);
}


function generateDocWithShowExt()
{
	generateDocWithType(false,1);
}

function generateDocWithShowInt()
{
	generateDocWithType(false,2);
}


function InsertTag()
{

	var doc = CommonScripts.GetTextDoc(1, 0);
	
	list = "";
	list += "//i \r\n";
	list += "//i #\r\n";
	list += "//i ##\r\n";
	list += "//i ###\r\n";
	list += "//i ===\r\n";
	list += "//i ---\r\n";

	list += "//i +\r\n";
	list += "//i -\r\n";
	list += "//i *\r\n";
	list += "//i <pre>\r\n";
	list += "//i <code>\r\n";
	list += "//i </pre>\r\n";
	list += "//i </code>\r\n";

	list += "//tech \r\n";
	list += "//tech #\r\n";
	list += "//tech ##\r\n";
	list += "//tech ###\r\n";
	list += "//tech ===\r\n";
	list += "//tech ---\r\n";

	list += "//tech +\r\n";
	list += "//tech -\r\n";
	list += "//tech *\r\n";
	list += "//tech <pre>\r\n";
	list += "//tech <code>\r\n";
	list += "//tech </pre>\r\n";
	list += "//tech </code>\r\n";
	
	var vRes = CommonScripts.SelectValue(list, " ", "", true, true)
	if (!(vRes) == "")
	{
		doc.Range(doc.SelStartLine,doc.SelStartCol ,doc.SelEndLine ,doc.SelEndCol ) += vRes;
	}
}



function init(_)
{
    try {
        var c = null;
        if (!(c = new ActiveXObject("OpenConf.CommonServices"))) {
            throw(true);
        }        
        c.SetConfig(Configurator);
        SelfScript.AddNamedItem("CommonScripts", c, false);
	
	gDirTxt = IBDir +"Documentation\\txt\\";
	gDirHtml = IBDir +"Documentation\\html\\";
    }
    catch (e) {
	Message("    OpenConf.CommonServices", mRedErr);
	Message(e.description, mRedErr);
	Message(" " + SelfScript.Name + "  ", mInformation);
	Scripts.UnLoad(SelfScript.Name); 		
    }
}

init(1);