Imports System.Windows.Forms

Public Class QA
    Private obj1C As Object
    Private EM As Object
    Private VT As Object

    Private ItemIndex As Integer
    Private Item As ListViewItem

    Public Sub New(ByVal obj As Object, ByVal QueryText As String)

        ' This call is required by the Windows Form Designer.
        InitializeComponent()
        AddHandler qryText.TextChanged, AddressOf qryText_TextChanged

        ' Add any initialization after the InitializeComponent() call.
        obj1C = obj
        Me.qryText.Text = QueryText
        qryText_TextChanged(Me.qryText, New System.EventArgs)

        EM = obj1C.CreateObject("ExecuteModule")
        EM.AssignSource( _
            "Var mdw;" & vbCrLf & _
            "Function Str() Return String(); EndFunction" & vbCrLf & _
            "Function VT2Str(VT)" & vbCrLf & _
            "    NewVT = CreateObject("""");" & vbCrLf & _
            "    For I = 1 To VT.ColumnCount() Do" & vbCrLf & _
            "        NewVT.NewColumn(VT.GetColumnParameters(I), """");" & vbCrLf & _
            "    EndDo;" & vbCrLf & _
            "    NewVT.LinesCnt(VT.LinesCnt());" & vbCrLf & _
            "    For I = 1 To VT.LinesCnt() Do" & vbCrLf & _
            "        For J = 1 To VT.ColumnCount() Do" & vbCrLf & _
            "            NewVT.SetValue(I, J, String(VT.GetValue(I, J)));" & vbCrLf & _
            "        EndDo;" & vbCrLf & _
            "    EndDo;" & vbCrLf & _
            "    Return NewVT;" & vbCrLf & _
            "EndFunction" & vbCrLf & _
            "Function VarTypeStr() Return ValueTypeStr(); EndFunction" & vbCrLf & _
            "Function Doc2IdStr(O) Return mdw.ValueToDBString(O.CurrentDocument()); EndFunction" & vbCrLf & _
            "Function IdStr2Doc(t, s) Return mdw.ValueFromDBString(t, s); EndFunction" & vbCrLf & _
            "Function GetVal(t)" & vbCrLf & _
            "    retVal = """";" & vbCrLf & _
            "    If t = """" Then" & vbCrLf & _
            "        InputString(retVal, "" "", 80);" & vbCrLf & _
            "        retVal = TrimAll(retVal);" & vbCrLf & _
            "    ElsIf t = """" Then" & vbCrLf & _
            "        InputNumeric(retVal, "" "", 19, 5);" & vbCrLf & _
            "    ElsIf t = """" Then" & vbCrLf & _
            "        InputDate(retVal, "" "");" & vbCrLf & _
            "    EndIf;" & vbCrLf & _
            "    Return retVal;" & vbCrLf & _
            "EndFunction" & vbCrLf & _
            "mdw = CreateObject(""MetaDataWork"");" & vbCrLf & _
            "" & vbCrLf _
        )
        EM.Compile()
        EM.Execute()
    End Sub

    Private Sub QA_FormClosed(ByVal sender As Object, ByVal e As FormClosedEventArgs) Handles Me.FormClosed
        VT = Nothing
        EM = Nothing
        obj1C = Nothing
    End Sub

    Private Sub ToolStripButton1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ToolStripButton1.Click
        Dim RS As Object
        RS = obj1C.CreateObject("ODBCRecordset")

        For Each Item As ListViewItem In Params.Items
            If Trim(Item.SubItems(2).Text) <> "" Then
                If Microsoft.VisualBasic.Left(Item.SubItems(1).Text, 9) = "." Then
                    RS.SetTextParam(Item.Text, EM.IdStr2Doc(Item.SubItems(1).Text, Item.SubItems(2).Text))
                ElseIf Item.SubItems(1).Text = "" Then
                    RS.SetTextParam(Item.Text, Double.Parse(Item.SubItems(2).Text))
                ElseIf Item.SubItems(1).Text = "" Then
                    RS.SetTextParam(Item.Text, Date.Parse(Item.SubItems(2).Text))
                Else
                    RS.SetTextParam(Item.Text, Item.SubItems(2).Text)
                End If
            End If
        Next

        With Me.Result
            '.Visible = False
            .VirtualListSize = 0
            ItemIndex = -1
            .VirtualMode = False
            .Clear()

            Try
                VT = RS.ExecuteStatement(Me.qryText.Text)

                Select Case EM.VarTypeStr(VT)
                    Case ""
                        'VT = EM.VT2Str(VT)

                        Dim I As Integer
                        With .Columns
                            For I = 1 To VT.ColumnCount()
                                .Add(VT.GetColumnParameters(I))
                            Next
                        End With

                        .VirtualMode = True
                        .VirtualListSize = VT.LinesCnt()

                        'VT.SelectLines()
                        'Do While VT.GetLine() = 1
                        '    'With Result.Items.Add(EM.Str(VT.GetValue(VT.LineNum, 1)))
                        '    '    For I = 2 To VT.ColumnCount()
                        '    '        .SubItems.Add(EM.Str(VT.GetValue(VT.LineNum, I)))
                        '    '    Next
                        '    'End With
                        '    With Result.Items.Add(VT.GetValue(VT.LineNum, 1))
                        '        For I = 2 To VT.ColumnCount()
                        '            .SubItems.Add(VT.GetValue(VT.LineNum, I))
                        '        Next
                        '    End With
                        'Loop
                    Case ""
                        .Columns.Add(" ")
                        .Items.Add(EM.Str(VT))
                End Select
            Catch
                .VirtualListSize = 0
                .VirtualMode = False
                .Clear()
                .Columns.Add("")
                .Items.Add(RS.GetLastError())
            End Try
            '.Visible = True
        End With
    End Sub

    Private Sub ToolStripButton2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ToolStripButton2.Click
        Me.qryText.Text = ""
    End Sub

    Private Sub ToolStripButton3_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ToolStripButton3.Click
        With Params.Items.Add("pName")
            .SubItems.Add("")
            .SubItems.Add("")
            .SubItems.Add("")
        End With
    End Sub

    Private Sub ToolStripButton5_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ToolStripButton5.Click
        Params.Items.Remove(Params.FocusedItem)
    End Sub

    Private Sub Params_MouseDoubleClick(ByVal sender As Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles Params.MouseDoubleClick
        Dim lb As New System.Windows.Forms.ListBox
        lb.Size = New System.Drawing.Size(Params.Width, 100)
        lb.Location = New System.Drawing.Point(0, Params.Top + Params.FocusedItem.Position.Y + Params.FocusedItem.Font.Height)
        Me.SplitContainer2.Panel2.Controls.Add(lb)

        AddHandler lb.Click, AddressOf lb_Click

        lb.BeginUpdate()
        lb.Items.Add("")
        lb.Items.Add("")
        lb.Items.Add("")

        Dim md As Object = obj1C.MetaData
        Dim I As Integer
        For I = 1 To md.()
            lb.Items.Add("." & md.(I).)
        Next

        lb.EndUpdate()
        lb.SelectedIndex = lb.FindStringExact(Params.FocusedItem.SubItems(1).Text)

        lb.BringToFront()
        lb.Focus()
        lb.Select()
    End Sub

    Private Sub lb_Click(ByVal sender As Object, ByVal e As System.EventArgs)
        Dim lb As System.Windows.Forms.ListBox = sender

        Params.FocusedItem.SubItems(1).Text = lb.Text
        RemoveHandler lb.Click, AddressOf lb_Click
        Me.SplitContainer2.Panel2.Controls.Remove(lb)

        Dim mdw As Object = obj1C.CreateObject("MetaDataWork")

        If Microsoft.VisualBasic.Left(Params.FocusedItem.SubItems(1).Text, 9) = "." Then
            Dim doc As Object = obj1C.CreateObject(Params.FocusedItem.SubItems(1).Text)
            If doc.Choose(" ", "") = 1 Then
                Params.FocusedItem.SubItems(2).Text = EM.Doc2IdStr(doc)
                Params.FocusedItem.SubItems(3).Text = EM.Str(doc)
            End If
        Else
            Dim val As Object = EM.GetVal(Params.FocusedItem.SubItems(1).Text)
            Params.FocusedItem.SubItems(2).Text = CStr(val)
            Params.FocusedItem.SubItems(3).Text = CStr(val)
        End If
    End Sub

    Private Function ToSkip(ByVal c As Char) As Boolean
        Dim RetVal As Boolean

        RetVal = Char.IsLetterOrDigit(c)
        If Not RetVal Then RetVal = (c = "$"c)
        If Not RetVal Then RetVal = (c = ":"c)

        Return RetVal
    End Function

    Private Sub ColorWord(ByRef txt As String, ByRef uct As String, ByVal KeyWord As String)
        Dim I As Integer
        Dim skip As Boolean

        I = InStr(uct, KeyWord)
        Do While I > 0
            skip = False
            If I > 1 Then skip = ToSkip(txt.Chars(I - 2))
            If skip Then
                I += 1
            Else
                If I + KeyWord.Length - 1 < txt.Length Then skip = ToSkip(txt.Chars(I + KeyWord.Length - 1))
                If skip Then
                    I += 1
                Else
                    txt = txt.Substring(0, I - 1) & "\cf1 " & KeyWord & "\cf0 " & txt.Substring(I + KeyWord.Length - 1)
                    uct = uct.Substring(0, I - 1) & "\cf1 " & KeyWord & "\cf0 " & uct.Substring(I + KeyWord.Length - 1)
                    I += 6
                End If
            End If
            I = InStr(I, uct, KeyWord)
        Loop
    End Sub

    Private Sub qryText_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs)
        RemoveHandler qryText.TextChanged, AddressOf qryText_TextChanged
        Dim pos As Integer = Me.qryText.SelectionStart

        Dim rtf As String = "{\rtf1\ansi\ansicpg1251\deff0{\fonttbl{\f0\fnil\fcharset204{\*\fname Courier New;}Courier New CYR;}}" & vbCrLf & _
                            "{\colortbl ;\red0\green0\blue255;}" & vbCrLf & _
                            "\viewkind4\uc1\pard\lang1049\f0\fs17 "
        Dim txt As String = Me.qryText.Text
        txt = txt.Replace("\", "\\").Replace(vbLf, vbLf & "\par ")
        Dim uct As String = UCase(txt)
        ColorWord(txt, uct, "SELECT")
        ColorWord(txt, uct, "FROM")
        ColorWord(txt, uct, "WHERE")
        ColorWord(txt, uct, "GROUP BY")
        ColorWord(txt, uct, "HAVING")
        ColorWord(txt, uct, "ORDER BY")
        ColorWord(txt, uct, "UNION ALL")
        ColorWord(txt, uct, "UNION")
        rtf &= txt & vbLf & "\par }"
        Me.qryText.Rtf = rtf

        Me.qryText.SelectionStart = pos
        AddHandler qryText.TextChanged, AddressOf qryText_TextChanged
    End Sub

    Private Sub ToolStripButton11_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ToolStripButton11.Click
        Me.qryText.Paste()
    End Sub

    Private Sub ToolStripButton10_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ToolStripButton10.Click
        Me.qryText.Copy()
    End Sub

    Private Sub ToolStripButton9_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ToolStripButton9.Click
        Me.qryText.Cut()
    End Sub

    Private Sub ToolStripButton7_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ToolStripButton7.Click
        Dim myStream As System.IO.Stream
        Dim myStreamWriter As System.IO.StreamWriter
        Dim saveFileDialog1 As New System.Windows.Forms.SaveFileDialog()

        saveFileDialog1.Filter = "txt files (*.txt)|*.txt|All files (*.*)|*.*"
        saveFileDialog1.FilterIndex = 1
        saveFileDialog1.RestoreDirectory = True

        If saveFileDialog1.ShowDialog() = DialogResult.OK Then
            myStream = saveFileDialog1.OpenFile()
            If (myStream IsNot Nothing) Then
                myStreamWriter = New System.IO.StreamWriter(myStream)
                myStreamWriter.Write(Me.qryText.Text)
                myStreamWriter.Close()
                myStream.Close()
            End If
        End If
    End Sub

    Private Sub ToolStripButton6_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ToolStripButton6.Click
        Dim myStream As System.IO.Stream
        Dim myStreamReader As System.IO.StreamReader
        Dim saveFileDialog1 As New System.Windows.Forms.OpenFileDialog()

        saveFileDialog1.Filter = "txt files (*.txt)|*.txt|All files (*.*)|*.*"
        saveFileDialog1.FilterIndex = 1
        saveFileDialog1.RestoreDirectory = True

        If saveFileDialog1.ShowDialog() = DialogResult.OK Then
            myStream = saveFileDialog1.OpenFile()
            If (myStream IsNot Nothing) Then
                myStreamReader = New System.IO.StreamReader(myStream)
                Me.qryText.Text = myStreamReader.ReadToEnd()
                myStreamReader.Close()
                myStream.Close()
            End If
        End If
    End Sub

    Private Sub Result_RetrieveVirtualItem(ByVal sender As Object, ByVal e As System.Windows.Forms.RetrieveVirtualItemEventArgs) Handles Result.RetrieveVirtualItem
        If e.ItemIndex = ItemIndex Then
            e.Item = Item
        Else
            ItemIndex = e.ItemIndex

            Dim I As Integer
            Dim J As Integer = ItemIndex + 1

            Item = New ListViewItem(EM.Str(VT.GetValue(J, 1)).ToString)
            With Item
                For I = 2 To VT.ColumnCount()
                    .SubItems.Add(EM.Str(VT.GetValue(J, I)))
                Next
            End With
            e.Item = Item
            'e.Item = New ListViewItem(VT.GetValue(J, 1).ToString)
            'With e.Item
            '    For I = 2 To VT.ColumnCount()
            '        .SubItems.Add(VT.GetValue(J, I))
            '    Next
            'End With
        End If
    End Sub
End Class