Title	Real Mode 80386 Emulator, Version 1.40
;	Copyright (C) Lions Group, 1993-4. All rights reserved.
;------------------------------------------------------------------------------
Code		Segment	Para
		Org	100h
		Assume	CS:Code,DS:Code,ES:Code,SS:Code
		.286P
Main		PROC
		Jmp	Init
;--------------------------------------
TsrReq          Equ	124Fh
;--------------------------------------
HotShift	Equ	08h
QuitScan        Equ	01h
;--------------------------------------
CFlag		Equ	1 shl 0
PFlag		Equ	1 shl 2
AFlag		Equ	1 shl 4
ZFlag		Equ	1 shl 6
SFlag		Equ	1 shl 7
TFlag		Equ	1 shl 8
IFlag		Equ	1 shl 9
DFlag		Equ	1 shl 10d
OFlag		Equ	1 shl 11d
AllFlags	Equ	CFlag+PFlag+AFlag+ZFlag+SFlag+OFlag
All		Equ	0FFFFh
;--------------------------------------
Even
;--------------------------------------
LowAX		DW	0
HighAX		DW	0
LowCX		DW	0
HighCX		DW	0
LowDX		DW	0
HighDX		DW	0
LowBX		DW	0
HighBX		DW	0
LowSP		DW	0
HighSP		DW	0
LowBP		DW	0
HighBP		DW	0
LowSI		DW	0
HighSI		DW	0
LowDI		DW	0
HighDI		DW	0

SegES		DW	0
SegCS		DW	0
SegSS		DW	0
SegDS		DW	0
SegFS		DW	0
SegGS		DW	0

LowIP		DW	0
Flags		DW	0
HighFlags	DW	0

ExtDataFlag	DB	0
RepPfx		DB	0
DataSegPfx	DW	0
StackSegPfx	DW	0

Int01old	DD	0
Int06old	DD	0
Int09old	DD	0
Int21old	DD	0
Vectors		DD	100h Dup (0)
XmsControl	DD	0

KeyPressedFlag	DB	0
QuitFlag	DB	0

InstrListPtr	DW	Offset InstrList

		Mov	AX,CS:[InstrListPtr]

InstrList	DB	1024d Dup (0)
InstrListEnd	Equ	$

SoundMask	DB	0
StoreFlag	DB	0

TMask		DW	0	;TFlag
;------------------------------------------------------------------------------
Even
;------------------------------------------------------------------------------
InstrTable	DW	O,	Add01,	O,	Add03,	O,	Add05,	O,	O,		O,	Or09,	O,	Or0B,	O,	Or0D,	O,	Opc0F
		DW	O,	Adc11,	O,	Adc13,	O,	Adc15,	O,	O,		O,	Sbb19,	O,	Sbb1B,	O,	Sbb1D,	O,	O
		DW	O,	And21,	O,	And23,	O,	And25,	Pfx26,	O,		O,	Sub29,	O,	Sub2B,	O,	Sub2D,	Pfx2E,	O
		DW	O,	Xor31,	O,	Xor33,	O,	Xor35,	Pfx36,	O,		O,	Cmp39,	O,	Cmp3B,	O,	Cmp3D,	Pfx3E,	O
;4O
		DW	Inc40,	Inc40,	Inc40,	Inc40,	Inc40,	Inc40,	Inc40,	Inc40,		Dec48,	Dec48,	Dec48,	Dec48,	Dec48,	Dec48,	Dec48,	Dec48
		DW	Push50,	Push50,	Push50,	Push50,	Push50,	Push50,	Push50,	Push50,		Pop58,	Pop58,	Pop58,	Pop58,	Pop58,	Pop58,	Pop58,	Pop58
		DW	Pusha60,Popa61,	O,	O,	Pfx64,	Pfx65,	Pfx66,	Pfx67,		Push68,	Imul69,	Push6A,	O,	O,	O,	O,	O
		DW	O,	O,	O,	O,	O,	O,	O,	O,		O,	O,	O,	O,	O,	O,	O,	O
;8O
		DW	O,	Opc81,	O,	Opc83,	O,	Test85,	O,	Xchg87,		O,	Mov89,	O,	Mov8B,	Mov8C,	Lea8D,	Mov8E,	Opc8F
		DW	Xchg90,	Xchg90,	Xchg90,	Xchg90,	Xchg90,	Xchg90,	Xchg90,	Xchg90,		O,	Cdq99,	O,	O,	Pushf9C,Popf9D,	O,	O
		DW	O,	MovA1,	O,	MovA3,	O,	MovsdA5,O,	CmpsdA7,	O,	TestA9,	O,	StosdAB,O,	O,	O,	O
		DW	O,	O,	O,	O,	O,	O,	O,	O,		MovB8,	MovB8,	MovB8,	MovB8,	MovB8,	MovB8,	MovB8,	MovB8
;CO
		DW	O,	OpcC1,	O,	O,	LesC4,	LdsC5,	O,	MovC7,		O,	O,	O,	O,	O,	O,	O,	O
		DW	O,	OpcD1,	O,	OpcD3,	O,	O,	O,	O,		O,	O,	O,	O,	O,	O,	O,	O
		DW	O,	O,	O,	O,	O,	O,	O,	O,		O,	O,	O,	O,	O,	O,	O,	O
		DW	O,	O,	PfxF2,	PfxF3,	O,	O,	O,	OpcF7,		O,	O,	O,	O,	O,	O,	O,	OpcFF
;------------------------------------------------------------------------------
OpCode0F	DW	O,	O,	O,	O,	O,	O,	O,	O,		O,	O,	O,	O,	O,	O,	O,	O
		DW	O,	O,	O,	O,	O,	O,	O,	O,		O,	O,	O,	O,	O,	O,	O,	O
		DW	MovR_CR,O,	MovCR_R,O,	O,	O,	O,	O,		O,	O,	O,	O,	O,	O,	O,	O
		DW	O,	O,	O,	O,	O,	O,	O,	O,		O,	O,	O,	O,	O,	O,	O,	O
;40
		DW	O,	O,	O,	O,	O,	O,	O,	O,		O,	O,	O,	O,	O,	O,	O,	O
		DW	O,	O,	O,	O,	O,	O,	O,	O,		O,	O,	O,	O,	O,	O,	O,	O
		DW	O,	O,	O,	O,	O,	O,	O,	O,		O,	O,	O,	O,	O,	O,	O,	O
		DW	O,	O,	O,	O,	O,	O,	O,	O,		O,	O,	O,	O,	O,	O,	O,	O
;80
		DW	J80,	J80,	J80,	J80,	J80,	J80,	J80,	J80,		J80,	J80,	J80,	J80,	J80,	J80,	J80,	J80
		DW	O,	O,	O,	O,	O,	O,	O,	O,		O,	O,	O,	O,	O,	O,	O,	O
		DW	PushFS,	PopFS,	Invalid,BtA3,	ShldA4,	ShldA5,	O,	O,		PushGS,	PopGS,	O,	BtsAB,	ShrdAC,	ShrdAD,	O,	ImulAF
		DW	O,	O,	LssB2,	BtrB3,	LfsB4,	LgsB5,	MovzxB6,MovzxB7,	O,	O,	OpcBA,	BtcBB,	BsfBC,	BsrBD,	MovsxBE,MovsxBF
;C0
		DW	O,	O,	O,	O,	O,	O,	O,	O,		O,	O,	O,	O,	O,	O,	O,	O
		DW	O,	O,	O,	O,	O,	O,	O,	O,		O,	O,	O,	O,	O,	O,	O,	O
		DW	O,	O,	O,	O,	O,	O,	O,	O,		O,	O,	O,	O,	O,	O,	O,	O
		DW	O,	O,	O,	O,	O,	O,	O,	O,		O,	O,	O,	O,	O,	O,	O,	O
;------------------------------------------------------------------------------
OpCode81	DW	Add810,	Or811,	Adc812,	Sbb813,	And814,	Sub815,	Xor816,	Cmp817
OpCode83	DW	Add830,	Or831,	Adc832,	Sbb833,	And834,	Sub835,	Xor836,	Cmp837
OpCode8F	DW	Pop8F0,	O,	O,	O,	O,	O,	O,	O
OpCodeC1&D1&D3	DW	Rol0,	Ror1,	Rcl2,	Rcr3,	Shl4,	Shr5,	O,	Sar7
OpCodeF7	DW	TestF70,O,	NotF72,	NegF73,	O,	O,	O,	IdivF77
OpCodeFF	DW	IncFF0,	DecFF1,	O,	O,	O,	O,	PushFF6,O
;------------------------------------------------------------------------------
OpCodeMovR_CR	DW	MovR_C0,O,	O,	O,	O,	O,	O,	O
OpCodeMovCR_R	DW	MovC0_R,O,	O,	O,	O,	O,	O,	O
OpCodeBA	DW	O,	O,	O,	O,	O,	O,	O,	BtcBA7
;------------------------------------------------------------------------------
Int01		Proc	Far
		Push	BP
		Mov	BP,SP
		Push	BX
		Push	DS
		Lds	BX,[BP][2]
		Mov	BX,[BX]
		Cmp	BL,9Ch
		Jb	ExitInt01
		Cmp	BL,0CFh
		Ja	ExitInt01
		Cmp	BL,9Dh
		Jbe	PushfPopf
		Sub	BL,0CCh
		Jnb	IntIret
ExitInt01:
		Pop	DS
		Pop	BX
		Pop	BP
		Iret
IntIret:
		Je	Int3Proc
		Dec	BL
		Je	IntProc
		Dec	BL
		Je	IntoProc
IretProc:
		Mov	BX,CS
		Cmp	BX,[BP][4]
		Je	ExitInt01
		Or	[BP][12d],TFlag
		Jmp	ExitInt01
Int3Proc:
		Mov	BX,0301h
		Jmp	Short	ExitIntProc
IntoProc:
		Test	[BP][6],OFlag
		Je	ExitInt01
		Mov	BX,0401h
		Jmp	Short	ExitIntProc
IntProc:
		Mov	BL,02h
ExitIntProc:
		Pop	CS:[SegDS]
		Pop	CS:[LowBX]
		Pop	CS:[LowBP]
		Add	[BP][2],BL
		Mov	BL,BH
		Mov	BH,0
		Adc	Byte Ptr [BP][3],BH
		Push	[BP][6]
		Shl	BX,1
		Shl	BX,1
		Xor	BP,BP
		Mov	DS,BP
		Lds	BX,[BX]
		Push	DS
		Push	BX
		Mov	DS,CS:[SegDS]
		Mov	BX,CS:[LowBX]
		Mov	BP,CS:[LowBP]
		Iret
PushfPopf:
		Pop	CS:[SegDS]
		Pop	CS:[LowBX]
		Pop	CS:[LowBP]
		Pop	CS:[LowIP]
		Pop	CS:[SegCS]
		Pop	BX
		Je	PopfProc
PushfProc:
		Mov	BP,CS:[Flags]
		And	BP,0F000h
		And	BH,Low All xor TFlag shr 8
		Or      BX,BP
		Push	BX
		Test	BP,BP
		Je	ExitPushfPopfProc
		Jmp	Short	ExitPushfPopfProc2
PopfProc:
		Pop	BX
		Mov	CS:[Flags],BX
ExitPushfPopfProc:
		Or	BH,TFlag shr 8
ExitPushfPopfProc2:
		Push	BX
		Push	CS:[SegCS]
		Mov	BX,CS:[LowIP]
		Inc	BX
		Push	BX
		Mov	DS,CS:[SegDS]
		Mov	BX,CS:[LowBX]
		Mov	BP,CS:[LowBP]
		Jmp	Int01
Int01		Endp
;------------------------------------------------------------------------------
Int06		Proc	Far
		Mov	CS:[LowAX],AX
		Mov	CS:[SegDS],DS
		Mov	CS:[DataSegPfx],DS
		Mov	AX,CS
		Mov	DS,AX
	Inc	[StoreFlag]
;	Call	Sound
		Mov	[StackSegPfx],SS
		Mov	[LowCX],CX
		Mov	[LowDX],DX
		Mov	[LowBX],BX
		Mov	[LowBP],BP
		Mov	[LowSI],SI
		Mov	[LowDI],DI
		Mov	[SegES],ES
		Pop	BX
		Mov	[LowIP],BX
		Pop	ES
		Mov	[SegCS],ES
		Mov	AX,[Flags]
		And	AH,0F0h
		Pop	DX
;	And	DH,Low All xor TFlag shr 8
		Or	DH,AH
		Mov	[Flags],DX
		Mov	[SegSS],SS
		Mov	[LowSP],SP
		Mov	Word Ptr [ExtDataFlag],0
TranslateOpCode:
		Mov	AX,ES:[BX]
		Inc	BX
		Mov	DI,AX
		And	DI,00FFh
		Shl	DI,1
		Jmp	[DI][InstrTable]
ExitInt06:
		Push	DX
		Push	[SegCS]
		Push	BX

		Shr	[StoreFlag],1
		Jnc	ExitNoStore
		Cld
		Mov	AX,CS
		Mov	ES,AX
		Mov	DI,[InstrListPtr]
		Mov	SI,[LowIP]
		Sub	BX,SI
		Mov	CX,BX
		Add	BX,DI
		Cmp	BX,Offset InstrListEnd
		Jb	StoreLastInstr
;		Call	Sound2
		Mov	DI,Offset InstrList
	StoreLastInstr:
		Mov	DS,[SegCS]
	Rep	Movsb
		Mov	DS,AX
		Mov	[InstrListPtr],DI
ExitNoStore:
		Shr	DH,1
		Jnc	NoTrap
		Shl	DH,1
		Push	DX
		Xor	DX,DX
		Mov	ES,DX
		Push	ES:[6]
		Push	ES:[4]
NoTrap:
		Mov	AX,[LowAX]
		Mov	CX,[LowCX]
		Mov	DX,[LowDX]
		Mov	BX,[LowBX]
		Mov	BP,[LowBP]
		Mov	SI,[LowSI]
		Mov	DI,[LowDI]
		Mov	ES,[SegES]
		Mov	DS,[SegDS]
		Iret
Int06		Endp
;------------------------------------------------------------------------------
Int09           Proc	Far
		Push	BP
		Mov	BP,SP
		Push	AX
		Push	DS
		Xor	AX,AX
		Mov	DS,AX
		In	AL,60h
		Mov	AH,Byte Ptr DS:[0417h]
		And	AH,0Fh
		Push	CS
		Pop	DS
		Cmp	[KeyPressedFlag],0
		Jne	CheckHotKeyUp
		Cmp	AH,HotShift
		Jne	ExitInt09
CheckHotKeyDown:
		Cmp	AL,QuitScan
		Jne	ExitInt09
	Jmp	Quit
;		Mov	Byte Ptr [KeyPressedFlag],AL
;		Or	[QuitFlag],1
;		And	[BP][6],All Xor TFlag
;		Jmp	Short	ExitInt09
CheckHotKeyUp:
		Xor	AL,80h
		Js	ExitInt09
		Cmp	AL,[KeyPressedFlag]
		Jne	ExitInt09
		Xor	Byte Ptr [KeyPressedFlag],AL
ExitInt09:
		Pop	DS
		Pop	AX
		Pop	BP
		Jmp     CS:[Int09old]
Int09		Endp
;------------------------------------------------------------------------------
Int21		Proc	Far
		Cmp	AX,2506h
		Je	ProcessInt21SetVect06
		Test	CS:[QuitFlag],1
		Je	ProcessInt21
		Jmp	Quit
ProcessInt21SetVect06:
		Cmp	CX,TsrReq
		Jne	ExitInt21
		Push	BP
		Mov	BP,SP
		And	[BP][6],All xor TFlag
		Mov	DX,CS
		Pop	BP
		Iret
ProcessInt21:
		Cmp	AH,4Bh
		Jne	ExitInt21
		Pusha
		Mov	BP,SP
		Push	DS
		Push	ES
		Cld
		Xor	SI,SI
		Mov	DS,SI
		Mov	CX,CS
		Mov	ES,CX
		Mov	DI,Offset Vectors
		Mov	CX,200h
	Rep	Movsw
		Pop	ES
		Pop	DS
		Mov	CS:[Flags],CX
		Mov	AX,[BP][14h]
		And	AH,Low All xor IFlag shr 8
		Or	AX,CS:[TMask]
		Push	AX
		Popf
		Popa
ExitInt21:
		Jmp	CS:[Int21old]
Int21		Endp
;------------------------------------------------------------------------------
Pfx26		Proc	Near			;ES:
		Mov	AX,[SegES]
		Mov	[DataSegPfx],AX
		Mov	[StackSegPfx],AX
		Jmp	TranslateOpCode
Pfx26		Endp
;--------------------------------------
Pfx2E		Proc	Near			;CS:
		Mov	AX,[SegCS]
		Mov	[DataSegPfx],AX
		Mov	[StackSegPfx],AX
		Jmp	TranslateOpCode
Pfx2E		Endp
;--------------------------------------
Pfx36		Proc	Near			;SS:
		Mov	AX,[SegSS]
		Mov	[DataSegPfx],AX
		Mov	[StackSegPfx],AX
		Jmp	TranslateOpCode
Pfx36		Endp
;--------------------------------------
Pfx3E		Proc	Near			;DS:
		Mov	AX,[SegDS]
		Mov	[DataSegPfx],AX
		Mov	[StackSegPfx],AX
		Jmp	TranslateOpCode
Pfx3E		Endp
;--------------------------------------
Pfx64		Proc	Near			;FS:
		Mov	AX,[SegFS]
		Mov	[DataSegPfx],AX
		Mov	[StackSegPfx],AX
		Jmp	TranslateOpCode
Pfx64		Endp
;--------------------------------------
Pfx65		Proc	Near			;GS
		Mov	AX,[SegGS]
		Mov	[DataSegPfx],AX
		Mov	[StackSegPfx],AX
		Jmp	TranslateOpCode
Pfx65		Endp
;--------------------------------------
Pfx66		Proc	Near			;Extended Data
		Inc	[ExtDataFlag]
		Jmp	TranslateOpCode
Pfx66		Endp
;--------------------------------------
Pfx67		Proc	Near			;Extended Address
		Jmp	O
Pfx67		Endp
;--------------------------------------
PfxF2		Proc	Near			;Repnz
		Mov	[RepPfx],1
		Jmp	TranslateOpCode
PfxF2		Endp
;--------------------------------------
PfxF3		Proc	Near			;Rep
		Mov	[RepPfx],1+ZFlag
		Jmp	TranslateOpCode
PfxF3		Endp
;------------------------------------------------------------------------------
Opc0F		Proc	Near
		Inc	BX
		Mov	AL,AH
		Mov	AH,0
		Mov	DI,AX
		Shl	DI,1
		Jmp	[DI][OpCode0F]
Opc0F		Endp
;--------------------------------------
Opc81		Proc	Near
		Call	GetOpCode&RM
		Jmp	[SI][OpCode81]
Opc81		Endp
;--------------------------------------
Opc83		Proc	Near
		Call	GetOpCode&RM
		Jmp	[SI][OpCode83]
Opc83		Endp
;--------------------------------------
Opc8F		Proc	Near
		Call	GetOpCode&RM
		Jmp	[SI][OpCode8F]
Opc8F		Endp
;--------------------------------------
OpcC1		Proc	Near
		Call	GetOpCode&RM
		Mov	DS,[SegCS]
		Mov	CL,[BX]
		Inc	BX
		Mov	AX,CS
		Mov	DS,AX
		And	CX,11111b
		Je	ExitOpcC1
		Mov	AH,DL
		Sahf
		Mov	AX,ES:[DI]
		Mov	DX,ES:[DI][2]
		Jmp	[SI][OpCodeC1&D1&D3]
ExitOpcC1:
		Jmp	ExitInt06
OpcC1		Endp
;--------------------------------------
OpcD1		Proc	Near
		Call	GetOpCode&RM
		Mov	CX,1
		Mov	AH,DL
		Sahf
		Mov	AX,ES:[DI]
		Mov	DX,ES:[DI][2]
		Jmp	[SI][OpCodeC1&D1&D3]
OpcD1		Endp
;--------------------------------------
OpcD3		Proc	Near
		Call	GetOpCode&RM
		Mov	CX,[LowCX]
		And	CX,11111b
		Je	ExitOpcD3
		Mov	AH,DL
		Sahf
		Mov	AX,ES:[DI]
		Mov	DX,ES:[DI][2]
		Jmp	[SI][OpCodeC1&D1&D3]
ExitOpcD3:
		Jmp	ExitInt06
OpcD3		Endp
;--------------------------------------
OpcF7		Proc	Near
		Call	GetOpCode&RM
		Jmp	[SI][OpCodeF7]
OpcF7		Endp
;--------------------------------------
OpcFF		Proc	Near
		Call	GetOpCode&RM
		Jmp	[SI][OpCodeFF]
OpcFF		Endp
;------------------------------------------------------------------------------
MovR_CR		Proc	Near			;Mov R32,CR0/CR2/CR3
		Mov	SI,ES:[BX]
		Mov	DI,SI
		And	SI,07h
		Shl	SI,2
		Add	SI,Offset LowAX
		And	DI,07h shl 3
		Shr	DI,2
		Inc	BX
		Jmp	[DI][OpCodeMovR_CR]
MovR_CR		Endp
;------------------------------------------------------------------------------
MovCR_R		Proc	Near                  	;Mov CR0/CR2/CR3,R32
		Mov	SI,ES:[BX]
		Mov	DI,SI
		And	SI,07h
		Shl	SI,2
		Add	SI,Offset LowAX
		And	DI,07h shl 3
		Shr	DI,2
		Inc	BX
		Jmp	[DI][OpCodeMovCR_R]
MovCR_R		Endp
;------------------------------------------------------------------------------
OpcBA		Proc	Near
		Call	GetOpCode&RM
		Mov	DS,[SegCS]
		Mov	CL,[BX]
		Inc	BX
		Mov	AX,CS
		Mov	DS,AX
		Jmp	[SI][OpCodeBA]
OpcBA		Endp
;------------------------------------------------------------------------------
O		Proc	Near
		Mov	CS:[TMask],0
		Int	03
		Call 	ResetIRQ
		Call	RestoreVectors
		Call	FreeXMS
		Cld
		Push	CS
		Pop	ES
		Mov	DI,Offset InstrList
		Mov	SI,[LowIP]
		Mov	DS,[SegCS]
		Mov	CX,100h
	Rep	Movsb
		Mov	AX,4C00h
		Int	21h
O		Endp
;------------------------------------------------------------------------------
Quit		Proc	Near
		Mov	AX,CS
		Mov	DS,AX
		Mov	[QuitFlag],0
		Mov	[TMask],0
		Call 	ResetIRQ
		Call	RestoreVectors
		Call	FreeXMS
		Mov	AX,4C00h
		Int	21h
Quit		Endp
;------------------------------------------------------------------------------
ResetIRQ	Proc	Near
		Pusha
		Push	DS
		Mov	AL,20h			;Reset IRQ
		Out	20h,AL

		Mov	AL,36h                  ;Set RTC
		Out	43h,AL
		Mov	AL,0FFh
		Out	40h,AL
		Out	40h,AL

		In	AL,61h                 	;Disable Sound
		And	AL,0FEh
		Out	61h,AL

		Mov	AX,40h			;Set VideoMode
		Mov	DS,AX
		Mov	AX,03h
		Int	10h
ResetMouse:
		Xor	AX,AX			;Reset Mouse
		Mov	DS,AX
		Cmp	DS:[33h*4][2],AX
		Je	ExitIRQ
		Int	33h
ExitIRQ:
		Pop	DS
		Popa
		Ret
ResetIRQ	Endp
;------------------------------------------------------------------------------
RestoreVectors	Proc	Near
		Pusha
		Push	ES
		Mov	SI,Offset Vectors
		Xor	DI,DI
		Mov	ES,DI
		Mov	CX,200h
		Cld
		Cli
	Rep	Movsw
		Sti
		Pop	ES
		Popa
		Ret
RestoreVectors	Endp
;------------------------------------------------------------------------------
FreeXMS		Proc	Near
		Pusha
		Mov	AH,09h  		;Allocate XMS Block 0 Kb
		Xor	DX,DX
		Call	[XmsControl]
		Mov	CL,0
		Mov	CH,DH
FreeXmsLoop:
		Mov	AH,0Dh			;UnLock XMS Block
		Mov	DX,CX
		Call	[XmsControl]
		Mov	AH,0Ah			;Free XMS Block
		Mov	DX,CX
		Call	[XmsControl]
		Inc	CL
		Jne	FreeXmsLoop
		Popa
		Ret
FreeXMS		Endp
;------------------------------------------------------------------------------
Store		Proc	Near
;		Push	AX
		Inc	[StoreFlag]
;		Mov	AX,[SI]
;		Mov	[LowReg],AX
;		Mov	AX,[SI][2]
;		Mov	[HighReg],AX
;		Mov	AX,ES:[DI]
;		Mov	[LowRM],AX
;		Mov	AX,ES:[DI][2]
;		Mov	[HighRM],AX
;		Pop	AX
		Call	Sound
		Ret
Store		Endp
;------------------------------------------------------------------------------
Sound		Proc	Near
		Push	AX
		In	AL,61h
		Xor	AL,02h
		Out	61h,AL
		Pop	AX
		Ret
Sound		Endp
;------------------------------------------------------------------------------
Sound2		Proc	Near
		Push	AX
		Push	CX
		In	AL,61h
		Mov	AH,80h
SoundLoop:
		Mov	CX,100h
		Xor	AL,02h
		Out	61h,AL
SoundDelay:
		Loop	SoundDelay
		Dec	AH
		Jne	SoundLoop
		Pop	CX
		Pop	AX
		Ret
Sound2		Endp
;------------------------------------------------------------------------------
GetOpCode&RM	Proc	Near
		Mov	AX,ES:[BX]		;Output		SI-Opcode x 2
		Inc	BX			;		ES:DI-R/M Addr
		Mov	SI,AX
		Shr	SI,1
		Shr	SI,1
		And	SI,00001110b
		Jmp	Short	BeginGetReg&RM
GetReg&RM:					;Output: 	DS:SI-Reg Pointer
		Mov	AX,ES:[BX]		;		ES:DI-R/M Addr
		Inc	BX
		Mov	SI,AX
		Shr	SI,1
		And	SI,00011100b
		Add	SI,Offset LowAX
BeginGetReg&RM:
		Test	AL,11000000b
		Jns	Mod00
		Test	AL,01000000b
		Je	Mod10
		And	AX,00000111b
		Shl	AX,1
		Shl	AX,1
		Mov	DI,AX
		Add	DI,Offset LowAX
		Mov	AX,CS
		Mov	ES,AX
		Ret
Mod00:
		Jne	Mod01
		Xor	DI,DI
		And	AL,00000111b
		Cmp	AL,00000110b
		Jne	AddIndex
		Mov	DI,ES:[BX]
		Lea	BX,[BX][2]
		Mov	ES,[DataSegPfx]
	Jmp	Short	ExitGetReg&RM
;		Ret
Mod01:
		Mov	DI,AX
		Mov	AL,AH
		Cbw
		Xchg	AX,DI
		And	AL,00000111b
		Inc	BX
		Jmp	Short	AddIndex
Mod10:
		Mov	DI,ES:[BX]
		And	AL,00000111b
		Lea	BX,[BX][2]
AddIndex:
		Cmp	AL,00000110b
		Je	BaseBP
		Mov	ES,[DataSegPfx]
		Ja	BaseBX
		Shr	AL,1
		Jc	IndexDI
		Add	DI,[LowSI]
		Jmp	Short	AddBase
IndexDI:
		Add	DI,[LowDI]
AddBase:
		Shr	AL,1
		Jne	ExitGetReg&RM
		Jc	BaseBP
BaseBX:
		Add	DI,[LowBX]
	Jmp	Short	ExitGetReg&RM
;		Ret
BaseBP:
		Mov	ES,[StackSegPfx]
		Add	DI,[LowBP]
ExitGetReg&RM:
		Ret
GetOpCode&RM	Endp
;------------------------------------------------------------------------------
Invalid         Proc	Near			;Invalid OpCode
		Jmp	ExitInt06
Invalid		Endp
;------------------------------------------------------------------------------
Cdq99		Proc	Near			;Cdq
		Mov	AL,Byte Ptr [HighAX][1]
		Cbw
		Mov	AL,AH
		Mov	[LowDX],AX
		Mov	[HighDX],AX
		Jmp	ExitInt06
Cdq99		Endp
;------------------------------------------------------------------------------
Mov89		Proc	Near			;Mov r/m32,r32
		Call	GetReg&RM
		Mov	AX,[SI]
		Mov	ES:[DI],AX
		Mov	AX,[SI][2]
		Mov	ES:[DI][2],AX
		Jmp	ExitInt06
Mov89		Endp
;--------------------------------------
Mov8B		Proc	Near			;Mov r32,r/m32
		Call	GetReg&RM
		Mov	AX,ES:[DI]
		Mov	[SI],AX
		Mov	AX,ES:[DI][2]
		Mov	[SI][2],AX
		Jmp	ExitInt06
Mov8B		Endp
;--------------------------------------
Mov8C		Proc	Near			;r/m16,SR
		Call	GetOpCode&RM
		Mov	AX,[SI][SegES]
		Mov	ES:[DI],AX
		Jmp	ExitInt06
Mov8C		Endp
;--------------------------------------
Mov8E		Proc	Near			;Mov SR,r/m16
		Call	GetOpCode&RM
		Mov	AX,ES:[DI]
		Mov	[SI][SegES],AX
		Jmp	ExitInt06
Mov8E		Endp
;--------------------------------------
MovA1		Proc	Near			;Mov EAX,Off32
		Mov	DI,ES:[BX]
		Mov	ES,[DataSegPfx]
		Mov	AX,ES:[DI]
		Mov	[LowAX],AX
		Mov	AX,ES:[DI][2]
		Mov	[HighAX],AX
		Lea	BX,[BX][2]
		Jmp	ExitInt06
MovA1		Endp
;--------------------------------------
MovA3		Proc	Near			;Mov Off32,EAX
		Mov	DI,ES:[BX]
		Mov	ES,[DataSegPfx]
		Mov	AX,[LowAX]
		Mov	ES:[DI],AX
		Mov	AX,[HighAX]
		Mov	ES:[DI][2],AX
		Lea	BX,[BX][2]
		Jmp	ExitInt06
MovA3		Endp
;--------------------------------------
MovB8		Proc	Near			;Mov reg32,imm32
		And	DI,7 shl 1
		Shl	DI,1
		Mov	AX,ES:[BX]
		Mov	[DI][LowAX],AX
		Mov	AX,ES:[BX][2]
		Mov	[DI][HighAX],AX
		Lea	BX,[BX][4]
		Jmp	ExitInt06
MovB8		Endp
;--------------------------------------
MovC7		Proc	Near			;Mov r/m32,imm32
		Call	GetReg&RM
		Mov	DS,[SegCS]
		Mov	AX,[BX]
		Mov	ES:[DI],AX
		Mov	AX,[BX][2]
		Mov	ES:[DI][2],AX
		Mov	AX,CS
		Mov	DS,AX
		Lea	BX,[BX][4]
		Jmp	ExitInt06
MovC7		Endp
;------------------------------------------------------------------------------
MovzxB6		Proc	Near			;Movzx r16,r/m8
		Call	GetReg&RM               ;Movzx r32,r/m8
		Mov	AL,ES:[DI]
		Mov	AH,0
		Xor	DX,DX
		Jmp	Short	StoreMovExt
MovzxB6		Endp
;--------------------------------------
MovzxB7		Proc	Near			;Movzx r32,r/m16
		Call	GetReg&RM
		Mov	AX,ES:[DI]
		Xor	DX,DX
		Jmp	Short	StoreMovExt
MovzxB7		Endp
;--------------------------------------
MovsxBE		Proc	Near			;Movsx r16,r/m8
		Call	GetReg&RM               ;Movsx r32,r/m8
		Mov	AL,ES:[DI]
		Cbw
		Cwd
		Jmp	Short	StoreMovExt
MovsxBE		Endp
;--------------------------------------
MovsxBF		Proc	Near			;Movsx r32,r/m16
		Call	GetReg&RM
		Mov	AX,ES:[DI]
		Cwd
StoreMovExt:
		Mov	[SI],AX
		Cmp	[ExtDataFlag],0
		Je	RestoreMovFlags
		Mov	[SI][2],DX
RestoreMovFlags:
		Mov	DX,[Flags]
		Jmp	ExitInt06
MovsxBF		Endp
;------------------------------------------------------------------------------
MovsdA5		Proc	Near
		Mov	CX,1
		Test	[RepPfx],CL
		Je	ProcessMovsd
		Mov	CX,[LowCX]
		Jcxz	QuitMovsd
ProcessMovsd:
		Mov	DI,[LowDI]
		Mov	ES,[SegES]
		Mov	SI,[LowSI]
		Mov	DS,[DataSegPfx]
		Std
		Test	DH,DFlag shr 8
		Jne	DoMovsd
		Cld
DoMovsd:
		Mov	AX,CX
	Rep	Movsw
		Mov	CX,AX
	Rep	Movsw
		Mov	AX,CS
		Mov	DS,AX
		Test	[RepPfx],1
		Je	ExitMovsd
		Mov	[LowCX],CX
ExitMovsd:
		Mov	[LowSI],SI
		Mov	[LowDI],DI
QuitMovsd:
		Mov	[RepPfx],CL
		Jmp	ExitInt06
MovsdA5		Endp
;------------------------------------------------------------------------------
MovR_C0		Proc	Near
	.386P
		Smsw	AX
	.286P
		Mov	[SI],AX
		Mov	Word Ptr [SI][2],0
		Jmp	ExitInt06
MovR_C0		Endp
;------------------------------------------------------------------------------
MovC0_R		Proc	Near
		Mov	AX,[SI]
	.386P
		Lmsw	AX
	.286P
		Jmp	ExitInt06
MovC0_R		Endp
;------------------------------------------------------------------------------
CmpsdA7		Proc	Near			;Cmpsd
		Mov	CX,1
		Test	[RepPfx],CL
		Je	ProcessCmpsd
		Mov	CX,[LowCX]
		Jcxz	QuitCmpsd
ProcessCmpsd:
		Push	BX
		Mov	BL,DH
		And	BX,4
		Neg	BX
		Add	BX,2
		Shl	BX,1
		Mov	DI,[LowDI]
		Mov	ES,[SegES]
		Mov	SI,[LowSI]
		Mov	DS,[DataSegPfx]
CmpsdLoop:
		Mov	AX,[SI]
		Sub	AX,ES:[DI]
		Lahf
		Mov	DL,AH
		Mov	AX,[SI][2]
		Sbb	AX,ES:[DI][2]
		Pushf
		Pop	AX
		Or	DX,AllFlags xor PFlag+AFlag+ZFlag
		Or	AX,All xor CFlag+ZFlag+SFlag+OFlag
		And	DX,AX
		Lea	SI,[SI][BX]
		Lea	DI,[DI][BX]
		Mov	AX,DX
		Xor	AL,CS:[RepPfx]
		And	AX,ZFlag
		LoopE	CmpsdLoop
		Mov	AX,CS
		Mov	DS,AX
		Test	[RepPfx],1
		Je	ExitCmpsd
		Mov	[LowCX],CX
ExitCmpsd:
		Mov	[LowSI],SI
		Mov	[LowDI],DI
		Pop	BX
QuitCmpsd:
		Mov	[RepPfx],0
		Jmp	ExitInt06
CmpsdA7		Endp
;------------------------------------------------------------------------------
StosdAB		Proc	Near
		Mov	CX,1
		Test	[RepPfx],CL
		Je	ProcessStosd
		Mov	CX,[LowCX]
		Jcxz	ExitStosd
ProcessStosd:
		Mov	AL,DH
		And	AX,4
		Mov	SI,2
		Sub	SI,AX
		Shl	SI,1
		Mov	AX,[LowAX]
		Mov	BP,[HighAX]
		Mov	DI,[LowDI]
		Mov	ES,[SegES]
StosdLoop:
		Mov	ES:[DI],AX
		Mov	ES:[DI][2],BP
		Add	DI,SI
		Loop	StosdLoop
		Mov	[LowDI],DI
		Test	[RepPfx],1
		Je	ExitStosd
		Mov	[LowCX],CX
ExitStosd:
		Mov	[RepPfx],0
		Jmp	ExitInt06
StosdAB		Endp
;------------------------------------------------------------------------------
Push50		Proc	Near			;Push r32
		And	DI,7 shl 1
		Shl	DI,1
		Push	[DI][HighAX]
		Push	[DI][LowAX]
		Jmp	ExitInt06
Push50		Endp
;--------------------------------------
Pusha60		Proc	Near			;Pushad
	;Jmp O
		Mov	CX,8
		Mov	SI,Offset LowAX
PushadLoop:
		Push	[SI][2]
		Push	[SI]
		Lea	SI,[SI][4]
		Loop	PushadLoop
		Jmp	ExitInt06
Pusha60		Endp
;--------------------------------------
Push68		Proc	Near			;Push imm32
		Push	ES:[BX][2]
		Push	ES:[BX]
		Lea	BX,[BX][4]
		Jmp	ExitInt06
Push68		Endp
;--------------------------------------
Push6A		Proc	Near			;Push imm8
		Mov	AL,ES:[BX]
		Cbw
		Mov	CL,AH
		Mov	CH,AH
		Push	CX
		Push	AX
		Inc	BX
		Jmp	ExitInt06
Push6A		Endp
;--------------------------------------
PushFF6		Proc	Near			;Push m32
		Push	ES:[DI][2]
		Push	ES:[DI]
		Jmp	ExitInt06
PushFF6		Endp
;--------------------------------------
PushFS		Proc	Near			;Push FS
		Push	[SegFS]
		Jmp	ExitInt06
PushFS		Endp
;--------------------------------------
PushGS		Proc	Near			;Push GS
		Push	[SegGS]
		Jmp	ExitInt06
PushGS		Endp
;------------------------------------------------------------------------------
Pushf9C         Proc	Near			;Pushfd
;		Xor	AX,AX
;		Push	AX
	Push	[HighFlags]
		Push	DX
		Jmp	ExitInt06
Pushf9C		Endp
;------------------------------------------------------------------------------
Pop58		Proc	Near			;Pop r32
		And	DI,7 shl 1
		Shl	DI,1
		Pop	[DI][LowAX]
		Pop	[DI][HighAX]
		Jmp	ExitInt06
Pop58		Endp
;--------------------------------------
Popa61		Proc	Near			;Popad
	;Jmp O
		Mov	SI,Offset LowDI
		Mov	CX,8
PopadLoop:
		Pop	[SI]
		Pop	[SI][2]
		Lea	SI,[SI-4]
		Loop	PopadLoop
		Jmp	ExitInt06
Popa61		Endp
;--------------------------------------
Pop8F0		Proc	Near			;Pop m32
		Pop	ES:[DI]
		Pop	ES:[DI][2]
		Jmp	ExitInt06
Pop8F0		Endp
;--------------------------------------
PopFS		Proc	Near			;Pop FS
		Pop	[SegFS]
		Jmp	ExitInt06
PopFS		Endp
;--------------------------------------
PopGS		Proc	Near			;Pop GS
		Pop	[SegGS]
		Jmp	ExitInt06
PopGS		Endp
;------------------------------------------------------------------------------
Popf9D		Proc	Near			;Popfd
		Pop	DX
	Pop	[HighFlags]
;		Pop	AX
		Jmp	ExitInt06
Popf9D		Endp
;------------------------------------------------------------------------------
Xchg87		Proc	Near			;Xchg r32,r/m32
	;Jmp O
		Call	GetReg&RM
		Mov	AX,[SI]
		Xchg	AX,ES:[DI]
		Mov	[SI],AX
		Mov	AX,[SI][2]
		Xchg	AX,ES:[DI][2]
		Mov	[SI][2],AX
		Jmp	ExitInt06
Xchg87		Endp
;--------------------------------------
Xchg90		Proc	Near			;Xchg EAX,r32
	;Jmp O
		And	DI,7 shl 1
		Shl	DI,1
		Mov	AX,[LowAX]
		Xchg	AX,[DI][LowAX]
		Mov	[LowAX],AX
		Mov	AX,[HighAX]
		Xchg	AX,[DI][HighAX]
		Mov	[HighAX],AX
		Jmp	ExitInt06
Xchg90		Endp
;------------------------------------------------------------------------------
Lea8D		Proc	Near			;Lea r32,r/m32
	;Jmp O
		Call	GetReg&RM
		Mov	[SI],DI
		Xor	AX,AX
		Mov	[SI][2],AX
		Jmp	ExitInt06
Lea8D		Endp
;--------------------------------------
LssB2		Proc	Near			;Lds r32,r/m32
		Push	Offset SegSS
		Jmp	Short	LoadFullPointer
LssB2		Endp
;--------------------------------------
LdsC5		Proc	Near
		Push	Offset SegDS
		Jmp	Short	LoadFullPointer
LdsC5		Endp
;--------------------------------------
LesC4		Proc	Near
		Push	Offset SegES
		Jmp	Short	LoadFullPointer
LesC4		Endp
;--------------------------------------
LfsB4		Proc	Near
		Push	Offset SegFS
		Jmp	Short	LoadFullPointer
LfsB4		Endp
;--------------------------------------
LgsB5		Proc	Near
		Push	Offset	SegGS
LoadFullPointer:
	;Jmp O
		Call	GetReg&RM
		Mov	AX,ES:[DI]
		Mov	[SI],AX
		Cmp	[ExtDataFlag],0
		Je	LoadDataSeg
		Lea	DI,[DI][2]
		Mov	AX,ES:[DI]
		Mov	[SI][2],AX
LoadDataSeg:
		Pop	SI
		Mov	AX,ES:[DI][2]
		Mov	[SI],AX
		Cmp	SI,Offset SegSS
		Jne	ExitLoadFullPointer
		Mov	SS,[SI]
		Mov	SP,[LowSP]
ExitLoadFullPointer:
		Jmp	ExitInt06
LgsB5		Endp
;------------------------------------------------------------------------------
Add01		Proc	Near			;Add r/m32,r32
		Call	GetReg&RM
		Mov	AX,[SI]
		Add	ES:[DI],AX
		Lahf
		Mov	DL,AH
		Mov	AX,[SI][2]
		Adc	ES:[DI][2],AX
		Pushf
		Pop	AX
		Or	DX,AllFlags xor PFlag+AFlag+ZFlag
		Or	AX,All xor CFlag+ZFlag+SFlag+OFlag
		And	DX,AX
		Jmp	ExitInt06
Add01		Endp
;--------------------------------------
Add03		Proc	Near			;Add r32,r/m32
		Call	GetReg&RM
		Mov	AX,ES:[DI]
		Add	[SI],AX
		Lahf
		Mov	DL,AH
		Mov	AX,ES:[DI][2]
		Adc	[SI][2],AX
		Pushf
		Pop	AX
		Or	DX,AllFlags xor PFlag+AFlag+ZFlag
		Or	AX,All xor CFlag+ZFlag+SFlag+OFlag
		And	DX,AX
		Jmp	ExitInt06
Add03		Endp
;--------------------------------------
Add05		Proc	Near			;Add EAX,imm32
		Mov	AX,ES:[BX]
		Add	[LowAX],AX
		Lahf
		Mov	DL,AH
		Mov	AX,ES:[BX][2]
		Adc	[HighAX],AX
		Pushf
		Pop	AX
		Or	DX,AllFlags xor PFlag+AFlag+ZFlag
		Or	AX,All xor CFlag+ZFlag+SFlag+OFlag
		And	DX,AX
		Lea	BX,[BX][4]
		Jmp	ExitInt06
Add05		Endp
;--------------------------------------
Add810		Proc	Near			;Add r/m32,imm32
		Mov	DS,[SegCS]
		Mov	AX,[BX]
		Add	ES:[DI],AX
		Lahf
		Mov	DL,AH
		Mov	AX,[BX][2]
		Adc	ES:[DI][2],AX
		Pushf
		Pop	AX
		Or	DX,AllFlags xor PFlag+AFlag+ZFlag
		Or	AX,All xor CFlag+ZFlag+SFlag+OFlag
		And	DX,AX
		Mov	AX,CS
		Mov	DS,AX
		Lea	BX,[BX][4]
		Jmp	ExitInt06
Add810		Endp
;--------------------------------------
Add830		Proc	Near			;Add r/m32,imm8
		Mov	DS,[SegCS]
		Mov	CX,DX
		Mov	AL,[BX]
		Cbw
		Cwd
		Add	ES:[DI],AX
		Lahf
		Mov	CL,AH
		Adc	ES:[DI][2],DX
		Pushf
		Pop	DX
		Or	CX,AllFlags xor PFlag+AFlag+ZFlag
		Or	DX,All xor CFlag+ZFlag+SFlag+OFlag
		And	DX,CX
		Mov	AX,CS
		Mov	DS,AX
		Inc	BX
		Jmp	ExitInt06
Add830		Endp
;------------------------------------------------------------------------------
Adc11		Proc	Near			;Adc r/m32,r32
	;Jmp O
		Call	GetReg&RM
		Mov	AH,DL
		Sahf
		Mov	AX,[SI]
		Adc	ES:[DI],AX
		Lahf
		Mov	DL,AH
		Mov	AX,[SI][2]
		Adc	ES:[DI][2],AX
		Pushf
		Pop	AX
		Or	DX,AllFlags xor PFlag+AFlag+ZFlag
		Or	AX,All xor CFlag+ZFlag+SFlag+OFlag
		And	DX,AX
		Jmp	ExitInt06
Adc11		Endp
;--------------------------------------
Adc13		Proc	Near			;Adc r32,r/m32
	;Jmp O
		Call	GetReg&RM
		Mov	AH,DL
		Sahf
		Mov	AX,ES:[DI]
		Adc	[SI],AX
		Lahf
		Mov	DL,AH
		Mov	AX,ES:[DI][2]
		Adc	[SI][2],AX
		Pushf
		Pop	AX
		Or	DX,AllFlags xor PFlag+AFlag+ZFlag
		Or	AX,All xor CFlag+ZFlag+SFlag+OFlag
		And	DX,AX
		Jmp	ExitInt06
Adc13		Endp
;--------------------------------------
Adc15		Proc	Near			;Adc EAX,imm32
	;Jmp O
		Mov	AH,DL
		Sahf
		Mov	AX,ES:[BX]
		Adc	[LowAX],AX
		Lahf
		Mov	DL,AH
		Mov	AX,ES:[BX][2]
		Adc	[HighAX],AX
		Pushf
		Pop	AX
		Or	DX,AllFlags xor PFlag+AFlag+ZFlag
		Or	AX,All xor CFlag+ZFlag+SFlag+OFlag
		And	DX,AX
		Lea	BX,[BX][4]
		Jmp	ExitInt06
Adc15		Endp
;--------------------------------------
Adc812		Proc	Near			;Adc r/m32,imm32
	;Jmp O
		Mov	DS,[SegCS]
		Mov	AH,DL
		Sahf
		Mov	AX,[BX]
		Adc	ES:[DI],AX
		Lahf
		Mov	DL,AH
		Mov	AX,[BX][2]
		Adc	ES:[DI][2],AX
		Pushf
		Pop	AX
		Or	DX,AllFlags xor PFlag+AFlag+ZFlag
		Or	AX,All xor CFlag+ZFlag+SFlag+OFlag
		And	DX,AX
		Mov	AX,CS
		Mov	DS,AX
		Lea	BX,[BX][4]
		Jmp	ExitInt06
Adc812		Endp
;--------------------------------------
Adc832		Proc	Near			;Adc r/m32,imm8
	;Jmp O
		Mov	DS,[SegCS]
		Mov	CX,DX
		Mov	AH,DL
		Sahf
		Mov	AL,[BX]
		Cbw
		Cwd
		Adc	ES:[DI],AX
		Lahf
		Mov	CL,AH
		Adc	ES:[DI][2],DX
		Pushf
		Pop	DX
		Or	CX,AllFlags xor PFlag+AFlag+ZFlag
		Or	DX,All xor CFlag+ZFlag+SFlag+OFlag
		And	DX,CX
		Mov	AX,CS
		Mov	DS,AX
		Inc	BX
		Jmp	ExitInt06
Adc832		Endp
;------------------------------------------------------------------------------
Inc40		Proc	Near
		And	DI,7 shl 1		;Inc r32
		Shl	DI,1
		Add	[DI][LowAX],1
		Lahf
		Adc	[DI][HighAX],0
		Pushf
		Or	DX,AllFlags xor CFlag
		Or	AH,Low All xor PFlag+AFlag+ZFlag
		And	DL,AH
		Pop	AX
		Or	AX,All xor ZFlag+SFlag+OFlag
		And	DX,AX
		Jmp	ExitInt06
Inc40		Endp
;--------------------------------------
IncFF0		Proc	Near			;Inc r/m32
		Add	Word Ptr ES:[DI],1
		Lahf
		Adc	Word Ptr ES:[DI][2],0
		Pushf
		Or	DX,AllFlags xor CFlag
		Or	AH,Low All xor PFlag+AFlag+ZFlag
		And	DL,AH
		Pop	AX
		Or	AX,All xor ZFlag+SFlag+OFlag
		And	DX,AX
		Jmp	ExitInt06
IncFF0		Endp
;------------------------------------------------------------------------------
Sub29		Proc	Near			;Sub r/m32,r32
		Call	GetReg&RM
		Mov	AX,[SI]
		Sub	ES:[DI],AX
		Lahf
		Mov	DL,AH
		Mov	AX,[SI][2]
		Sbb	ES:[DI][2],AX
		Pushf
		Pop	AX
		Or	DX,AllFlags xor PFlag+AFlag+ZFlag
		Or	AX,All xor CFlag+ZFlag+SFlag+OFlag
		And	DX,AX
		Jmp	ExitInt06
Sub29		Endp
;--------------------------------------
Sub2B		Proc	Near			;Sub r32,r/m32
		Call	GetReg&RM
		Mov	AX,ES:[DI]
		Sub	[SI],AX
		Lahf
		Mov	DL,AH
		Mov	AX,ES:[DI][2]
		Sbb	[SI][2],AX
		Pushf
		Pop	AX
		Or	DX,AllFlags xor PFlag+AFlag+ZFlag
		Or	AX,All xor CFlag+ZFlag+SFlag+OFlag
		And	DX,AX
		Jmp	ExitInt06
Sub2B		Endp
;--------------------------------------
Sub2D		Proc	Near			;Sub EAX,imm32
		Mov	AX,ES:[BX]
		Sub	[LowAX],AX
		Lahf
		Mov	DL,AH
		Mov	AX,ES:[BX][2]
		Sbb	[HighAX],AX
		Pushf
		Pop	AX
		Or	DX,AllFlags xor PFlag+AFlag+ZFlag
		Or	AX,All xor CFlag+ZFlag+SFlag+OFlag
		And	DX,AX
		Lea	BX,[BX][4]
		Jmp	ExitInt06
Sub2D		Endp
;--------------------------------------
Sub815		Proc	Near			;Sub r/m32,imm32
		Mov	DS,[SegCS]
		Mov	AX,[BX]
		Sub	ES:[DI],AX
		Lahf
		Mov	DL,AH
		Mov	AX,[BX][2]
		Sbb	ES:[DI][2],AX
		Pushf
		Pop	AX
		Or	DX,AllFlags xor PFlag+AFlag+ZFlag
		Or	AX,All xor CFlag+ZFlag+SFlag+OFlag
		And	DX,AX
		Mov	AX,CS
		Mov	DS,AX
		Lea	BX,[BX][4]
		Jmp	ExitInt06
Sub815		Endp
;--------------------------------------
Sub835		Proc	Near			;Sub r/m32,imm8
		Mov	DS,[SegCS]
		Mov	CX,DX
		Mov	AL,[BX]
		Cbw
		Cwd
		Sub	ES:[DI],AX
		Lahf
		Mov	CL,AH
		Sbb	ES:[DI][2],DX
		Pushf
		Pop	DX
		Or	CX,AllFlags xor PFlag+AFlag+ZFlag
		Or	DX,All xor CFlag+ZFlag+SFlag+OFlag
		And	DX,CX
		Mov	AX,CS
		Mov	DS,AX
		Inc	BX
		Jmp	ExitInt06
Sub835		Endp
;------------------------------------------------------------------------------
Sbb19		Proc	Near			;Sbb r/m32,r32
	;Jmp O
		Call	GetReg&RM
		Mov	AH,DL
		Sahf
		Mov	AX,[SI]
		Sbb	ES:[DI],AX
		Lahf
		Mov	DL,AH
		Mov	AX,[SI][2]
		Sbb	ES:[DI][2],AX
		Pushf
		Pop	AX
		Or	DX,AllFlags xor PFlag+AFlag+ZFlag
		Or	AX,All xor CFlag+ZFlag+SFlag+OFlag
		And	DX,AX
		Jmp	ExitInt06
Sbb19		Endp
;--------------------------------------
Sbb1B		Proc	Near			;Sbb r32,r/m32
	;Jmp O
		Call	GetReg&RM
		Mov	AH,DL
		Sahf
		Mov	AX,ES:[DI]
		Sbb	[SI],AX
		Lahf
		Mov	DL,AH
		Mov	AX,ES:[DI][2]
		Sbb	[SI][2],AX
		Pushf
		Pop	AX
		Or	DX,AllFlags xor PFlag+AFlag+ZFlag
		Or	AX,All xor CFlag+ZFlag+SFlag+OFlag
		And	DX,AX
		Jmp	ExitInt06
Sbb1B		Endp
;--------------------------------------
Sbb1D		Proc	Near			;Sbb EAX,imm32
	;Jmp O
		Mov	AH,DL
		Sahf
		Mov	AX,ES:[BX]
		Sbb	[LowAX],AX
		Lahf
		Mov	DL,AH
		Mov	AX,ES:[BX][2]
		Sbb	[HighAX],AX
		Pushf
		Pop	AX
		Or	DX,AllFlags xor PFlag+AFlag+ZFlag
		Or	AX,All xor CFlag+ZFlag+SFlag+OFlag
		And	DX,AX
		Lea	BX,[BX][4]
		Jmp	ExitInt06
Sbb1D		Endp
;--------------------------------------
Sbb813		Proc	Near			;Sbb r/m32,imm32
	;Jmp O
		Mov	DS,[SegCS]
		Mov	AH,DL
		Sahf
		Mov	AX,[BX]
		Sbb	ES:[DI],AX
		Lahf
		Mov	DL,AH
		Mov	AX,[BX][2]
		Sbb	ES:[DI][2],AX
		Pushf
		Pop	AX
		Or	DX,AllFlags xor PFlag+AFlag+ZFlag
		Or	AX,All xor CFlag+ZFlag+SFlag+OFlag
		And	DX,AX
		Mov	AX,CS
		Mov	DS,AX
		Lea	BX,[BX][4]
		Jmp	ExitInt06
Sbb813		Endp
;--------------------------------------
Sbb833		Proc	Near			;Sbb r/m32,imm8
	;Jmp O
		Mov	DS,[SegCS]
		Mov	CX,DX
		Mov	AH,DL
		Sahf
		Mov	AL,[BX]
		Cbw
		Cwd
		Sbb	ES:[DI],AX
		Lahf
		Mov	CL,AH
		Sbb	ES:[DI][2],DX
		Pushf
		Pop	DX
		Or	CX,AllFlags xor PFlag+AFlag+ZFlag
		Or	DX,All xor CFlag+ZFlag+SFlag+OFlag
		And	DX,CX
		Mov	AX,CS
		Mov	DS,AX
		Inc	BX
		Jmp	ExitInt06
Sbb833		Endp
;------------------------------------------------------------------------------
Dec48		Proc	Near			;Dec r32
	;Jmp O
		And	DI,7 shl 1
		Shl	DI,1
		Sub	[DI][LowAX],1
		Lahf
		Sbb	[DI][HighAX],0
		Pushf
		Or	DX,AllFlags xor CFlag
		Or	AH,Low All xor PFlag+AFlag+ZFlag
		And	DL,AH
		Pop	AX
		Or	AX,All xor ZFlag+SFlag+OFlag
		And	DX,AX
		Jmp	ExitInt06
Dec48		Endp
;--------------------------------------
DecFF1		Proc	Near			;Dec r/m32
		Sub	Word Ptr ES:[DI],1
		Lahf
		Sbb	Word Ptr ES:[DI][2],0
		Pushf
		Or	DX,AllFlags xor CFlag
		Or	AH,Low All xor PFlag+AFlag+ZFlag
		And	DL,AH
		Pop	AX
		Or	AX,All xor ZFlag+SFlag+OFlag
		And	DX,AX
		Jmp	ExitInt06
DecFF1		Endp
;------------------------------------------------------------------------------
Cmp39		Proc	Near			;Cmp r/m32,r32
	;Jmp O
		Call	GetReg&RM
		Mov	AX,ES:[DI]
		Sub	AX,[SI]
		Lahf
		Mov	DL,AH
		Mov	AX,ES:[DI][2]
		Sbb	AX,[SI][2]
		Pushf
		Pop	AX
		Or	DX,AllFlags xor PFlag+AFlag+ZFlag
		Or	AX,All xor CFlag+ZFlag+SFlag+OFlag
		And	DX,AX
		Jmp	ExitInt06
Cmp39		Endp
;--------------------------------------
Cmp3B		Proc	Near			;Cmp r32,r/m32
		Call	GetReg&RM
		Mov	AX,[SI]
		Sub	AX,ES:[DI]
		Lahf
		Mov	DL,AH
		Mov	AX,[SI][2]
		Sbb	AX,ES:[DI][2]
		Pushf
		Pop	AX
		Or	DX,AllFlags xor PFlag+AFlag+ZFlag
		Or	AX,All xor CFlag+ZFlag+SFlag+OFlag
		And	DX,AX
		Jmp	ExitInt06
Cmp3B		Endp
;--------------------------------------
Cmp3D		Proc	Near			;Cmp EAX,imm32
		Mov	AX,[LowAX]
		Sub	AX,ES:[BX]
		Lahf
		Mov	DL,AH
		Mov	AX,[HighAX]
		Sbb	AX,ES:[BX][2]
		Pushf
		Pop	AX
		Or	DX,AllFlags xor PFlag+AFlag+ZFlag
		Or	AX,All xor CFlag+ZFlag+SFlag+OFlag
		And	DX,AX
		Lea	BX,[BX][4]
		Jmp	ExitInt06
Cmp3D		Endp
;--------------------------------------
Cmp817		Proc	Near			;Cmp r/m32,imm32
		Mov	DS,[SegCS]
		Mov	AX,ES:[DI]
		Sub	AX,[BX]
		Lahf
		Mov	DL,AH
		Mov	AX,ES:[DI][2]
		Sbb	AX,[BX][2]
		Pushf
		Pop	AX
		Or	DX,AllFlags xor PFlag+AFlag+ZFlag
		Or	AX,All xor CFlag+ZFlag+SFlag+OFlag
		And	DX,AX
		Mov	AX,CS
		Mov	DS,AX
		Lea	BX,[BX][4]
		Jmp	ExitInt06
Cmp817		Endp
;--------------------------------------
Cmp837		Proc	Near			;Cmp r/m32,imm8
		Mov	DS,[SegCS]
		Mov	CX,DX
		Mov	AL,[BX]
		Cbw
		Cwd
		Cmp	ES:[DI],AX
		Lahf
		Mov	CL,AH
		Mov	AX,ES:[DI][2]
		Sbb	AX,DX
		Pushf
		Pop	DX
		Or	CX,AllFlags xor PFlag+AFlag+ZFlag
		Or	DX,All xor CFlag+ZFlag+SFlag+OFlag
		And	DX,CX
		Mov	AX,CS
		Mov	DS,AX
		Inc	BX
		Jmp	ExitInt06
Cmp837		Endp
;------------------------------------------------------------------------------
NegF73		Proc	Near			;Neg r/m32
		Neg	Word Ptr ES:[DI]
		Lahf
		Mov	DL,AH
		Sbb	AX,AX
		Sub	AX,ES:[DI][2]
		Mov	ES:[DI][2],AX
		Pushf
		Pop	AX
		Or	DX,AllFlags xor PFlag+AFlag+ZFlag
		Or	AX,All xor CFlag+ZFlag+SFlag+OFlag
		And	DX,AX
		Jmp	ExitInt06
NegF73		Endp
;------------------------------------------------------------------------------
ImulAF		Proc	Near			;Imul r32,r/m32
		Call	GetReg&RM
		Jmp	Short	ProcessImul
ImulAF		Endp
;------------------------------------------------------------------------------
Imul69		Proc	Near			;Imul r32,imm32
		Call	GetReg&RM
		Mov	AX,ES:[DI]
		Mov	[SI],AX
		Mov	AX,ES:[DI][2]
		Mov	[SI][2],AX
		Mov	ES,[SegCS]
		Mov	DI,BX
		Lea	BX,[BX][4]
ProcessImul:
		Enter	8,0
		Mov	AX,[SI]
		Mov	DX,ES:[DI]
		Mul	DX
		Mov	[BP-8],AX
		Mov	[BP-6],DX
		Mov	AX,[SI][2]
		Mov	DX,ES:[DI][2]
		Mul	DX
		Mov	[BP-4],AX
		Mov	[BP-2],DX
		Mov	AX,[SI]
		Mov	DX,ES:[DI][2]
		Mul	DX
		Add	[BP-6],AX
		Adc	[BP-4],DX
		Adc	Word Ptr [BP-2],0
		Mov	AX,[SI][2]
		Mov	DX,ES:[DI]
		Mul	DX
		Add	[BP-6],AX
		Adc	[BP-4],DX
		Adc	Word Ptr [BP-2],0
		Pop	[SI]
		Pop	[SI][2]
		Pop	AX
		Pop	CX
		Mov	DX,[Flags]
		And	DX,All xor CFlag+OFlag
		Or	AX,CX
		Je	ExitImul
		Or	DX,CFlag+OFlag
ExitImul:
		Pop	BP
		Jmp	ExitInt06
Imul69		Endp
;------------------------------------------------------------------------------
IdivF77		Proc	Near			;Idiv r/m32
		Mov	CX,Word Ptr ES:[DI]
		Mov	AX,Word Ptr ES:[DI][2]
		Cwd
		Cmp	AX,DX
		Jne	NpuIdiv
		Xor	CX,AX
		Sub	CX,AX
		Mov	SI,AX
		Mov	AX,[HighDX]
		Cwd
		Cmp	AX,DX
		Jne	NpuIdiv
		Xor	SI,AX
		Mov	DI,AX
		Xor	[LowAX],DI
		Xor	AX,[HighAX]
		Xor	DX,[LowDX]
		Neg	DI
		Add	[LowAX],DI
		Adc	AX,0
		Adc	DX,0
		Neg	DI
		Div	CX
		Xor	AX,SI
		Mov	[HighAX],AX
		Mov	AX,[LowAX]
		Div	CX
		Xor	AX,SI
		Neg	SI
		Add	AX,SI
		Mov	[LowAX],AX
		Adc	[HighAX],0
		Xor	DX,DI
		Sub	DX,DI
		Mov	[LowDX],DX
		Shl	DX,1
		Sbb	[HighDX],DI
		Mov	DX,[Flags]
		Jmp	ExitInt06
NpuIdiv:
	Jmp O
		Push	[HighDX]
		Push	[LowDX]
		Push	[HighAX]
		Push	[LowAX]
		Mov	BP,SP
		Fild	Qword Ptr [BP]
	Fwait
		Fld	ST
	Fwait
		Fidiv	Dword Ptr ES:[DI]
	Fwait
		Fistp	Dword Ptr [LowAX]
	Fwait
		Fild	Dword Ptr [LowAX]
	Fwait
		Fimul	Dword Ptr ES:[DI]
	Fwait
		Fsubp	ST(1),ST
	Fwait
		Fistp	Dword Ptr [LowDX]
	Fwait
		Add	SP,0008h
		Jmp	ExitInt06
IdivF77		Endp
;------------------------------------------------------------------------------
NotF72		Proc	Near			;Not r/m32
	;Jmp O
		Not	Word Ptr ES:[DI]
		Not	Word Ptr ES:[DI][2]
		Jmp	ExitInt06
NotF72		Endp
;------------------------------------------------------------------------------
And21		Proc	Near			;And r/m32,r32
	;Jmp O
		Call	GetReg&RM
		Mov	AX,[SI]
		And	ES:[DI],AX
		Lahf
		Mov	DL,AH
		Mov	AX,[SI][2]
		And	ES:[DI][2],AX
		Pushf
		Pop	AX
		Or	DX,AllFlags xor PFlag+AFlag+ZFlag
		Or	AX,All xor CFlag+ZFlag+SFlag+OFlag
		And	DX,AX
		Jmp	ExitInt06
And21		Endp
;--------------------------------------
And23		Proc	Near			;And r32,r/m32
	;Jmp O
		Call	GetReg&RM
		Mov	AX,ES:[DI]
		And	[SI],AX
		Lahf
		Mov	DL,AH
		Mov	AX,ES:[DI][2]
		And	[SI][2],AX
		Pushf
		Pop	AX
		Or	DX,AllFlags xor PFlag+AFlag+ZFlag
		Or	AX,All xor CFlag+ZFlag+SFlag+OFlag
		And	DX,AX
		Jmp	ExitInt06
And23		Endp
;--------------------------------------
And25		Proc	Near			;And EAX,imm32
	;Jmp O
		Mov	AX,ES:[BX]
		And	[LowAX],AX
		Lahf
		Mov	DL,AH
		Mov	AX,ES:[BX][2]
		And	[HighAX],AX
		Pushf
		Pop	AX
		Or	DX,AllFlags xor PFlag+AFlag+ZFlag
		Or	AX,All xor CFlag+ZFlag+SFlag+OFlag
		And	DX,AX
		Lea	BX,[BX][4]
		Jmp	ExitInt06
And25		Endp
;--------------------------------------
And814		Proc	Near			;And r/m32,imm32
	;Jmp O
		Mov	DS,[SegCS]
		Mov	AX,[BX]
		And	ES:[DI],AX
		Lahf
		Mov	DL,AH
		Mov	AX,[BX][2]
		And	ES:[DI][2],AX
		Pushf
		Pop	AX
		Or	DX,AllFlags xor PFlag+AFlag+ZFlag
		Or	AX,All xor CFlag+ZFlag+SFlag+OFlag
		And	DX,AX
		Mov	AX,CS
		Mov	DS,AX
		Lea	BX,[BX][4]
		Jmp	ExitInt06
And814		Endp
;--------------------------------------
And834		Proc	Near			;And r/m32,imm8
		Mov	DS,[SegCS]
		Mov	AL,[BX]
		Cbw
		And	ES:[DI],AX
		Lahf
		Mov	DL,AH
		Shl	AL,1
		Sbb	AX,AX
		And	ES:[DI][2],AX
		Pushf
		Pop	AX
		Or	DX,AllFlags xor PFlag+AFlag+ZFlag
		Or	AX,All xor CFlag+ZFlag+SFlag+OFlag
		And	DX,AX
		Mov	AX,CS
		Mov	DS,AX
		Inc	BX
		Jmp	ExitInt06
And834		Endp
;------------------------------------------------------------------------------
Or09		Proc	Near			;Or r/m32,r32
		Call	GetReg&RM
		Mov	AX,[SI]
		Or	ES:[DI],AX
		Lahf
		Mov	DL,AH
		Mov	AX,[SI][2]
		Or	ES:[DI][2],AX
		Pushf
		Pop	AX
		Or	DX,AllFlags xor PFlag+AFlag+ZFlag
		Or	AX,All xor CFlag+ZFlag+SFlag+OFlag
		And	DX,AX
		Jmp	ExitInt06
Or09		Endp
;--------------------------------------
Or0B		Proc	Near			;Or r32,r/m32
		Call	GetReg&RM
	;Jmp O
		Mov	AX,ES:[DI]
		Or	[SI],AX
		Lahf
		Mov	DL,AH
		Mov	AX,ES:[DI][2]
		Or	[SI][2],AX
		Pushf
		Pop	AX
		Or	DX,AllFlags xor PFlag+AFlag+ZFlag
		Or	AX,All xor CFlag+ZFlag+SFlag+OFlag
		And	DX,AX
		Jmp	ExitInt06
Or0B		Endp
;--------------------------------------
Or0D		Proc	Near			;Or EAX,imm32
	;Jmp O
		Mov	AX,ES:[BX]
		Or	[LowAX],AX
		Lahf
		Mov	DL,AH
		Mov	AX,ES:[BX][2]
		Or	[HighAX],AX
		Pushf
		Pop	AX
		Or	DX,AllFlags xor PFlag+AFlag+ZFlag
		Or	AX,All xor CFlag+ZFlag+SFlag+OFlag
		And	DX,AX
		Lea	BX,[BX][4]
		Jmp	ExitInt06
Or0D		Endp
;--------------------------------------
Or811		Proc	Near			;Or r/m32,imm32
	;Jmp O
		Mov	DS,[SegCS]
		Mov	AX,[BX]
		Or	ES:[DI],AX
		Lahf
		Mov	DL,AH
		Mov	AX,[BX][2]
		Or	ES:[DI][2],AX
		Pushf
		Pop	AX
		Or	DX,AllFlags xor PFlag+AFlag+ZFlag
		Or	AX,All xor CFlag+ZFlag+SFlag+OFlag
		And	DX,AX
		Mov	AX,CS
		Mov	DS,AX
		Lea	BX,[BX][4]
		Jmp	ExitInt06
Or811		Endp
;--------------------------------------
Or831		Proc	Near			;Or r/m32,imm8
	;Jmp O
		Mov	DS,[SegCS]
		Mov	CX,DX
		Mov	AL,[BX]
		Cbw
		Cwd
		Or	ES:[DI],AX
		Lahf
		Mov	CL,AH
		Or	ES:[DI][2],DX
		Pushf
		Pop	DX
		Or	CX,AllFlags xor PFlag+AFlag+ZFlag
		Or	DX,All xor CFlag+ZFlag+SFlag+OFlag
		And	DX,CX
		Mov	AX,CS
		Mov	DS,AX
		Inc	BX
		Jmp	ExitInt06
Or831		Endp
;------------------------------------------------------------------------------
Xor31		Proc	Near			;Xor r/m32,r32
	;Jmp O
		Call	GetReg&RM
		Mov	AX,[SI]
		Xor	ES:[DI],AX
		Lahf
		Mov	DL,AH
		Mov	AX,[SI][2]
		Xor	ES:[DI][2],AX
		Pushf
		Pop	AX
		Or	DX,AllFlags xor PFlag+AFlag+ZFlag
		Or	AX,All xor CFlag+ZFlag+SFlag+OFlag
		And	DX,AX
		Jmp	ExitInt06
Xor31		Endp
;--------------------------------------
Xor33		Proc	Near			;Xor r32,r/m32
		Call	GetReg&RM
		Mov	AX,ES:[DI]
		Xor	[SI],AX
		Lahf
		Mov	DL,AH
		Mov	AX,ES:[DI][2]
		Xor	[SI][2],AX
		Pushf
		Pop	AX
		Or	DX,AllFlags xor PFlag+AFlag+ZFlag
		Or	AX,All xor CFlag+ZFlag+SFlag+OFlag
		And	DX,AX
		Jmp	ExitInt06
Xor33		Endp
;--------------------------------------
Xor35		Proc	Near			;Xor EAX,imm32
	;Jmp O
		Mov	AX,ES:[BX]
		Xor	[LowAX],AX
		Lahf
		Mov	DL,AH
		Mov	AX,ES:[BX][2]
		Xor	[HighAX],AX
		Pushf
		Pop	AX
		Or	DX,AllFlags xor PFlag+AFlag+ZFlag
		Or	AX,All xor CFlag+ZFlag+SFlag+OFlag
		And	DX,AX
		Lea	BX,[BX][4]
		Jmp	ExitInt06
Xor35		Endp
;--------------------------------------
Xor816		Proc	Near			;Xor r/m32,imm32
	;Jmp O
		Mov	DS,[SegCS]
		Mov	AX,[BX]
		Xor	ES:[DI],AX
		Lahf
		Mov	DL,AH
		Mov	AX,[BX][2]
		Xor	ES:[DI][2],AX
		Pushf
		Pop	AX
		Or	DX,AllFlags xor PFlag+AFlag+ZFlag
		Or	AX,All xor CFlag+ZFlag+SFlag+OFlag
		And	DX,AX
		Mov	AX,CS
		Mov	DS,AX
		Lea	BX,[BX][4]
		Jmp	ExitInt06
Xor816		Endp
;--------------------------------------
Xor836		Proc	Near			;Xor r/m32,imm8
	;Jmp O
		Mov	DS,[SegCS]
		Mov	CX,DX
		Mov	AL,[BX]
		Cbw
		Cwd
		Xor	ES:[DI],AX
		Lahf
		Mov	CL,AH
		Xor	ES:[DI][2],DX
		Pushf
		Pop	DX
		Or	CX,AllFlags xor PFlag+AFlag+ZFlag
		Or	DX,All xor CFlag+ZFlag+SFlag+OFlag
		And	DX,CX
		Mov	AX,CS
		Mov	DS,AX
		Inc	BX
		Jmp	ExitInt06
Xor836		Endp
;------------------------------------------------------------------------------
Test85		Proc	Near			;Test r/m32,r32
		Call	GetReg&RM
		Mov	AX,[SI]
		Test	ES:[DI],AX
		Lahf
		Mov	DL,AH
		Mov	AX,[SI][2]
		Test	ES:[DI][2],AX
		Pushf
		Pop	AX
		Or	DX,AllFlags xor PFlag+AFlag+ZFlag
		Or	AX,All xor CFlag+ZFlag+SFlag+OFlag
		And	DX,AX
		Jmp	ExitInt06
Test85		Endp
;--------------------------------------
TestA9		Proc	Near			;Test EAX,imm32
		Mov	AX,ES:[BX]
		Test	[LowAX],AX
		Lahf
		Mov	DL,AH
		Mov	AX,ES:[BX][2]
		Test	[HighAX],AX
		Pushf
		Pop	AX
		Or	DX,AllFlags xor PFlag+AFlag+ZFlag
		Or	AX,All xor CFlag+ZFlag+SFlag+OFlag
		And	DX,AX
		Lea	BX,[BX][4]
		Jmp	ExitInt06
TestA9		Endp
;--------------------------------------
TestF70		Proc	Near			;Test r/m32,imm32
		Mov	DS,[SegCS]
		Mov	AX,[BX]
		Test	ES:[DI],AX
		Lahf
		Mov	DL,AH
		Mov	AX,[BX][2]
		Test	ES:[DI][2],AX
		Pushf
		Pop	AX
		Or	DX,AllFlags xor PFlag+AFlag+ZFlag
		Or	AX,All xor CFlag+ZFlag+SFlag+OFlag
		And	DX,AX
		Mov	AX,CS
		Mov	DS,AX
		Lea	BX,[BX][4]
		Jmp	ExitInt06
TestF70		Endp
;------------------------------------------------------------------------------
Rol0		Proc	Near
		Shl	AX,1
		Rcl	DX,1
		Adc	AX,0
		Loop	Rol0
		Mov	ES:[DI],AX
		Mov	ES:[DI][2],DX
		Mov	DL,AL
		Ror	DX,1
		Rol	DX,1
		Pushf
		Pop	AX
		Mov	DX,[Flags]
		Or	DX,CFlag+OFlag
		Or	AX,All xor CFlag+OFlag
		And	DX,AX
		Jmp	ExitInt06
Rol0		Endp
;--------------------------------------
Ror1		Proc	Near
		Shr	DX,1
		Rcr	AX,1
		Rcl	DX,1
		Ror	DX,1
		Loop	Ror1
		Mov	ES:[DI],AX
		Mov	ES:[DI][2],DX
		Pushf
		Pop	AX
		Mov	DX,[Flags]
		Or	DX,CFlag+OFlag
		Or	AX,All xor CFlag+OFlag
		And	DX,AX
		Jmp	ExitInt06
Ror1		Endp
;--------------------------------------
Rcl2		Proc	Near
	;Jmp O
		Rcl	AX,1
		Rcl	DX,1
		Loop	Rcl2
		Mov	ES:[DI],AX
		Mov	ES:[DI][2],DX
		Pushf
		Pop	AX
		Mov	DX,[Flags]
		Or	DX,CFlag+OFlag
		Or	AX,All xor CFlag+OFlag
		And	DX,AX
		Jmp	ExitInt06
Rcl2		Endp
;--------------------------------------
Rcr3		Proc	Near
	;Jmp O
		Rcr	DX,1
		Rcr	AX,1
		Loop	Rcr3
		Mov	ES:[DI],AX
		Mov	ES:[DI][2],DX
		Xchg	AH,DH
		Rcl	AX,1
		Rcr	AX,1
		Pushf
		Pop	AX
		Mov	DX,[Flags]
		Or	DX,CFlag+OFlag
		Or	AX,All xor CFlag+OFlag
		And	DX,AX
		Jmp	ExitInt06
Rcr3		Endp
;--------------------------------------
Shl4		Proc	Near
		Shl	AX,1
		Rcl	DX,1
		Loop	Shl4
		Pushf
		Mov	ES:[DI],AX
		Mov	ES:[DI][2],DX
		Test	DX,DX
		Mov	DX,[Flags]
		Lahf
		Mov	DL,AH
		Pop	AX
		Or	DX,AllFlags xor SFlag+ZFlag
		Or	AX,All xor CFlag+PFlag+AFlag+ZFlag+OFlag
		And	DX,AX
		Jmp	ExitInt06
Shl4		Endp
;--------------------------------------
Shr5		Proc	Near
		Shr	DX,1
		Rcr	AX,1
		Loop	Shr5
		Mov	ES:[DI],AX
		Mov	ES:[DI][2],DX
		Xchg	AH,DH
		Rcl	AX,1
		Shr	AX,1
		Pushf
		Test	DX,DX
		Mov	DX,[Flags]
		Lahf
		Mov	DL,AH
		Pop	AX
		Or	DX,AllFlags xor ZFlag
		Or	AX,All xor AllFlags
		And	DX,AX
		Jmp	ExitInt06
Shr5		Endp
;--------------------------------------
Sar7		Proc	Near
		Sar	DX,1
		Rcr	AX,1
		Loop	Sar7
		Mov	ES:[DI],AX
		Mov	ES:[DI][2],DX
		Xchg	AH,DH
		Rcl	AX,1
		Sar	AX,1
		Pushf
		Test	DX,DX
		Mov	DX,[Flags]
		Lahf
		Mov	DL,AH
		Pop	AX
		Or	DX,AllFlags xor ZFlag
		Or	AX,All xor AllFlags
		And	DX,AX
		Jmp	ExitInt06
Sar7		Endp
;--------------------------------------
ShldA4		Proc	Near			;Shld rm,R,imm8
		Call	GetReg&RM
		Mov	DS,[SegCS]
		Mov	CL,[BX]
		Mov	AX,CS
		Mov	DS,AX
		Inc	BX
		Jmp	Short	ProcessShld
ShldA4		Endp
;--------------------------------------
ShldA5		Proc	Near			;Shld rm,R,CL
		Call	GetReg&RM
		Mov	CX,[LowCX]
ProcessShld:
		And	CX,11111b
		Je	ExitProcessShld
		Mov	BP,[SI]
		Mov	AX,ES:[DI]
		Cmp	[ExtDataFlag],0
		Jne	Shld32
Shld16Loop:
	;Jmp O
		Shl	BP,1
		Rcl	AX,1
		Loop	Shld16Loop
		Pushf
		Mov	ES:[DI],AX
		Test	AX,AX
		Lahf
		Jmp	Short	EndShldLoop
Shld32:
		Mov	SI,[SI][2]
		Mov	DX,ES:[DI][2]
Shld32Loop:
		Shl	BP,1
		Rcl	SI,1
		Rcl	AX,1
		Rcl     DX,1
		Loop	Shld32Loop
		Pushf
		Mov	ES:[DI],AX
		Mov	ES:[DI][2],DX
		Xchg	AH,DH
		Test	AX,AX
		Lahf
		Mov	AL,AH
		Or	AL,Low AllFlags xor PFlag+ZFlag+SFlag
		Test	DX,DX
		Lahf
		Or	AH,Low AllFlags xor ZFlag
		And	AH,AL
EndShldLoop:
		Mov	DX,[Flags]
		Mov	DL,AH
		Pop	AX
		Or	DX,AllFlags xor PFlag+ZFlag+SFlag
		Or	AX,All xor CFlag+OFlag+AFlag
		And	DX,AX
ExitProcessShld:
		Jmp	ExitInt06
ShldA5		Endp
;--------------------------------------
ShrdAC		Proc	Near
		Call	GetReg&RM
		Mov	DS,[SegCS]
		Mov	CL,[BX]
		Mov	AX,CS
		Mov	DS,AX
		Inc	BX
		Jmp	Short	ProcessShrd
ShrdAC		Endp
;--------------------------------------
ShrdAD		Proc	Near
		Call	GetReg&RM
		Mov	CX,[LowCX]
ProcessShrd:
	;Jmp O
		And	CX,11111b
		Je	ExitProcessShrd
		Mov	AX,[SI]
		Mov	DX,ES:[DI]
		Cmp	[ExtDataFlag],0
		Jne	Shrd32
Shrd16Loop:
		Shr	AX,1
		Rcr	DX,1
		Loop	Shrd16Loop
		Pushf
		Mov	ES:[DI],DX
		Test	DX,DX
		Lahf
		Jmp	Short	EndShrdLoop
Shrd32:
		Mov	SI,[SI][2]
Shrd32Loop:
		Shr	SI,1
		Rcr	AX,1
		Rcr	Word Ptr ES:[DI][2],1
		Rcr	DX,1
		Loop	Shrd32Loop
		Pushf
		Mov	ES:[DI],DX
		Mov	AX,ES:[DI][2]
		Xchg	AL,DL
		Test	AX,AX
		Lahf
		Mov	AL,AH
		Or	AL,Low AllFlags xor PFlag+ZFlag+SFlag
		Test	DX,DX
		Lahf
		Or	AH,Low AllFlags xor ZFlag
		And	AH,AL
EndShrdLoop:
		Mov	DX,[Flags]
		Mov	DL,AH
		Pop	AX
		Or	DX,AllFlags xor PFlag+ZFlag+SFlag
		Or	AX,All xor CFlag+OFlag+AFlag
		And	DX,AX
ExitProcessShrd:
		Jmp	ExitInt06
ShrdAD		Endp
;------------------------------------------------------------------------------
J80		Proc	Near
		Xor	AL,00F1h
		Mov	Byte Ptr [ShortJump],AL
		Mov	AX,DX
		And	AX,AllFlags
		Push	AX
		Popf
ShortJump:
		Jmp	Short	ExitJ80
		Mov	DI,ES:[BX]
		Lea	BX,[BX][DI][2]
ExitJ80:
		Jmp	ExitInt06
J80		Endp
;------------------------------------------------------------------------------
BtA3		Proc	Near			;Bt r32,r/m32
	;Jmp O
		Call	GetReg&RM
		Mov	AX,ES:[DI]
		Mov	DX,ES:[DI][2]
		Mov	CX,ES:[SI]
		And	CX,11111b
		Inc	CX
BtA3Loop:
		Shr	DX,1
		Rcr	AX,1
		Loop	BtA3Loop
		Lahf
		Or	AH,Low All xor CFlag
		Mov	DX,[Flags]
		Or	DL,CFlag
		And	DL,AH
		Jmp	ExitInt06
BtA3		Endp
;--------------------------------------
BtsAB		Proc	Near			;Bts r32,r/m32
	;Jmp O
		Call	GetReg&RM
		Mov	CX,[SI]
		And	CX,11111b
		Inc	CX
		Xor	AX,AX
		Mov	DX,AX
		Stc
BtsABLoop:
		Rcl	AX,1
		Rcl	DX,1
		Loop	BtsABLoop
		Or	DX,AX
		Cmp	AX,DX
		Adc	CX,CX
		Shl	CX,1
		Add	DI,CX
		Test	DX,ES:[DI]
		Lahf
		Or	ES:[DI],DX
		Mov	DX,[Flags]
		Shr	DX,1
		And	AH,ZFlag
		Cmp	AH,ZFlag
		Rcl	DX,1
		Jmp	ExitInt06
BtsAB		Endp
;--------------------------------------
BtrB3		Proc	Near			;Btr r32,r/m32
	;Jmp O
		Call	GetReg&RM
		Mov	CX,[SI]
		And	CX,11111b
		Inc	CX
		Xor	AX,AX
		Mov	DX,AX
		Stc
BtrB3Loop:
		Rcl	AX,1
		Rcl	DX,1
		Loop	BtrB3Loop
		Or	DX,AX
		Cmp	AX,DX
		Adc	CX,CX
		Shl	CX,1
		Add	DI,CX
		Test	DX,ES:[DI]
		Lahf
		Not	DX
		And	ES:[DI],DX
		Mov	DX,[Flags]
		Shr	DX,1
		And	AH,ZFlag
		Cmp	AH,ZFlag
		Rcl	DX,1
		Jmp	ExitInt06
BtrB3		Endp
;--------------------------------------
BtcBB		Proc	Near			;Btc r32,r/m32
	;Jmp O
		Call	GetReg&RM
		Mov	CX,[SI]
BtcBA7:
		And	CX,11111b
		Inc	CX
		Xor	AX,AX
		Mov	DX,AX
		Stc
BtcBBLoop:
		Rcl	AX,1
		Rcl	DX,1
		Loop	BtcBBLoop
		Or	DX,AX
		Cmp	AX,DX
		Adc	CX,CX
		Shl	CX,1
		Add	DI,CX
		Test	DX,ES:[DI]
		Lahf
		Xor	ES:[DI],DX
		Mov	DX,[Flags]
		Shr	DX,1
		And	AH,ZFlag
		Cmp	AH,ZFlag
		Rcl	DX,1
		Jmp	ExitInt06
BtcBB		Endp
;--------------------------------------
BsfBC		Proc	Near
	;Jmp O
		Call	GetReg&RM
		Mov	AX,ES:[DI]
		Mov	DX,ES:[DI][2]
		Mov	CX,32d
BsfBCLoop:
		Test	AX,1
		Rcr	DX,1
		Rcr	AX,1
		LoopE	BsfBCLoop
		Lahf
		Je	SkipBsfBCStore
		Sub	CX,31d
		Neg	CX
		Mov	Word Ptr [SI],CX
		Mov	Word Ptr [SI][2],0
SkipBsfBCStore:
		Mov	DX,[Flags]
		Or	AH,Low All xor ZFlag
		Or	DL,Low AllFlags
		And	DL,AH
		Jmp	ExitInt06
BsfBC		Endp
;--------------------------------------
BsrBD		Proc	Near
	;Jmp O
		Call	GetReg&RM
		Mov	AX,ES:[DI]
		Mov	DX,ES:[DI][2]
		Mov	CX,32d
BsrBDLoop:
		Test	DX,8000h
		Rcl	AX,1
		Rcl	DX,1
		LoopE	BsrBDLoop
		Lahf
		Je	SkipBsrBDStore
		Mov	Word Ptr [SI],CX
		Mov	Word Ptr [SI][2],0
SkipBsrBDStore:
		Mov	DX,[Flags]
		Or	AH,Low All xor ZFlag
		Or	DL,Low AllFlags
		And	DL,AH
		Jmp	ExitInt06
BsrBD		Endp
;------------------------------------------------------------------------------
ResSize		Equ	($-Code+0Fh)/10h
;------------------------------------------------------------------------------
FirstMes	DB	0Dh,0Ah,	'80386 32-bit Real Mode Emulator Version 1.40.',0Dh,0Ah
		DB			'Copyright (C) Lions Group, 1993-4.  All rights reserved.',0Dh,0Ah,'$'
InstalledMes	DB			'REAL installed.',0Dh,0Ah,'$'
UnloadedMes	DB			'REAL unloaded.',0Dh,0Ah,'$'
ImpossibleMes	DB			'Cannot unload until TSRs loaded higher are removed.',0Dh,0Ah,'$'
;------------------------------------------------------------------------------
Init:   	Mov	AH,09h
		Mov	DX,Offset FirstMes
		Int	21h
		Mov	AX,3506h
		Int	21h
		Mov	Word Ptr [Int06old],BX
		Mov	Word Ptr [Int06old][2],ES
		Mov	AX,2506h
		Mov	CX,TsrReq
		Mov	DX,Offset Int06
		Int	21h
		Cmp	DX,Offset Int06
		Je	Install
Uninstall:
		Xor	AX,AX
		Mov	DS,AX
		Mov	AX,DX
		Mov	DX,Offset ImpossibleMes
		Cmp	AX,DS:[4*01h][2]
		Jne	ExitUninstall
		Cmp	AX,DS:[4*06h][2]
		Jne	ExitUninstall
		Cmp	AX,DS:[4*09h][2]
		Jne	ExitUninstall
		Cmp	AX,DS:[4*21h][2]
		Jne	ExitUninstall

		Mov	ES,AX
		Mov	AX,2521h
		Lds	DX,ES:[Int21old]
		Int	21h
		Mov	AL,09h
		Lds	DX,ES:[Int09old]
		Int	21h
		Mov	AL,06h
		Lds	DX,ES:[Int06old]
		Int	21h
		Mov	AL,01h
		Lds	DX,ES:[Int01old]
		Int	21h
		Mov	AH,49h
		Int	21h
		Mov	AH,49h
		Mov	ES,ES:[002Ch]
		Int	21h
		Mov	DX,Offset UnloadedMes
ExitUninstall:
		Mov	AX,CS
		Mov	DS,AX
		Mov	AH,09h
		Int	21h
		Mov	AX,4C00h
		Int	21h
Install:
		Mov	AX,3501h
		Int	21h
		Mov	Word Ptr [Int01old],BX
		Mov	Word Ptr [Int01old][2],ES
		Mov	AX,2501h
		Mov	DX,Offset Int01
		Int	21h

		Mov	AX,3509h
		Int	21h
		Mov	Word Ptr [Int09old],BX
		Mov	Word Ptr [Int09old][2],ES
		Mov	AX,2509h
		Mov	DX,Offset Int09
		Int	21h

		Mov	AX,3521h
		Int	21h
		Mov	word ptr [Int21old],BX
		Mov	word ptr [Int21old][2],ES
		Mov	AX,2521h
		Mov	DX,Offset Int21
		Int	21h

		Mov	AX,4300h		;Check XMS
		Int	2Fh
		Cmp	AL,80h
		Jne	ExitInstall             ;Get XMS Control Address
		Mov	AX,4310h
		Int	2Fh
		Mov	Word Ptr [XmsControl],BX
		Mov	Word Ptr [XmsControl][2],ES
ExitInstall:
		Mov	AH,09h
		Mov	DX,Offset InstalledMes
		Int	21h
		Mov	AX,3100h
		Mov	DX,ResSize
		Int	21h
Main		Endp
Code		Ends
		End	Main
;------------------------------------------------------------------------------
