unit AddInObj;

interface

uses ComServ, ComObj, ActiveX, AddInLib, Windows, SysUtils, Classes, Hook, Compile;

//{$define Test}

//{$IFDEF Test}  
//{$IFNDEF Test} 
//{$ELSE}
//{$ENDIF}
type

CString = PChar;

function GetFullName(Fecx:DWord): CString;
function c_malloc(size: Integer): Pointer; cdecl; external 'msvcrt.dll' name 'malloc';
procedure c_free(p: Pointer); cdecl; external 'msvcrt.dll' name 'free';

const
             { This GUID should be changed}
     CLSID_AddInObject : TGUID = '{C379E361-3503-4A1F-A6A9-CE8A799BF1A8}';
     // Ctrl-Shift-G     GUID.
     //      Windows.

      {    }
var
  MyCompile: TMyCompile;

type

{ ,   1.     ,  ,  , }
TProperties = (LastProp );

{  -   ,   1.     ,  ,  , }
//TMethods = (methPatch, methUnPatch, LastMethod );
TMethods = ( methOpen, methClose, methExtTrace, methAllTrace, LastMethod );

TAddInObject = class (TComObject, IDispatch, IInitDone,{ ISpecifyPropertyPages,}
                                        ILanguageExtender{,IPropertyLink})

      { This function is useful in ILanguageExtender implementation }
//    function TermString(strTerm: string; iAlias: Integer): string;
      {These two methods is convenient way to access function
       parameters from SAFEARRAY vector of variants }
    function GetNParam(var pArray : PSafeArray; lIndex: Integer ): OleVariant;
    function GetNParamAsString(var pArray : PSafeArray; lIndex: Integer ): String;
    function GetNParamAsInteger(var pArray : PSafeArray; lIndex: Integer ): Integer;
    procedure PutNParam(var pArray: PSafeArray; lIndex: Integer; var varPut: OleVariant);

      { Interface implementation }
      { IInitDone implementation }
    function Init(pConnection: IDispatch): HResult; stdcall;
    function Done: HResult; stdcall;
    function GetInfo(var pInfo: PSafeArray{(OleVariant)}): HResult; stdcall;
      { ISpecifyPropertyPages implementation }
    function GetPages(out Pages: TCAGUID) : HResult; stdcall;
      { ILanguageExtender implementation }
    function RegisterExtensionAs(var bstrExtensionName: WideString): HResult; stdcall;
    function GetNProps(var plProps: Integer): HResult; stdcall;
    function FindProp(const bstrPropName: WideString; var plPropNum: Integer): HResult; stdcall;
    function GetPropName(lPropNum, lPropAlias: Integer; var pbstrPropName: WideString): HResult; stdcall;
    function GetPropVal(lPropNum: Integer; var pvarPropVal: OleVariant): HResult; stdcall;
    function SetPropVal(lPropNum: Integer; var varPropVal: OleVariant): HResult; stdcall;
    function IsPropReadable(lPropNum: Integer; var pboolPropRead: Integer): HResult; stdcall;
    function IsPropWritable(lPropNum: Integer; var pboolPropWrite: Integer): HResult; stdcall;
    function GetNMethods(var plMethods: Integer): HResult; stdcall;
    function FindMethod(const bstrMethodName: WideString; var plMethodNum: Integer): HResult; stdcall;
    function GetMethodName(lMethodNum, lMethodAlias: Integer; var pbstrMethodName: WideString): HResult; stdcall;
    function GetNParams(lMethodNum: Integer; var plParams: Integer): HResult; stdcall;
    function GetParamDefValue(lMethodNum, lParamNum: Integer; var pvarParamDefValue: OleVariant): HResult; stdcall;
    function HasRetVal(lMethodNum: Integer; var pboolRetValue: Integer): HResult; stdcall;
    function CallAsProc(lMethodNum: Integer; var paParams: PSafeArray{(OleVariant)}): HResult; stdcall;
    function CallAsFunc(lMethodNum: Integer; var pvarRetValue: OleVariant; var paParams: PSafeArray{(OleVariant)}): HResult; stdcall;
      { IPropertyLink implementation }
    function get_Enabled(var IsEnabled : Integer): HResult; stdcall;
    function put_Enabled(IsEnabled : Integer): HResult; stdcall;

        { IDispatch }
    function GetIDsOfNames(const IID: TGUID; Names: Pointer;
      NameCount, LocaleID: Integer; DispIDs: Pointer): HResult; virtual; stdcall;
    function GetTypeInfo(Index, LocaleID: Integer; out TypeInfo): HResult; virtual; stdcall;
    function GetTypeInfoCount(out Count: Integer): HResult; virtual; stdcall;
    function Invoke(DispID: Integer; const IID: TGUID; LocaleID: Integer;
      Flags: Word; var Params; VarResult, ExcepInfo, ArgErr: Pointer): HResult; virtual; stdcall;
end;

implementation

///////////////////////////////////////////////////////////////
function TAddInObject.GetNParam(var pArray : PSafeArray; lIndex: Integer ): OleVariant;
var varGet : OleVariant;
begin
  SafeArrayGetElement(pArray,lIndex,varGet);
  GetNParam := varGet;
end;

///////////////////////////////////////////////////////////////
function TAddInObject.GetNParamAsString(var pArray : PSafeArray; lIndex: Integer ): String;
begin
  Try
    SafeArrayGetElement(pArray,lIndex,Result);
  Except
    Result:='';
  End;
end;

///////////////////////////////////////////////////////////////
function TAddInObject.GetNParamAsInteger(var pArray : PSafeArray; lIndex: Integer ): Integer;
begin
  Try
    SafeArrayGetElement(pArray,lIndex,Result);
  Except
    Result:=0;
  End;
end;


///////////////////////////////////////////////////////////////
procedure TAddInObject.PutNParam(var pArray: PSafeArray; lIndex: Integer; var varPut: OleVariant);
begin
  SafeArrayPutElement(pArray,lIndex,varPut);
end;

///////////////////////////////////////////////////////////////
// 
var old111,p_GetFullName: Pointer;
var ecx111,ecx222: DWORD;
var UnitText: String;
var NewUnitText: AnsiString;
var CloseMode: boolean;
var Modul:CString;
    //cstr_glob: CString;
//  GetFullName: function(): CString; stdcall;

procedure OWrite(Name,str: string);
{    doNextLine -  }
const
  CR = #13#10;
var
  f: TFileStream;
  FileName: string;
begin
  FileName := 'C:\' + Name + '.txt';
//  if FileExists(FileName) then
//    f := TFileStream.Create(FileName, fmOpenWrite + fmShareDenyNone)
//  else
    f := TFileStream.Create(FileName, fmCreate);
  f.Position := f.Size;
  // if doNextLine and (f.Size> 0)
  //  then f.Write(CR,2);
  f.Write(pointer(str)^, length(str));
  f.Write(CR, 2);
  f.Destroy;
end;

function CString_Create(capacity: integer): CString;
var
  p: Pointer;
begin
  p := c_malloc(capacity + 13);
  FillChar(p^, capacity + 13, 0);
  result := Pointer(Longword(p) + 12);
  PInteger(p)^ := 1;
  PInteger(Longword(p) + 4)^ := capacity;
  PInteger(Longword(p) + 8)^ := capacity + 13;
end;

procedure CString_Done(var cstr: CString);
begin
  if cstr <> nil then
  begin
    c_free(Pointer(Longword(cstr) - 12));
    cstr := nil;
  end;
end;

function CString_Init(cstr: CString; const s: string): CString;
begin
  if cstr = nil then
    result := CString_Create(Length(s) + 1)
  else
  if PInteger(Longint(cstr) - 8)^ <= Length(s) then
  begin
    CString_Done(cstr);
    result := CString_Create(Length(s) + 1);
  end
  else
    result := cstr;
  StrCopy(result, PChar(s));
end;

function GetFullName(Fecx:DWord): CString;
// eax, edx, ecx
asm
   mov   ecx, eax
   lea   eax, Result
   push  eax
   call  p_GetFullName
end;

///////////////////////////////////////////////////////////////
procedure NewAssignSource_xxx; stdcall; export;
var t,f: PChar;
    id:dword;
    Name:string;
begin
  asm
    push ebx;
    push esi;
    push edi;
    mov ecx, [ecx111];
    mov eax, dword ptr [ecx+$0C];
    mov id, eax
    mov eax, [ecx222];
    mov eax, [eax];
    mov t, eax;
  end;

  {$IFDEF Test}
  MessageBox(0,'NewAssignSource ','Tracer',0);
  {$ENDIF}
  UnitText:=t;
  if UnitText<>'' then
  begin
    if id=3131961357 then
    begin
      try
        //  1++    !!!
        //   1++     !!!!
        F:= PChar(Pointer(ecx111+$60)^);
        Name:= '_'+F;
      except
        Name:='_';
      end;
    end
    else
    begin
      Modul:=GetFullName(ecx111);
      Name:= '_'+Modul;
    end;

    //if (Name<>'_') and (Pos('.',Name)>0) then
    if MyCompile.Test(UnitText) then
    begin
    //OWrite('1',UnitText);
      NewUnitText:=MyCompile.Run(UnitText);
    //OWrite('2',NewUnitText);
      t:=nil;
      t:= PChar(NewUnitText+#0);
      asm
        // eax   t,   ,  !
        //mov eax, t;
        mov ecx, [ecx222];
        mov dword ptr[ecx], eax;
      end;
    end;
  end;
{$IFDEF Test}
MessageBox(0,'NewAssignSource ','Tracer',0);
{$ENDIF}
  asm
    pop edi;
    pop esi;
    pop ebx;
  end;
end;

///////////////////////////////////////////////////////////////
procedure NewAssignSource; stdcall;
begin
  if not CloseMode then
  begin
    asm
      mov [ecx111], ecx;
      mov eax,esp
      add eax, $04;
      mov [ecx222], eax;
    end;
    NewAssignSource_xxx;
    asm
      mov ecx,[ecx111];
    end;
  end;
  asm
    jmp [old111];
  end;
end;


{ IInitDone interface }

///////////////////////////////////////////////////////////////
function TAddInObject.Init(pConnection: IDispatch): HResult; stdcall;
begin
  CloseMode:=true;
  MyCompile:=TMyCompile.Create;
  Init := S_OK;
{$IFDEF Test}
MessageBox(0,'Init','Tracer',0);
{$ENDIF}

end;

///////////////////////////////////////////////////////////////
function TAddInObject.Done: HResult; stdcall;
begin
  Done := S_OK;
{$IFDEF Test}
MessageBox(0,'Done','Tracer',0);
{$ENDIF}
end;

///////////////////////////////////////////////////////////////
function TAddInObject.GetInfo(var pInfo: PSafeArray{(OleVariant)}): HResult; stdcall;
var  varInfo : OleVariant;
begin
  varInfo := '2000';
  PutNParam(pInfo,0,varInfo);
  GetInfo := S_OK;
end;

///////////////////////////////////////////////////////////////
{ ISpecifyPropertyPages interface }
function TAddInObject.GetPages(out Pages: TCAGUID) : HResult; stdcall;
begin
  GetPages := S_OK;
end;

///////////////////////////////////////////////////////////////
{ ILanguageExtender interface }
function TAddInObject.RegisterExtensionAs(var bstrExtensionName: WideString): HResult; stdcall;
begin
  bstrExtensionName := 'Tracer1C';
  RegisterExtensionAs := S_OK;
end;

///////////////////////////////////////////////////////////////
function TAddInObject.GetNProps(var plProps: Integer): HResult; stdcall;
begin
  plProps := Integer(LastProp);
  GetNProps := S_OK;
end;

///////////////////////////////////////////////////////////////
function TAddInObject.FindProp(const bstrPropName: WideString; var plPropNum: Integer): HResult; stdcall;
{ 1   }
begin
  plPropNum := -1;
  FindProp := S_FALSE;
end;

///////////////////////////////////////////////////////////////
function TAddInObject.GetPropName(lPropNum, lPropAlias: Integer; var pbstrPropName: WideString): HResult; stdcall;
{ 1   }
begin
  pbstrPropName := '';
  Result := S_FALSE;
end;

///////////////////////////////////////////////////////////////
function TAddInObject.GetPropVal(lPropNum: Integer; var pvarPropVal: OleVariant): HResult; stdcall;
{ 1   }
begin
  GetPropVal := S_FALSE;
end;

///////////////////////////////////////////////////////////////
function TAddInObject.SetPropVal(lPropNum: Integer; var varPropVal: OleVariant): HResult; stdcall;
{ 1   }
begin
  SetPropVal := S_FALSE;
end;

///////////////////////////////////////////////////////////////
function TAddInObject.IsPropReadable(lPropNum: Integer; var pboolPropRead: Integer): HResult; stdcall;
{ 1 ,    }
begin
  IsPropReadable := S_FALSE;
end;

///////////////////////////////////////////////////////////////
function TAddInObject.IsPropWritable(lPropNum: Integer; var pboolPropWrite: Integer): HResult; stdcall;
{ 1 ,    }
begin
  IsPropWritable := S_FALSE;
end;

///////////////////////////////////////////////////////////////
function TAddInObject.GetNMethods(var plMethods: Integer): HResult; stdcall;
begin
  plMethods := Integer(LastMethod);
  GetNMethods := S_OK;
end;

function TAddInObject.FindMethod(const bstrMethodName: WideString; var plMethodNum: Integer): HResult; stdcall;
{ 1    (  )   }
var name:ShortString;
begin
  plMethodNum := -1;
  name:=ShortString(bstrMethodName);

  if (LowerCase(name)='close') then plMethodNum := Integer(methClose);
  if (LowerCase(name)='open') then plMethodNum := Integer(methOpen);
  if (LowerCase(name)='exttracer') then plMethodNum := Integer(methExtTrace);
  if (LowerCase(name)='traceall') then plMethodNum := Integer(methAllTrace);

  if (plMethodNum = -1) then
  begin
    FindMethod := S_FALSE;
    Exit;
  end;

  FindMethod := S_OK;

end;

///////////////////////////////////////////////////////////////
function TAddInObject.GetMethodName(lMethodNum, lMethodAlias: Integer; var pbstrMethodName: WideString): HResult; stdcall;
{ 1    -   }
begin
  pbstrMethodName := '';
  GetMethodName := S_FALSE;
end;

///////////////////////////////////////////////////////////////
function TAddInObject.GetNParams(lMethodNum: Integer; var plParams: Integer): HResult; stdcall;
{ 1 ,     }
begin
  plParams := 0;

  case TMethods(lMethodNum) of
    methClose: plParams := 0;{ }
    methOpen: plParams := 0;{ }
    methExtTrace: plParams := 0;{ }
    methAllTrace: plParams := 1;{ }
  else
    begin
      GetNParams := S_FALSE;
      Exit;
    end;
  end;

  GetNParams := S_OK;

end;

///////////////////////////////////////////////////////////////
function TAddInObject.GetParamDefValue(lMethodNum, lParamNum: Integer; var pvarParamDefValue: OleVariant): HResult; stdcall;
begin
       { Ther is no default value for any parameter }
  VarClear(pvarParamDefValue);
  GetParamDefValue := S_OK;
end;
///////////////////////////////////////////////////////////////
function TAddInObject.HasRetVal(lMethodNum: Integer; var pboolRetValue: Integer): HResult; stdcall;
{ 1 ,     }
begin
  pboolRetValue := 0;
  case TMethods(lMethodNum) of
    methOpen: pboolRetValue := 0; {1= }
    methClose: pboolRetValue := 0; {1= }
    methExtTrace: pboolRetValue := 0; {1= }
    methAllTrace: pboolRetValue := 0; {1= }
  end;
  HasRetVal := S_OK;
end;
///////////////////////////////////////////////////////////////
function TAddInObject.CallAsProc(
{ 1    }
  lMethodNum: Integer;
  var paParams: PSafeArray{(OleVariant)})   : HResult; stdcall;
var  
      par0:integer;
begin
  case TMethods(lMethodNum) of
    methOpen:
    begin
      CloseMode:=false;
    end;
    methClose:
    begin
      CloseMode:=true;
      MyCompile.Close;
    end;
    methExtTrace:
    begin
      MyCompile.SetExtTracer;
    end;
    methAllTrace:
    begin
      par0:=GetNParam(paParams,0);
      if par0=1 then
        MyCompile.SetAllTrace(true)
      else
        MyCompile.SetAllTrace(false);
    end;
  else
    begin
      CallAsProc := S_FALSE;
      Exit;
    end;
  end;
  CallAsProc := S_OK;
end;

///////////////////////////////////////////////////////////////
function TAddInObject.CallAsFunc(lMethodNum: Integer; var pvarRetValue: OleVariant; var paParams: PSafeArray{(OleVariant)}): HResult; stdcall;
{ 1    }
begin
  CallAsFunc := S_FALSE;
end;

///////////////////////////////////////////////////////////////
function TAddInObject.get_Enabled(var IsEnabled : Integer): HResult; stdcall;
begin
  IsEnabled := 1;
  get_Enabled := S_OK;
end;

///////////////////////////////////////////////////////////////
function TAddInObject.put_Enabled(IsEnabled : Integer): HResult; stdcall;
begin
  put_Enabled := S_OK;
end;

///////////////////////////////////////////////////////////////
function TAddInObject.GetIDsOfNames(const IID: TGUID; Names: Pointer;
  NameCount, LocaleID: Integer; DispIDs: Pointer): HResult;
begin
  Result := E_NOTIMPL;
end;

///////////////////////////////////////////////////////////////
function TAddInObject.GetTypeInfo(Index, LocaleID: Integer;
  out TypeInfo): HResult;
begin
  Result := E_NOTIMPL;
end;

///////////////////////////////////////////////////////////////
function TAddInObject.GetTypeInfoCount(out Count: Integer): HResult;
begin
  Result := E_NOTIMPL;
end;

///////////////////////////////////////////////////////////////
function TAddInObject.Invoke(DispID: Integer; const IID: TGUID; LocaleID: Integer;
  Flags: Word; var Params; VarResult, ExcepInfo, ArgErr: Pointer): HResult;
begin
  Result := E_NOTIMPL;
end;

initialization

ComServer.SetServerName('AddIn');
TComObjectFactory.Create(ComServer,TAddInObject,CLSID_AddInObject,
                        'Tracer1C','V7 AddIn 2.0',ciMultiInstance);

if not HookProc('BLang.dll', '?AssignSource@CBLModule@@QAEXPBD@Z',
  @NewAssignSource, old111) then MessageBox(0,'?AssignSource@CBLModule@@QAEXPBD@Z','',0);
 ecx111 := GetModuleHandle('seven.dll');
 if ecx111 = 0 then ecx111 := LoadLibrary('seven.dll');
 p_GetFullName := GetProcAddress(ecx111, '?GetFullName@CBLModule7@@QBE?AVCString@@XZ');
{$IFDEF Test}
MessageBox(0,'initialization','Tracer',0);
{$ENDIF}

finalization

UnhookCode(old111);
{$IFDEF Test}
MessageBox(0,'finalization','Tracer',0);
{$ENDIF}
end.
