unit Compile;

interface
uses Classes,SysUtils,Math;

resourcestring
  LowSimb='qwertyuiopasdfghjklzxcvbnm';
  UpSimb='QWERTYUIOPASDFGHJKLZXCVBNMި';

type
TMyCompile = class
  public
  constructor Create;
    destructor Free;
    function Run(var s:String):String;
    function Test(var s:String):Boolean;
    procedure SetExtTracer;
    procedure SetAllTrace(b:boolean);
    procedure Close;
  private
    varlist:TStrings;
    iflist:TStrings;
    byltracer,tracer:boolean;
    TraceProc:boolean;
    ExtTracer:boolean;
    ToEndTraceProc:boolean;
    PervProc:boolean;
    AllTrace:boolean;
//    PLOHO:integer;
    function KeyPos(key:string;var s:string):integer;
    function GetIdent(var s:string):integer;
    function BegProc(var next,ost,res:String;var poln:Boolean):boolean;
    function EndProc(var next,pred,ost:String;var poln:Boolean):boolean;
    function GetPerem(var next,ost:String;var poln:Boolean):boolean;
    function GetNextString(var tek:String;var bylVK:boolean):String;
    function GetEval(var next,ost:String;var poln:Boolean):boolean;
    function GetIf(var next,ost:String;var poln:Boolean):boolean;
    function InfoFromBeginProc:String;
    function InfoFromEndProc(procname:String):String;
    function InfoFromEval:String;
    function InfoFromIF:String;
end;


implementation

function Prostoe(var s:string):boolean;
var
  k,ll:integer;
  c:char;
begin
  Result:=false;
  ll:=Length(s);
  if ll=0 then
  begin
    Result:=true;
    exit;
  end;
  if (s[1]='"')and(((s[ll-1]='"')and(s[ll]=';'))or(s[ll]='"')) then
    Result:=true
  else
  begin
    for k:=1 to ll do
    begin
      c:=s[k];
      if not(((c>='0')and(c<='9'))or((c='-')and(k=1))or((c='.')and(k>1))or((c=';')and(k=ll))) then
        break;
    end;
    if k>ll then
      Result:=true;
  end;
end;

function ToUp(s:string):string;
var
  ss:string;
  c:char;
  p,k,len:integer;
begin
  len:=Length(s);
  ss:=Copy(s,1,len);
  for k:=1 to len do
  begin
    c:=s[k];
    p:=Pos(c,LowSimb);
    if p>0 then
      ss[k]:=UpSimb[p];
  end;
  Result:=ss;
end;

constructor TMyCompile.Create;
begin
  varlist:=TStringList.Create;
  iflist:=TStringList.Create;
  AllTrace:=true;
  ExtTracer:=false;
//  PLOHO:=0;
end;

destructor TMyCompile.Free;
begin
  iflist.Free;
  varlist.Free;
end;

procedure TMyCompile.SetAllTrace(b:boolean);
begin
  AllTrace:=b;
end;

procedure TMyCompile.SetExtTracer;
begin
  ExtTracer:=true;
end;

procedure TMyCompile.Close;
begin
  iflist.Clear;
  varlist.Clear;
end;

function TMyCompile.KeyPos(key:string;var s:string):integer;
var p,ll:integer;
  c1,c2:char;
begin
  Result:=0;
  p:=Pos(key,s);
  if p>0 then
  begin
    ll:=Length(key);
    c1:=s[p+ll];
    c2:=s[p-1];
    if ((p+ll-1=Length(s))or(c1=' ')or(c1=#9)or(c1='(')or(c1=';')or(c1='"'))and
       ((p=1)or(c2=' ')or(c2=#9)or(c2=';')or(c2=')')or(c2='"')) then
      Result:=p;
  end;
end;

function TMyCompile.GetIdent(var s:string):integer;
var k,p,ll:integer;
  c:char;
  key:string;
begin
  Result:=0;
  p:=Pos('=',s);
  if p>0 then
  begin
    key:=trim(Copy(s,1,p-1));
    ll:=Length(key);
    for k:=1 to ll do
    begin
      c:=key[k];
      if Pos(c,UpSimb)=0 then
        break;
    end;
    if k>ll then
      Result:=p;
  end;
end;

//       / , 
//   ,   
// ,   
//    

//    
//  ,  next     
//  varslist       ,    ,
//  .   ,  next  
function TMyCompile.BegProc(var next,ost,res:String;var poln:Boolean):boolean;
var
  p,ll,kol:integer;
  c:char;
  s1,name:String;
  kov,ravno,perv:boolean;
begin
  varlist.Clear;
  s1:=ToUp(next);
  ll:=length(next);
  kov:=false;
  for p:=1 to ll do
  begin
    c:=s1[p];
    if c='"' then
      kov:=not kov
    else
      if kov then
        s1[p]:='-';
  end;
  p:=KeyPos('',s1);
  if p=0 then
    p:=KeyPos('PROCEDURE',s1);
  if p=1 then
    varlist.add('')
  else
  begin
    p:=KeyPos('',s1);
    if p=0 then
      p:=KeyPos('FUNCTION',s1);
    if p=1 then
      varlist.add('')
    else
    begin
      result:=false;
      exit;
    end;
  end;
  result:=true;
  poln:=false;
  p:=Pos(' ',next);
  if p=0 then
    exit;
  name:='';
  kol:=0;
  c:=' ';
  while p<=ll do
  begin
    c:=next[p];
    inc(p);
    if c='(' then
      break;
    name:=name+c;
  end;
  if c<>'(' then
    exit;
  varlist.add(trim(name));
  name:='';
  kov:=false;
  ravno:=false;
  while p<=ll do
  begin
    c:=next[p];
    inc(p);
    if c='"' then
    begin
      kov:=not kov;
      continue;
    end;
    if kov then
      continue;
    if c=')' then
      break;
    if c='=' then
      ravno:=true;
    if c=',' then
    begin
      varlist.add(trim(name));
      ravno:=false;
      name:='';
      kol:=0;
      continue;
    end;
    if not ravno then
    begin
      name:=name+c;
      if (c<>' ')and(c<>#9) then
        inc(kol);
      if ((c=' ')or(c=#9))and(kol=4) then
        if trim(ToUp(name))='' then
        begin
          name:='';
          kol:=100;
        end;
    end;
  end;
  if c<>')' then
    exit;
  ost:=trim(Copy(s1,p,ll-p+1));
  if trim(ost)='' then
    exit;
  if KeyPos('',ost)=1 then
  begin
    Result:=false;
    exit;
  end;
  if (KeyPos('',ost)=1)or(KeyPos('EXPORT',ost)=1) then
  begin
    perv:=true;
    ost:='';
    while p<=ll do
    begin
      c:=s1[p];
      inc(p);
      if ((c=' ')or(c=#9))and perv then
        continue;
      perv:=false;
      ost:=ost+c;
      if ost='' then
        break;
    end;
  end;
  if toUp(trim(varlist[1]))='' then
  begin
    PervProc:=false;
    ToEndTraceProc:=true;
    TraceProc:=false;
    byltracer:=tracer;
    tracer:=false;
  end;
  ost:=Copy(next,p,ll-p+1);
  next:=Copy(next,1,p-1);

  //PVR  res   1++
  if ExtTracer and PervProc then
  begin
    ll:=length(res);
    kov:=false;
    if ll>23 then
    begin
      s1:=Copy(res,ll-23,24);
      if s1='//#if _NOW_PREPARE_CLASS' then
      begin
       kov:=true;
       Delete(res, ll-23, 24);
      end;
    end;
    res:=res+#13#10+' (,="",="")'+#13#10+
     	'(,,);'+#13#10+
      ''+#13#10;
    if kov then
     res:=res+#13#10+'//#if _NOW_PREPARE_CLASS'+#13#10;

//    next:=' (,="",="")'+#13#10+
//     	'(,,);'+#13#10+
//      ''+#13#10+
//      #13#10+next;

    PervProc:=false;
  end;
  iflist.Clear;
  poln:=true;
end;

//    
//  ,  next     
//  varslist     ,  
//   ,  next  
function TMyCompile.EndProc(var next,pred,ost:String;var poln:Boolean):boolean;
var
  s1,dop:string;
  kov:Boolean;
  p,pp,p1,ll,pend,tp:integer;
  c:char;
begin
  Result:=false;
  poln:=false;
  varlist.Clear;
  s1:=ToUp(next);
  ll:=length(next);
  kov:=false;
  for p:=1 to ll do
  begin
    c:=s1[p];
    if c='"' then
      kov:=not kov
    else
      if kov then
        s1[p]:='-';
  end;
  p:=KeyPos('',s1);
  if p=0 then
    p:=KeyPos('RETURN',s1);
  if p>0 then
  begin
    Result:=true;
    pp:=p;
    c:=' ';
    while p<=ll do
    begin
      c:=next[p];
      inc(p);
      if (c=';')or(c=' ')or(c=#9) then
        break;
    end;
    if c<>';' then
    begin
      dop:=Copy(s1,p,ll-p+1);
      pend:=ll+1;
      p1:=KeyPos('',dop);
      if (p1>0) then
        pend:=min(pend,p1);
      p1:=KeyPos('',dop);
      if (p1>0) then
        pend:=min(pend,p1);
      p1:=KeyPos('',dop);
      if (p1>0) then
        pend:=min(pend,p1);
      p1:=KeyPos('',dop);
      if (p1>0) then
        pend:=min(pend,p1);
      p1:=KeyPos('',dop);
      if (p1>0) then
        pend:=min(pend,p1);
      p1:=KeyPos('',dop);
      if (p1>0) then
        pend:=min(pend,p1);
      p1:=KeyPos('',dop);
      if (p1>0) then
        pend:=min(pend,p1);
      p1:=KeyPos('',dop);
      if (p1>0) then
        pend:=min(pend,p1);
      p1:=KeyPos('ENDDO',dop);
      if (p1>0) then
        pend:=min(pend,p1);
      p1:=KeyPos('ELSEIF',dop);
      if (p1>0) then
        pend:=min(pend,p1);
      p1:=KeyPos('ELSE',dop);
      if (p1>0) then
        pend:=min(pend,p1);
      p1:=KeyPos('ENDIF',dop);
      if (p1>0) then
        pend:=min(pend,p1);
      p1:=KeyPos('ENDFUNCTION',dop);
      if (p1>0) then
        pend:=min(pend,p1);
      p1:=KeyPos('ENDPROCEDURE',dop);
      if (p1>0) then
        pend:=min(pend,p1);
      p1:=KeyPos('EXCEPT',dop);
      if (p1>0) then
        pend:=min(pend,p1);
      p1:=KeyPos('ENDTRY',dop);
      if (p1>0) then
        pend:=min(pend,p1);
      p1:=Pos(';',dop);
      if (p1>0) then
        pend:=min(pend,p1);
      if pend=ll+1 then
        exit;
      poln:=true;
      pred:=Copy(next,1,pp-1);
      if dop[pend]=';' then
      begin
        ost:=Copy(next,pend+p,ll-pend-p+1);
        dop:=Copy(next,p,pend-1);
        if (trim(dop)<>'') then
          if tracer then
            next:='Return Tracer___Ret;'
          else
            next:='Return '+dop+';'
        else
          next:=Copy(next,pp,pend+p-pp);
      end
      else
      begin
        ost:=Copy(next,pend+p-2,ll-pend-p+3);
        dop:=Copy(next,p,pend-2);
        if (trim(dop)<>'') then
          next:='Return Tracer___Ret;'
        else
          next:=Copy(next,pp,pend+p-pp-1);
      end;
      varlist.Add('');
      if (trim(dop)<>'') then
        varlist.Add(dop);
    end
    else
    begin
      varlist.Add('');
      poln:=true;
      pred:=Copy(next,1,pp-1);
      ost:=Copy(next,p,ll-p+1);
      next:=Copy(next,pp,p-pp+1);
    end
  end
  else
  begin
    tp:=0;
    p:=KeyPos('',s1);
    if p=0 then
      p:=KeyPos('ENDFUNCTION',s1);
    if p>0 then
      tp:=1
    else
    begin
      if p=0 then
        p:=KeyPos('',s1);
      if p=0 then
        p:=KeyPos('ENDPROCEDURE',s1);
      if p>0 then
        tp:=2;
    end;
    if p=0 then
      exit;
    if ToEndTraceProc then
      TraceProc:=true;
    pp:=p;
    while p<=ll do
    begin
      c:=next[p];
      if (c=' ') or (c=#9) then
        break;
      inc(p);
    end;
    if p=0 then
      p:=Pos(#9,next);
    pred:=Copy(next,1,pp-1);
    if p<=ll then
      ost:=Copy(next,p,ll-p+1)
    else
      ost:='';
    if tp=1 then
      varlist.Add('')
    else
      varlist.Add('');
    next:=Copy(next,pp,p-pp);
    poln:=true;
    Result:=true;
  end;
end;

//      
//  ,  next     
//   ,  next  
function TMyCompile.GetPerem(var next,ost:String;var poln:Boolean):boolean;
var
  s:String;
  p,ll:integer;
  c:char;
  net:boolean;
begin
  Result:=false;
  poln:=false;
  s:=ToUp(next);
  p:=1;
  net:=false;
  ll:=Length(s);
  while p<=ll do
  begin
    while p<=ll do
    begin
      c:=s[p];
      if (c<>' ')and(c<>#9) then
        break;
      inc(p);
    end;
    if p>ll then
      break;
    if (Copy(s,p,5)<>'')and(Copy(s,p,3)<>'VAR') then
      net:=true;
    if p<ll then
      if ((s[p]='V')and(s[p+3]<>' ')and(s[p+3]<>#9))or
         ((s[p]='')and(s[p+5]<>' ')and(s[p+5]<>#9))
      then
        net:=true;
    if net then
    begin
      ost:=Copy(next,p,ll-p+1);
      next:=Copy(next,1,p-1);
      Result:=true;
      poln:=true;
      exit;
    end;
    while p<=ll do
    begin
      c:=s[p];
      inc(p);
      if c=';' then
        break;
    end;
    Result:=true;
  end;
end;

//      = ...
//  ,  next     
//  varslist    
//   ,  next  
function TMyCompile.GetEval(var next,ost:String;var poln:Boolean):boolean;
var
  s1,dop:String;
  kov:boolean;
  p,p1,pid,psem,pend,ll:integer;
  c:char;
begin
  Result:=false;
  poln:=false;
  s1:=ToUp(next);
  ll:=length(next);
  kov:=false;
  for p:=1 to ll do
  begin
    c:=s1[p];
    if c='"' then
      kov:=not kov
    else
      if kov then
        s1[p]:='-';
  end;
  pid:=GetIdent(s1);
  if pid=0 then
    exit;
  psem:=Pos(';',s1);
  pend:=ll+1;
  p1:=KeyPos('',s1);
  if (p1>0) then
    pend:=min(pend,p1);
  p1:=KeyPos('',s1);
  if (p1>0) then
    pend:=min(pend,p1);
  p1:=KeyPos('',s1);
  if (p1>0) then
    pend:=min(pend,p1);
  p1:=KeyPos('',s1);
  if (p1>0) then
    pend:=min(pend,p1);
  p1:=KeyPos('',s1);
  if (p1>0) then
    pend:=min(pend,p1);
  p1:=KeyPos('',s1);
  if (p1>0) then
    pend:=min(pend,p1);
  p1:=KeyPos('ENDDO',s1);
  if (p1>0) then
    pend:=min(pend,p1);
  p1:=KeyPos('ELSEIF',s1);
  if (p1>0) then
    pend:=min(pend,p1);
  p1:=KeyPos('ELSE',s1);
  if (p1>0) then
    pend:=min(pend,p1);
  p1:=KeyPos('ENDIF',s1);
  if (p1>0) then
    pend:=min(pend,p1);
  p1:=KeyPos('ENDFUNCTION',s1);
  if (p1>0) then
    pend:=min(pend,p1);
  p1:=KeyPos('ENDPROCEDURE',s1);
  if (p1>0) then
    pend:=min(pend,p1);
  if (psem>0)or(pend<ll+1) then
  begin
    if pend<psem then
      dop:=trim(Copy(s1,pid+1,pend-pid))
    else
      dop:=trim(Copy(s1,pid+1,psem-pid));
    if (Pos('',dop)>0)or(Pos('CREATEOBJECT',dop)>0)or(Prostoe(dop)) then
      exit;
    Result:=true;
    poln:=true;
    varlist.add(trim(Copy(next,1,pid-1)));
    if pend<psem then
    begin
      ost:=Copy(next,pend-1,ll-pend+2);
      next:=Copy(next,1,pend-1);
    end
    else
    begin
      ost:=Copy(next,psem+1,ll-psem);
      next:=Copy(next,1,psem);
    end;
  end
  else
    Result:=true;
end;

function TMyCompile.GetIf(var next,ost:String;var poln:Boolean):boolean;
var
  s1,name:String;
  p,pif,pel,pelif,penif,p1,p2,pth,ll:integer;
  kov:boolean;
  ty:integer;
  c:char;
begin
  Result:=false;
  s1:=ToUp(next);
  ll:=length(next);
  kov:=false;
  for p:=1 to ll do
  begin
    c:=s1[p];
    if c='"' then
      kov:=not kov
    else
      if kov then
        s1[p]:='-';
  end;
  p1:=ll+1;
  ty:=0;
  pif:=KeyPos('',s1);
  if pif=0 then
    pif:=KeyPos('IF',s1);
  if pif>0 then
  begin
    ty:=1;
    p1:=pif;
  end;
  pelif:=KeyPos('',s1);
  if pelif=0 then
    pelif:=KeyPos('ELSEIF',s1);
  if (pelif>0)and(pelif<p1) then
  begin
    ty:=2;
    p1:=pelif;
  end;
  pel:=KeyPos('',s1);
  if pel=0 then
    pel:=KeyPos('ELSE',s1);
  if (pel>0)and(pel<p1) then
  begin
    ty:=3;
    p1:=pel;
  end;
  penif:=KeyPos('',s1);
  if penif=0 then
    penif:=KeyPos('ENDIF',s1);
  if (penif>0)and(penif<p1) then
  begin
    ty:=4;
    p1:=penif;
  end;
  if ty=0 then
    Exit;
  Result:=true;
  poln:=false;
  if (ty=1)or(ty=2) then
  begin
    pth:=KeyPos('',s1);
    if pth=0 then
      pth:=KeyPos('THEN',s1);
    if pth=0 then
      exit;
    while (s1[p1]<>' ')and(s1[p1]<>#9)and(s1[p1]<>'(') do inc(p1);
    p2:=pth;
    while (p2<=ll)and(s1[p2]<>' ')and(s1[p2]<>#9)and(s1[p2]<>'(') do inc(p2);
    name:=trim(Copy(next,p1,pth-p1));
    varlist.Add('IF');
    varlist.Add(name);
    if ty=2 then
      iflist[iflist.Count-1]:=name
    else
      iflist.Add(name);
    if p2<=ll then
    begin
      ost:=Copy(next,p2,ll-p2+1);
      next:=Copy(next,1,p2-1);
    end
    else
      ost:='';
    poln:=true;
  end
  else
  if ty=3 then
  begin
    varlist.Add('ELSE');
    varlist.Add(iflist[iflist.Count-1]);
    while (p1<=ll)and(s1[p1]<>' ')and(s1[p1]<>#9)and(s1[p1]<>'(') do inc(p1);
    if p1<=ll then
    begin
      ost:=Copy(next,p1,ll-p1+1);
      next:=Copy(next,1,p1-1);
    end
    else
      ost:='';
    poln:=true;
  end
  else
  if ty=4 then
  begin
    varlist.Add('END');
//    if iflist.Count<=0 then
//    begin
//      PLOHO:=1;
//    end
//    else
    varlist.Add(iflist[iflist.Count-1]);
    iflist.Delete(iflist.Count-1);
    while (p1<=ll)and(s1[p1]<>' ')and(s1[p1]<>#9)and(s1[p1]<>'(') do inc(p1);
    if p1<=ll then
    begin
      ost:=Copy(next,p1,ll-p1+1);
      next:=Copy(next,1,p1-1);
    end
    else
      ost:='';
    poln:=true;
  end;
end;

//         tek
function TMyCompile.GetNextString(var tek:String;var bylVK:boolean):String;
var
  k,ll:integer;
  s:String;
  c:char;
  kov,simv:boolean;
begin
  s:='';
  ll:=Length(tek);
  bylVK:=false;
  k:=1;
  kov:=false;
  simv:=false;
  while k<=ll do
  begin
    c:=tek[k];
    inc(k);
    if c=#10 then continue;
    if c=#13 then
    begin
      bylVK:=true;
      break;
    end;
    if (c='|')and(not simv) then
      kov:=not kov;
    if ((c=' ')or(c=#9))and(not simv) then
      continue;
    simv:=true;
    if c='"' then
      kov:=not kov;
    s:=s+c;
    if (c=';') and not kov then break;
  end;
  if k>ll then
    tek:=''
  else
    tek:=Copy(tek,k,ll-k+1);
  Result:=s;
end;

function TMyCompile.InfoFromBeginProc:String;
var
  k:integer;
  res:String;
begin
  if varlist[0]='' then
    if TraceProc then
      res:='("","'+varlist[1]+'");'
    else
      res:='("<<<   : '+varlist[1]+'");'
  else
    if TraceProc then
      res:='("","'+varlist[1]+'");'
    else
      res:='("<<<   : '+varlist[1]+'");';
  if varlist.Count>1 then
    for k:=2 to varlist.Count-1 do
      if TraceProc then
        res:=res+#13#10+'("","'+varlist[k]+'",'+varlist[k]+');'
      else
        res:=res+#13#10+'("'+varlist[k]+'="+('+varlist[k]+'));';
  if TraceProc then
    res:=res+#13#10+'("");';
  Result:=res;
end;

function TMyCompile.InfoFromEndProc(procname:String):String;
var
  s,res:String;
begin
  res:='';
  s:=varlist[0];
  if s='' then
    if TraceProc then
      if varlist.Count>1 then
        res:='Tracer___Ret='+varlist[1]+';'+#13#10+'("","'+procname+'",Tracer___Ret);'
      else
        res:='("","'+procname+'");'
    else
      if varlist.Count>1 then
        res:='Tracer___Ret='+varlist[1]+';'+#13#10+'("  '+procname+': "+(Tracer___Ret));'
      else
        res:='("  '+procname+'");'
  else
  if s='' then
    if TraceProc then
      res:=';("","'+procname+'");'
    else
      res:=';(">>>   '+procname+'");'
  else
  if s='' then
    if TraceProc then
      res:=';("","'+procname+'");'
    else
      res:=';(">>>   '+procname+'");';
  Result:=res;
end;

function TMyCompile.InfoFromIF:String;
var
  s,res:String;      //StringToOleStr
begin
  res:='';
  if varlist.Count>0 then
  begin
    if varlist.Count>1 then
    begin
      s:=varlist[1];
      s:=StringReplace(s,'"','""',[rfReplaceAll]);
    end;
    if varlist[0]='IF' then
      if TraceProc then
        res:='("","'+s+'");'
      else
        res:='(": '+s+'");'
    else
    if varlist[0]='ELSE' then
      if TraceProc then
        res:='("","'+s+'");'
      else
        res:='(" : '+s+'");';
    if varlist[0]='END' then
      if TraceProc then
        res:=';("","'+s+'");'
      else
        res:=';(" : '+s+'");';
  end;
  Result:=res;
end;

function TMyCompile.InfoFromEval:String;
begin
  if TraceProc then
    Result:=';("","'+varlist[0]+'",'+varlist[0]+');'
  else
    Result:=';("'+varlist[0]+'="+('+varlist[0]+'));'
end;

function TMyCompile.Test(var s:String):Boolean;
var tek,n:String;
  bylVK:Boolean;
begin
  tek:=s;
  n:=trim(GetNextString(tek,bylVK));
  if AllTrace then
    if n='//*** Traced by O-Planet' then
      Result:=false
    else
      Result:=true
  else
  begin
    Result:=false;
    if ToUp(n)='//TRACER ON' then
      Result:=true;
  end;
end;

function TMyCompile.Run(var s:String):String;
var n,tek,pred,next,res,ost,otlstr,procname:String;
  poln,waitperem,bylVK,bylcomm,newinput:boolean;
  p:integer;
begin
  TraceProc:=ExtTracer;
  ToEndTraceProc:=false;
  PervProc:=true;
  tek:=s;
  res:='//*** Traced by O-Planet'+#13#10;
  otlstr:='';
  waitperem:=false;
  bylcomm:=false;
  bylVK:=false;
  tracer:=true;
  newinput:=true;
  while (tek<>'')or(otlstr<>'') do
  begin
    if tek='' then
    begin
      tek:=otlstr;
      otlstr:='';
    end;
    if newinput then
      n:=trim(GetNextString(tek,bylVK))
    else
      n:='';
    //     
    if bylcomm then
    begin
      if bylVK then
        bylcomm:=false

      //PVR      :)
      else if newinput=False then
        bylcomm:=false;

      Continue;
    end;
    if newinput then
    begin
      if ToUp(n)='//TRACER ON' then
        tracer:=true;
      if ToUp(n)='//TRACER OFF' then
        tracer:=false;
      p:=Pos('//',n);
      if p>0 then
      begin
        if not bylVK then
          bylcomm:=true;

        //n:=trim(Copy(n,1,p-1));
        //PVR  
        if (n[1]='/') and (n[2]='/') then
        begin
          res:=res+#13#10+n;
          Continue;
        end;
      end;

      if n='' then
        Continue;
      if (Length(n)>0)and(n[1]='|') then
        n:=#13#10+n;
      //     
      next:=trim(otlstr+' '+n);
      newinput:=false;
    end
    else
    begin
      next:=trim(otlstr);
      if next='' then
      begin
        newinput:=true;
        continue;
      end;
    end;
    otlstr:='';
    //          
    if waitperem then
    begin
      if GetPerem(next,ost,poln) then
    //    ,   
        if not poln then
        begin
          otlstr:=next;
          newinput:=true;
        end
        else
    //   ,       
    //    -  ,   ,  next  
        begin
          if tracer then
            res:=res+#13#10+next+#13#10+InfoFromBeginProc
          else
            res:=res+#13#10+next+#13#10;
          otlstr:=ost;
          if ost='' then
            newinput:=true;
          waitperem:=false;
        end;
    end
    else
    //    
    if BegProc(next,ost,res,poln) then
    begin
    //    ,   
      if not poln then
      begin
        otlstr:=next;
        newinput:=true;
      end
      else
    //   ,         
    // varlist      
    //    -  ,   ,  next  
      begin
        procname:=varlist[1];
        res:=res+#13#10+next;
        otlstr:=ost;
        if ost='' then
          newinput:=true;
        waitperem:=true;
      end;
    end
    else
    //     = ... ,  
    //   
    if GetEval(next,ost,poln) then
    begin
      if not poln then
      begin
        otlstr:=next;
        newinput:=true;
      end
      else
      begin
        if tracer then
          res:=res+#13#10+next+#13#10+InfoFromEval
        else
          res:=res+#13#10+next;
        otlstr:=ost;
        if ost='' then
          newinput:=true;
      end
    end
    else
    //   if  elseif  else    then (else) ,
    //   
    if GetIf(next,ost,poln) then
    begin
      if not poln then
      begin
        otlstr:=next;
        newinput:=true;
      end
      else
      begin
        if tracer then
        begin
          if varlist[0]='IF' then
            res:=res+#13#10+next+#13#10+InfoFromIF
          else
          if varlist[0]='ELSE' then
          begin
            varlist[0]:='END';
            res:=res+#13#10+InfoFromIF+#13#10+next;
            varlist[0]:='ELSE';
            res:=res+#13#10+InfoFromIF;
          end
          else
            res:=res+#13#10+InfoFromIF+#13#10+next;
        end
        else
          res:=res+#13#10+next;
        otlstr:=ost;
        if ost='' then
          newinput:=true;
      end
    end
    else
    //    
    if EndProc(next,pred,ost,poln) then
    begin
    //    ,   
      if not poln then
      begin
        otlstr:=next;
        newinput:=true;
      end
      else
    //   ,         
    //    -  ,   ,  next 
      begin
        if tracer then
          res:=res+#13#10+pred+#13#10+InfoFromEndProc(procname)+#13#10+next
        else
          res:=res+#13#10+pred+#13#10+next;
        if ToEndTraceProc and TraceProc then
        begin
          ToEndTraceProc:=false;
          tracer:=byltracer;
        end;
        otlstr:=ost;
        if ost='' then
          newinput:=true;
      end;
    end
    else
    //    -,    .   .
    begin
      res:=res+#13#10+next;
      newinput:=true;
      otlstr:='';
    end;
//    if PLOHO=1 then break;
  end;
  Result:=res;
end;

end.
