unit PatchMemory;


Interface
uses Windows, ImageHlp, SysUtils;

var  BasePointer: pointer;
type TPatchMemory = Class
  Debug: Boolean; // 
  DllNameToPatch: String; // DLL,       
  DllNameToFind: String; // DLL,      (, 'KERNEL32.dll')
  FuncNameToFind: String; //,     (, 'CreateProcessA')
  NewFunctionAddr: Pointer; //  - 
  OldFunctionAddr: Pointer; //   
  function Patch():Boolean;  //     
  procedure UnPatch;  // 

        Constructor Create;
        Destructor Destroy; Override;

private

  AddrWherePatching: Pointer; // UnPatch
  function GetDwordByRVA(rva: dword):dword;
  function GetStringByRVA(rva: dword):pchar;
  function GetPointerByRVA(rva: DWORD):Pointer;
  function GetRVAByPointer(P: Pointer):DWORD;
  procedure WriteDwordToMemory(Kuda: Pointer; Data: DWORD);
  function GetDwordFromMemory(addr: Pointer):DWORD;
//  function GetPointerFromAddr(addr: DWORD):Pointer;
  procedure say(s:String);

end;


//////////////////////////////////////////////////////////
implementation

//////////////////////////////////////////////////////////
procedure TPatchMemory.say(s:String);
// 
begin
  if Debug then
  MessageBox(0,pchar(s),'',0);
end;


//////////////////////////////////////////////////////////////
Constructor TPatchMemory.Create;
begin
     inherited Create;
     debug:=False;
end;

//////////////////////////////////////////////////////////////
destructor TPatchMemory.Destroy;
begin
     say('Destroy');
     inherited Destroy;

end;



//////////////////////////////////////////////////
function TPatchMemory.GetDwordByRVA(rva: dword):dword;
//  (4     - DWORD)   
// (RVA)
begin
   asm
     push ebx;

     mov ebx, [rva];
     add ebx, [BasePointer];

     mov eax, [ebx];
     mov Result, eax;

     pop ebx;
   end;
end;

//////////////////////////////////////////////////
function TPatchMemory.GetStringByRVA(rva: dword):pchar;
//    RVA
begin
   asm
     mov eax, [rva];
     add eax, [BasePointer];
     mov Result, eax;
   end;
end;

//////////////////////////////////////////////////
function TPatchMemory.GetPointerByRVA(rva: DWORD):Pointer;
//   RVA (..   rva  BasePointer)
begin
   asm
     mov eax, rva;
     add eax, [BasePointer];
     mov Result, eax;
   end;
end;

//////////////////////////////////////////////////
function TPatchMemory.GetDwordFromMemory(addr: Pointer):DWORD;
begin
   asm
     push ebx;

     mov ebx, [addr];
     mov eax, [ebx];
     mov Result, eax;

     pop ebx;
   end;
end;


//////////////////////////////////////////////////
function TPatchMemory.GetRVAByPointer(P: Pointer):DWORD;
//  RVA  
//(..     BasePointer)
begin
  asm
    mov eax, [p];
    sub eax, BasePointer;
    mov Result, eax;
  end;
end;

//////////////////////////////////////////////////
Procedure TPatchMemory.WriteDwordToMemory( // 4     .
  Kuda: Pointer; //  
  Data: DWORD //  
);

var  BytesWritten: DWORD;
var  hProcess: THandle;
var old: DWORD;
begin

  hProcess := Windows.GetCurrentProcess();


    //      

    Windows.VirtualProtect(// WinAPI
      kuda, //
      4, //  (  1  2    4)
      PAGE_EXECUTE_READWRITE, // 
      @old); //    

    BytesWritten:=0;

    // 4 
    Windows.WriteProcessMemory(// WinAPI
      hProcess,
      kuda,
      @data,
      4,
      BytesWritten);

 //   
    Windows.VirtualProtect(// WinAPI
      kuda,
      4,
      old,
      @old);

end;



//////////////////////////////////////////////////////////
function TPatchMemory.Patch():boolean;
var ulSize: ULONG;
var rva: DWORD;
var ImportTableOffset: pointer;
var OffsetDllName: DWORD;
var OffsetFuncAddrs: DWORD;
var FunctionAddr: DWORD;
var DllName: String;
//var FuncAddrToFind: DWORD;

var OffsetFuncNames: DWORD;
var pFuncName: pchar;
var dFuncName: DWORD;
var nFuncName: Integer;
var nFuncAddr: Integer;
var ok: Integer;
begin

   Result:=False;

// Windows 2000 DLL   , ,   
   if DWORD(GetModuleHandle(pchar(DllNameToPatch)))=0 then begin
      LoadLibrary(pchar(DllNameToPatch));
   end;

//  ,       IAT
  say(DllNameToFind+' '+FuncNameToFind);
(*
  FuncAddrToFind:= DWORD(
    GetProcAddress(// Windows API
      GetModuleHandle(// Windows API
        pchar(DllNameToFind)
      ),
      pchar(FuncNameToFind)
    ));
*)
//  say('FuncAddrToFind: '+IntToHex(FuncAddrToFind,8));
//  OldFunctionAddr:=Pointer(FuncAddrToFind);

// ,      dll - "".
  BasePointer:=pointer(GetModuleHandle(// Windows API
  pChar(DllNameToPatch)));

//   
  ImportTableOffset:= ImageDirectoryEntryToData( // Windows API
  BasePointer, TRUE, IMAGE_DIRECTORY_ENTRY_IMPORT, ulSize);

//      RVA
//(   DLL)
  rva:=GetRvaByPointer(ImportTableOffset);

  repeat    {   .
            20 :
     +0 -     
     +4 - ?
     +8 - ?
     +12 -  (RVA)   DLL
     +16 -     
     }

         OffsetDllName := GetDwordByRVA(rva+12);
         if OffsetDllName = 0 then break; //  , 

          DllName := GetStringByRVA(OffsetDllName);// DLL
//            if LowerCase(Trim(DllName))=LowerCase(Trim(DllNameToFind)) then begin   // avgreen@molvest.org.ua
            if pos(LowerCase(Trim(DllNameToFind)), LowerCase(Trim(DllName))) = 1 then begin //        .     'plugin_unload_dat_fix.dpr'

               OffsetFuncNames:=GetDwordByRVA(rva+0); //  
               //if LowerCase(DllNameToPatch)='dbeng32.dll' then
               //MessageBox(0, pchar(IntToHex(OffsetFuncNames,8)), pchar(DllNameToFind+' '+DllNameToPatch+' '+FuncNameToFind), 0);

                 nFuncName:=0;
                 ok:=0;
                 repeat //     DLL
                     dFuncName:=GetDwordByRva(OffsetFuncNames);
                     if dFuncName=0 then break;

                     inc(nFuncName);

                     pFuncName:=GetStringByRva(dFuncName);
                     inc(pFuncName,2);

                     //if debug then
                     //MessageBox(0, pchar(IntToHex(GetDwordByRva(OffsetFuncNames),8)), pchar(DllNameToFind+' '+DllNameToPatch+' '+FuncNameToFind), 0);
                     //MessageBox(0, pFuncName, pchar(DllNameToFind+' '+DllNameToPatch+' '+FuncNameToFind), 0);

                     if LowerCase(Trim(''+pFuncName))=LowerCase(Trim(FuncNameToFind)) then begin
                       ok:=1;
                       //MessageBox(0, pchar(DllNameToFind+' '+DllNameToPatch+' '+FuncNameToFind), pFuncName, 0);
                       break; //
                     end;

                     inc(OffsetFuncNames,4);
                 until False;


               if ok=1 then begin
                 OffsetFuncAddrs:=GetDwordByRva(rva+16);
                 nFuncAddr:=0;
                 repeat //    DLL
                   FunctionAddr:=Dword(GetDwordByRva(OffsetFuncAddrs));
                   if FunctionAddr=0 then break; //  , 
                   inc(nFuncAddr);

                   //if (FunctionAddr=FuncAddrToFind) then begin
                   if nFuncAddr=nFuncName then begin
                    // -  
                     AddrWherePatching:=GetPointerByRva(OffsetFuncAddrs);
                      say('AddrWherePatching: '+IntToHex(Dword(AddrWherePatching),8));





                      OldFunctionAddr:=Pointer(GetDwordFromMemory(AddrWherePatching));
                      Result:=True;

//                      MessageBox(0, pchar(IntToHex(Dword(OldFunctionAddr), 8)),
//                        pchar(DllNameToPatch+' '+FuncNameToFind+' sleep_dbf'), 0);
                      //OldFunctionAddr:=OldFunctionAddr1;

                     WriteDwordToMemory(
                      AddrWherePatching,
                      DWORD(NewFunctionAddr));

                      say('AddrWherePatching: '+IntToHex(Dword(AddrWherePatching),8));
                   end;


                   inc(OffsetFuncAddrs,4);
                 until false;
               end;

             end;
          rva:=rva+20;
  until false;

end;


//////////////////////////////////////////////////////////
procedure TPatchMemory.UnPatch;
begin
   say('AddrWherePatching: '+IntToHex(Dword(AddrWherePatching),8));
   say('OldFunctionAddr: '+IntToHex(Dword(OldFunctionAddr),8));
   WriteDwordToMemory(
     AddrWherePatching,
     DWORD(OldFunctionAddr));
end;


end.
