// Connection.h : Declaration of the CConnection

#pragma once
#include "V7Server.h"
#include "resource.h"       // main symbols
#include <comsvcs.h>



// CConnection

class ATL_NO_VTABLE CConnection :
	public CComObjectRootEx<CComMultiThreadModel>,
	public IObjectControl,
	public IObjectConstruct,
	public CComCoClass<CConnection, &CLSID_Connection>,
	public IDispatchImpl<IConnection, &IID_IConnection, &LIBID_V7ServerLib, /*wMajor =*/ 1, /*wMinor =*/ 0>
{
public:
	CConnection()
	{
	}

	DECLARE_PROTECT_FINAL_CONSTRUCT()

	HRESULT FinalConstruct()
	{
		return S_OK;
	}

	void FinalRelease()
	{
	}

DECLARE_REGISTRY_RESOURCEID(IDR_CONNECTION)

BEGIN_COM_MAP(CConnection)
	COM_INTERFACE_ENTRY(IConnection)
	COM_INTERFACE_ENTRY(IObjectControl)
	COM_INTERFACE_ENTRY(IObjectConstruct)
	COM_INTERFACE_ENTRY(IDispatch)
END_COM_MAP()

// IObjectControl
public:
	STDMETHOD(Activate)();
	STDMETHOD_(BOOL, CanBePooled)();
	STDMETHOD_(void, Deactivate)();

	CComPtr<IObjectContext> m_spObjectContext;
	CComDispatchDriver V7;

	STDMETHOD(Construct)(IDispatch * pCtorObj)
	{
		CComPtr<IObjectConstructString> spObjectConstructString;
		HRESULT hr = pCtorObj->QueryInterface(&spObjectConstructString);
		if (SUCCEEDED(hr))
		{
			CComBSTR bstrConstruct;
			hr = spObjectConstructString->get_ConstructString(&bstrConstruct);
			if (SUCCEEDED(hr))
			{
				VARIANT Params[3];
				CLSID clsid;
				hr = CLSIDFromProgID(L"V77.Application", &clsid);
				if(FAILED(hr)) return hr;
				hr = CoCreateInstance(clsid, 0, CLSCTX_LOCAL_SERVER, IID_IDispatch, (void **)&V7.p);
				if(FAILED(hr)) return hr;
				hr = V7.GetPropertyByName(L"RMTrade" , &Params[2]);
				if(FAILED(hr)) return hr;
				Params[1].vt = VT_BSTR;
				Params[1].bstrVal = bstrConstruct;
				Params[0].vt = VT_BSTR;
				Params[0].bstrVal = SysAllocString(L"NO_SPLASH_SHOW");
				VARIANT retval;
				hr = V7.InvokeN(L"Initialize", Params, 3, &retval);
				if(retval.boolVal == FALSE) return E_FAIL;
			}
		}
		return hr;
	}

// IConnection
public:
	STDMETHOD(GetTypeInfoCount)(UINT* pctinfo)
	{		
		return V7 -> GetTypeInfoCount(pctinfo);
	}
	STDMETHOD(GetTypeInfo)(UINT itinfo, LCID lcid, ITypeInfo** pptinfo)
	{
		return V7 -> GetTypeInfo(itinfo, lcid, pptinfo);
	}
	STDMETHOD(GetIDsOfNames)(REFIID riid, LPOLESTR* rgszNames, UINT cNames,
		LCID lcid, DISPID* rgdispid)
	{
		return V7 -> GetIDsOfNames(riid, rgszNames, cNames, lcid, rgdispid);
	}
	STDMETHOD(Invoke)(DISPID dispidMember, REFIID riid,
		LCID lcid, WORD wFlags, DISPPARAMS* pdispparams, VARIANT* pvarResult,
		EXCEPINFO* pexcepinfo, UINT* puArgErr)
	{
		HRESULT hr;
		try{
			hr = V7 -> Invoke(dispidMember, riid, lcid, wFlags, pdispparams, pvarResult,
				pexcepinfo, puArgErr);
			return hr;
		}catch(...)
		{
			pexcepinfo -> bstrDescription = SysAllocString(L"  OLE- 1");
			pexcepinfo -> bstrSource = SysAllocString(L"Connection");
			pexcepinfo -> wCode = 1006;			
			return E_FAIL;
		};
		return E_FAIL;
	}
};

OBJECT_ENTRY_AUTO(__uuidof(Connection), CConnection)
