unit CRC32;

interface
function GetNewCRC32(OldCRC: Cardinal; StPtr: Pointer; StLen: Integer): Cardinal;
function GetStringCRC32(Src: String): Cardinal;

implementation
var
  CRC32table: array[0..255] of Cardinal;

function GetNewCRC32(OldCRC: cardinal; StPtr: pointer; StLen: integer): cardinal;
//  
asm
  test edx,edx;
  jz @ret;
  neg ecx;
  jz @ret;
  sub edx,ecx; // Address after last element
  push ebx;
  mov ebx,0; // Set ebx=0 & align @next
@next:
  mov bl,al;
  xor bl,byte [edx+ecx];
  shr eax,8;
  xor eax,cardinal [CRC32table+ebx*4];
  inc ecx;
  jnz @next;
  pop ebx;
@ret:
end;

function GetStringCRC32(Src: String): Cardinal;
begin
  Result:= GetNewCRC32($FFFFFFFF, Pointer(Src), Length(Src));// xor $FFFFFFFF;
end;

procedure CRC32Init;
var
  i, j, c: Cardinal;
begin
  for i:=0 to 255 do begin
    c:=i;
    for j:=1 to 8 do if odd(c) then c:= (c shr 1) xor $EDB88320 else c:= c shr 1;
    CRC32table[i]:=c;
  end;
end;

initialization
  CRC32init;
end.