#ifndef _IMULTINTERFACE2_H_
#define _IMULTINTERFACE2_H_

#include "IMultInterface.h"

// Our IMultInterface has a Base1 sub-object. It must be embedded as the
// very first member.
//
// Our IMultInterface also has one ISub1 sub-object. The app may ask for this
// sub-object, and call its functions. The easiest way make this possible
// is to simply embed that one ISub1 object right inside of our
// IMultInterface object.
//
// Our IMultInterface also has one ISub1 sub-object. The app may ask for this
// sub-object, and call its functions. But let's assume that this ISub2 object
// may have a lot of data members, so we don't want to actually allocate one
// until/unless the app specifically asks for it. So let's just put a pointer
// to a ISub2 object here. This will be zero'ed until we actually allocate
// an ISub2
//
// Finally, we have a reference count for the base object.
typedef struct {
	IBase				base;
	ISub1				sub1;
	ISub2				*sub2;
	DWORD				count;
} IMultInterface;

// We need to call IBase's QueryInterface, AddRef, and Release
// functions (which are in IBase.c) from ISub1.c and ISub2.c,
// so let the C compiler know they're extern
extern HRESULT STDMETHODCALLTYPE IBase_QueryInterface(IBase *, REFIID, void **);
extern ULONG STDMETHODCALLTYPE IBase_AddRef(IBase *);
extern ULONG STDMETHODCALLTYPE IBase_Release(IBase *);

extern void initISub1(IMultInterface *);
extern ISub2 * allocISub2(IBase *);

#endif