#ifndef _APPOBJECT_H
#define _APPOBJECT_H

#undef  INTERFACE
#define INTERFACE IApp
DECLARE_INTERFACE_ (INTERFACE, IDispatch)
{
	// IUnknown functions
	STDMETHOD  (QueryInterface)	(THIS_ REFIID, void **) PURE;
	STDMETHOD_ (ULONG, AddRef)	(THIS) PURE;
	STDMETHOD_ (ULONG, Release)	(THIS) PURE;
	// IDispatch functions
	STDMETHOD (GetTypeInfoCount)(THIS_ UINT *) PURE;
	STDMETHOD (GetTypeInfo)		(THIS_ UINT, LCID, ITypeInfo **) PURE;
	STDMETHOD (GetIDsOfNames)	(THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID *) PURE;
	STDMETHOD (Invoke)			(THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT *) PURE;
	// Extra functions
	STDMETHOD  (CreateDocument)	(THIS_ BSTR, IDispatch **) PURE;
};

class MyRealIApp: public IApp, public IProvideMultipleClassInfo
{
public:
	static const wchar_t MyAppObjectName[];

	MyRealIApp()
	{
	}

	~MyRealIApp()
	{
	}

	//***** IUnknown Methods *****
	STDMETHODIMP QueryInterface(REFIID, void**);
	STDMETHODIMP_(ULONG) AddRef();
	STDMETHODIMP_(ULONG) Release();

	//***** IDispatch Methods *****
	STDMETHODIMP GetTypeInfoCount(UINT *);
	STDMETHODIMP GetTypeInfo(UINT, LCID, ITypeInfo **);
	STDMETHODIMP GetIDsOfNames(REFIID, OLECHAR **, UINT, LCID, DISPID *);
	STDMETHODIMP Invoke(DISPID, REFIID, LCID, WORD, DISPPARAMS *,  VARIANT *, EXCEPINFO *, UINT *);

	//***** IProvideMultipleClassInfo Methods *****
	STDMETHODIMP GetClassInfo(ITypeInfo **);
	STDMETHODIMP GetGUID(DWORD, GUID *);
	STDMETHODIMP GetMultiTypeInfoCount(ULONG *);
	STDMETHODIMP GetInfoOfIndex(ULONG, DWORD, ITypeInfo **, DWORD *, ULONG *, GUID *, GUID *);

	//***** Extra Methods *****
	STDMETHODIMP CreateDocument(BSTR, IDispatch **);
};

#undef  INTERFACE
#define INTERFACE IDocument
DECLARE_INTERFACE_ (INTERFACE, IDispatch)
{
	// IUnknown functions
	STDMETHOD  (QueryInterface)	(THIS_ REFIID, void **) PURE;
	STDMETHOD_ (ULONG, AddRef)	(THIS) PURE;
	STDMETHOD_ (ULONG, Release)	(THIS) PURE;
	// IDispatch functions
	STDMETHOD (GetTypeInfoCount)(THIS_ UINT *) PURE;
	STDMETHOD (GetTypeInfo)		(THIS_ UINT, LCID, ITypeInfo **) PURE;
	STDMETHOD (GetIDsOfNames)	(THIS_ REFIID, LPOLESTR *, UINT, LCID, DISPID *) PURE;
	STDMETHOD (Invoke)			(THIS_ DISPID, REFIID, LCID, WORD, DISPPARAMS *, VARIANT *, EXCEPINFO *, UINT *) PURE;
	// Extra functions
	STDMETHOD  (WriteText)		(THIS_ BSTR) PURE;
};

class MyRealIDocument: public IDocument
{
public:
	ULONG				RefCount;
	HWND				Hwnd;
	LPTSTR				Text;

	// Increment RefCount -- once because this document window's WM_DESTROY
	// will call the IDocument->Release(), and also increment RefCount on
	// behalf of the script (ie, we'll be returning the IDocument to the
	// script)
	MyRealIDocument() : RefCount(2), Hwnd(0), Text(0)
	{
	}

	~MyRealIDocument()
	{
	}

	//***** IUnknown Methods *****
	STDMETHODIMP QueryInterface(REFIID, void**);
	STDMETHODIMP_(ULONG) AddRef();
	STDMETHODIMP_(ULONG) Release();

	//***** IDispatch Methods *****
	STDMETHODIMP GetTypeInfoCount(UINT *);
	STDMETHODIMP GetTypeInfo(UINT, LCID, ITypeInfo **);
	STDMETHODIMP GetIDsOfNames(REFIID, OLECHAR **, UINT, LCID, DISPID *);
	STDMETHODIMP Invoke(DISPID, REFIID, LCID, WORD, DISPPARAMS *,  VARIANT *, EXCEPINFO *, UINT *);

	//***** Extra Methods *****
	STDMETHODIMP WriteText(BSTR);
};

extern IUnknown *	getAppObject(void);
extern HRESULT		getAppObjectITypeInfo(ITypeInfo **);
extern void			initMyRealIAppObject(void);
extern void			freeMyRealIAppObject(void);
extern HRESULT		allocIDocument(MyRealIDocument **);

#endif