/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileNameExtensionFilter;

public class ConsoleQuery1C
extends JFrame
implements ChangeListener {
    Properties lastPropertys = new Properties();
    static TabQuerys querys;
    static ConsoleQuery1C console;
    final OpenAction openAction = new OpenAction();
    final SaveAction saveAction = new SaveAction();
    final SaveAsAction saveAsAction = new SaveAsAction();
    final ConnectAction connectAction = new ConnectAction();
    final ExecuteAction executionAction = new ExecuteAction();
    final ParseAction parseAction = new ParseAction();
    final StopAction stopAction = new StopAction();
    final ConnectPropertysAction connectionPropertysAction = new ConnectPropertysAction();
    final ParametersAction parametersAction = new ParametersAction();
    static final Font mainFont;

    void controlActions(FieldQuery fq) {
        if (fq == null) {
            this.parseAction.setEnabled(false);
            this.executionAction.setEnabled(false);
            this.stopAction.setEnabled(false);
            this.connectionPropertysAction.setEnabled(false);
            this.parametersAction.setEnabled(false);
            this.openAction.setEnabled(false);
            this.saveAction.setEnabled(false);
            this.saveAsAction.setEnabled(false);
            return;
        }
        if (fq.thread == null) {
            this.parseAction.setEnabled(true);
            this.executionAction.setEnabled(true);
            this.stopAction.setEnabled(false);
            this.connectionPropertysAction.setEnabled(true);
            this.parametersAction.setEnabled(true);
            this.openAction.setEnabled(true);
            this.saveAction.setEnabled(true);
            this.saveAsAction.setEnabled(true);
        } else {
            this.parseAction.setEnabled(true);
            this.executionAction.setEnabled(false);
            this.stopAction.setEnabled(true);
            this.connectionPropertysAction.setEnabled(true);
            this.parametersAction.setEnabled(true);
            this.openAction.setEnabled(true);
            this.saveAction.setEnabled(true);
            this.saveAsAction.setEnabled(true);
        }
    }

    private void saveToFile(String value, String filename) {
        try {
            FileOutputStream osr = new FileOutputStream(filename);
            osr.write(value.getBytes());
            osr.close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0444\u0430\u0439\u043b: " + e.getMessage(), "\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u043f\u0438\u0441\u0438", 0);
        }
    }

    private String readFromFile(String fileName) {
        String result = "";
        try {
            FileInputStream isr = new FileInputStream(fileName);
            int availble = isr.available();
            byte[] buf = new byte[availble];
            int i = isr.read(buf);
            result = new String(buf);
            isr.close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u0440\u043e\u0447\u0438\u0430\u0442\u044c \u0444\u0430\u0439\u043b: " + e.getMessage(), "\u041e\u0448\u0438\u0431\u043a\u0430 \u0447\u0442\u0435\u043d\u0438\u044f", 0);
        }
        return result;
    }

    void open() {
        FieldQuery fq = (FieldQuery)querys.getSelectedComponent();
        if (fq == null) {
            return;
        }
        JFileChooser cc = new JFileChooser(fq.file);
        cc.setFileSelectionMode(0);
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Query Files (*sql)", "sql");
        cc.setFileFilter(filter);
        int returnVal = cc.showDialog(null, "\u041e\u0442\u043a\u0440\u044b\u0442\u044c \u0441\u043a\u0440\u0438\u043f\u0442");
        if (returnVal == 0) {
            fq.file = cc.getSelectedFile().getAbsolutePath();
            fq.textQuery.setText(this.readFromFile(fq.file));
        }
    }

    void saveAs() {
        FieldQuery fq = (FieldQuery)querys.getSelectedComponent();
        if (fq == null) {
            return;
        }
        JFileChooser cc = new JFileChooser(fq.file);
        cc.setFileSelectionMode(0);
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Query Files (*sql)", "sql");
        cc.setFileFilter(filter);
        int returnVal = cc.showDialog(null, "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0441\u043a\u0440\u0438\u043f\u0442");
        if (returnVal == 0) {
            fq.file = cc.getSelectedFile().getAbsolutePath();
            this.saveToFile(fq.textQuery.getText(), fq.file);
        }
    }

    void save() {
        FieldQuery fq = (FieldQuery)querys.getSelectedComponent();
        if (fq == null) {
            return;
        }
        File f = new File(fq.file);
        if (f.exists()) {
            this.saveToFile(fq.textQuery.getText(), fq.file);
        } else {
            this.saveAs();
        }
    }

    private JToolBar createToolBar() {
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        JButton buttonOpen = new JButton(this.openAction);
        buttonOpen.setText("");
        toolBar.add(buttonOpen);
        JButton buttonSave = new JButton(this.saveAction);
        buttonSave.setText("");
        toolBar.add(buttonSave);
        toolBar.addSeparator();
        JButton buttonParse = new JButton(this.parseAction);
        buttonParse.setText("");
        toolBar.add(buttonParse);
        JButton buttonExecute = new JButton(this.executionAction);
        buttonExecute.setText("");
        toolBar.add(buttonExecute);
        JButton buttonStop = new JButton(this.stopAction);
        buttonStop.setText("");
        toolBar.add(buttonStop);
        JButton buttonParameters = new JButton(this.parametersAction);
        buttonParameters.setText("");
        toolBar.add(buttonParameters);
        toolBar.addSeparator();
        JButton buttonConnectionPropertys = new JButton(this.connectionPropertysAction);
        buttonConnectionPropertys.setText("");
        toolBar.add(buttonConnectionPropertys);
        return toolBar;
    }

    private JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        JMenu menuFile = new JMenu("\u0424\u0430\u0439\u043b");
        menuFile.setMnemonic(70);
        JMenu menuQuery = new JMenu("\u0417\u0430\u043f\u0440\u043e\u0441");
        menuQuery.setMnemonic(81);
        JMenuItem menuExit = new JMenuItem("Quit", 81);
        menuExit.setAccelerator(KeyStroke.getKeyStroke(81, 8));
        menuFile.add(this.connectAction);
        menuFile.addSeparator();
        menuFile.add(this.openAction);
        menuFile.add(this.saveAction);
        menuFile.add(this.saveAsAction);
        menuFile.add(menuExit);
        menuQuery.add(this.parseAction);
        menuQuery.add(this.executionAction);
        menuQuery.add(this.stopAction);
        menuQuery.add(this.parametersAction);
        menuQuery.addSeparator();
        menuQuery.add(this.connectionPropertysAction);
        menuBar.add(menuFile);
        menuBar.add(menuQuery);
        menuExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConsoleQuery1C.this.dispose();
                System.exit(0);
            }
        });
        return menuBar;
    }

    public ConsoleQuery1C() {
        this.setIconImage(SupportToolkit.getImage("images/logo.gif"));
        this.setTitle("1C-SQL Query Analyzer");
        querys = new TabQuerys(1);
        querys.addChangeListener(this);
        this.lastPropertys.put("choice", (Object)false);
        this.lastPropertys.put("port", (Object)1433);
        this.lastPropertys.put("bufferMaxMemory", (Object)1024);
        this.lastPropertys.put("bufferMinPackets", (Object)8);
        this.setJMenuBar(this.createMenuBar());
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this.createToolBar(), "North");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ConsoleQuery1C.this.dispose();
                System.exit(0);
            }
        });
        this.setPreferredSize(new Dimension(800, 600));
        this.getContentPane().add((Component)contentPane, "North");
        this.getContentPane().add((Component)querys, "Center");
    }

    public static void main(String[] args) {
        console = new ConsoleQuery1C();
        console.pack();
        console.setLocationByPlatform(true);
        console.setVisible(true);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.controlActions((FieldQuery)querys.getSelectedComponent());
    }

    static {
        mainFont = new Font("Tahoma", 0, 12);
    }

    class ParametersAction
    extends AbstractAction {
        public ParametersAction() {
            super("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b", new ImageIcon(SupportToolkit.getImage("images/propertys.gif")));
            this.putValue("ShortDescription", "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0437\u0430\u043f\u0440\u043e\u0441\u0430");
            this.putValue("MnemonicKey", 80);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(80, 2));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FieldQuery fq = (FieldQuery)querys.getSelectedComponent();
            if (fq != null) {
                FieldQuery fieldQuery = fq;
                fieldQuery.getClass();
                new FieldQuery.ParametersDialog(fieldQuery, ConsoleQuery1C.this);
            }
        }
    }

    class ParseAction
    extends AbstractAction {
        public ParseAction() {
            super("\u041f\u0430\u0440\u0441\u0438\u0442\u044c", new ImageIcon(SupportToolkit.getImage("images/parse.gif")));
            this.putValue("ShortDescription", "\u041f\u0430\u0440\u0441\u0438\u0442\u044c \u0437\u0430\u043f\u0440\u043e\u0441");
            this.putValue("MnemonicKey", 117);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(117, 2));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FieldQuery fq = (FieldQuery)querys.getSelectedComponent();
            if (fq != null) {
                fq.parseQuery();
            }
        }
    }

    class StopAction
    extends AbstractAction {
        public StopAction() {
            super("\u041e\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c", new ImageIcon(SupportToolkit.getImage("images/stop.gif")));
            this.putValue("ShortDescription", "\u041e\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0432\u044b\u043f\u043e\u043b\u0435\u043d\u0438\u0435 \u0437\u0430\u043f\u0440\u043e\u0441\u0430");
            this.putValue("MnemonicKey", 19);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(19, 8));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FieldQuery fq = (FieldQuery)querys.getSelectedComponent();
            if (fq != null) {
                fq.stopQuery();
            }
        }
    }

    class ExecuteAction
    extends AbstractAction {
        public ExecuteAction() {
            super("\u0412\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c", new ImageIcon(SupportToolkit.getImage("images/execute.gif")));
            this.putValue("ShortDescription", "\u0412\u044b\u043f\u043e\u043b\u043d\u0438\u0442\u044c \u0437\u0430\u043f\u0440\u043e\u0441");
            this.putValue("MnemonicKey", 116);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(116, 2));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FieldQuery fq = (FieldQuery)querys.getSelectedComponent();
            if (fq != null) {
                fq.executeQuery();
            }
        }
    }

    class ConnectPropertysAction
    extends AbstractAction {
        public ConnectPropertysAction() {
            super("\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f", new ImageIcon(SupportToolkit.getImage("images/connect_p.gif")));
            this.putValue("ShortDescription", "\u0422\u0435\u043a\u0443\u0449\u0438\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FieldQuery fq = (FieldQuery)querys.getSelectedComponent();
            if (fq != null) {
                PreferenceDialog pref = new PreferenceDialog();
                pref.showPreference(fq.propertys);
            }
        }
    }

    class ConnectAction
    extends AbstractAction {
        public ConnectAction() {
            super("\u041f\u043e\u0434\u043a\u043b\u044e\u0447\u0438\u0442\u044c\u0441\u044f", new ImageIcon(SupportToolkit.getImage("images/connect.gif")));
            this.putValue("ShortDescription", "\u041f\u043e\u0434\u0441\u043e\u0435\u0434\u0438\u043d\u0438\u0442\u044c\u0441\u044f \u043a \u0431\u0430\u0437\u0435");
            this.putValue("MnemonicKey", 79);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(79, 2));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PreferenceDialog pref = new PreferenceDialog();
            if (pref.showPreference(ConsoleQuery1C.this.lastPropertys) == 1) {
                ConsoleQuery1C.this.lastPropertys = pref.getPreferences();
                FieldQuery fq = querys.createFieldQuery();
                fq.setPropertys(ConsoleQuery1C.this.lastPropertys);
                fq.connect();
            }
        }
    }

    class OpenAction
    extends AbstractAction {
        public OpenAction() {
            super("\u041e\u0442\u043a\u0440\u044b\u0442\u044c", new ImageIcon(SupportToolkit.getImage("images/open.gif")));
            this.putValue("ShortDescription", "\u0417\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c SQL \u0441\u043a\u0440\u0438\u043f\u0442");
            this.putValue("MnemonicKey", 83);
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ConsoleQuery1C.this.open();
        }
    }

    class SaveAsAction
    extends AbstractAction {
        public SaveAsAction() {
            super("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u043a\u0430\u043a...", new ImageIcon(SupportToolkit.getImage("images/save_as.gif")));
            this.putValue("ShortDescription", "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0437\u0430\u043f\u0440\u043e\u0441 \u043a\u0430\u043a...");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(80, 66));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ConsoleQuery1C.this.saveAs();
        }
    }

    class SaveAction
    extends AbstractAction {
        public SaveAction() {
            super("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c", new ImageIcon(SupportToolkit.getImage("images/save.gif")));
            this.putValue("ShortDescription", "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0437\u0430\u043f\u0440\u043e\u0441");
            this.putValue("MnemonicKey", 83);
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, 2));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ConsoleQuery1C.this.save();
        }
    }
}

