/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.plaf.basic.BasicButtonUI;

public class TabQuerys
extends JTabbedPane {
    static ImageIcon[] movingGlobus = new ImageIcon[4];
    private static final MouseListener buttonMouseListener;

    public TabQuerys(int tabPlacement) {
        super(tabPlacement);
    }

    FieldQuery createFieldQuery() {
        FieldQuery fq = new FieldQuery();
        this.addTab(null, fq);
        int i = this.indexOfComponent(fq);
        ButtonTabComponent tab = new ButtonTabComponent();
        this.setTabComponentAt(i, tab);
        fq.tab = tab;
        return fq;
    }

    static {
        for (int i = 0; i < movingGlobus.length; ++i) {
            String nm = "images/run" + (i + 1) + ".gif";
            TabQuerys.movingGlobus[i] = new ImageIcon(SupportToolkit.getImage(nm));
        }
        buttonMouseListener = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                Component component = e.getComponent();
                if (component instanceof AbstractButton) {
                    AbstractButton button = (AbstractButton)component;
                    button.setBorderPainted(true);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                Component component = e.getComponent();
                if (component instanceof AbstractButton) {
                    AbstractButton button = (AbstractButton)component;
                    button.setBorderPainted(false);
                }
            }
        };
    }

    class ButtonTabComponent
    extends JPanel {
        private static final long serialVersionUID = 1104624952887217785L;
        private JLabel label;
        private TabButton button;
        boolean isRunning = false;
        String name;

        public ButtonTabComponent() {
            this.setOpaque(false);
            this.label = new JLabel();
            this.label.setIcon(new ImageIcon(SupportToolkit.getImage("images/table.gif")));
            this.label.setFont(ConsoleQuery1C.mainFont);
            this.add(this.label);
            this.label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
            this.button = new TabButton();
            this.add(this.button);
            this.setPreferredSize(new Dimension(110, 24));
        }

        public void setRunningState() {
            this.setRunningState(this.name);
        }

        public void setRunningState(String text) {
            this.isRunning = true;
            this.label.setText(text);
            Thread motionGlobus = new Thread(new MotionGlobus());
            motionGlobus.start();
        }

        class MotionGlobus
        extends Thread {
            private int count = 0;
            private int sleep = 300;

            MotionGlobus() {
            }

            @Override
            public void run() {
                while (ButtonTabComponent.this.isRunning) {
                    ButtonTabComponent.this.label.setIcon(movingGlobus[this.count++]);
                    if (this.count == movingGlobus.length) {
                        this.count = 0;
                    }
                    try {
                        MotionGlobus.sleep(this.sleep);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                ButtonTabComponent.this.label.setText(ButtonTabComponent.this.name);
                ButtonTabComponent.this.label.setIcon(new ImageIcon(SupportToolkit.getImage("images/table.gif")));
            }
        }

        private class TabButton
        extends JButton {
            private static final long serialVersionUID = -5885796662214383635L;

            public TabButton() {
                int size = 17;
                this.setPreferredSize(new Dimension(size, size));
                this.setToolTipText("close this tab");
                this.setUI(new BasicButtonUI());
                this.setContentAreaFilled(false);
                this.setFocusable(false);
                this.setBorder(BorderFactory.createEtchedBorder(0));
                this.setBorderPainted(false);
                this.addMouseListener(buttonMouseListener);
                this.setRolloverEnabled(true);
                this.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int i = TabQuerys.this.indexOfTabComponent(ButtonTabComponent.this);
                        if (i != -1) {
                            TabQuerys.this.remove(i);
                        }
                    }
                });
            }

            @Override
            public void updateUI() {
            }

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                Graphics2D g2 = (Graphics2D)g.create();
                if (this.getModel().isPressed()) {
                    g2.translate(1, 1);
                }
                g2.setStroke(new BasicStroke(2.0f));
                g2.setColor(Color.BLACK);
                if (this.getModel().isRollover()) {
                    g2.setColor(Color.WHITE);
                }
                int delta = 6;
                g2.drawLine(delta, delta, this.getWidth() - delta - 1, this.getHeight() - delta - 1);
                g2.drawLine(this.getWidth() - delta - 1, delta, delta, this.getHeight() - delta - 1);
                g2.dispose();
            }
        }
    }
}

