/*
 * Decompiled with CFR 0.152.
 */
package j1c.ru;

import j1c.ru.Compound;
import j1c.ru.ExceptionAPI;
import j1c.ru.ExceptionAdapter;
import j1c.ru.Token;
import j1c.ru.V7;
import java.io.File;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public final class Metadatas {
    V7 v7;
    final char ALGORITHM = (char)65;
    final char CALENDAR = (char)67;
    final char CATALOG = (char)66;
    final char DATE = (char)68;
    final char NUMERIC = (char)78;
    final char UNDEFINE = (char)85;
    final char DOCUMENT = (char)79;
    final char ENUMERATION = (char)69;
    final char PLAN = (char)84;
    final char PLANS = (char)80;
    final char STRING = (char)83;
    final char SUBCONTO_KIND = (char)75;
    private int lenghtSubconto = 0;
    int maxLengthAccountName;
    int maxLengthAccountCode;
    int maxSubconto;
    int lengthOperContent;
    int lengthOperSum;
    int precisionOper;
    int modeCalculatingOperSum;
    boolean isChoiceModeCalculatingOperSum;
    boolean isOnlyAnaliticalByNumericalAccounting;
    Plan mainPlan;
    Catalog currencyCatalog;
    Property currencyCourse;
    Property currencyFactor;
    Reference separatingAccouting;
    ArrayList<AccountProperty> accountsPropertys = new ArrayList();
    final ArrayList<EntryProperty> entryPropertys = new ArrayList();
    final ArrayList<EntryProperty> entryHardPropertys = new ArrayList();
    final ArrayList<EntryProperty> operPropertys = new ArrayList();
    ArrayList<GrafSelect> grafSelects = new ArrayList();
    static final HashMap<String, Class<?>> MAPTYPES = new HashMap();
    ArrayList<Reference> types = new ArrayList();
    Token root;

    static {
        MAPTYPES.put("\u041f\u0435\u0440\u0435\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u0435", Enumeration.class);
        MAPTYPES.put("\u041f\u0435\u0440\u0435\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u0435.\u0420\u0435\u043a\u0432\u0438\u0437\u0438\u0442", Reference.class);
        MAPTYPES.put("\u0421\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a", Catalog.class);
        MAPTYPES.put("\u0421\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a.\u0420\u0435\u043a\u0432\u0438\u0437\u0438\u0442", Property.class);
        MAPTYPES.put("\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442", Document.class);
        MAPTYPES.put("\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442.\u0420\u0435\u043a\u0432\u0438\u0437\u0438\u0442\u0428\u0430\u043f\u043a\u0438", Qualifier.class);
        MAPTYPES.put("\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442.\u0420\u0435\u043a\u0432\u0438\u0437\u0438\u0442\u0422\u0430\u0431\u043b\u0438\u0447\u043d\u043e\u0439\u0427\u0430\u0441\u0442\u0438", TableProperty.class);
        MAPTYPES.put("\u041e\u0431\u0449\u0438\u0439\u0420\u0435\u043a\u0432\u0438\u0437\u0438\u0442", Qualifier.class);
        MAPTYPES.put("\u0420\u0435\u0433\u0438\u0441\u0442\u0440", Register.class);
        MAPTYPES.put("\u0420\u0435\u0433\u0438\u0441\u0442\u0440.\u0418\u0437\u043c\u0435\u0440\u0435\u043d\u0438\u0435", Dimension.class);
        MAPTYPES.put("\u0420\u0435\u0433\u0438\u0441\u0442\u0440.\u0420\u0435\u0441\u0443\u0440\u0441", Qualifier.class);
        MAPTYPES.put("\u0420\u0435\u0433\u0438\u0441\u0442\u0440.\u0420\u0435\u043a\u0432\u0438\u0437\u0438\u0442", Qualifier.class);
        MAPTYPES.put("\u041f\u043e\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c", Stream.class);
        MAPTYPES.put("\u041f\u043b\u0430\u043d\u0421\u0447\u0435\u0442\u043e\u0432", Plan.class);
        MAPTYPES.put("\u0412\u0438\u0434\u0421\u0443\u0431\u043a\u043e\u043d\u0442\u043e", SubcontoKind.class);
        MAPTYPES.put("\u0421\u0443\u0431\u043a\u043e\u043d\u0442\u043e", Subconto.class);
    }

    public Metadatas() {
        new Row();
        new Numeric();
        new Date();
        new Undefine();
        new Catalog();
        new Enumeration();
        new Document();
        new SubcontoKind();
        new Calendar();
        new Plan();
        new Plans();
        new Algorithm();
    }

    public List<GrafSelect> getGrafSelects() {
        return Collections.unmodifiableList(this.grafSelects);
    }

    public Catalog getCurrencyCatalog() {
        return this.currencyCatalog;
    }

    public Property getCurrencyCourse() {
        return this.currencyCourse;
    }

    public Property getCurrencyFactor() {
        return this.currencyFactor;
    }

    public List<AccountProperty> getAccountsPropertys() {
        return Collections.unmodifiableList(this.accountsPropertys);
    }

    public List<EntryProperty> getEntryPropertys() {
        return Collections.unmodifiableList(this.entryPropertys);
    }

    public List<EntryProperty> getHardPropertys() {
        return Collections.unmodifiableList(this.entryPropertys);
    }

    public EntryProperty getEntryProperty(String name) {
        for (EntryProperty property : this.getEntryPropertys()) {
            if (!property.name.equalsIgnoreCase(name)) continue;
            return property;
        }
        return null;
    }

    public List<EntryProperty> getOperPropertys() {
        return Collections.unmodifiableList(this.operPropertys);
    }

    public EntryProperty getOperProperty(String name) {
        for (EntryProperty property : this.getOperPropertys()) {
            if (!property.name.equalsIgnoreCase(name)) continue;
            return property;
        }
        return null;
    }

    private Property createProperty(String locator, Token token) {
        Property property = (Property)this.getType(token.getTokens().get(0).getInteger());
        if (property == null) {
            property = new Property(locator, token);
        }
        return property;
    }

    private CommonProperty createCommonProperty(Token token) {
        CommonProperty property = (CommonProperty)this.getType(token.getTokens().get(0).getInteger());
        if (property == null) {
            property = new CommonProperty(token);
        }
        return property;
    }

    private Figure createFigure(String locator, Token token) {
        Figure property = (Figure)this.getType(token.getTokens().get(0).getInteger());
        if (property == null) {
            property = new Figure(locator, token);
        }
        return property;
    }

    private Field createFieled(String locator, Token token) {
        Field property = (Field)this.getType(token.getTokens().get(0).getInteger());
        if (property == null) {
            property = new Field(locator, token);
        }
        return property;
    }

    private HeadProperty createHeadProperty(String locator, Token token) {
        HeadProperty property = (HeadProperty)this.getType(token.getTokens().get(0).getInteger());
        if (property == null) {
            property = new HeadProperty(locator, token);
        }
        return property;
    }

    private Dimension createDimension(String locator, Token token) {
        Dimension property = (Dimension)this.getType(token.getTokens().get(0).getInteger());
        if (property == null) {
            property = new Dimension(locator, token);
        }
        return property;
    }

    private EntryProperty createEntryProperty(Token token) {
        EntryProperty property = (EntryProperty)this.getType(token.getTokens().get(0).getInteger());
        if (property == null) {
            property = new EntryProperty(token);
        }
        return property;
    }

    private Constanta createConstanta(Token token) {
        Constanta property = (Constanta)this.getType(token.getTokens().get(0).getInteger());
        if (property == null) {
            property = new Constanta(token);
        }
        return property;
    }

    private AccountProperty createAccountProperty(Token token) {
        AccountProperty property = (AccountProperty)this.getType(token.getTokens().get(0).getInteger());
        if (property == null) {
            property = new AccountProperty(token);
        }
        return property;
    }

    private Calendar createCalendar(Token token) {
        Calendar property = (Calendar)this.getType(token.getTokens().get(0).getInteger());
        if (property == null) {
            property = new Calendar(token);
        }
        return property;
    }

    private GrafSelect createGrafSelect(Token token) {
        GrafSelect property = (GrafSelect)this.getType(token.getTokens().get(0).getInteger());
        if (property == null) {
            property = new GrafSelect(token);
        }
        return property;
    }

    private GroupAlgorithms createGroup(Token token) {
        GroupAlgorithms property = (GroupAlgorithms)this.getType(token.getTokens().get(0).getInteger());
        if (property == null) {
            property = new GroupAlgorithms(token);
        }
        return property;
    }

    private Algorithm createAlgorithm(Token token) {
        Algorithm property = (Algorithm)this.getType(token.getTokens().get(0).getInteger());
        if (property == null) {
            property = new Algorithm(token);
        }
        return property;
    }

    private AccountValue createAccount(Token token, Plan plan) {
        AccountValue property = (AccountValue)this.getType(token.getTokens().get(0).getInteger());
        if (property == null) {
            property = new AccountValue(token, plan);
        }
        return property;
    }

    private SubcontoKind createSubcontoKind(Token token) {
        SubcontoKind property = (SubcontoKind)this.getType(token.getTokens().get(0).getInteger());
        if (property == null) {
            property = new SubcontoKind(token);
        }
        return property;
    }

    private Plan createPlan(Token token) {
        Plan property = (Plan)this.getType('T', token.getTokens().get(0).getInteger());
        if (property == null) {
            property = new Plan(token);
        }
        return property;
    }

    private Stream createStream(Token token) {
        Stream property = (Stream)this.getType(token.getTokens().get(0).getInteger());
        if (property == null) {
            property = new Stream(token);
        }
        return property;
    }

    private Register createRegisters(Token token) {
        Register property = (Register)this.getType(token.getTokens().get(0).getInteger());
        if (property == null) {
            property = new Register(token);
        }
        return property;
    }

    private Catalog createCatalog(Token token) {
        Catalog property = (Catalog)this.getType('B', token.getTokens().get(0).getInteger());
        if (property == null) {
            property = new Catalog(token);
        }
        return property;
    }

    private Document createDocument(Token token) {
        Document property = (Document)this.getType('O', token.getTokens().get(0).getInteger());
        if (property == null) {
            property = new Document(token);
        }
        return property;
    }

    private TableProperty createTableProperty(String locator, Token token) {
        TableProperty property = (TableProperty)this.getType(token.getTokens().get(0).getInteger());
        if (property == null) {
            property = new TableProperty(locator, token);
        }
        return property;
    }

    private Enumeration createEnumeration(Token token) {
        Enumeration property = (Enumeration)this.getType('E', token.getTokens().get(0).getInteger());
        if (property == null) {
            property = new Enumeration(token);
        }
        return property;
    }

    private EnumerationValue createEnumerationValue(String locator, Token token) {
        EnumerationValue property = (EnumerationValue)this.getType(token.getTokens().get(0).getInteger());
        if (property == null) {
            property = new EnumerationValue(locator, token);
        }
        return property;
    }

    private <T extends Reference> T createObject(char type1c, int id) {
        Reference ref;
        T type = this.getType(type1c, id);
        if (type != null) {
            return type;
        }
        if (type1c == 'B') {
            Token token = this.root.getById("SbCnts");
            ref = new Catalog(token.getById(String.valueOf(id)));
        } else if (type1c == 'E') {
            Token token = this.root.getById("EnumList");
            ref = new Enumeration(token.getById(String.valueOf(id)));
        } else if (type1c == 'O') {
            Token token = this.root.getById("Documents");
            ref = new Document(token.getById(String.valueOf(id)));
        } else if (type1c == 'T') {
            Token token = this.root.getById("Plans");
            ref = new Plan(token.getById(String.valueOf(id)));
        } else if (type1c == 'K') {
            Token token = this.root.getById("SbKind");
            ref = new SubcontoKind(token.getById(String.valueOf(id)));
        } else if (type1c == 'A') {
            Token token = this.root.getById("Algorithms");
            ref = new Algorithm(token.getById(String.valueOf(id)));
        } else {
            throw new ExceptionAPI("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0442\u0438\u043f \u043c\u0435\u0442\u0430\u0434\u0430\u043d\u043d\u044b\u0445 '" + type1c + "'");
        }
        return (T)ref;
    }

    public Plan getMainPlan() {
        return this.mainPlan;
    }

    private void parseBuh() {
        Token buh = this.root.getById("Buh");
        List<Token> tokens = buh.getChilds();
        if (tokens.size() > 0) {
            List<Token> tPatarms = tokens.get(0).getTokens();
            this.maxLengthAccountName = tPatarms.get(7).getInteger();
            this.maxLengthAccountCode = tPatarms.get(8).getInteger();
            this.maxSubconto = tPatarms.get(9).getInteger();
            this.lengthOperContent = tPatarms.get(10).getInteger();
            this.lengthOperSum = tPatarms.get(11).getInteger();
            this.precisionOper = tPatarms.get(12).getInteger();
            this.currencyCatalog = (Catalog)this.getType(tPatarms.get(23).getInteger());
            this.currencyCourse = (Property)this.getType(tPatarms.get(24).getInteger());
            this.modeCalculatingOperSum = tPatarms.get(28).getInteger();
            this.currencyFactor = (Property)this.getType(tPatarms.get(39).getInteger());
            this.isChoiceModeCalculatingOperSum = tPatarms.get(41).getBoolean();
            this.isOnlyAnaliticalByNumericalAccounting = tPatarms.get(45).getBoolean();
            this.separatingAccouting = this.getType(tPatarms.get(46).getInteger());
            this.mainPlan = (Plan)this.getType('T', tPatarms.get(47).getInteger());
            Iterator<Token> i = buh.getById("ProvHardFldDef").getChilds().iterator();
            while (i.hasNext()) {
                this.entryHardPropertys.add(this.createEntryProperty(i.next()));
            }
            i = buh.getById("ProvParams").getChilds().iterator();
            while (i.hasNext()) {
                this.entryPropertys.add(this.createEntryProperty(i.next()));
            }
            i = buh.getById("OperParams").getChilds().iterator();
            while (i.hasNext()) {
                this.operPropertys.add(this.createEntryProperty(i.next()));
            }
        }
    }

    public int getMaxLengthAccountName() {
        return this.maxLengthAccountName;
    }

    public int getMaxLengthAccountCode() {
        return this.maxLengthAccountCode;
    }

    public int getMaxSubconto() {
        return this.maxSubconto;
    }

    public int getLenghtSubconto() {
        return this.lenghtSubconto;
    }

    public int getLengthOperContent() {
        return this.lengthOperContent;
    }

    public int getLengthOperSum() {
        return this.lengthOperSum;
    }

    public int getPrecisionOper() {
        return this.precisionOper;
    }

    public int getModeCalculatingOperSum() {
        return this.modeCalculatingOperSum;
    }

    public boolean isChoiceModeCalculatingOperSum() {
        return this.isChoiceModeCalculatingOperSum;
    }

    public boolean isOnlyAnaliticalByNumericalAccounting() {
        return this.isOnlyAnaliticalByNumericalAccounting;
    }

    public Reference getSeparatingAccouting() {
        return this.separatingAccouting;
    }

    private void parseGrafSelects() {
        Iterator<Token> i = this.root.getById("DocSelRefObj").getChilds().iterator();
        while (i.hasNext()) {
            this.grafSelects.add(this.createGrafSelect(i.next()));
        }
    }

    private void parseGroupAlgorithms() {
        Iterator<Token> i = this.root.getById("Groups").getChilds().iterator();
        while (i.hasNext()) {
            this.createGroup(i.next());
        }
    }

    private void parseAlgorithms() {
        Iterator<Token> i = this.root.getById("Algorithms").getChilds().iterator();
        while (i.hasNext()) {
            this.createAlgorithm(i.next());
        }
    }

    private void parseConstantas() {
        Iterator<Token> i = this.root.getById("Consts").getChilds().iterator();
        while (i.hasNext()) {
            this.createConstanta(i.next());
        }
    }

    private void parseCalendars() {
        for (Token token : this.root.getById("Calendars").getChilds()) {
            if (token.getTokens().get(0).getString().equalsIgnoreCase("HolidaysDef")) continue;
            this.createCalendar(token);
        }
    }

    private void parseAccountPropertys() {
        Iterator<Token> i = this.root.getById("AccParams").getChilds().iterator();
        while (i.hasNext()) {
            this.accountsPropertys.add(this.createAccountProperty(i.next()));
        }
    }

    private void parseSubcontoKind() {
        Iterator<Token> i = this.root.getById("SbKind").getChilds().iterator();
        while (i.hasNext()) {
            SubcontoKind property = this.createSubcontoKind(i.next());
            int len = 0;
            len = property.type.getId() == 0 ? 13 : (property.type instanceof Row || property.type instanceof Numeric ? property.length : (property.type instanceof Undefine ? 23 : 9));
            if (this.lenghtSubconto >= len) continue;
            this.lenghtSubconto = len;
        }
    }

    private void parsePlan() {
        Iterator<Token> i = this.root.getById("Plans").getChilds().iterator();
        while (i.hasNext()) {
            this.createPlan(i.next());
        }
    }

    private void parseStreams() {
        Iterator<Token> i = this.root.getById("Document Streams").getChilds().iterator();
        while (i.hasNext()) {
            this.createStream(i.next());
        }
    }

    private void parseRegisters() {
        Iterator<Token> i = this.root.getById("Registers").getChilds().iterator();
        while (i.hasNext()) {
            this.createRegisters(i.next());
        }
    }

    private void parseCatalog() {
        Iterator<Token> i = this.root.getById("SbCnts").getChilds().iterator();
        while (i.hasNext()) {
            this.createCatalog(i.next());
        }
    }

    private void parseEnumeration() {
        Iterator<Token> i = this.root.getById("EnumList").getChilds().iterator();
        while (i.hasNext()) {
            this.createEnumeration(i.next());
        }
    }

    private void parseDocument() {
        Iterator<Token> i = this.root.getById("Documents").getChilds().iterator();
        while (i.hasNext()) {
            this.createDocument(i.next());
        }
    }

    private void parseCommonProperty() {
        Iterator<Token> i = this.root.getById("GenJrnlFldDef").getChilds().iterator();
        while (i.hasNext()) {
            this.createCommonProperty(i.next());
        }
    }

    public boolean open(String fileName) {
        Compound compound = new Compound();
        if (compound.read(new File(fileName))) {
            String stream = compound.getNode("/Metadata/Main MetaData Stream").getStream();
            this.root = Token.getInstance(stream.toCharArray());
            this.parseCatalog();
            this.parseEnumeration();
            this.parseDocument();
            this.parseCommonProperty();
            this.parseSubcontoKind();
            this.parsePlan();
            this.parseRegisters();
            this.parseStreams();
            this.parseAccountPropertys();
            this.parseBuh();
            this.parseCalendars();
            this.parseAlgorithms();
            this.parseGroupAlgorithms();
            this.parseConstantas();
            this.parseGrafSelects();
            return true;
        }
        return false;
    }

    public <T extends Reference> List<T> selectTypes(String typeName) {
        ArrayList<Reference> result = new ArrayList<Reference>();
        String[] parts = typeName.toUpperCase().split("\\.");
        for (Reference type : this.types) {
            String[] match;
            if (type.locator == null || parts.length != (match = type.locator.toUpperCase().split("\\.")).length) continue;
            boolean equal = true;
            int j = 0;
            while (j < parts.length) {
                if (!parts[j].equals(match[j]) && !parts[j].equals("*")) {
                    equal = false;
                    break;
                }
                ++j;
            }
            if (!equal) continue;
            result.add(type);
        }
        return Collections.unmodifiableList(result);
    }

    public Plan getPlanAccount(String name) {
        List sample = this.selectTypes("\u041f\u043b\u0430\u043d\u0421\u0447\u0435\u0442\u043e\u0432");
        for (Plan value : sample) {
            if (!value.getName().equalsIgnoreCase(name)) continue;
            return value;
        }
        return null;
    }

    public CommonProperty getCommonProperty(String name) {
        List sample = this.selectTypes("\u041e\u0431\u0449\u0438\u0439\u0420\u0435\u043a\u0432\u0438\u0437\u0438\u0442.*");
        for (CommonProperty value : sample) {
            if (!value.getName().equalsIgnoreCase(name)) continue;
            return value;
        }
        return null;
    }

    public Enumeration getEnumeration(String name) {
        List sample = this.selectTypes("\u041f\u0435\u0440\u0435\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u0435");
        for (Enumeration value : sample) {
            if (!value.getName().equalsIgnoreCase(name)) continue;
            return value;
        }
        return null;
    }

    public Catalog getCatalog(String name) {
        List sample = this.selectTypes("\u0421\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a.*");
        for (Catalog value : sample) {
            if (!value.getName().equalsIgnoreCase(name)) continue;
            return value;
        }
        return null;
    }

    public Document getDocument(String name) {
        List sample = this.selectTypes("\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442.*");
        for (Document value : sample) {
            if (!value.getName().equalsIgnoreCase(name)) continue;
            return value;
        }
        return null;
    }

    public Register getRegister(String name) {
        List sample = this.selectTypes("\u0420\u0435\u0433\u0438\u0441\u0442\u0440");
        for (Register value : sample) {
            if (!value.getName().equalsIgnoreCase(name)) continue;
            return value;
        }
        return null;
    }

    <T extends Reference> T getType(int id) {
        if (id == 0) {
            return null;
        }
        for (Reference ref : this.types) {
            if (ref.getId() != id) continue;
            return (T)ref;
        }
        return null;
    }

    <T extends Reference> T getType(char symbol, int id) {
        if (symbol == '\u0000' && id == 0) {
            throw new ExceptionAPI("\u0423\u043f\u0441... - \u0437\u0430\u0434\u0430\u043d \u043d\u0443\u043b\u0435\u0432\u043e\u0439 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0430\u043a\u0442\u043e\u0440 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \u0438 \u043d\u0435 \u0437\u0430\u0434\u0430\u043d \u0441\u0438\u043c\u0432\u043e\u043b \u0442\u0438\u043f\u0430.");
        }
        for (Reference ref : this.types) {
            if (ref.getId() != id || ref.symbol() != symbol) continue;
            return (T)ref;
        }
        return null;
    }

    public final class AccountProperty
    extends Qualifier {
        final boolean isPeriodical;

        public AccountProperty(Token token) {
            super("\u0420\u0435\u043a\u0432\u0438\u0437\u0438\u0442\u0421\u0447\u0435\u0442\u0430", token);
            List<Token> tokens = token.getTokens();
            this.isPeriodical = tokens.get(11).getBoolean();
        }

        @Override
        public boolean isPeriodical() {
            return this.isPeriodical;
        }

        @Override
        <T> T NullValue() {
            return (T)new V7.NullAccountReference(Metadatas.this.v7);
        }
    }

    public final class AccountValue
    extends Reference {
        final Plan plan;
        final String code;
        final boolean isCurrency;
        final boolean isNumerical;
        final boolean isOutBalance;
        final boolean isSubAccounts;
        final int activity;
        private final ArrayList<Subconto> subcontos;

        public List<Subconto> getSubcontos() {
            return Collections.unmodifiableList(this.subcontos);
        }

        AccountValue(Token token, Plan plan) {
            super("\u0421\u0447\u0435\u0442", token);
            this.subcontos = new ArrayList();
            List<Token> tokens = token.getTokens();
            this.code = tokens.get(4).getString();
            this.isCurrency = tokens.get(5).getBoolean();
            this.isNumerical = tokens.get(6).getBoolean();
            this.isOutBalance = tokens.get(7).getBoolean();
            this.isSubAccounts = tokens.get(8).getBoolean();
            this.activity = tokens.get(9).getInteger();
            this.plan = plan;
            Token tSubcontos = token.getById("AccSbCnts");
            Iterator<Token> i = tSubcontos.getChilds().iterator();
            while (i.hasNext()) {
                this.subcontos.add(new Subconto(i.next()));
            }
        }

        public boolean isCurrency() {
            return this.isCurrency;
        }

        public boolean isNumerical() {
            return this.isNumerical;
        }

        public boolean isOutBalance() {
            return this.isOutBalance;
        }

        public boolean isSubAccounts() {
            return this.isSubAccounts;
        }

        public int getActivity() {
            return this.activity;
        }

        public String getCode() {
            return this.code;
        }

        @Override
        public String toString() {
            return this.getCode();
        }

        @Override
        char symbol() {
            return '\u0000';
        }

        @Override
        <T> T fromInnerValue(V7.ResultSet result) {
            return null;
        }

        @Override
        <T> T NullValue() {
            return null;
        }
    }

    public final class Algorithm
    extends Reference {
        final int priority;
        final ArrayList<Algorithm> displaces;
        final ArrayList<GroupAlgorithms> groups;

        Algorithm() {
            super("\u0412\u0438\u0434\u0420\u0430\u0441\u0447\u0435\u0442\u0430", 0, "", "", "");
            this.displaces = new ArrayList();
            this.groups = new ArrayList();
            this.priority = 0;
        }

        Algorithm(Token token) {
            super("\u0412\u0438\u0434\u0420\u0430\u0441\u0447\u0435\u0442\u0430", token);
            this.displaces = new ArrayList();
            this.groups = new ArrayList();
            List<Token> tokens = token.getTokens();
            this.priority = tokens.get(4).getInteger();
            List<Token> tDisplaces = tokens.get(7).getTokens().get(4).getChilds();
            for (Token tAlg : tDisplaces) {
                Algorithm algorithm = (Algorithm)Metadatas.this.getType(tAlg.getTokens().get(0).getInteger());
                if (algorithm == null) {
                    algorithm = new Algorithm(Metadatas.this.root.getById(tAlg.getTokens().get(0).getString()));
                }
                this.displaces.add(algorithm);
            }
            List<Token> tGroups = token.getById("InGroups").getChilds();
            for (Token tGroup : tGroups) {
                GroupAlgorithms group = (GroupAlgorithms)Metadatas.this.getType(tGroup.getInteger());
                if (group == null) {
                    group = new GroupAlgorithms(Metadatas.this.root.getById(tGroup.getString()));
                }
                this.groups.add(group);
            }
        }

        public int getPriority() {
            return this.priority;
        }

        public List<Algorithm> getDisplaces() {
            return Collections.unmodifiableList(this.displaces);
        }

        public ArrayList<GroupAlgorithms> getGroups() {
            return this.groups;
        }

        @Override
        char symbol() {
            return 'A';
        }

        @Override
        public String toString() {
            if (this.getId() == 0) {
                return "\u0412\u0438\u0434\u0420\u0430\u0441\u0447\u0435\u0442\u0430";
            }
            return "\u0412\u0438\u0434\u0420\u0430\u0441\u0447\u0435\u0442\u0430." + this.getName();
        }

        @Override
        <T> T fromInnerValue(V7.ResultSet result) {
            String value = result.getString();
            String idPart = value.substring(4, 13);
            if (idPart.equals("     0   ")) {
                return (T)new V7.NullAlgorithmReference(Metadatas.this.v7);
            }
            V7 v7 = Metadatas.this.v7;
            v7.getClass();
            return (T)new V7.AlgorithmReference(v7, Integer.valueOf(idPart.trim(), 36));
        }

        @Override
        String toInnerValue(Object obj) {
            V7.AlgorithmReference alg = (V7.AlgorithmReference)obj;
            return String.valueOf(alg.getVidId()) + alg.getId();
        }

        @Override
        <T> T NullValue() {
            return (T)new V7.NullAlgorithmReference(Metadatas.this.v7);
        }
    }

    public final class Calendar
    extends Reference
    implements Distribution {
        final int startDay;
        final ArrayList<Integer> lengthDays;
        final DistributionRule rule;

        public int getStartDay() {
            return this.startDay;
        }

        public List<Integer> getLengthDays() {
            return Collections.unmodifiableList(this.lengthDays);
        }

        Calendar() {
            super(null, 0, "", "", "");
            this.lengthDays = new ArrayList();
            this.startDay = 0;
            this.rule = null;
        }

        Calendar(Token token) {
            super("\u041a\u0430\u043b\u0435\u043d\u0434\u0430\u0440\u044c", token);
            this.lengthDays = new ArrayList();
            List<Token> list = token.getTokens();
            this.startDay = list.get(4).getInteger();
            Token tDays = token.getById("Days");
            Iterator<Token> i = tDays.getChilds().iterator();
            while (i.hasNext()) {
                this.lengthDays.add(i.next().getInteger());
            }
            this.rule = new DistributionRule(token.getById("Distribution ruler"));
        }

        @Override
        char symbol() {
            return 'C';
        }

        @Override
        public String toString() {
            return this.getName();
        }

        @Override
        public DistributionRule getRule() {
            return this.rule;
        }

        @Override
        <T> T fromInnerValue(V7.ResultSet result) {
            String value = result.getString();
            String idPart = value.substring(4, 13);
            if (idPart.equals("     0   ")) {
                return (T)new V7.NullCalendarReference(Metadatas.this.v7);
            }
            V7 v7 = Metadatas.this.v7;
            v7.getClass();
            return (T)new V7.CalendarReference(v7, Integer.valueOf(idPart.trim(), 36));
        }

        @Override
        String toInnerValue(Object obj) {
            V7.CalendarReference cal = (V7.CalendarReference)obj;
            return String.valueOf(cal.getVidId()) + cal.getId();
        }

        @Override
        <T> T NullValue() {
            return (T)new V7.NullCalendarReference(Metadatas.this.v7);
        }
    }

    public final class Catalog
    extends Reference
    implements Distribution {
        final int lengthCode;
        final int lengthName;
        final int countLevel;
        final int presentation;
        final Catalog owner;
        final ArrayList<Property> propertys;
        final DistributionRule rule;

        Catalog() {
            super(null, 0, "", "", "");
            this.propertys = new ArrayList();
            this.lengthCode = 0;
            this.lengthName = 0;
            this.countLevel = 0;
            this.presentation = 0;
            this.owner = null;
            this.rule = null;
        }

        Catalog(Token token) {
            super("\u0421\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a", token);
            this.propertys = new ArrayList();
            List<Token> tokens = token.getTokens();
            this.owner = tokens.get(4).getInteger() != 0 ? (Catalog)Metadatas.this.createObject('B', tokens.get(4).getInteger()) : null;
            this.lengthCode = tokens.get(5).getInteger();
            this.lengthName = tokens.get(9).getInteger();
            this.presentation = tokens.get(10).getInteger();
            this.countLevel = tokens.get(12).getInteger();
            Token tParams = token.getById("Params");
            Iterator<Token> i = tParams.getChilds().iterator();
            while (i.hasNext()) {
                this.propertys.add(Metadatas.this.createProperty(this.locator, i.next()));
            }
            this.rule = new DistributionRule(token.getById("Distribution ruler"));
        }

        public Catalog getOwner() {
            return this.owner;
        }

        public int getPresentation() {
            return this.getId() != 0 ? this.presentation : -1;
        }

        @Override
        public String toString() {
            if (this.getId() == 0) {
                return "\u0421\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a";
            }
            return "\u0421\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a." + this.getName();
        }

        public int getLengthCode() {
            return this.lengthCode;
        }

        public int getLengthName() {
            return this.lengthName;
        }

        public int getCountLevel() {
            return this.countLevel;
        }

        public List<Property> getPropertys() {
            return Collections.unmodifiableList(this.propertys);
        }

        public List<Property> getNonPeriodicalPropertys() {
            ArrayList<Property> result = new ArrayList<Property>();
            for (Property property : this.propertys) {
                if (property.isPeriodical()) continue;
                result.add(property);
            }
            return Collections.unmodifiableList(result);
        }

        public List<Property> getPeriodicalPropertys() {
            ArrayList<Property> result = new ArrayList<Property>();
            for (Property property : this.propertys) {
                if (!property.isPeriodical()) continue;
                result.add(property);
            }
            return Collections.unmodifiableList(result);
        }

        public Property getProperty(int index) {
            return this.propertys.get(index);
        }

        Property getPropertyById(int id) {
            for (Property property : this.propertys) {
                if (property.getId() != id) continue;
                return property;
            }
            return null;
        }

        public Property getProperty(String name) {
            Property property2 = null;
            for (Property property2 : this.propertys) {
                if (!property2.getName().equalsIgnoreCase(name)) continue;
                return property2;
            }
            return null;
        }

        @Override
        char symbol() {
            return 'B';
        }

        @Override
        public DistributionRule getRule() {
            return this.rule;
        }

        @Override
        <T> T fromInnerValue(V7.ResultSet result) {
            String value = result.getString();
            if (this.id == 0) {
                String vidPart = value.substring(0, 4);
                String idPart = value.substring(4, 13);
                Object type = Metadatas.this.getType(this.symbol(), Integer.valueOf(vidPart.trim(), 36));
                if (idPart.equals("     0   ")) {
                    V7 v7 = Metadatas.this.v7;
                    v7.getClass();
                    return (T)new V7.NullCatalogReference(v7, this);
                }
                V7 v7 = Metadatas.this.v7;
                v7.getClass();
                return (T)new V7.CatalogReference(v7, idPart, (Reference)type);
            }
            String idPart = value.substring(0, 9);
            if (idPart.equals("     0   ")) {
                V7 v7 = Metadatas.this.v7;
                v7.getClass();
                return (T)new V7.NullCatalogReference(v7, this);
            }
            V7 v7 = Metadatas.this.v7;
            v7.getClass();
            return (T)new V7.CatalogReference(v7, idPart, this);
        }

        @Override
        <T> T NullValue() {
            V7 v7 = Metadatas.this.v7;
            v7.getClass();
            return (T)new V7.NullCatalogReference(v7, this);
        }
    }

    public final class CommonProperty
    extends Qualifier {
        final boolean isSelection;

        public boolean isSelection() {
            return this.isSelection;
        }

        CommonProperty(Token token) {
            super("\u041e\u0431\u0449\u0438\u0439\u0420\u0435\u043a\u0432\u0438\u0437\u0438\u0442", token);
            List<Token> tokens = token.getTokens();
            this.isSelection = tokens.get(10).getBoolean();
        }

        @Override
        public boolean isPeriodical() {
            return false;
        }
    }

    public final class Constanta
    extends Qualifier
    implements Distribution {
        final boolean isPeriodical;
        final DistributionRule rule;

        public Constanta(Token token) {
            super("\u041a\u043e\u043d\u0441\u0442\u0430\u043d\u0442\u0430", token);
            List<Token> tokens = token.getTokens();
            this.isPeriodical = tokens.get(10).getBoolean();
            this.rule = new DistributionRule(token.getById("Distribution ruler"));
        }

        @Override
        public boolean isPeriodical() {
            return this.isPeriodical;
        }

        @Override
        char symbol() {
            return '\u0000';
        }

        @Override
        public DistributionRule getRule() {
            return this.rule;
        }
    }

    public final class Date
    extends Reference {
        Date() {
            super(null, 0, "\u0414\u0430\u0442\u0430", "", "");
        }

        @Override
        String toInnerValue(Object obj) {
            if (obj == null) {
                return "17530101";
            }
            return new SimpleDateFormat("yyyyMMdd").format((java.util.Date)obj);
        }

        String toInnerPeriodicValue(Object obj) {
            if (obj == null) {
                return "  .  .    ";
            }
            return new SimpleDateFormat("dd.MM.yyyy").format((java.util.Date)obj);
        }

        @Override
        char symbol() {
            return 'D';
        }

        @Override
        <T> T fromInnerValue(V7.ResultSet result) {
            Qualifier qualifier = result.getQualifier();
            if (qualifier.isPeriodical()) {
                String value = result.getString();
                if (value.equals("  .  .    ")) {
                    return (T)new java.util.Date(0L);
                }
                try {
                    return (T)new SimpleDateFormat("dd.MM.yyyy").parse(value);
                }
                catch (ParseException e) {
                    throw new ExceptionAdapter(e);
                }
            }
            return (T)result.getDate();
        }

        @Override
        <T> T NullValue() {
            return (T)new java.util.Date(0L);
        }
    }

    public final class Dimension
    extends Qualifier {
        final boolean isSelectTotals;

        public Dimension(String locator, Token token) {
            super(locator, token);
            List<Token> tokens = token.getTokens();
            this.isSelectTotals = tokens.get(10).getBoolean();
        }

        public boolean isSelectTotals() {
            return this.isSelectTotals;
        }

        @Override
        public boolean isPeriodical() {
            return false;
        }
    }

    public static interface Distribution {
        public DistributionRule getRule();
    }

    public final class DistributionRule {
        final char area;
        final String additionally;
        final boolean autoRegistration;
        final boolean isNull;

        DistributionRule(Token token) {
            if (token == null) {
                this.isNull = true;
                this.area = (char)87;
                this.additionally = "";
                this.autoRegistration = true;
            } else {
                List<Token> tokens = token.getTokens();
                this.area = tokens.get(1).getChar();
                this.additionally = tokens.get(2).getString();
                this.autoRegistration = tokens.get(3).getBoolean();
                this.isNull = false;
            }
        }

        public boolean isNull() {
            return this.isNull;
        }

        public char getArea() {
            return this.area;
        }

        public String getAdditionally() {
            return this.additionally;
        }

        public boolean isAutoRegistration() {
            return this.autoRegistration;
        }
    }

    public final class Document
    extends Reference
    implements Distribution {
        final int lengthCode;
        final int periodicalCode;
        final int typeCode;
        final int autoNumerationCode;
        final boolean uniqueCode;
        final boolean autoNumerationLine;
        final boolean autoMovements;
        final boolean operativeRecording;
        final boolean accountingRecording;
        final boolean staffRecording;
        final int createOperation;
        final boolean editActivity;
        final boolean inputOnAuthority;
        final int journal;
        final boolean permitClose;
        final DistributionRule rule;
        final ArrayList<TableProperty> detail;
        final ArrayList<Qualifier> propertys;

        public boolean isPermitClose() {
            return this.permitClose;
        }

        Document() {
            super(null, 0, "", "", "");
            this.detail = new ArrayList();
            this.propertys = new ArrayList();
            this.lengthCode = 0;
            this.periodicalCode = 0;
            this.typeCode = 0;
            this.autoNumerationCode = 0;
            this.uniqueCode = false;
            this.autoNumerationLine = false;
            this.autoMovements = false;
            this.operativeRecording = false;
            this.accountingRecording = false;
            this.staffRecording = false;
            this.createOperation = 0;
            this.editActivity = false;
            this.inputOnAuthority = false;
            this.journal = 0;
            this.permitClose = false;
            this.rule = null;
        }

        Document(Token token) {
            Qualifier property;
            super("\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442", token);
            this.detail = new ArrayList();
            this.propertys = new ArrayList();
            List<Token> tokens = token.getTokens();
            this.lengthCode = tokens.get(4).getInteger();
            this.periodicalCode = tokens.get(5).getInteger();
            this.typeCode = tokens.get(6).getInteger();
            this.autoNumerationCode = tokens.get(7).getInteger();
            this.journal = tokens.get(8).getInteger();
            this.uniqueCode = tokens.get(10).getBoolean();
            this.operativeRecording = tokens.get(12).getBoolean();
            this.staffRecording = tokens.get(13).getBoolean();
            this.accountingRecording = tokens.get(14).getBoolean();
            this.inputOnAuthority = tokens.get(16).getBoolean();
            this.createOperation = tokens.get(17).getInteger();
            this.autoNumerationLine = tokens.get(18).getBoolean();
            this.autoMovements = tokens.get(19).getBoolean();
            this.editActivity = tokens.get(20).getBoolean();
            this.permitClose = tokens.get(21).getBoolean();
            Token tParams = token.getById("Head Fields");
            Iterator<Token> i = tParams.getChilds().iterator();
            while (i.hasNext()) {
                property = Metadatas.this.createHeadProperty(this.locator, i.next());
                this.propertys.add(property);
            }
            tParams = token.getById("Table Fields");
            i = tParams.getChilds().iterator();
            while (i.hasNext()) {
                property = Metadatas.this.createTableProperty(this.locator, i.next());
                this.detail.add((TableProperty)property);
            }
            this.rule = new DistributionRule(token.getById("Distribution ruler"));
        }

        public int getJournal() {
            return this.journal;
        }

        public int getCreateOperation() {
            return this.createOperation;
        }

        public int getTypeCode() {
            return this.typeCode;
        }

        public boolean isAccountingRecording() {
            return this.accountingRecording;
        }

        public boolean isAutoDeleteMovements() {
            return this.autoMovements;
        }

        public int getAutoNumerationCode() {
            return this.autoNumerationCode;
        }

        public boolean isAutoNumerationLine() {
            return this.autoNumerationLine;
        }

        public boolean isInputOnAuthority() {
            return this.inputOnAuthority;
        }

        public boolean isOperativeRecording() {
            return this.operativeRecording;
        }

        public boolean isStaffRecording() {
            return this.staffRecording;
        }

        public boolean isEditActivity() {
            return this.editActivity;
        }

        public boolean isUniqueCode() {
            return this.uniqueCode;
        }

        public int isAutoNumerationCode() {
            return this.autoNumerationCode;
        }

        public int getLengthCode() {
            return this.lengthCode;
        }

        public int getPeriodicalCode() {
            return this.periodicalCode;
        }

        public List<TableProperty> getDetail() {
            return Collections.unmodifiableList(this.detail);
        }

        @Override
        public String toString() {
            if (this.getId() == 0) {
                return "\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442";
            }
            return "\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442." + this.getName();
        }

        public List<Qualifier> getPropertys() {
            return Collections.unmodifiableList(this.propertys);
        }

        public TableProperty getPropertyDetail(int index) {
            return this.detail.get(index);
        }

        public TableProperty getPropertyDetail(String name) {
            TableProperty property2 = null;
            for (TableProperty property2 : this.detail) {
                if (!property2.getName().equalsIgnoreCase(name)) continue;
                return property2;
            }
            return null;
        }

        public Qualifier getProperty(int index) {
            return this.propertys.get(index);
        }

        public Qualifier getProperty(String name) {
            Qualifier property2 = null;
            for (Qualifier property2 : this.propertys) {
                if (!property2.getName().equalsIgnoreCase(name)) continue;
                return property2;
            }
            return null;
        }

        @Override
        char symbol() {
            return 'O';
        }

        @Override
        public DistributionRule getRule() {
            return this.rule;
        }

        @Override
        <T> T fromInnerValue(V7.ResultSet result) {
            String value = result.getString();
            if (this.id == 0) {
                String idPart = value.substring(4, 13);
                String vidPart = value.substring(0, 4);
                Object type = Metadatas.this.getType(this.symbol(), Integer.valueOf(vidPart.trim(), 36));
                if (idPart.equals("     0   ")) {
                    V7 v7 = Metadatas.this.v7;
                    v7.getClass();
                    return (T)new V7.NullDocumentReference(v7, this);
                }
                V7 v7 = Metadatas.this.v7;
                v7.getClass();
                return (T)new V7.DocumentReference(v7, idPart, (Reference)type);
            }
            String idPart = value.substring(0, 9);
            if (idPart.equals("     0   ")) {
                V7 v7 = Metadatas.this.v7;
                v7.getClass();
                return (T)new V7.NullDocumentReference(v7, this);
            }
            V7 v7 = Metadatas.this.v7;
            v7.getClass();
            return (T)new V7.DocumentReference(v7, idPart, this);
        }

        @Override
        <T> T NullValue() {
            V7 v7 = Metadatas.this.v7;
            v7.getClass();
            return (T)new V7.NullDocumentReference(v7, this);
        }
    }

    public final class EntryProperty
    extends Qualifier {
        final boolean isSelection;

        public EntryProperty(Token token) {
            super("\u0420\u0435\u043a\u0432\u0438\u0437\u0438\u0442\u041f\u0440\u043e\u0432\u043e\u0434\u043a\u0438", token);
            List<Token> tokens = token.getTokens();
            this.isSelection = tokens.get(10).getBoolean();
        }

        public boolean isSelection() {
            return this.isSelection;
        }

        @Override
        public boolean isPeriodical() {
            return false;
        }
    }

    public final class Enumeration
    extends Reference {
        final ArrayList<Reference> propertys;

        public Enumeration() {
            super(null, 0, "", "", "");
            this.propertys = new ArrayList();
        }

        Enumeration(Token token) {
            super("\u041f\u0435\u0440\u0435\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u0435", token);
            this.propertys = new ArrayList();
            Token tParams = token.getById("EnumVal");
            Iterator<Token> i = tParams.getChilds().iterator();
            while (i.hasNext()) {
                this.propertys.add(Metadatas.this.createEnumerationValue(this.locator, i.next()));
            }
        }

        @Override
        public String toString() {
            if (this.getId() == 0) {
                return "\u041f\u0435\u0440\u0435\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u0435";
            }
            return "\u041f\u0435\u0440\u0435\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u0435." + this.getName();
        }

        public List<Reference> getPropertys() {
            return Collections.unmodifiableList(this.propertys);
        }

        public Reference getProperty(int index) {
            return this.propertys.get(index);
        }

        public Reference getProperty(String name) {
            Reference property2 = null;
            for (Reference property2 : this.propertys) {
                if (!property2.getName().equalsIgnoreCase(name)) continue;
                return property2;
            }
            return property2;
        }

        @Override
        char symbol() {
            return 'E';
        }

        @Override
        <T> T fromInnerValue(V7.ResultSet result) {
            String value = result.getString();
            String idPart = value.substring(0, 9);
            if (idPart.equals("     0   ")) {
                return (T)new V7.NullEnumerationReference(Metadatas.this.v7);
            }
            V7 v7 = Metadatas.this.v7;
            v7.getClass();
            return (T)new V7.EnumerationReference(v7, idPart, this);
        }

        @Override
        <T> T NullValue() {
            return (T)new V7.NullEnumerationReference(Metadatas.this.v7);
        }
    }

    public final class EnumerationValue
    extends Reference {
        public EnumerationValue(String locator, Token token) {
            super(locator, token);
        }

        @Override
        char symbol() {
            return '\u0000';
        }

        @Override
        <T> T fromInnerValue(V7.ResultSet result) {
            return null;
        }

        @Override
        <T> T NullValue() {
            return null;
        }
    }

    public final class Field
    extends Qualifier {
        Field(String locator, Token token) {
            super(locator, token);
        }

        @Override
        public boolean isPeriodical() {
            return false;
        }
    }

    public final class Figure
    extends Qualifier {
        Figure(String locator, Token token) {
            super(locator, token);
        }

        @Override
        public boolean isPeriodical() {
            return false;
        }
    }

    public final class GrafSelect
    extends Reference {
        final Reference type;
        final boolean isSelectEmpty;
        final ArrayList<Reference> refers;

        GrafSelect(Token token) {
            super("\u0413\u0440\u0430\u0444\u0430\u041e\u0442\u0431\u043e\u0440\u0430", token);
            this.refers = new ArrayList();
            List<Token> tokens = token.getTokens();
            this.isSelectEmpty = tokens.get(4).getBoolean();
            this.type = Metadatas.this.getType(tokens.get(5).getChar(), tokens.get(6).getInteger());
            List<Token> tRefs = tokens.get(7).getChilds();
            for (Token tRef : tRefs) {
                this.refers.add((Reference)Metadatas.this.getType(tRef.getTokens().get(0).getInteger()));
            }
        }

        @Override
        char symbol() {
            return '\u0000';
        }

        public Reference getType() {
            return this.type;
        }

        public boolean isSelectEmpty() {
            return this.isSelectEmpty;
        }

        public List<Reference> getRefers() {
            return Collections.unmodifiableList(this.refers);
        }

        @Override
        <T> T fromInnerValue(V7.ResultSet result) {
            return null;
        }

        @Override
        <T> T NullValue() {
            return null;
        }
    }

    public final class GroupAlgorithms
    extends Reference {
        final ArrayList<Algorithm> algorithms;

        GroupAlgorithms(Token token) {
            super("\u0413\u0440\u0443\u043f\u043f\u0430\u0420\u0430\u0441\u0447\u0435\u0442\u043e\u0432", token);
            this.algorithms = new ArrayList();
            for (Token tAlg : token.getById("Algs").getChilds()) {
                Algorithm algorithm = (Algorithm)Metadatas.this.getType(tAlg.getInteger());
                if (algorithm == null) {
                    algorithm = new Algorithm(Metadatas.this.root.getById(tAlg.getString()));
                }
                this.algorithms.add(algorithm);
            }
        }

        public List<Algorithm> getAlgorithms() {
            return Collections.unmodifiableList(this.algorithms);
        }

        @Override
        char symbol() {
            return '\u0000';
        }

        @Override
        public String toString() {
            if (this.getId() == 0) {
                return "\u0413\u0440\u0443\u043f\u043f\u0430\u0420\u0430\u0441\u0447\u0435\u0442\u043e\u0432";
            }
            return "\u0413\u0440\u0443\u043f\u043f\u0430\u0420\u0430\u0441\u0447\u0435\u0442\u043e\u0432." + this.getName();
        }

        @Override
        <T> T fromInnerValue(V7.ResultSet result) {
            return null;
        }

        @Override
        <T> T NullValue() {
            return null;
        }
    }

    public final class HeadProperty
    extends Qualifier {
        HeadProperty(String locator, Token token) {
            super(locator, token);
        }

        @Override
        public boolean isPeriodical() {
            return false;
        }
    }

    public final class Numeric
    extends Reference {
        Numeric() {
            super(null, 0, "\u0427\u0438\u0441\u043b\u043e", "", "");
        }

        @Override
        String toInnerValue(Object obj) {
            if (obj == null) {
                return "0";
            }
            return obj.toString();
        }

        @Override
        char symbol() {
            return 'N';
        }

        @Override
        <T> T fromInnerValue(V7.ResultSet result) {
            Qualifier qualifier = result.getQualifier();
            if (qualifier.isPeriodical()) {
                return (T)new BigDecimal(result.getString().trim());
            }
            return (T)result.getBigDecimal();
        }

        @Override
        <T> T NullValue() {
            return (T)BigDecimal.valueOf(0L);
        }
    }

    public final class Plan
    extends Reference
    implements Distribution {
        final String pattern;
        final ArrayList<AccountValue> accounts;
        final DistributionRule rule;

        Plan() {
            super("\u041f\u043b\u0430\u043d\u0421\u0447\u0435\u0442\u043e\u0432", 0, "", "", "");
            this.accounts = new ArrayList();
            this.pattern = "";
            this.rule = null;
        }

        Plan(Token token) {
            super("\u041f\u043b\u0430\u043d\u0421\u0447\u0435\u0442\u043e\u0432", token);
            this.accounts = new ArrayList();
            List<Token> tokens = token.getTokens();
            this.pattern = tokens.get(4).getString();
            Token tAccounts = token.getById("Accounts");
            Iterator<Token> i = tAccounts.getChilds().iterator();
            while (i.hasNext()) {
                this.accounts.add(Metadatas.this.createAccount(i.next(), this));
            }
            this.rule = new DistributionRule(token.getById("Distribution ruler"));
        }

        public List<AccountValue> getAccounts() {
            return Collections.unmodifiableList(this.accounts);
        }

        public AccountValue getAccount(String code) {
            for (AccountValue acc : this.accounts) {
                if (!acc.code.equalsIgnoreCase(code)) continue;
                return acc;
            }
            return null;
        }

        public String getPattern() {
            return this.pattern;
        }

        @Override
        public String toString() {
            if (this.id == 0) {
                return "\u0421\u0447\u0435\u0442";
            }
            return "\u0421\u0447\u0435\u0442." + this.getName();
        }

        @Override
        char symbol() {
            return 'T';
        }

        @Override
        public DistributionRule getRule() {
            return this.rule;
        }

        @Override
        <T> T fromInnerValue(V7.ResultSet result) {
            String value = result.getString();
            if (this.id == 0) {
                String vidPart = value.substring(0, 4);
                String idPart = value.substring(4, 13);
                Object type = Metadatas.this.getType(this.symbol(), Integer.valueOf(vidPart.trim(), 36));
                if (idPart.equals("     0   ")) {
                    return (T)new V7.NullAccountReference(Metadatas.this.v7);
                }
                V7 v7 = Metadatas.this.v7;
                v7.getClass();
                return (T)new V7.AccountReference(v7, idPart, (Reference)type);
            }
            String idPart = value.substring(0, 9);
            if (idPart.equals("     0   ")) {
                return (T)new V7.NullAccountReference(Metadatas.this.v7);
            }
            V7 v7 = Metadatas.this.v7;
            v7.getClass();
            return (T)new V7.AccountReference(v7, idPart, this);
        }

        @Override
        <T> T NullValue() {
            return (T)new V7.NullAccountReference(Metadatas.this.v7);
        }
    }

    public final class Plans
    extends Reference {
        Plans() {
            super(null, 0, "", "", "");
        }

        @Override
        <T> T NullValue() {
            return (T)new V7.NullPlanReference(Metadatas.this.v7);
        }

        @Override
        <T> T fromInnerValue(V7.ResultSet result) {
            String value = result.getString();
            String vidPart = value.substring(0, 4);
            if (vidPart.equals("   0")) {
                return (T)new V7.NullPlanReference(Metadatas.this.v7);
            }
            V7 v7 = Metadatas.this.v7;
            v7.getClass();
            return (T)new V7.PlanReference(v7, Integer.valueOf(vidPart.trim(), 36));
        }

        @Override
        String toInnerValue(Object obj) {
            if (obj == null) {
                return String.format("%1$4S      ", "   0");
            }
            return ((V7.PlanReference)obj).getId();
        }

        @Override
        char symbol() {
            return 'P';
        }
    }

    public final class Property
    extends Qualifier {
        final boolean isSorted;
        final boolean isModifyDocument;
        final boolean isModifyManual;
        final boolean isUseElement;
        final boolean isUseGroup;
        final boolean isSelection;
        final boolean isPeriodical;

        @Override
        String toInnerValue(Object obj) {
            if (this.isPeriodical() && obj instanceof Date) {
                if (obj == null) {
                    return "  .  .    ";
                }
                return new SimpleDateFormat("dd.MM.yyyy").format((Date)obj);
            }
            return super.toInnerValue(obj);
        }

        public Property(String locator, Token token) {
            super(locator, token);
            List<Token> tokens = token.getTokens();
            this.isPeriodical = tokens.get(10).getBoolean();
            this.isUseElement = tokens.get(11).getBoolean();
            this.isUseGroup = tokens.get(12).getBoolean();
            this.isSorted = tokens.get(13).getBoolean();
            this.isModifyManual = tokens.get(14).getBoolean();
            this.isModifyDocument = tokens.get(15).getBoolean();
            this.isSelection = tokens.get(16).getBoolean();
        }

        public boolean isSorted() {
            return this.isSorted;
        }

        public boolean isModifyDocument() {
            return this.isModifyDocument;
        }

        public boolean isModifyManual() {
            return this.isModifyManual;
        }

        public boolean isUseElement() {
            return this.isUseElement;
        }

        public boolean isUseGroup() {
            return this.isUseGroup;
        }

        public boolean isSelection() {
            return this.isSelection;
        }

        @Override
        public boolean isPeriodical() {
            return this.isPeriodical;
        }
    }

    public abstract class Qualifier
    extends Reference {
        final Reference type;
        final int length;
        final int precision;
        final boolean isNonNegative;
        final boolean isSharedTriadas;

        Qualifier(String locator, int id, String name, String comment, String synonym) {
            super(locator, id, name, comment, synonym);
            this.type = Metadatas.this.getType('U', 0);
            this.length = 0;
            this.precision = 0;
            this.isNonNegative = false;
            this.isSharedTriadas = false;
        }

        Qualifier(String locator, Token token) {
            super(locator, token);
            List<Token> tokens = token.getTokens();
            this.type = Metadatas.this.createObject(tokens.get(4).getChar(), tokens.get(7).getInteger());
            this.length = tokens.get(5).getInteger();
            this.precision = tokens.get(6).getInteger();
            this.isNonNegative = tokens.get(8).getBoolean();
            this.isSharedTriadas = tokens.get(9).getBoolean();
        }

        @Override
        char symbol() {
            return '\u0000';
        }

        public abstract boolean isPeriodical();

        public int getLength() {
            return this.length;
        }

        public int getPrecision() {
            return this.precision;
        }

        public Reference getType() {
            return this.type;
        }

        public boolean isNonNegative() {
            return this.isNonNegative;
        }

        public boolean isSharedTriadas() {
            return this.isSharedTriadas;
        }

        @Override
        public String toString() {
            return String.valueOf(this.getName()) + " <" + this.type.toString() + ">";
        }

        @Override
        String toInnerValue(Object obj) {
            if (this.isPeriodical() && this.type instanceof Date) {
                return ((Date)this.type).toInnerPeriodicValue(obj);
            }
            return this.type.toInnerValue(obj);
        }

        @Override
        <T> T fromInnerValue(V7.ResultSet result) {
            result.setQualifier(this);
            return this.type.fromInnerValue(result);
        }

        @Override
        <T> T NullValue() {
            if (this.isPeriodical() && this.type instanceof Date) {
                return (T)new java.util.Date(0L);
            }
            return this.type.NullValue();
        }

        public String typeSQL() {
            if (this.type instanceof Undefine) {
                return "char(23)";
            }
            if (this.isPeriodical()) {
                return "char(23)";
            }
            if (this.type instanceof Row) {
                return "char(" + this.length + ")";
            }
            if (this.type instanceof Numeric) {
                return "numeric(" + this.length + "," + this.precision + ")";
            }
            if (this.type instanceof Date) {
                return "datetime";
            }
            if (this.type.getId() == 0) {
                return "char(13)";
            }
            return "char(9)";
        }
    }

    public abstract class Reference {
        final int id;
        final String name;
        final String comment;
        final String synonym;
        final String locator;

        Reference(String locator, int id, String name, String comment, String synonym) {
            this.id = id;
            this.name = name;
            this.comment = comment;
            this.synonym = synonym;
            this.locator = locator != null ? String.valueOf(locator) + "." + name : null;
            Metadatas.this.types.add(this);
        }

        Reference(String locator, Token token) {
            List<Token> tokens = token.getTokens();
            this.id = tokens.get(0).getInteger();
            this.name = tokens.get(1).getString();
            this.comment = tokens.get(2).getString();
            this.synonym = tokens.get(3).getString();
            this.locator = locator != null ? String.valueOf(locator) + "." + tokens.get(1).getString() : null;
            if (!(this instanceof Subconto)) {
                Metadatas.this.types.add(this);
            }
        }

        public int getId() {
            return this.id;
        }

        abstract char symbol();

        String getId36() {
            return String.format("%1$6S   ", Integer.toString(this.id, 36));
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            return obj instanceof Reference && this.getClass().equals(obj.getClass()) && this.id == ((Reference)obj).id;
        }

        public int hashCode() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getSynonym() {
            return this.synonym;
        }

        public String getComment() {
            return this.comment;
        }

        public String toString() {
            return this.name;
        }

        abstract <T> T fromInnerValue(V7.ResultSet var1);

        abstract <T> T NullValue();

        String toInnerValue(Object obj) {
            if (obj == null) {
                if (this.getId() != 0) {
                    return "     0   ";
                }
                return "   0     0   ";
            }
            V7.Ref ref = (V7.Ref)obj;
            if (this.getId() != 0) {
                return String.format("%1$9S", ref.getId());
            }
            return String.format("%1$4S%2$9S", ref.getVidId(), ref.getId());
        }
    }

    public final class Register
    extends Reference {
        final boolean isReverse;
        final char reverse;
        final boolean isFastHandling;
        final boolean isDisableMigration;
        final ArrayList<Dimension> dimensions;
        final ArrayList<Qualifier> figures;
        final ArrayList<Qualifier> fields;

        Register(Token token) {
            super("\u0420\u0435\u0433\u0438\u0441\u0442\u0440", token);
            this.dimensions = new ArrayList();
            this.figures = new ArrayList();
            this.fields = new ArrayList();
            List<Token> tokens = token.getTokens();
            this.isReverse = tokens.get(4).getBoolean();
            this.reverse = tokens.get(5).getChar();
            this.isFastHandling = tokens.get(6).getBoolean();
            this.isDisableMigration = tokens.get(7).getBoolean();
            Token tDimensions = token.getById("Props");
            Iterator<Token> i = tDimensions.getChilds().iterator();
            while (i.hasNext()) {
                this.dimensions.add(Metadatas.this.createDimension(this.locator, i.next()));
            }
            Token tFigures = token.getById("Figures");
            Iterator<Token> i2 = tFigures.getChilds().iterator();
            while (i2.hasNext()) {
                this.figures.add(Metadatas.this.createFigure(this.locator, i2.next()));
            }
            Token tFields = token.getById("Flds");
            Iterator<Token> i3 = tFields.getChilds().iterator();
            while (i3.hasNext()) {
                this.fields.add(Metadatas.this.createFieled(this.locator, i3.next()));
            }
        }

        public List<Dimension> getDimensions() {
            return Collections.unmodifiableList(this.dimensions);
        }

        public Dimension getDimension(String name) {
            for (Dimension dim : this.dimensions) {
                if (!dim.getName().equalsIgnoreCase(name)) continue;
                return dim;
            }
            return null;
        }

        public Qualifier getFigure(String name) {
            for (Qualifier fig : this.figures) {
                if (!fig.getName().equalsIgnoreCase(name)) continue;
                return fig;
            }
            return null;
        }

        public Qualifier getField(String name) {
            for (Qualifier field : this.fields) {
                if (!field.getName().equalsIgnoreCase(name)) continue;
                return field;
            }
            return null;
        }

        public List<Qualifier> getFigures() {
            return Collections.unmodifiableList(this.figures);
        }

        public List<Qualifier> getFields() {
            return Collections.unmodifiableList(this.fields);
        }

        public boolean isReverse() {
            return this.isReverse;
        }

        public char getReverse() {
            return this.reverse;
        }

        public boolean isFastHandling() {
            return this.isFastHandling;
        }

        public boolean isDisableMigration() {
            return this.isDisableMigration;
        }

        @Override
        char symbol() {
            return '\u0000';
        }

        @Override
        <T> T fromInnerValue(V7.ResultSet result) {
            return null;
        }

        @Override
        <T> T NullValue() {
            return null;
        }
    }

    public final class Row
    extends Reference {
        Row() {
            super(null, 0, "\u0421\u0442\u0440\u043e\u043a\u0430", "", "");
        }

        @Override
        String toInnerValue(Object obj) {
            if (obj == null) {
                return "";
            }
            return obj.toString();
        }

        @Override
        char symbol() {
            return 'S';
        }

        @Override
        <T> T fromInnerValue(V7.ResultSet result) {
            Qualifier qualifier = result.getQualifier();
            if (qualifier.getLength() == 0) {
                return (T)result.getString();
            }
            return (T)result.getString().trim();
        }

        @Override
        <T> T NullValue() {
            return (T)"";
        }
    }

    public final class Stream
    extends Reference {
        final boolean isSeparate;
        final ArrayList<Reference> registers;
        final ArrayList<Document> documents;

        Stream(Token token) {
            super("\u041f\u043e\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c", token);
            this.registers = new ArrayList();
            this.documents = new ArrayList();
            List<Token> tokens = token.getTokens();
            this.isSeparate = tokens.get(5).getBoolean();
            Token tRegs = token.getById("Registers");
            Iterator<Token> i = tRegs.getChilds().iterator();
            while (i.hasNext()) {
                Object reg = Metadatas.this.getType(i.next().getInteger());
                this.registers.add((Reference)reg);
            }
            Token tDocs = token.getById("Documents");
            Iterator<Token> i2 = tDocs.getChilds().iterator();
            while (i2.hasNext()) {
                Document doc = (Document)Metadatas.this.getType('O', i2.next().getInteger());
                this.documents.add(doc);
            }
        }

        public List<Reference> getRegisters() {
            return Collections.unmodifiableList(this.registers);
        }

        public List<Document> getDocuments() {
            return Collections.unmodifiableList(this.documents);
        }

        public boolean isSeparate() {
            return this.isSeparate;
        }

        @Override
        char symbol() {
            return '\u0000';
        }

        @Override
        <T> T fromInnerValue(V7.ResultSet result) {
            return null;
        }

        @Override
        <T> T NullValue() {
            return null;
        }
    }

    public final class Subconto
    extends Reference {
        final boolean isOnlyTurnover;
        final boolean isSum;
        final boolean isCurrencySum;
        final boolean isNumerical;
        final SubcontoKind subcontoKind;

        Subconto(Token token) {
            super("\u0421\u0443\u0431\u043a\u043e\u043d\u0442\u043e", token);
            List<Token> tokens = token.getTokens();
            this.subcontoKind = (SubcontoKind)Metadatas.this.createObject('K', tokens.get(10).getInteger());
            this.isOnlyTurnover = tokens.get(11).getBoolean();
            this.isSum = tokens.get(12).getBoolean();
            this.isCurrencySum = tokens.get(13).getBoolean();
            this.isNumerical = tokens.get(14).getBoolean();
        }

        public boolean isOnlyTurnover() {
            return this.isOnlyTurnover;
        }

        public boolean isSum() {
            return this.isSum;
        }

        public boolean isCurrencySum() {
            return this.isCurrencySum;
        }

        public boolean isNumerical() {
            return this.isNumerical;
        }

        @Override
        char symbol() {
            return '\u0000';
        }

        @Override
        <T> T fromInnerValue(V7.ResultSet result) {
            return null;
        }

        @Override
        <T> T NullValue() {
            return null;
        }
    }

    public final class SubcontoKind
    extends Qualifier {
        final Property price;
        final Property currencyPrice;
        final boolean isSelection;
        final boolean isFastSelection;
        final boolean isPermitEmpty;
        final ArrayList<Performance> performances;

        SubcontoKind() {
            super(null, 0, "", "", "");
            this.performances = new ArrayList();
            this.price = null;
            this.currencyPrice = null;
            this.isSelection = false;
            this.isFastSelection = false;
            this.isPermitEmpty = false;
        }

        SubcontoKind(Token token) {
            super("\u0412\u0438\u0434\u0421\u0443\u0431\u043a\u043e\u043d\u0442\u043e", token);
            this.performances = new ArrayList();
            List<Token> tokens = token.getTokens();
            this.isSelection = tokens.get(10).getBoolean();
            this.price = (Property)Metadatas.this.getType(tokens.get(11).getInteger());
            this.currencyPrice = (Property)Metadatas.this.getType(tokens.get(12).getInteger());
            this.isFastSelection = tokens.get(14).getBoolean();
            this.isPermitEmpty = tokens.get(15).getBoolean();
        }

        @Override
        char symbol() {
            return 'K';
        }

        @Override
        public String toString() {
            if (this.id == 0) {
                return "\u0412\u0438\u0434\u0421\u0443\u0431\u043a\u043e\u043d\u0442\u043e";
            }
            return "\u0412\u0438\u0434\u0421\u0443\u0431\u043a\u043e\u043d\u0442\u043e." + this.getName();
        }

        @Override
        <T> T fromInnerValue(V7.ResultSet result) {
            if (this.getId() == 0) {
                String value = result.getString();
                String vidPart = value.substring(0, 4);
                if (vidPart.equals("   0")) {
                    return (T)new V7.NullSubcontoKindReference(Metadatas.this.v7);
                }
                V7 v7 = Metadatas.this.v7;
                v7.getClass();
                return (T)new V7.SubcontoKindReference(v7, Integer.valueOf(vidPart.trim(), 36));
            }
            return this.type.fromInnerValue(result);
        }

        @Override
        String toInnerValue(Object obj) {
            if (this.id == 0) {
                if (obj == null) {
                    return String.format("%1$4S      ", "   0");
                }
                return ((V7.SubcontoKindReference)obj).getId();
            }
            return this.type.toInnerValue(obj);
        }

        public boolean isFastSelection() {
            return this.isFastSelection;
        }

        public boolean isSelection() {
            return this.isSelection;
        }

        public List<Performance> getPerformances() {
            return Collections.unmodifiableList(this.performances);
        }

        public boolean isPermitEmpty() {
            return this.isPermitEmpty;
        }

        public Property getPrice() {
            return this.price;
        }

        public Property getCurrencyPrice() {
            return this.currencyPrice;
        }

        void addPerformance(int id, String title, boolean newLine) {
            if (id < 0) {
                this.performances.add(new Performance(id, title, newLine));
            } else if (id > 0) {
                Catalog type = (Catalog)this.getType();
                this.performances.add(new Performance(type.getPropertyById(id), title, newLine));
            }
        }

        @Override
        public boolean isPeriodical() {
            return false;
        }

        class Performance {
            final Object value;
            final String title;
            boolean newLine;

            public Object getValue() {
                return this.value;
            }

            public String getTitle() {
                return this.title;
            }

            public boolean isNewLine() {
                return this.newLine;
            }

            Performance(Object property, String title, boolean newLine) {
                this.value = property;
                this.title = title;
                this.newLine = newLine;
            }
        }
    }

    public final class TableProperty
    extends Qualifier {
        final boolean total;

        TableProperty(String locator, Token token) {
            super(locator, token);
            List<Token> tokens = token.getTokens();
            this.total = tokens.get(10).getBoolean();
        }

        public boolean isTotal() {
            return this.total;
        }

        @Override
        public boolean isPeriodical() {
            return false;
        }
    }

    public final class Undefine
    extends Reference {
        Undefine() {
            super(null, 0, "\u041d\u0435\u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u043d\u044b\u0439", "", "");
        }

        @Override
        String toInnerValue(Object obj) {
            if (obj == null) {
                return "U                      ";
            }
            if (obj instanceof BigDecimal) {
                return String.format("N%1$22S", ((BigDecimal)obj).toPlainString());
            }
            if (obj instanceof Integer) {
                return String.format("N%1$22S", obj.toString());
            }
            if (obj instanceof Date) {
                return String.format("D%1$tY%1$tm%1$-16td", obj);
            }
            if (obj instanceof Row) {
                return String.format("S%1$22S", obj.toString());
            }
            V7.Ref ref = (V7.Ref)obj;
            return String.format("%1$2S%2$4S%3$6S           ", ref.getTypeId(), ref.getVidId(), ref.getId());
        }

        @Override
        char symbol() {
            return 'U';
        }

        @Override
        <T> T fromInnerValue(V7.ResultSet result) {
            String value = result.getString();
            if (value == null) {
                return (T)new V7.NullUndefineReference(Metadatas.this.v7);
            }
            char symbol = value.charAt(0);
            switch (symbol) {
                case 'U': {
                    return (T)new V7.NullUndefineReference(Metadatas.this.v7);
                }
                case 'S': {
                    return (T)result.getString().substring(1);
                }
                case 'N': {
                    String tsp = result.getString("t" + result.getLabel());
                    if (tsp.charAt(1) == '0') {
                        return (T)Integer.valueOf(value.substring(1).trim());
                    }
                    return (T)new BigDecimal(value.substring(1).trim());
                }
                case 'D': {
                    try {
                        return (T)new SimpleDateFormat("yyyyMMdd").parse(value.substring(1, 9));
                    }
                    catch (ParseException e) {
                        throw new ExceptionAdapter(e);
                    }
                }
                case 'B': {
                    Object type = Metadatas.this.getType('B', Integer.valueOf(value.substring(2, 6).trim(), 36));
                    String id = value.substring(6, 15);
                    if (id.equals("     0   ")) {
                        V7 v7 = Metadatas.this.v7;
                        v7.getClass();
                        return (T)new V7.NullCatalogReference(v7, this);
                    }
                    V7 v7 = Metadatas.this.v7;
                    v7.getClass();
                    return (T)new V7.CatalogReference(v7, id, (Reference)type);
                }
                case 'O': {
                    Object type = Metadatas.this.getType('O', Integer.valueOf(value.substring(2, 6).trim(), 36));
                    String id = value.substring(6, 15);
                    if (id.equals("     0   ")) {
                        V7 v7 = Metadatas.this.v7;
                        v7.getClass();
                        return (T)new V7.NullDocumentReference(v7, (Reference)type);
                    }
                    V7 v7 = Metadatas.this.v7;
                    v7.getClass();
                    return (T)new V7.DocumentReference(v7, id, (Reference)type);
                }
                case 'E': {
                    Object type = Metadatas.this.getType('E', Integer.valueOf(value.substring(2, 6).trim(), 36));
                    String id = value.substring(6, 15);
                    if (id.equals("     0   ")) {
                        return (T)new V7.NullEnumerationReference(Metadatas.this.v7);
                    }
                    V7 v7 = Metadatas.this.v7;
                    v7.getClass();
                    return (T)new V7.EnumerationReference(v7, id, (Reference)type);
                }
                case 'K': {
                    Object type = Metadatas.this.getType('K', Integer.valueOf(value.substring(2, 6).trim(), 36));
                    String id = value.substring(6, 15);
                    if (id.equals("     0   ")) {
                        return (T)new V7.NullSubcontoKindReference(Metadatas.this.v7);
                    }
                    V7 v7 = Metadatas.this.v7;
                    v7.getClass();
                    return (T)new V7.SubcontoKindReference(v7, Integer.valueOf(id.trim(), 36));
                }
                case 'P': {
                    Object type = Metadatas.this.getType('P', Integer.valueOf(value.substring(2, 6).trim(), 36));
                    String id = value.substring(6, 15);
                    if (id.equals("     0   ")) {
                        return (T)new V7.NullPlanReference(Metadatas.this.v7);
                    }
                    V7 v7 = Metadatas.this.v7;
                    v7.getClass();
                    return (T)new V7.PlanReference(v7, Integer.valueOf(id.trim(), 36));
                }
                case 'T': {
                    Object type = Metadatas.this.getType('T', Integer.valueOf(value.substring(2, 6).trim(), 36));
                    String id = value.substring(6, 15);
                    if (id.equals("     0   ")) {
                        return (T)new V7.NullAccountReference(Metadatas.this.v7);
                    }
                    V7 v7 = Metadatas.this.v7;
                    v7.getClass();
                    return (T)new V7.AccountReference(v7, id, (Reference)type);
                }
                case 'C': {
                    Object type = Metadatas.this.getType('C', Integer.valueOf(value.substring(2, 6).trim(), 36));
                    String id = value.substring(6, 15);
                    if (id.equals("     0   ")) {
                        return (T)new V7.NullCalendarReference(Metadatas.this.v7);
                    }
                    V7 v7 = Metadatas.this.v7;
                    v7.getClass();
                    return (T)new V7.CalendarReference(v7, Integer.valueOf(id.trim(), 36));
                }
                case 'A': {
                    Object type = Metadatas.this.getType('A', Integer.valueOf(value.substring(2, 6).trim(), 36));
                    String id = value.substring(6, 15);
                    if (id.equals("     0   ")) {
                        return (T)new V7.NullAccountReference(Metadatas.this.v7);
                    }
                    V7 v7 = Metadatas.this.v7;
                    v7.getClass();
                    return (T)new V7.AlgorithmReference(v7, Integer.valueOf(id.trim(), 36));
                }
            }
            throw new ExceptionAPI("\u0423\u043f\u0441.. \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0442\u0438\u043f '" + symbol + "'");
        }

        @Override
        <T> T NullValue() {
            return (T)new V7.NullUndefineReference(Metadatas.this.v7);
        }
    }
}

