/*
 * Decompiled with CFR 0.152.
 */
package j1c.ru;

import j1c.ru.ExceptionAPI;
import j1c.ru.V7;
import java.util.Calendar;
import java.util.Date;

public class Position {
    private final Date date;
    private final String id;
    public static final int CURRENT = 0;
    public static final int PRECEDING = -1;
    public static final int NEXT = 1;

    public Date getDate() {
        return this.date;
    }

    private String shift(String id, int shift) {
        String prefix = id.substring(0, 6).toUpperCase();
        String sufix = id.substring(6).toUpperCase();
        return String.format("%1$6S%2$3S", Integer.toString(Integer.valueOf(prefix.trim(), 36) + shift, 36), sufix);
    }

    public Position(String date_time_iddoc) {
        if (date_time_iddoc.length() != 23) {
            throw new NumberFormatException("\u041f\u043e\u0437\u0438\u0446\u0438\u044f \u0434\u043e\u043b\u0436\u043d\u0430 \u0431\u044b\u0442\u044c \u0434\u043b\u0438\u043d\u043e\u0439 \u0432 23 \u0441\u0438\u043c\u0432\u043e\u043b\u0430");
        }
        int year = Integer.valueOf(date_time_iddoc.substring(0, 4));
        int month = Integer.valueOf(date_time_iddoc.substring(4, 6));
        int day = Integer.valueOf(date_time_iddoc.substring(6, 8));
        int sec_from_day = Integer.valueOf(date_time_iddoc.substring(8, 14).trim(), 36) / 10000;
        int hour = sec_from_day / 60 / 60;
        int minute = (sec_from_day - hour * 60 * 60) / 60;
        int second = sec_from_day - hour * 60 * 60 - minute * 60;
        Calendar cal = Calendar.getInstance();
        cal.set(year, month - 1, day, hour, minute, second);
        this.date = cal.getTime();
        this.id = date_time_iddoc.substring(15).toUpperCase();
    }

    public Position(String id, Date date, int shift) {
        this.id = this.shift(id, shift);
        this.date = date;
    }

    public Position(String id, Date date, int seconds, int shift) {
        if (seconds >= 86400) {
            throw new ExceptionAPI("\u041d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u0430 \u0441\u0435\u043a\u0443\u043d\u0434 \u0441 \u043d\u0430\u0447\u0430\u043b\u0430 \u0434\u043d\u044f");
        }
        this.id = this.shift(id, shift);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        this.toStartDay(cal);
        int hour = seconds / 3600;
        int minute = (seconds - hour * 60 * 60) / 60;
        int second = seconds - hour * 60 * 60 - minute * 60;
        cal.set(11, hour);
        cal.set(12, minute);
        cal.set(13, second);
        this.date = cal.getTime();
    }

    public <T extends V7.DocumentReference> Position(T ref, int shift) {
        this.id = this.shift(ref.getId(), shift);
        this.date = ref.getDate();
    }

    public <T extends V7.DocumentObject> Position(T obj, int shift) {
        this.id = this.shift(((V7.Ref)obj.getRef()).getId(), shift);
        this.date = obj.getDate();
    }

    public Position(Position pos, int shift) {
        this.id = this.shift(pos.id, shift);
        this.date = pos.date;
    }

    public int getSeconds() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.date);
        return cal.get(11) * 60 * 60 + cal.get(12) * 60 + cal.get(13);
    }

    public Date getBeginningDay() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.date);
        this.toStartDay(cal);
        return cal.getTime();
    }

    private void toStartDay(Calendar cal) {
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return obj instanceof Position && this.toString().equalsIgnoreCase(obj.toString());
    }

    public boolean before(Position pos) {
        return this.toString().compareToIgnoreCase(pos.toString()) < 0;
    }

    public boolean after(Position pos) {
        return this.toString().compareToIgnoreCase(pos.toString()) > 0;
    }

    public String toString() {
        return String.format("%1$tY%1$tm%1$td%2$6S%3$9S", this.date, Integer.toString(this.getSeconds() * 10000, 36), this.id);
    }
}

