/*
 * Decompiled with CFR 0.152.
 */
package j1c.ru;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class Token {
    static int current;
    static char[] stream;
    private char[] value;
    private ArrayList<Token> tokens;
    private final Token parent;

    boolean isLeaf() {
        return this.value != null;
    }

    int getInteger() {
        if (this.value.length == 0) {
            return 0;
        }
        return Integer.valueOf(String.valueOf(this.value));
    }

    String getString() {
        return String.valueOf(this.value);
    }

    public List<Token> getChilds() {
        ArrayList<Token> result = new ArrayList<Token>();
        int i = 1;
        while (i < this.getTokens().size()) {
            Token token = this.getTokens().get(i);
            result.add(token);
            ++i;
        }
        return result;
    }

    char getChar() {
        return this.value[0];
    }

    boolean getBoolean() {
        return this.value.length != 0 && (this.value.length != 1 || this.value[0] != '0');
    }

    public Token getRoot() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.getRoot();
    }

    public Token getById(String id) {
        if (this.isLeaf()) {
            return null;
        }
        int i = 0;
        while (i < this.tokens.size()) {
            Token current = this.tokens.get(i);
            if (this.isRefers(i, current)) {
                return null;
            }
            if (this.isTarget(id, i, current)) {
                return current.parent;
            }
            if ((current = current.getById(id)) != null) {
                return current;
            }
            ++i;
        }
        return null;
    }

    private boolean isTarget(String id, int i, Token current) {
        return i == 0 && current.isLeaf() && current.getString().equalsIgnoreCase(id);
    }

    private boolean isRefers(int i, Token current) {
        return i == 0 && current.isLeaf() && current.getString().equalsIgnoreCase("Refers");
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        if (!this.isLeaf()) {
            result.append("\r\n{");
            Iterator<Token> i = this.tokens.iterator();
            while (i.hasNext()) {
                Token token = i.next();
                result.append(token.toString());
                if (!i.hasNext()) continue;
                result.append(",");
            }
            result.append("}");
        } else {
            result.append("\"");
            int i = 0;
            while (i < this.value.length) {
                result.append(this.value[i]);
                if (this.value[i] == '\"') {
                    result.append("\"");
                }
                ++i;
            }
            result.append("\"");
        }
        return result.toString();
    }

    private Token(Token parent, char[] value) {
        this.parent = parent;
        this.value = value;
    }

    public List<Token> getTokens() {
        return Collections.unmodifiableList(this.tokens);
    }

    private Token(Token parent) {
        this.tokens = new ArrayList();
        this.parent = parent;
        StringBuffer temp = new StringBuffer();
        boolean parity = true;
        block8: while (Token.hasNext()) {
            char symbol = Token.next();
            switch (symbol) {
                case '\r': {
                    break;
                }
                case '\n': {
                    break;
                }
                case ',': {
                    if (parity) continue block8;
                    temp.append(symbol);
                    break;
                }
                case '}': {
                    if (parity) {
                        return;
                    }
                    temp.append(symbol);
                    ++current;
                    break;
                }
                case '{': {
                    if (!parity) continue block8;
                    this.tokens.add(new Token(this));
                    break;
                }
                case '\"': {
                    if (parity) {
                        parity = false;
                        break;
                    }
                    if (Token.symbol(current + 1) == '\"') {
                        temp.append(symbol);
                        ++current;
                        break;
                    }
                    char[] value = new char[temp.length()];
                    temp.getChars(0, temp.length(), value, 0);
                    temp.delete(0, temp.length());
                    this.tokens.add(new Token(this, value));
                    parity = true;
                    break;
                }
                default: {
                    temp.append(symbol);
                }
            }
        }
    }

    static char symbol(int pos) {
        return stream[pos];
    }

    static char[] sequence(int from, int to) {
        return Arrays.copyOfRange(stream, from, to);
    }

    static char next() {
        return stream[++current];
    }

    static boolean hasNext() {
        return current + 1 < stream.length;
    }

    public static Token getInstance(char[] stream) {
        Token.stream = stream;
        current = -1;
        return new Token(null);
    }
}

