/*
 * Decompiled with CFR 0.152.
 */
package j1c.ru;

import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import j1c.ru.DataBaseAccses;
import j1c.ru.ExceptionAPI;
import j1c.ru.ExceptionAdapter;
import j1c.ru.Metadatas;
import j1c.ru.Position;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class V7 {
    private static final boolean DEBAG = false;
    private File catalogDataBase;
    private File fileMD;
    private DataBaseAccses dba;
    private Metadatas metaData;
    private Connection cn;
    private _1SSystem _1ssystem;
    private HashMap<String, String> metaName;

    private AccountReference getAccount(String id) {
        RecordSet rs = new RecordSet();
        rs.setParameter("id", id);
        ResultSet result = rs.executeQuery("select * from _1saccs (nolock) where id=:id");
        if (result.next()) {
            return new AccountReference(id, (Metadatas.Reference)this.metaData.getType(result.getInt("planid")));
        }
        return new NullAccountReference();
    }

    public AccountReference accountByCode(String code, String plan) {
        AccountManager am = new AccountManager(plan);
        List<AccountReference> sample = am.serchByCode(code);
        if (sample.size() > 0) {
            return sample.get(0);
        }
        return null;
    }

    public AccountReference accountByCode(String code) {
        AccountManager am = new AccountManager();
        List<AccountReference> sample = am.serchByCode(code);
        if (sample.size() > 0) {
            return sample.get(0);
        }
        return null;
    }

    public DataBaseAccses getDba() {
        return this.dba;
    }

    public Map<String, String> getMetaName() {
        return Collections.unmodifiableMap(this.metaName);
    }

    public synchronized Metadatas getMetaData() {
        return this.metaData;
    }

    public File getCatalogDataBase() {
        return this.catalogDataBase;
    }

    public boolean isSQLFormat() {
        return true;
    }

    public boolean isConnected() {
        if (this.cn == null) {
            return false;
        }
        try {
            return !this.cn.isClosed();
        }
        catch (SQLException e) {
            throw new ExceptionAdapter(e);
        }
    }

    private String readFromFile(String fileName) {
        StringBuffer buf = new StringBuffer();
        try {
            String ch;
            InputStreamReader isr = new InputStreamReader(new FileInputStream(fileName));
            BufferedReader in = new BufferedReader(isr);
            while ((ch = in.readLine()) != null) {
                buf.append(ch);
            }
            in.close();
        }
        catch (Exception e) {
            System.err.println("Caught exception " + e.toString());
            System.exit(1);
        }
        return buf.toString();
    }

    private String gatheringParameters() {
        DataBaseAccses dba = new DataBaseAccses();
        try {
            dba.open(String.valueOf(this.catalogDataBase.getAbsolutePath()) + "\\1Cv7.DBA");
        }
        catch (Exception e) {
            System.err.println("Caught exception " + e.toString());
            System.exit(1);
        }
        StringBuffer dbaContent = new StringBuffer();
        Map<String, String> params = dba.getFields();
        for (String key : params.keySet()) {
            if (key.equalsIgnoreCase("checksum")) continue;
            dbaContent.append(String.valueOf(key) + "=" + params.get(key) + ";");
        }
        return dbaContent.toString();
    }

    private boolean checkSignature() {
        String pubKyeFile = String.valueOf(this.catalogDataBase.getAbsolutePath()) + "/public.key";
        String signatureFile = String.valueOf(this.catalogDataBase.getAbsolutePath()) + "/signature.lic";
        boolean result = false;
        try {
            X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(Base64.decode(this.readFromFile(pubKyeFile)));
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PublicKey pubKey = keyFactory.generatePublic(pubKeySpec);
            byte[] sigToVerify = Base64.decode(this.readFromFile(signatureFile));
            Signature sig = Signature.getInstance("SHA1withRSA", "SunRsaSign");
            sig.initVerify(pubKey);
            sig.update(this.gatheringParameters().getBytes());
            result = sig.verify(sigToVerify);
        }
        catch (Exception e) {
            System.err.println("Caught exception " + e.toString());
            return result;
        }
        return result;
    }

    private void putMetaName(String key, String value) {
        this.metaName.put(key.toLowerCase(), value.toLowerCase());
    }

    private void initMetaName() {
        if (this.metaName == null) {
            this.metaName = new HashMap();
        }
        this.metaName.clear();
        this.putMetaName("\u041f\u0443\u0441\u0442\u043e\u0439\u0418\u0414", "'     0   '");
        this.putMetaName("\u041f\u0443\u0441\u0442\u043e\u0439\u0418\u041413", "'   0     0   '");
        List constants = this.metaData.selectTypes("\u041a\u043e\u043d\u0441\u0442\u0430\u043d\u0442\u0430.*");
        for (Metadatas.Constanta constanta : constants) {
            this.putMetaName("\u041a\u043e\u043d\u0441\u0442\u0430\u043d\u0442\u0430." + constanta.getName(), "" + constanta.getId());
            if (!constanta.isPeriodical) continue;
            String v_table = "c" + constanta.getId() + "_vv";
            this.putMetaName("\u041f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0435\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435.\u041a\u043e\u043d\u0441\u0442\u0430\u043d\u0442\u0430." + constanta.getName(), "(select top 1 " + v_table + ".value " + "from _1sconst as " + v_table + " (nolock) " + "where " + v_table + ".id = " + constanta.getId() + " and " + v_table + ".objid = '" + "     0   " + "' and " + v_table + ".date <= arg2_vv " + "order by " + v_table + ".date desc, " + v_table + ".time desc, " + v_table + ".docid desc, " + v_table + ".row_id desc)");
            this.putMetaName("\u041f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0435\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435\u0422\u0438\u043f.\u041a\u043e\u043d\u0441\u0442\u0430\u043d\u0442\u0430." + constanta.getName(), "(select top 1 " + v_table + ".tvalue " + "from _1sconst as " + v_table + " (nolock) " + "where " + v_table + ".id = " + constanta.getId() + " and " + v_table + ".objid = '" + "     0   " + "' and " + v_table + ".date <= arg2_vv " + "order by " + v_table + ".date desc, " + v_table + ".time desc, " + v_table + ".docid desc, " + v_table + ".row_id desc)");
        }
        List enums = this.metaData.selectTypes("\u041f\u0435\u0440\u0435\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u0435.*");
        for (Metadatas.Enumeration enum_ : enums) {
            this.putMetaName("\u041f\u0435\u0440\u0435\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u0435." + enum_.getName(), "" + enum_.getId());
            this.putMetaName("\u0412\u0438\u0434\u041f\u0435\u0440\u0435\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f36." + enum_.getName(), "'" + enum_.getId36() + "'");
            this.putMetaName("EnumKind36." + enum_.getName(), "'" + enum_.getId36() + "'");
            List<Metadatas.Reference> sample = enum_.getPropertys();
            for (Metadatas.Reference property : sample) {
                this.putMetaName("\u041f\u0435\u0440\u0435\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u0435." + enum_.getName() + "." + property.getName(), property.getId36());
            }
        }
        List commonPropertys = this.metaData.selectTypes("\u041e\u0431\u0449\u0438\u0439\u0420\u0435\u043a\u0432\u0438\u0437\u0438\u0442.*");
        ArrayList<Metadatas.CommonProperty> psevdoCommonPropperty = new ArrayList<Metadatas.CommonProperty>();
        for (Metadatas.CommonProperty commonProperty : commonPropertys) {
            if (commonProperty.isSelection) {
                this.putMetaName("\u041e\u0431\u0449\u0438\u0439\u0420\u0435\u043a\u0432\u0438\u0437\u0438\u0442." + commonProperty.getName(), "sp" + commonProperty.getId());
                if (!(commonProperty.type instanceof Metadatas.Undefine)) continue;
                this.putMetaName("\u041e\u0431\u0449\u0438\u0439\u0420\u0435\u043a\u0432\u0438\u0437\u0438\u0442\u0422\u0438\u043f." + commonProperty.getName(), "tsp" + commonProperty.getId());
                continue;
            }
            psevdoCommonPropperty.add(commonProperty);
        }
        List catalogs = this.metaData.selectTypes("\u0421\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a.*");
        for (Metadatas.Catalog catalog : catalogs) {
            this.putMetaName("\u0421\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a." + catalog.getName(), "sc" + catalog.getId());
            this.putMetaName("\u0412\u0438\u0434\u0421\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u043036." + catalog.getName(), "'" + catalog.getId36() + "'");
            this.putMetaName("ReferenceKind36." + catalog.getName(), "'" + catalog.getId36() + "'");
            List<Metadatas.Property> sample = catalog.getPropertys();
            for (Metadatas.Property property : sample) {
                if (property.isPeriodical) {
                    this.putMetaName("\u0418\u0441\u0442\u043e\u0440\u0438\u044f\u0420\u0435\u043a\u0432\u0438\u0437\u0438\u0442\u0430." + catalog.getName() + "." + property.getName(), "" + property.getId());
                    String v_table = "c" + property.getId() + "_vv";
                    this.putMetaName("\u041f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0435\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435." + catalog.getName() + "." + property.getName(), "(select top 1 " + v_table + ".value " + "from _1sconst as " + v_table + " (nolock) " + "where " + v_table + ".id = " + property.getId() + " and " + v_table + ".objid = arg1_vv and " + v_table + ".date <= arg2_vv " + "order by " + v_table + ".date desc, " + v_table + ".time desc, " + v_table + ".docid desc, " + v_table + ".row_id desc)");
                    this.putMetaName("\u041f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0435\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435\u0422\u0438\u043f." + catalog.getName() + "." + property.getName(), "(select top 1 " + v_table + ".tvalue " + "from _1sconst as " + v_table + " (nolock) " + "where " + v_table + ".id = " + property.getId() + " and " + v_table + ".objid = arg1_vv and " + v_table + ".date <= arg2_vv " + "order by " + v_table + ".date desc, " + v_table + ".time desc, " + v_table + ".docid desc, " + v_table + ".row_id desc)");
                    continue;
                }
                this.putMetaName("\u0421\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a." + catalog.getName() + "." + property.getName(), "sp" + property.getId());
            }
        }
        List docs = this.metaData.selectTypes("\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442.*");
        for (Metadatas.Document doc : docs) {
            this.putMetaName("\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442." + doc.getName(), "dh" + doc.getId());
            this.putMetaName("\u0412\u0438\u0434\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430." + doc.getName(), "" + doc.getId());
            this.putMetaName("DocumentKind." + doc.getName(), "" + doc.getId());
            this.putMetaName("\u0412\u0438\u0434\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043036." + doc.getName(), "'" + doc.getId36() + "'");
            this.putMetaName("DocumentKind36." + doc.getName(), "'" + doc.getId36() + "'");
            for (Metadatas.CommonProperty commonProperty : psevdoCommonPropperty) {
                this.putMetaName("\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442." + doc.getName() + "." + commonProperty.getName(), "sp" + commonProperty.getId());
                if (!(commonProperty.type instanceof Metadatas.Undefine)) continue;
                this.putMetaName("\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442." + doc.getName() + "." + commonProperty.getName() + "\u0422\u0438\u043f", "tsp" + commonProperty.getId());
            }
            List<Metadatas.Qualifier> properties = doc.getPropertys();
            for (Metadatas.Qualifier property : properties) {
                this.putMetaName("\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442." + doc.getName() + "." + property.getName(), "sp" + property.getId());
                if (!(property.type instanceof Metadatas.Undefine)) continue;
                this.putMetaName("\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442." + doc.getName() + "." + property.getName() + "\u0422\u0438\u043f", "tsp" + property.getId());
            }
            this.putMetaName("\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0421\u0442\u0440\u043e\u043a\u0438." + doc.getName(), "dt" + doc.getId());
            List<Metadatas.TableProperty> list = doc.getDetail();
            for (Metadatas.TableProperty property : list) {
                this.putMetaName("\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0421\u0442\u0440\u043e\u043a\u0438." + doc.getName() + "." + property.getName(), "sp" + property.getId());
                if (!(property.type instanceof Metadatas.Undefine)) continue;
                this.putMetaName("\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0421\u0442\u0440\u043e\u043a\u0438." + doc.getName() + "." + property.getName() + "\u0422\u0438\u043f", "tsp" + property.getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void open(String catalog, Properties props) {
        this.catalogDataBase = null;
        this.fileMD = null;
        this.metaData = null;
        this.catalogDataBase = new File(catalog);
        try {
            Class.forName("net.sourceforge.jtds.jdbc.Driver");
        }
        catch (ClassNotFoundException e) {
            throw new ExceptionAdapter(e);
        }
        String server = props.getProperty("server");
        String[] namedInstance = server.split("\\\\");
        if (namedInstance.length > 1) {
            server = namedInstance[0];
            props.put("instance", namedInstance[1]);
        }
        String base = props.getProperty("base");
        String port = props.getProperty("port", "1433");
        props.put("tds", "8.0");
        props.put("lastUpdateCount", "true");
        String cs = String.format("jdbc:jtds:sqlserver://%1$s:%2$s/%3$s", server, port, base);
        try {
            this.cn = DriverManager.getConnection(cs, props);
        }
        catch (SQLException e) {
            throw new ExceptionAPI(e.getMessage());
        }
        if (!this.catalogDataBase.isDirectory()) {
            throw new ExceptionAPI("\u041f\u0443\u0442\u044c '" + catalog + "' \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043a\u0430\u0442\u0430\u043b\u043e\u0433\u043e\u043c");
        }
        this.fileMD = new File(String.valueOf(catalog) + File.separator + "1Cv7.MD");
        if (!this.fileMD.exists()) {
            throw new ExceptionAPI("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0444\u0430\u0439\u043b '" + this.fileMD.getAbsolutePath() + "'");
        }
        Metadatas metadatas = this.metaData = new Metadatas();
        synchronized (metadatas) {
            if (!this.metaData.open(this.fileMD.getAbsolutePath())) {
                throw new ExceptionAPI("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u0440\u043e\u0447\u0438\u0442\u0430\u0442\u044c \u043c\u0435\u0442\u0430\u0434\u0430\u043d\u043d\u044b\u0435 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438");
            }
            this.metaData.v7 = this;
        }
        this.initMetaName();
    }

    public void connect(String catalogName) {
        this.dba = new DataBaseAccses();
        try {
            this.dba.open(String.valueOf(catalogName) + File.separator + "1Cv7.DBA");
        }
        catch (Exception e) {
            throw new ExceptionAPI("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u044f \u043a \u0431\u0430\u0437\u0435 \u0434\u0430\u043d\u043d\u044b\u0445: " + e.getMessage());
        }
        Properties props = new Properties();
        props.setProperty("server", this.dba.getField("server"));
        props.setProperty("base", this.dba.getField("db"));
        props.setProperty("user", this.dba.getField("uid"));
        props.setProperty("password", this.dba.getField("pwd"));
        this.open(catalogName, props);
        this._1ssystem = new _1SSystem();
    }

    public void connect(String catalogName, Properties props) {
        this.open(catalogName, props);
    }

    public RecordSet getRecordSet() {
        return new RecordSet();
    }

    public void close() {
        this.catalogDataBase = null;
        this.fileMD = null;
        this.metaData = null;
        this.dba = null;
        try {
            this.cn.close();
        }
        catch (SQLException e) {
            throw new ExceptionAdapter(e);
        }
    }

    public static interface Account {
        public boolean isMark();
    }

    public class AccountManager
    extends Manager {
        public AccountManager() {
            super(V7.this.metaData.getMainPlan());
        }

        public AccountManager(String name) {
            super(V7.this.metaData.getPlanAccount(name));
        }

        public List<Ref> selectRefs() {
            return null;
        }

        public List<AccountReference> serchByCode(String code) {
            Metadatas.Plan meta = (Metadatas.Plan)this.getMetaObject();
            ArrayList<AccountReference> sample = new ArrayList<AccountReference>();
            String query = "select id from _1saccs with (nolock) where planid=:plan and replace(left(schkod,len(schkod)-1),' ','') like '" + code + "'";
            RecordSet rs = new RecordSet();
            rs.setParameter("plan", meta.getId());
            ResultSet result = rs.executeQuery(query);
            while (result.next()) {
                AccountReference v = (AccountReference)result.getRef(1, this.metaObject);
                sample.add(v);
            }
            return Collections.unmodifiableList(sample);
        }
    }

    public class AccountReference
    extends Ref
    implements Account {
        AccountReference(String id, Metadatas.Reference metaObject) {
            super(id, metaObject);
        }

        public boolean defineConfiguration() {
            return this.getMetaAccount() != null;
        }

        public Metadatas.AccountValue getMetaAccount() {
            Metadatas.Plan plan = (Metadatas.Plan)this.getMetaObject();
            for (Metadatas.AccountValue acc : plan.accounts) {
                if (!acc.getCode().equals(this.getCode())) continue;
                return acc;
            }
            return null;
        }

        public int amountSubconto() {
            RecordSet rs = new RecordSet();
            rs.setParameter("id", this);
            ResultSet result = rs.executeQuery("select * from _1saccs (nolock) where id=:id");
            int amount = 0;
            if (result.next()) {
                int i = 0;
                while (i < V7.this.metaData.getMaxSubconto()) {
                    if (result.getInt("sc" + i) != 0) {
                        ++amount;
                    }
                    ++i;
                }
            }
            return amount;
        }

        public SubcontoKindReference getSubcontoKind(int number) {
            if (number < 0 || number > this.amountSubconto() - 1) {
                throw new ExceptionAPI("\u041d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043d\u043e\u043c\u0435\u0440\u0430 \u0441\u0443\u0431\u043a\u043e\u043d\u0442\u043e");
            }
            RecordSet rs = new RecordSet();
            rs.setParameter("id", this);
            ResultSet result = rs.executeQuery("select sc" + number + " from _1saccs (nolock) where id=:id");
            if (result.next()) {
                return new SubcontoKindReference(result.getInt(1));
            }
            return new NullSubcontoKindReference();
        }

        public PlanReference getPlan() {
            RecordSet rs = new RecordSet();
            rs.setParameter("id", this);
            ResultSet result = rs.executeQuery("select * from _1saccs (nolock) where id=:id");
            result.next();
            if (result.next()) {
                return new PlanReference(result.getInt("planid"));
            }
            return new NullPlanReference();
        }

        public List<SubcontoKindReference> getSubcontoKinds() {
            ArrayList<SubcontoKindReference> result = new ArrayList<SubcontoKindReference>();
            int i = 0;
            while (i < this.amountSubconto()) {
                SubcontoKindReference subcontoKind = this.getSubcontoKind(i);
                result.add(subcontoKind);
                ++i;
            }
            return Collections.unmodifiableList(result);
        }

        public String getCode() {
            String query = "select * from _1saccs with (nolock) where id=:id";
            RecordSet rs = new RecordSet();
            rs.setParameter("id", this);
            ResultSet result = rs.executeQuery(query);
            if (result.next()) {
                String temp = result.getString("schkod").trim();
                return temp.substring(0, temp.length() - 1);
            }
            return "";
        }

        public String toString() {
            return this.getCode();
        }

        public <T extends Obj> Obj getObj() {
            return null;
        }

        @Override
        public boolean isMark() {
            RecordSet rs = new RecordSet();
            rs.setParameter("id", this);
            ResultSet result = rs.executeQuery("select ismark&1 from _1saccs (nolock) where id=:id");
            if (result.next()) {
                return result.getBoolean(1);
            }
            return false;
        }

        public boolean isFolder() {
            RecordSet rs = new RecordSet();
            rs.setParameter("id", this);
            ResultSet result = rs.executeQuery("select isfolder&1 from _1saccs (nolock) where id=:id");
            if (result.next()) {
                return result.getBoolean(1);
            }
            return false;
        }

        public int getAcctive() {
            RecordSet rs = new RecordSet();
            rs.setParameter("id", this);
            ResultSet result = rs.executeQuery("select acctive from _1saccs (nolock) where id=:id");
            if (result.next()) {
                return result.getInt(1);
            }
            return 0;
        }

        public boolean isCurrency() {
            RecordSet rs = new RecordSet();
            rs.setParameter("id", this);
            ResultSet result = rs.executeQuery("select schv&1 from _1saccs (nolock) where id=:id");
            if (result.next()) {
                return result.getBoolean(1);
            }
            return false;
        }

        public boolean isAmount() {
            RecordSet rs = new RecordSet();
            rs.setParameter("id", this);
            ResultSet result = rs.executeQuery("select schkol&1 from _1saccs (nolock) where id=:id");
            result.next();
            if (result.next()) {
                return result.getBoolean(1);
            }
            return false;
        }

        public boolean isSingle() {
            RecordSet rs = new RecordSet();
            rs.setParameter("id", this);
            ResultSet result = rs.executeQuery("select schsingle&1 from _1saccs (nolock) where id=:id");
            if (result.next()) {
                return result.getBoolean(1);
            }
            return false;
        }

        public boolean isOnlyTurnover(int number) {
            if (number < 0 || number > V7.this.metaData.getMaxSubconto() - 1) {
                throw new ExceptionAPI("\u041d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043d\u043e\u043c\u0435\u0440\u0430 \u0441\u0443\u0431\u043a\u043e\u043d\u0442\u043e");
            }
            RecordSet rs = new RecordSet();
            rs.setParameter("id", this);
            ResultSet result = rs.executeQuery("select osc" + number + " from _1saccs (nolock) where id=:id");
            if (result.next()) {
                return result.getBoolean(1);
            }
            return false;
        }

        @Override
        String getTypeId() {
            return "T1";
        }

        @Override
        String getVidId() {
            return String.format("%1$4S", Integer.toString(((Metadatas.Reference)this.getMetaObject()).getId(), 36));
        }
    }

    public final class Advance {
        private final Metadatas.Register metaObject;
        private final DocumentReference docContext;
        private int debkred;
        private int lineno;
        public static final int DEBIT = 0;
        public static final int KREDIT = 1;
        private Hashtable<String, Property> dimensions = new Hashtable();
        private Hashtable<String, Property> figures = new Hashtable();
        private Hashtable<String, Property> fields = new Hashtable();

        Advance(Metadatas.Register metaObject, DocumentReference docContext) {
            if (metaObject == null) {
                throw new ExceptionAPI("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u0434\u0432\u0438\u0436\u0435\u043d\u0438\u044f \u0441 null \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435\u043c \u043c\u0435\u0442\u0430\u0434\u0430\u043d\u043d\u044b\u0445");
            }
            if (docContext == null) {
                throw new ExceptionAPI("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430 \u0441 null \u0441\u0441\u044b\u043a\u043e\u0439 \u043d\u0430 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442");
            }
            this.metaObject = metaObject;
            this.docContext = docContext;
            this.initAttribute();
        }

        private void readAttribute(ResultSet result) {
            this.lineno = result.getInt("lineno_");
            this.dimensions.clear();
            for (Metadatas.Dimension dim : this.metaObject.getDimensions()) {
                this.dimensions.put(dim.getName(), new Property(dim, result.getRef("sp" + dim.getId(), (Metadatas.Reference)dim)));
            }
            this.figures.clear();
            for (Metadatas.Qualifier fig : this.metaObject.getFigures()) {
                this.figures.put(fig.getName(), new Property(fig, result.getRef("sp" + fig.getId(), (Metadatas.Reference)fig)));
            }
            this.fields.clear();
            for (Metadatas.Qualifier field : this.metaObject.getFields()) {
                this.fields.put(field.getName(), new Property(field, result.getRef("sp" + field.getId(), (Metadatas.Reference)field)));
            }
        }

        private void initAttribute() {
            for (Metadatas.Dimension dim : this.metaObject.getDimensions()) {
                this.dimensions.put(dim.getName(), new Property(dim));
            }
            for (Metadatas.Qualifier fig : this.metaObject.getFigures()) {
                this.figures.put(fig.getName(), new Property(fig));
            }
            for (Metadatas.Qualifier field : this.metaObject.getFields()) {
                this.fields.put(field.getName(), new Property(field));
            }
        }

        public void setDimension(String name, Object value) {
            Metadatas.Dimension dim = this.metaObject.getDimension(name);
            if (dim == null) {
                throw new ExceptionAPI("\u0418\u0437\u043c\u0435\u0440\u0435\u043d\u0438\u0435 '" + name + "' \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u043e");
            }
            this.dimensions.get(name).setValue(value);
        }

        public void setFigure(String name, Object value) {
            Metadatas.Qualifier fig = this.metaObject.getFigure(name);
            if (fig == null) {
                throw new ExceptionAPI("\u0420\u0435\u0441\u0443\u0440\u0441 '" + name + "' \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
            }
            this.figures.get(name).setValue(value);
        }

        public void setField(String name, Object value) {
            Metadatas.Qualifier field = this.metaObject.getField(name);
            if (field == null) {
                throw new ExceptionAPI("\u0420\u0435\u043a\u0432\u0438\u0437\u0438\u0442 '" + name + "' \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
            }
            this.fields.get(name).setValue(value);
        }

        public int getDebkred() {
            return this.debkred;
        }

        public void setDebkred(int direction) {
            if (direction != 0 || direction != 1) {
                throw new ExceptionAPI("\u041d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0434\u0432\u0438\u0436\u0435\u043d\u0438\u044f");
            }
            this.debkred = direction;
        }
    }

    public class AlgorithmReference
    extends Ref {
        AlgorithmReference(int id) {
            super(((Metadatas.Reference)V7.this.metaData.getType('A', id)).getId36(), (Metadatas.Reference)V7.this.metaData.getType('A', 0));
        }

        @Override
        String getTypeId() {
            return "A1";
        }

        @Override
        String getVidId() {
            return String.format("%1$4S", Integer.toString(((Metadatas.Reference)this.getMetaObject()).getId(), 36));
        }

        public String toString() {
            return ((Metadatas.Reference)V7.this.metaData.getType('A', Integer.valueOf(this.getId().trim(), 36))).getName();
        }
    }

    public class CalendarReference
    extends Ref {
        CalendarReference(int id) {
            super(((Metadatas.Reference)V7.this.metaData.getType('C', id)).getId36(), (Metadatas.Reference)V7.this.metaData.getType('C', 0));
        }

        @Override
        String getTypeId() {
            return "C1";
        }

        @Override
        String getVidId() {
            return String.format("%1$4S", Integer.toString(((Metadatas.Reference)this.getMetaObject()).getId(), 36));
        }

        public String toString() {
            return ((Metadatas.Reference)V7.this.metaData.getType('C', Integer.valueOf(this.getId().trim(), 36))).getName();
        }
    }

    public static interface Catalog {
        public boolean isMark();

        public Object getAttribute(String var1);

        public Object getAttribute(int var1);

        public void setDate(Date var1);

        public CatalogReference getOwner();

        public CatalogReference getParent();

        public boolean isFolder();

        public String getCode();

        public String getName();
    }

    public final class CatalogManager
    extends Manager {
        private CatalogReference parent;
        private CatalogReference owner;

        public CatalogManager(String name) {
            super(V7.this.metaData.getCatalog(name));
            this.parent = new NullCatalogReference((Metadatas.Reference)this.getMetaObject());
            this.owner = new NullCatalogReference((Metadatas.Reference)this.getMetaObject());
        }

        public void setParent(CatalogReference parent) {
            Metadatas.Catalog meta = (Metadatas.Catalog)this.getMetaObject();
            if (meta.getCountLevel() == 1) {
                throw new ExceptionAPI("\u0421\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a '" + meta.toString() + "' \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043e\u0434\u043d\u043e\u0443\u0440\u043e\u0432\u043d\u0435\u0432\u044b\u043c");
            }
            if (parent.isFolder()) {
                throw new ExceptionAPI("\u042d\u043b\u0435\u043c\u0435\u043d\u0442 '" + parent + "' \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0433\u0440\u0443\u043f\u043f\u043e\u0439");
            }
            this.parent = parent;
        }

        public void setOwner(CatalogReference owner) {
            Metadatas.Catalog meta = (Metadatas.Catalog)this.getMetaObject();
            if (meta.getOwner() == null) {
                throw new ExceptionAPI("\u0421\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a '" + meta.toString() + "' \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043f\u043e\u0434\u0447\u0438\u043d\u0435\u043d\u043d\u044b\u043c");
            }
            this.owner = owner;
        }

        public List<CatalogReference> selectRefs() {
            RecordSet rs = new RecordSet();
            ArrayList<CatalogReference> sample = new ArrayList<CatalogReference>();
            Metadatas.Catalog meta = (Metadatas.Catalog)this.getMetaObject();
            String query = "select t.id from $\u0421\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a." + this.metaObject.getName() + " as t with (nolock)";
            ArrayList<String> conditions = new ArrayList<String>();
            if (meta.getCountLevel() > 1 && this.parent != null) {
                conditions.add("t.parentid=:parent");
                rs.setParameter("parent", this.parent);
            }
            if (meta.getOwner() != null && this.owner != null) {
                conditions.add("t.parentext=:owner");
                rs.setParameter("owner", this.owner);
            }
            if (conditions.size() > 0) {
                query = String.valueOf(query) + "\nwhere ";
                Iterator counter = conditions.iterator();
                while (counter.hasNext()) {
                    query = String.valueOf(query) + (String)counter.next();
                    if (!counter.hasNext()) continue;
                    query = String.valueOf(query) + "\n and ";
                }
            }
            ResultSet resultQuery = rs.executeQuery(query);
            while (resultQuery.next()) {
                CatalogReference v = (CatalogReference)resultQuery.getRef(1, this.metaObject);
                sample.add(v);
            }
            return Collections.unmodifiableList(sample);
        }

        public List<CatalogReference> serchByCode(String code, boolean mode) {
            Metadatas.Catalog meta = (Metadatas.Catalog)this.getMetaObject();
            if (meta.lengthCode == 0) {
                throw new ExceptionAPI("\u0421\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a \u043d\u0435 \u0438\u043c\u0435\u0435\u0442 \u043a\u043e\u0434\u0430");
            }
            return this.serchByCodeName("code", code, mode);
        }

        private List<CatalogReference> serchByCodeName(String field, String value, boolean modeSubmission) {
            RecordSet rs = new RecordSet();
            Metadatas.Catalog meta = (Metadatas.Catalog)this.getMetaObject();
            ArrayList<CatalogReference> sample = new ArrayList<CatalogReference>();
            String query = "select id from $\u0421\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a." + this.metaObject.getName() + " (nolock) where " + field + " like '" + value + "'";
            ArrayList<String> conditions = new ArrayList<String>();
            if (modeSubmission) {
                if (meta.getCountLevel() > 1) {
                    conditions.add("parentid = :parent");
                    rs.setParameter("parent", this.parent);
                }
                if (meta.getOwner() != null) {
                    conditions.add("parentext = :owner");
                    rs.setParameter("owner", this.owner);
                }
                Iterator iterator = conditions.iterator();
                while (iterator.hasNext()) {
                    query = String.valueOf(query) + " and " + (String)iterator.next();
                }
            }
            ResultSet result = rs.executeQuery(query);
            while (result.next()) {
                CatalogReference v = (CatalogReference)result.getRef(1, this.metaObject);
                sample.add(v);
            }
            return Collections.unmodifiableList(sample);
        }

        public List<CatalogReference> serchByName(String name, boolean modeSubmission) {
            Metadatas.Catalog meta = (Metadatas.Catalog)this.getMetaObject();
            if (meta.getLengthName() == 0) {
                throw new ExceptionAPI("\u0421\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a \u043d\u0435 \u0438\u043c\u0435\u0435\u0442 \u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u044f");
            }
            return this.serchByCodeName("descr", name, modeSubmission);
        }

        public CatalogObject newObject() {
            return new CatalogObject(this.metaObject);
        }
    }

    public class CatalogObject
    extends Obj
    implements Catalog {
        private boolean newObject;
        boolean isMark;
        private Date date;
        private boolean isFolder;
        private String code;
        private String name;
        private CatalogReference parent;
        private CatalogReference owner;
        private HashMap<String, Property> attributes;

        private void readPropertys() {
            this.readNonPeriodical();
            this.readPeriodical();
        }

        private void readPeriodical() {
            RecordSet rs = new RecordSet();
            Metadatas.Catalog meta = (Metadatas.Catalog)this.getMetaObject();
            List<Metadatas.Property> sample = meta.getPeriodicalPropertys();
            if (sample.size() == 0 || this.date == null) {
                return;
            }
            for (Metadatas.Property property : sample) {
                String query = "select $\u041f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0435\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435." + meta.getName() + "." + property.getName() + "(:id,:date)";
                rs.setParameter("id", this.getRef());
                rs.setParameter("date", this.date);
                ResultSet result = rs.executeQuery(query);
                result.next();
                this.attributes.put(property.getName(), result.getProperty(1, (Metadatas.Qualifier)property));
            }
        }

        private void readNonPeriodical() {
            RecordSet rs = new RecordSet();
            Metadatas.Catalog meta = (Metadatas.Catalog)this.getMetaObject();
            String query = "select t.ismark";
            if (meta.lengthCode > 0) {
                query = String.valueOf(query) + ", t.code";
            }
            if (meta.lengthName > 0) {
                query = String.valueOf(query) + ", t.descr";
            }
            if (meta.getCountLevel() > 1) {
                query = String.valueOf(query) + ", t.parentid, t.isfolder";
            }
            if (meta.getOwner() != null) {
                query = String.valueOf(query) + ", t.parentext";
            }
            for (Metadatas.Property property : meta.getNonPeriodicalPropertys()) {
                query = String.valueOf(query) + ", $t." + property.getName() + " as " + property.getName();
            }
            query = String.valueOf(query) + "\nfrom $\u0421\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a." + meta.getName() + " as t with (nolock) where t.id=:id";
            rs.setParameter("id", this.getRef());
            ResultSet result = rs.executeQuery(query);
            result.next();
            this.isMark = result.getBoolean("ismark");
            if (meta.getLengthCode() > 0) {
                this.code = result.getString("code");
            }
            if (meta.getLengthName() > 0) {
                this.name = result.getString("descr");
            }
            if (meta.getCountLevel() > 1) {
                this.parent = (CatalogReference)result.getRef("parentid", (Metadatas.Reference)this.getMetaObject());
                this.isFolder = result.getBoolean("isfolder");
            }
            if (meta.getOwner() != null) {
                this.owner = (CatalogReference)result.getRef("parentext", (Metadatas.Reference)meta.getOwner());
            }
            for (Metadatas.Property property : meta.getNonPeriodicalPropertys()) {
                this.attributes.put(property.getName(), result.getProperty(property.getName(), (Metadatas.Qualifier)property));
            }
        }

        public String toString() {
            Metadatas.Catalog meta = (Metadatas.Catalog)this.getMetaObject();
            switch (meta.getPresentation()) {
                case 1: {
                    return this.getCode();
                }
                case 2: {
                    return this.getName();
                }
            }
            return "";
        }

        @Override
        String getPrefix() {
            return String.format("%1$ 10d", ((Metadatas.Reference)this.getMetaObject()).getId());
        }

        public CatalogObject(String name) {
            super(V7.this.metaData.getCatalog(name));
            this.attributes = new HashMap();
            this.initAttribute();
        }

        private CatalogObject(Metadatas.Reference metaObject) {
            super(metaObject);
            this.attributes = new HashMap();
            this.initAttribute();
        }

        @Override
        public void setRef(Ref ref) {
            super.setRef(ref);
            if (ref instanceof Null) {
                this.initAttribute();
            } else {
                this.readPropertys();
            }
        }

        @Override
        public void newObject() {
            this.setRef(new NullCatalogReference((Metadatas.Reference)this.getMetaObject()));
            this.createCode();
            this.newObject = true;
        }

        private void initAttribute() {
            this.newObject = false;
            this.isMark = false;
            this.code = "";
            this.name = "\u043d\u043e\u0432\u044b\u0439";
            this.parent = new NullCatalogReference((Metadatas.Reference)this.getMetaObject());
            this.owner = new NullCatalogReference((Metadatas.Reference)this.getMetaObject());
            Metadatas.Catalog meta = (Metadatas.Catalog)this.getMetaObject();
            for (Metadatas.Property property : meta.getPropertys()) {
                this.attributes.put(property.getName(), new Property(property));
            }
        }

        private void createCode() {
            Metadatas.Catalog meta = (Metadatas.Catalog)this.getMetaObject();
            if (meta.getLengthCode() > 0) {
                this.startTransaction();
                this.blockX("sc" + this.metaObject.getId());
                RecordSet rs = new RecordSet();
                rs.setParameter("prefix", this.getPrefix());
                rs.setParameter("first", String.format("%1$0" + meta.getLengthCode() + "d", 0));
                ResultSet result = rs.executeQuery("select isnull(max(t.code),:first)\nfrom (select max(t1.code) as code\n\tfrom $\u0421\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a." + meta.getName() + " as t1 with (nolock)\n" + "\tunion\n" + "\tselect t2.docno as code from _1sdnlock as t2 where t2.dnprefix=:prefix) as t");
                result.next();
                this.code = this.generateNewNumber(result.getString(1));
                this.commitTransaction();
            }
        }

        public void setParent(CatalogReference parent) {
            Metadatas.Catalog meta = (Metadatas.Catalog)this.getMetaObject();
            if (meta.getCountLevel() == 1) {
                throw new ExceptionAPI("\u0421\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a '" + meta.toString() + "' \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043e\u0434\u043d\u043e\u0443\u0440\u043e\u0432\u043d\u0435\u0432\u044b\u043c");
            }
            if (parent.isFolder()) {
                throw new ExceptionAPI("\u042d\u043b\u0435\u043c\u0435\u043d\u0442 '" + parent + "' \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0433\u0440\u0443\u043f\u043f\u043e\u0439");
            }
            this.parent = parent;
        }

        public void setOwner(CatalogReference owner) {
            Metadatas.Catalog meta = (Metadatas.Catalog)this.getMetaObject();
            if (meta.getOwner() == null) {
                throw new ExceptionAPI("\u0421\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a '" + meta.toString() + "' \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043f\u043e\u0434\u0447\u0438\u043d\u0435\u043d\u043d\u044b\u043c");
            }
            if (!meta.getOwner().equals(owner.getMetaObject())) {
                throw new ExceptionAPI("\u0421\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a <" + meta.toString() + "> \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043f\u043e\u0434\u0447\u0438\u043d\u0435\u043d\u043d\u044b\u043c \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0443 " + "<" + ((Metadatas.Reference)owner.getMetaObject()).toString() + ">");
            }
            this.owner = owner;
        }

        public void setAttribute(String name, Object value, Date date, DocumentReference document) {
            try {
                this.attributes.get(name).setValue(value, date, document);
            }
            catch (NullPointerException e) {
                throw new ExceptionAPI("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e\u0435 \u0438\u043c\u044f \u0440\u0435\u043a\u0432\u0438\u0437\u0438\u0442\u0430");
            }
        }

        public void setAttribute(String name, Object value, Date date) {
            try {
                this.attributes.get(name).setValue(value, date);
            }
            catch (NullPointerException e) {
                throw new ExceptionAPI("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e\u0435 \u0438\u043c\u044f \u0440\u0435\u043a\u0432\u0438\u0437\u0438\u0442\u0430");
            }
        }

        public void setAttribute(String name, Object value) {
            try {
                this.attributes.get(name).setValue(value);
            }
            catch (NullPointerException e) {
                throw new ExceptionAPI("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e\u0435 \u0438\u043c\u044f \u0440\u0435\u043a\u0432\u0438\u0437\u0438\u0442\u0430");
            }
        }

        private List<Property> selectNonPeriodicalPropertys() {
            ArrayList<Property> result = new ArrayList<Property>();
            for (Property property : this.attributes.values()) {
                if (property.isPeriodical()) continue;
                result.add(property);
            }
            return Collections.unmodifiableList(result);
        }

        private List<Property> selectPeriodicalPropertys() {
            ArrayList<Property> result = new ArrayList<Property>();
            for (Property property : this.attributes.values()) {
                if (!property.isPeriodical()) continue;
                result.add(property);
            }
            return Collections.unmodifiableList(result);
        }

        private void constUpdate() {
            List<Property> sample = this.selectPeriodicalPropertys();
            if (sample.size() == 0) {
                return;
            }
            RecordSet rs = new RecordSet();
            this.block("_1sconst");
            for (Property property : sample) {
                String query = "delete from _1sconst where objid=:id and id=" + property.getId() + " and date=:date";
                rs.setParameter("date", property.getDate());
                rs.executeUpdate(query);
                query = "insert into _1sconst (objid,id,date,value,docid,time,actno,lineno_,tvalue)\nvalues (:id," + property.getId() + ",:date,:value,:doc,0,0,0,:tsp)";
                rs.setParameter("id", this.getRef());
                rs.setParameter("emptyRef", "     0   ");
                rs.setParameter("date", property.getDate());
                rs.setParameter("value", property);
                DocumentReference doc = property.getDocument();
                rs.setParameter("doc", doc);
                rs.setParameter("time", doc == null ? 0 : doc.getPosition().getSeconds());
                rs.setParameter("tsp", property.getTSP());
                rs.executeUpdate(query);
            }
        }

        private void scInsert() {
            Metadatas.Catalog meta = (Metadatas.Catalog)this.getMetaObject();
            RecordSet rs = new RecordSet();
            rs.setParameter("id", meta.getId());
            ResultSet result = rs.executeQuery("declare @id char(9)\nexec _1sp__1SUIDCTL_GetMaxID :id, @id output\nselect @id");
            result.next();
            int uMaxId = Integer.valueOf(result.getString(1).substring(0, 6).trim(), 36);
            result = rs.executeQuery("declare @id char(9)\nexec _1sp_SC" + meta.getId() + "_MaxID @id output\n" + "select @id");
            result.next();
            int cMaxId = Integer.valueOf(result.getString(1).substring(0, 6).trim(), 36);
            result = rs.executeQuery("select max(row_id) from $\u0421\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a." + meta.getName());
            result.next();
            int rowId = result.getInt(1);
            int newIdInt = Math.max(uMaxId, cMaxId);
            newIdInt = Math.max(newIdInt, rowId);
            String newId = String.format("%1$6S%2$3S", Integer.toString(++newIdInt, 36), V7.this._1ssystem.getDbsign());
            String query = "insert into $\u0421\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a." + ((Metadatas.Reference)this.getMetaObject()).getName() + " (id,ismark,verstamp";
            if (meta.getLengthCode() > 0) {
                query = String.valueOf(query) + ",code";
            }
            if (meta.getLengthName() > 0) {
                query = String.valueOf(query) + ",descr";
            }
            if (meta.getCountLevel() > 1) {
                query = String.valueOf(query) + ",parentid,isfolder";
            }
            if (meta.getOwner() != null) {
                query = String.valueOf(query) + ",parentext";
            }
            List<Property> sample = this.selectNonPeriodicalPropertys();
            for (Property property : sample) {
                query = String.valueOf(query) + ",sp" + property.getId();
                if (!property.isUndefine()) continue;
                query = String.valueOf(query) + ",tsp" + property.getId();
            }
            query = String.valueOf(query) + ") values (:id," + (this.isMark ? 1 : 0) + ",0";
            rs.setParameter("id", newId);
            if (meta.getLengthCode() > 0) {
                query = String.valueOf(query) + ",:code";
                rs.setParameter("code", this.getCode());
            }
            if (meta.getLengthName() > 0) {
                query = String.valueOf(query) + ",:descr";
                rs.setParameter("descr", this.getName());
            }
            if (meta.getCountLevel() > 1) {
                query = String.valueOf(query) + ",'" + meta.toInnerValue(this.parent) + "'," + (this.isFolder ? 1 : 2);
            }
            if (meta.getOwner() != null) {
                query = String.valueOf(query) + ",'" + meta.getOwner().toInnerValue(this.owner) + "'";
            }
            for (Property property : sample) {
                query = String.valueOf(query) + ",'" + property.toInnerValue() + "'";
                if (!property.isUndefine()) continue;
                query = String.valueOf(query) + ",'" + property.getTSP() + "'";
            }
            query = String.valueOf(query) + ")";
            rs.executeUpdate(query);
            rs.setParameter("id", meta.getId());
            rs.setParameter("newid", newId);
            rs.executeUpdate("exec _1sp__1SUIDCTL_SetMaxID :id, :newid");
            rs.setParameter("id", newId);
            result = rs.executeQuery("select * from sc" + this.metaObject.getId() + " (nolock) where id=:id");
            result.next();
            super.setRef((Ref)result.getRef("id", this.metaObject));
        }

        private void scUpdate() {
            RecordSet rs = new RecordSet();
            rs.executeUpdate("exec _1sp_SC" + ((Metadatas.Reference)this.getMetaObject()).getId() + "_TLockX");
            Metadatas.Catalog meta = (Metadatas.Catalog)this.getMetaObject();
            String query = "update $\u0421\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a." + meta.getName() + " set verstamp=verstamp+1";
            if (meta.getLengthCode() > 0) {
                query = String.valueOf(query) + ",code=:code";
                rs.setParameter("code", this.code);
            }
            if (meta.getLengthName() > 0) {
                query = String.valueOf(query) + ",descr=:name";
                rs.setParameter("name", this.name);
            }
            if (meta.getCountLevel() > 1) {
                query = String.valueOf(query) + ",parentid='" + meta.toInnerValue(this.parent) + "',isfolder=" + (this.isFolder ? 1 : 2);
            }
            if (meta.getOwner() != null) {
                query = String.valueOf(query) + ",parentext='" + meta.getOwner().toInnerValue(this.owner) + "'";
            }
            List<Property> sample = this.selectNonPeriodicalPropertys();
            for (Property property : sample) {
                query = String.valueOf(query) + ",sp" + property.getId() + "='" + property.toInnerValue() + "'";
                if (!property.isUndefine()) continue;
                query = String.valueOf(query) + ",tsp" + property.getId() + "='" + property.getTSP() + "'";
            }
            query = String.valueOf(query) + " where id=:id";
            rs.setParameter("id", this.getRef());
            rs.executeUpdate(query);
        }

        public void write() {
            if (this.newObject) {
                this.releaseNumber(this.code);
                this.startTransaction();
                this.blockX("sc" + this.metaObject.getId());
                this.scInsert();
                this.constUpdate();
                this.commitTransaction();
                this.newObject = false;
            } else if (!(this.getRef() instanceof Null)) {
                this.startTransaction();
                this.blockX("sc" + this.metaObject.getId());
                this.scUpdate();
                this.constUpdate();
                this.commitTransaction();
            } else {
                throw new ExceptionAPI("\u041e\u0431\u044a\u0435\u043a\u0442 \u043d\u0435 \u0441\u043f\u043e\u0437\u0438\u0446\u0438\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d");
            }
            this.notifyClients();
        }

        public void setCode(String code) {
            this.code = code;
        }

        @Override
        public String getCode() {
            return this.code.trim();
        }

        public void setName(String descr) {
            this.name = descr;
        }

        @Override
        public String getName() {
            return this.name.trim();
        }

        @Override
        public boolean isFolder() {
            return this.isFolder;
        }

        public void setFolder(boolean isFolder) {
            this.isFolder = isFolder;
        }

        @Override
        public Object getAttribute(String name) {
            return this.attributes.get(name).getValue();
        }

        @Override
        public Object getAttribute(int index) {
            Metadatas.Catalog meta = (Metadatas.Catalog)this.getMetaObject();
            return this.attributes.get(meta.getProperty(index).getName()).getValue();
        }

        @Override
        public boolean isMark() {
            return this.isMark;
        }

        @Override
        public CatalogReference getOwner() {
            return this.owner;
        }

        @Override
        public CatalogReference getParent() {
            return this.parent;
        }

        public void delete(boolean completely) {
            if (this.getRef() instanceof Null) {
                throw new ExceptionAPI("\u041e\u0431\u044a\u0435\u043a\u0442 \u043d\u0435 \u0441\u043f\u043e\u0437\u0438\u0446\u0438\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d");
            }
            this.startTransaction();
            this.blockX("sc" + this.metaObject.getId());
            RecordSet rs = new RecordSet();
            rs.setParameter("id", this.getRef());
            if (completely) {
                rs.executeUpdate("delete from $\u0421\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a." + ((Metadatas.Reference)this.getMetaObject()).getName() + " where id=:id");
            } else {
                rs.executeUpdate("update $\u0421\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a." + ((Metadatas.Reference)this.getMetaObject()).getName() + " set ismark=1 where id=:id");
            }
            this.commitTransaction();
        }

        @Override
        public void setDate(Date date) {
            this.date = date;
            this.readPeriodical();
        }
    }

    public class CatalogReference
    extends Ref
    implements Catalog {
        RecordSet rs;
        private Date date;

        public String toString() {
            Metadatas.Catalog meta = (Metadatas.Catalog)this.getMetaObject();
            this.rs.setParameter("id", this);
            ResultSet result = this.rs.executeQuery("exec _1sp_SC" + ((Metadatas.Reference)this.getMetaObject()).getId() + "_ByID :id");
            if (result.next()) {
                switch (meta.getPresentation()) {
                    case 0: {
                        return this.getCode();
                    }
                    case 1: {
                        return this.getName();
                    }
                }
                return "";
            }
            return "<\u041e\u0431\u044a\u0435\u043a\u0442 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d>(" + this.getId() + ")";
        }

        CatalogReference(String id, Metadatas.Reference metaObject) {
            super(id, metaObject);
            this.rs = new RecordSet();
            this.date = Calendar.getInstance().getTime();
        }

        public CatalogObject getObj() {
            CatalogObject obj = new CatalogObject((Metadatas.Reference)this.getMetaObject());
            obj.setRef(this);
            return obj;
        }

        @Override
        public String getCode() {
            Metadatas.Catalog meta = (Metadatas.Catalog)this.getMetaObject();
            if (meta.getLengthCode() == 0) {
                return "";
            }
            String query = "exec _1sp_SC" + ((Metadatas.Reference)this.getMetaObject()).getId() + "_ByID :id";
            this.rs.setParameter("id", this);
            ResultSet result = this.rs.executeQuery(query);
            if (result.next()) {
                return result.getString("code").trim();
            }
            return "";
        }

        @Override
        public String getName() {
            Metadatas.Catalog meta = (Metadatas.Catalog)this.getMetaObject();
            if (meta.getLengthName() == 0) {
                return "";
            }
            String query = "exec _1sp_SC" + ((Metadatas.Reference)this.getMetaObject()).getId() + "_ByID :id";
            this.rs.setParameter("id", this);
            ResultSet result = this.rs.executeQuery(query);
            if (result.next()) {
                return result.getString("descr").trim();
            }
            return "";
        }

        @Override
        public boolean isFolder() {
            Metadatas.Catalog meta = (Metadatas.Catalog)this.getMetaObject();
            if (meta.getCountLevel() == 1) {
                return false;
            }
            String query = "exec _1sp_SC" + ((Metadatas.Reference)this.getMetaObject()).getId() + "_ByID :id";
            this.rs.setParameter("id", this);
            ResultSet result = this.rs.executeQuery(query);
            if (result.next()) {
                return result.getInt("isfolder") == 1;
            }
            return false;
        }

        @Override
        public boolean isMark() {
            String query = "exec _1sp_SC" + ((Metadatas.Reference)this.getMetaObject()).getId() + "_ByID :id";
            this.rs.setParameter("id", this);
            ResultSet result = this.rs.executeQuery(query);
            if (result.next()) {
                return result.getInt("ismark") == 1;
            }
            return false;
        }

        @Override
        public CatalogReference getParent() {
            Metadatas.Catalog meta = (Metadatas.Catalog)this.getMetaObject();
            if (meta.getCountLevel() == 1) {
                return new NullCatalogReference((Metadatas.Reference)this.getMetaObject());
            }
            String query = "exec _1sp_SC" + ((Metadatas.Reference)this.getMetaObject()).getId() + "_ByID :id";
            this.rs.setParameter("id", this);
            ResultSet result = this.rs.executeQuery(query);
            if (result.next()) {
                return (CatalogReference)result.getRef("parentid", (Metadatas.Reference)this.getMetaObject());
            }
            return new NullCatalogReference((Metadatas.Reference)this.getMetaObject());
        }

        @Override
        public CatalogReference getOwner() {
            Metadatas.Catalog meta = (Metadatas.Catalog)this.getMetaObject();
            if (meta.getOwner() == null) {
                return new NullCatalogReference((Metadatas.Reference)this.getMetaObject());
            }
            String query = "exec _1sp_SC" + ((Metadatas.Reference)this.getMetaObject()).getId() + "_ByID :id";
            this.rs.setParameter("id", this);
            ResultSet result = this.rs.executeQuery(query);
            if (result.next()) {
                return (CatalogReference)result.getRef("parentext", (Metadatas.Reference)this.getMetaObject());
            }
            return new NullCatalogReference((Metadatas.Reference)this.getMetaObject());
        }

        public Object getAttribute(String name, Date date) {
            Metadatas.Catalog meta = (Metadatas.Catalog)this.getMetaObject();
            Metadatas.Property property = meta.getProperty(name);
            if (property == null) {
                throw new ExceptionAPI("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e\u0435 '" + name + "' \u0438\u043c\u044f \u0441\u0432\u043e\u0439\u0441\u0442\u0432\u0430");
            }
            if (!property.isPeriodical) {
                throw new ExceptionAPI("\u0421\u0432\u043e\u0439\u0441\u0442\u0432\u043e '" + name + "' \u043d\u0435 \u043f\u0435\u0440\u0438\u043e\u0434\u0438\u0447\u0435\u0441\u043a\u043e\u0435");
            }
            this.rs.setParameter("id", this);
            String query = "select $\u041f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0435\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435." + ((Metadatas.Reference)this.getMetaObject()).name + "." + name + "(:id,:date)";
            this.rs.setParameter("date", date);
            ResultSet result = this.rs.executeQuery(query);
            if (result.next()) {
                return result.getRef(1, (Metadatas.Reference)property);
            }
            return property.NullValue();
        }

        @Override
        public Object getAttribute(int index) {
            Metadatas.Catalog meta = (Metadatas.Catalog)this.getMetaObject();
            return this.getAttribute(meta.getProperty(index).getName());
        }

        @Override
        public Object getAttribute(String name) {
            Metadatas.Catalog meta = (Metadatas.Catalog)this.getMetaObject();
            Metadatas.Property property = meta.getProperty(name);
            if (property == null) {
                throw new ExceptionAPI("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e\u0435 \u0438\u043c\u044f \u0441\u0432\u043e\u0439\u0441\u0442\u0432\u0430 '" + name + "'");
            }
            if (property.isPeriodical && this.date == null) {
                throw new ExceptionAPI("\u0421\u0432\u043e\u0439\u0441\u0442\u0432\u043e <" + name + "> \u043f\u0435\u0440\u0438\u043e\u0434\u0438\u0447\u0435\u0441\u043a\u043e\u0435 \u0438 \u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430 \u0442\u0435\u043a\u0443\u0449\u0430\u044f \u0434\u0430\u0442\u0430 \u043f\u0435\u0440\u0438\u043e\u0434\u0438\u0447\u0435\u0441\u043a\u0438\u0445 \u0440\u0435\u043a\u0432\u0438\u0437\u0438\u0442\u043e\u0432");
            }
            if (!property.isPeriodical()) {
                String query = "exec _1sp_SC" + ((Metadatas.Reference)this.getMetaObject()).getId() + "_ByID :id";
                this.rs.setParameter("id", this);
                ResultSet result = this.rs.executeQuery(query);
                if (result.next()) {
                    return result.getRef("sp" + property.getId(), (Metadatas.Reference)property);
                }
                return property.NullValue();
            }
            String query = "select top 1 * from _1sconst (nolock) where id = " + property.getId() + " and objid = :id and date <= :date " + "order by date desc, time desc, docid desc, row_id desc";
            this.rs.setParameter("date", this.date);
            this.rs.setParameter("id", this);
            ResultSet result = this.rs.executeQuery(query);
            if (result.next()) {
                return result.getRef("value", (Metadatas.Reference)property);
            }
            return property.NullValue();
        }

        @Override
        public void setDate(Date date) {
            this.date = date;
        }

        private int getLevel(String id, int level) {
            String query = "exec _1sp_SC" + ((Metadatas.Reference)this.getMetaObject()).getId() + "_ByID :id";
            this.rs.setParameter("id", id);
            ResultSet result = this.rs.executeQuery(query);
            result.next();
            if (result.getString("parentid").equals("     0   ")) {
                return ++level;
            }
            return this.getLevel(result.getString(1), ++level);
        }

        public int getLevel() {
            Metadatas.Catalog meta = (Metadatas.Catalog)this.getMetaObject();
            if (meta.getCountLevel() == 1) {
                return 1;
            }
            return this.getLevel(this.getId(), 0);
        }

        @Override
        String getTypeId() {
            return "B1";
        }

        @Override
        String getVidId() {
            return String.format("%1$4S", Integer.toString(((Metadatas.Reference)this.getMetaObject()).getId(), 36));
        }
    }

    public static interface Document {
        public boolean isMark();

        public String getNumber();

        public Date getDate();

        public Object getAttribute(String var1);

        public Position getPosition();

        public boolean isClosed();
    }

    public class DocumentManager
    extends Manager {
        public DocumentManager(String name) {
            super(V7.this.metaData.getDocument(name));
        }

        public DocumentObject newObject() {
            DocumentObject obj = new DocumentObject(this.metaObject);
            obj.newObject();
            return obj;
        }

        public List<DocumentReference> serchByCode(String code, Date date) {
            String query;
            RecordSet rs = new RecordSet();
            Metadatas.Document meta = (Metadatas.Document)this.getMetaObject();
            int period = meta.getPeriodicalCode();
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            int year = cal.get(1);
            int month = cal.get(2);
            int day = cal.get(5);
            int quartal = month / 3;
            cal.clear();
            switch (period) {
                case 0: {
                    query = "select j.iddoc from _1sjourn as j with (nolock)\nwhere j.iddocdef=:doctype and j.docno like :code";
                    break;
                }
                case 1: {
                    query = "select j.iddoc from _1sjourn as j with (nolock)\nwhere iddocdef=:doctype and j.docno like :code\nand j.date_time_iddoc >=:from and j.date_time_iddoc<:to";
                    cal.set(1, year);
                    rs.setParameter("from", cal.getTime());
                    cal.roll(1, 1);
                    rs.setParameter("to", cal.getTime());
                    break;
                }
                case 2: {
                    query = "select j.iddoc from _1sjourn as j with (nolock)\nwhere iddocdef=:doctype and j.docno like :code\nand j.date_time_iddoc >=:from and j.date_time_iddoc<:to";
                    cal.set(1, year);
                    cal.set(2, quartal * 3);
                    rs.setParameter("from", cal.getTime());
                    cal.roll(2, 3);
                    rs.setParameter("to", cal.getTime());
                    break;
                }
                case 3: {
                    query = "select j.iddoc from _1sjourn as j with (nolock)\nwhere iddocdef=:doctype and j.docno like :code\nand j.date_time_iddoc >=:from and j.date_time_iddoc<:to";
                    cal.set(1, year);
                    cal.set(2, month);
                    rs.setParameter("from", cal.getTime());
                    cal.roll(2, 1);
                    rs.setParameter("to", cal.getTime());
                    break;
                }
                case 4: {
                    query = "select j.iddoc from _1sjourn as j with (nolock)\nwhere iddocdef=:doctype and j.docno like :code\nand j.date_time_iddoc >=:from and j.date_time_iddoc<:to";
                    cal.set(1, year);
                    cal.set(2, month);
                    cal.set(5, day);
                    rs.setParameter("from", cal.getTime());
                    cal.roll(5, 1);
                    rs.setParameter("to", cal.getTime());
                    break;
                }
                default: {
                    throw new ExceptionAPI("\u041d\u0435\u043e\u0436\u0438\u0434\u0430\u043d\u043d\u0430\u044f \u043f\u0435\u0440\u0438\u043e\u0434\u0438\u0447\u043d\u043e\u0441\u0442\u044c \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430");
                }
            }
            rs.setParameter("doctype", meta.getId());
            rs.setParameter("code", code);
            ArrayList<DocumentReference> list = new ArrayList<DocumentReference>();
            ResultSet result = rs.executeQuery(query);
            while (result.next()) {
                list.add((DocumentReference)result.getRef(1, (Metadatas.Reference)meta));
            }
            return Collections.unmodifiableList(list);
        }

        public List<DocumentReference> selectRefs() {
            try {
                Date from = new SimpleDateFormat("yyyyMMdd").parse("17530101");
                Date to = Calendar.getInstance().getTime();
                return this.selectObjects(from, to);
            }
            catch (ParseException e) {
                throw new ExceptionAdapter(e);
            }
        }

        public List<DocumentReference> selectObjects(Date from, Date to) {
            RecordSet rs = new RecordSet();
            ArrayList<DocumentReference> sample = new ArrayList<DocumentReference>();
            String query = "select t.iddoc as iddoc from $\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442." + this.metaObject.getName() + " as t with (nolock)\n" + "inner join _1sjourn as j with (nolock) on j.iddoc=t.iddoc\n" + "where j.date_time_iddoc > :from and j.date_time_iddoc < :to~";
            rs.setParameter("from", from);
            rs.setParameter("to", to);
            ResultSet result = rs.executeQuery(query);
            while (result.next()) {
                DocumentReference v = (DocumentReference)result.getRef("iddoc", this.metaObject);
                sample.add(v);
            }
            return Collections.unmodifiableList(sample);
        }
    }

    public class DocumentObject
    extends Obj
    implements Document {
        private boolean newObject;
        private OperationReference operation;
        private int action;
        private int row;
        private HashSet<Metadatas.Register> movementRegisters;
        private boolean changeDatail;
        private boolean isPeriodic;
        private boolean createOperation;
        private boolean writeOperation;
        private boolean isMark;
        private Date date;
        private String number;
        private boolean isClosed;
        private boolean closing;
        private HashMap<String, Property> cAttributes;
        private HashMap<String, Property> attributes;
        private ArrayList<DocumentString> details;
        Metadatas.Document meta;

        public void setDate(Date date) {
            this.date = date;
        }

        public void setNumber(String number) {
            this.number = number;
        }

        public void setRow(int row) {
            this.row = row;
        }

        public void setCreateOperation(boolean createOperation) {
            Metadatas.Document meta = (Metadatas.Document)this.getMetaObject();
            if (meta.getCreateOperation() == 1) {
                this.createOperation = createOperation;
            }
        }

        public boolean isCreateOperation() {
            return this.createOperation;
        }

        private void journRead() {
            List cPropertys = V7.this.metaData.selectTypes("\u041e\u0431\u0449\u0438\u0439\u0420\u0435\u043a\u0432\u0438\u0437\u0438\u0442");
            String query = "select * from _1sjourn (nolock) where iddoc=:iddoc";
            RecordSet rs = new RecordSet();
            rs.setParameter("iddoc", this.getRef());
            ResultSet result = rs.executeQuery(query);
            boolean existOperation = false;
            if (result.next()) {
                this.date = new Position(result.getString("date_time_iddoc")).getDate();
                this.number = result.getString("docno");
                this.isClosed = (result.getInt("closed") & 1) == 1;
                this.isMark = result.getBoolean("ismark");
                this.isPeriodic = (result.getInt("appcode") & 8) == 8;
                existOperation = (result.getInt("appcode") & 0x10) == 16;
                this.writeOperation = (result.getInt("appcode") & 0x20) == 32;
                for (Metadatas.CommonProperty cProperty : cPropertys) {
                    if (!cProperty.isSelection()) continue;
                    this.cAttributes.put(cProperty.getName(), result.getProperty("sp" + cProperty.getId(), (Metadatas.Qualifier)cProperty));
                }
                List registers = V7.this.metaData.selectTypes("\u0420\u0435\u0433\u0438\u0441\u0442\u0440");
                for (Metadatas.Register reg : registers) {
                    if (!result.getBoolean("rf" + reg.getId())) continue;
                    this.movementRegisters.add(reg);
                }
            }
            if (existOperation) {
                result = rs.executeQuery("select * from _1soper (nolock) where docid=:iddoc");
                result.next();
                this.operation = new OperationReference(result.getString("docid"));
            } else {
                this.operation = new NullOperationReference();
            }
        }

        private void dhRead() {
            Metadatas.Document meta = (Metadatas.Document)this.getMetaObject();
            List cPropertys = V7.this.metaData.selectTypes("\u041e\u0431\u0449\u0438\u0439\u0420\u0435\u043a\u0432\u0438\u0437\u0438\u0442");
            List<Metadatas.Qualifier> hPropertys = meta.getPropertys();
            String query = "select * from $\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442." + meta.getName() + " (nolock) where iddoc=:id";
            RecordSet rs = new RecordSet();
            rs.setParameter("id", this.getRef());
            ResultSet result = rs.executeQuery(query);
            if (result.next()) {
                for (Metadatas.CommonProperty cProperty : cPropertys) {
                    if (cProperty.isSelection()) continue;
                    this.cAttributes.put(cProperty.getName(), result.getProperty("sp" + cProperty.getId(), (Metadatas.Qualifier)cProperty));
                }
                for (Metadatas.Qualifier hProperty : hPropertys) {
                    this.attributes.put(hProperty.getName(), result.getProperty("sp" + hProperty.getId(), hProperty));
                }
            }
        }

        private void dtRead() {
            this.details.clear();
            Metadatas.Document meta = (Metadatas.Document)this.getMetaObject();
            if (meta.getDetail().size() == 0) {
                return;
            }
            String query = "select * from $\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0421\u0442\u0440\u043e\u043a\u0438." + meta.getName() + " (nolock) where iddoc=:id order by lineno_";
            RecordSet rs = new RecordSet();
            rs.setParameter("id", this.getRef());
            ResultSet result = rs.executeQuery(query);
            while (result.next()) {
                DocumentString row = new DocumentString((Metadatas.Document)this.getMetaObject());
                row.readAttributes(result);
                this.details.add(row);
            }
        }

        @Override
        public void setRef(Ref ref) {
            super.setRef(ref);
            if (ref instanceof Null) {
                this.initAttributes();
            } else {
                this.readAttibute();
            }
        }

        public DocumentObject(String metaName) {
            super(V7.this.metaData.getDocument(metaName));
            this.action = 0;
            this.movementRegisters = new HashSet();
            this.cAttributes = new HashMap();
            this.attributes = new HashMap();
            this.details = new ArrayList();
            this.meta = (Metadatas.Document)this.getMetaObject();
            this.initAttributes();
        }

        private DocumentObject(Metadatas.Reference metaObject) {
            super(metaObject);
            this.action = 0;
            this.movementRegisters = new HashSet();
            this.cAttributes = new HashMap();
            this.attributes = new HashMap();
            this.details = new ArrayList();
            this.meta = (Metadatas.Document)this.getMetaObject();
            this.initAttributes();
        }

        private void readAttibute() {
            this.journRead();
            this.dhRead();
            this.dtRead();
        }

        @Override
        public void newObject() {
            this.setRef(new NullDocumentReference((Metadatas.Reference)this.getMetaObject()));
            this.createNumber();
            this.newObject = true;
        }

        private int getClose() {
            Metadatas.Document meta = (Metadatas.Document)this.getMetaObject();
            int close = 0;
            if (this.isClosed) {
                ++close;
            }
            if (meta.isAccountingRecording()) {
                close += 4;
            }
            return close;
        }

        private int getAppCode() {
            Metadatas.Document meta = (Metadatas.Document)this.getMetaObject();
            int appCode = 0;
            if (meta.isOperativeRecording()) {
                ++appCode;
            }
            if (meta.isStaffRecording()) {
                appCode += 2;
            }
            if (meta.isAccountingRecording()) {
                appCode += 4;
            }
            if (this.isPeriodic) {
                appCode += 8;
            }
            if (!(this.operation instanceof Null)) {
                appCode += 16;
            }
            if (this.writeOperation) {
                appCode += 32;
            }
            return appCode;
        }

        private void initAttributes() {
            this.newObject = false;
            this.isMark = false;
            this.date = new Date(System.currentTimeMillis());
            this.number = "";
            this.createOperation = false;
            this.operation = new NullOperationReference();
            Metadatas.Document meta = (Metadatas.Document)this.getMetaObject();
            this.attributes.clear();
            List sample = V7.this.metaData.selectTypes("\u041e\u0431\u0449\u0438\u0439\u0420\u0435\u043a\u0432\u0438\u0437\u0438\u0442");
            for (Metadatas.CommonProperty property : sample) {
                this.cAttributes.put(property.getName(), new Property(property));
            }
            List<Metadatas.Qualifier> sample2 = meta.getPropertys();
            for (Metadatas.Qualifier property : sample2) {
                this.attributes.put(property.getName(), new Property(property));
            }
        }

        private void createNumber() {
            this.startTransaction();
            this.blockX("_1sjourn");
            Metadatas.Document meta = (Metadatas.Document)this.getMetaObject();
            RecordSet rs = new RecordSet();
            rs.setParameter("prefix", this.getPrefix());
            rs.setParameter("startno", String.format("%1$0" + meta.getLengthCode() + "d", 0));
            rs.setParameter("viddoc", meta.id);
            ResultSet result = rs.executeQuery("declare @docnum char(24)\nselect isnull(max(docno),:startno) from\n(select max(docno) as docno from _1sjourn with (nolock) where iddocdef=:viddoc and dnprefix=:prefix\nunion\nselect docno as docno from _1sdnlock with (nolock) where dnprefix=:prefix) as tmp");
            result.next();
            this.number = this.generateNewNumber(result.getString(1));
            this.commitTransaction();
        }

        private List<Map.Entry<Integer, Property>> getParentDocuments() {
            ArrayList<Map.Entry<Integer, Property>> result = new ArrayList<Map.Entry<Integer, Property>>();
            for (Property property : this.cAttributes.values()) {
                this.addParent(result, property);
            }
            for (Property property : this.attributes.values()) {
                this.addParent(result, property);
            }
            for (DocumentString row : this.details) {
                for (Property property : row.attributes.values()) {
                    this.addParent(result, property);
                }
            }
            return Collections.unmodifiableList(result);
        }

        private void addParent(ArrayList<Map.Entry<Integer, Property>> result, Property property) {
            if (property.getValue() instanceof DocumentReference) {
                boolean exist = false;
                Iterator<Map.Entry<Integer, Property>> m = result.iterator();
                while (m.hasNext()) {
                    if (!m.next().getValue().equals(property)) continue;
                    exist = true;
                    break;
                }
                if (!exist) {
                    result.add(new AbstractMap.SimpleEntry<Integer, Property>(0, property));
                }
            }
        }

        private void journUpdate() {
            RecordSet rs = new RecordSet();
            String query = "update _1sjourn set date_time_iddoc=:position~,appcode=:appcode,docno=:docno, closed=:closed, ismark=:ismark, verstamp=verstamp+1";
            ArrayList<Property> cPropertys = new ArrayList<Property>();
            for (Property property : this.cAttributes.values()) {
                if (!((Metadatas.CommonProperty)property.getMetaObject()).isSelection()) continue;
                cPropertys.add(property);
            }
            for (Property property : cPropertys) {
                query = String.valueOf(query) + ",sp" + property.getId() + "='" + property.toInnerValue() + "'";
                if (!property.isUndefine()) continue;
                query = String.valueOf(query) + ",tsp" + property.getId() + "='" + property.getTSP() + "'";
            }
            for (Metadatas.Register register : this.movementRegisters) {
                query = String.valueOf(query) + ",rf" + register.getId() + "=1";
            }
            query = String.valueOf(query) + "\nwhere iddoc=:id";
            rs.setParameter("position", this.getPosition());
            rs.setParameter("appcode", this.getAppCode());
            rs.setParameter("id", ((Ref)this.getRef()).getId());
            rs.setParameter("docno", this.getNumber());
            rs.setParameter("closed", this.getClose());
            rs.setParameter("ismark", this.isMark() ? 1 : 0);
            rs.executeUpdate(query);
            this.crdocWrite(1, this.date, this.getParentDocuments());
            this.crdocWrite(1, this.date, this.getSelectects(cPropertys));
        }

        private void dhUpdate() {
            Metadatas.Document meta = (Metadatas.Document)this.getMetaObject();
            String query = "update $\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442." + meta.getName() + "\n" + "set iddoc=:id";
            ArrayList<Property> cPropertys = new ArrayList<Property>();
            for (Property property : this.cAttributes.values()) {
                if (((Metadatas.CommonProperty)property.getMetaObject()).isSelection()) continue;
                cPropertys.add(property);
                query = String.valueOf(query) + ",sp" + property.getId() + "='" + property.toInnerValue() + "'";
                if (!property.isUndefine()) continue;
                query = String.valueOf(query) + ",tsp" + property.getId() + "='" + property.getTSP() + "'";
            }
            for (Property property : this.attributes.values()) {
                cPropertys.add(property);
                query = String.valueOf(query) + ",sp" + property.getId() + "='" + property.toInnerValue() + "'";
                if (!property.isUndefine()) continue;
                query = String.valueOf(query) + ",tsp" + property.getId() + "='" + property.getTSP() + "'";
            }
            for (Metadatas.TableProperty tableProperty : meta.detail) {
                if (!tableProperty.isTotal()) continue;
                query = String.valueOf(query) + ",sp" + tableProperty.getId() + "='" + this.total(tableProperty.getName()) + "'";
            }
            query = String.valueOf(query) + " where iddoc=:id";
            RecordSet rs = new RecordSet();
            rs.setParameter("id", this.getRef());
            rs.executeUpdate(query);
            this.crdocWrite(1, this.date, this.getParentDocuments());
            this.crdocWrite(1, this.date, this.getSelectects(cPropertys));
        }

        public void removeRow(int indexRow) {
            if (indexRow >= this.details.size() || indexRow < 0) {
                throw new ExceptionAPI("\u0418\u043d\u0434\u0435\u043a\u0441 \u0441\u0442\u0440\u043e\u043a\u0438 \u043d\u0435 \u0432\u0445\u043e\u0434\u0438\u0442 \u0432 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d \u043d\u043e\u043c\u0435\u0440\u043e\u0432 \u0441\u0442\u0440\u043e\u043a \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430");
            }
            this.details.remove(indexRow);
            this.changeDatail = true;
        }

        public DocumentString newString() {
            return new DocumentString((Metadatas.Document)this.getMetaObject());
        }

        public void putRow(DocumentString row) {
            this.details.add(row);
            this.changeDatail = true;
        }

        public void clearRow() {
            this.details.clear();
            this.changeDatail = true;
        }

        public List<DocumentString> getRows() {
            return Collections.unmodifiableList(this.details);
        }

        public DocumentString getRow(int indexRow) {
            if (indexRow >= this.details.size() || indexRow < 0) {
                throw new ExceptionAPI("\u0418\u043d\u0434\u0435\u043a\u0441 \u0441\u0442\u0440\u043e\u043a\u0438 \u043d\u0435 \u0432\u0445\u043e\u0434\u0438\u0442 \u0432 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d \u043d\u043e\u043c\u0435\u0440\u043e\u0432 \u0441\u0442\u0440\u043e\u043a \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430");
            }
            return this.details.get(indexRow);
        }

        public int countRows() {
            return this.details.size();
        }

        private void dtUpdate() {
            if (!this.changeDatail) {
                return;
            }
            Metadatas.Document meta = (Metadatas.Document)this.getMetaObject();
            String query = "delete from $\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0421\u0442\u0440\u043e\u043a\u0438." + meta.getName() + " where iddoc=:iddoc\n";
            RecordSet rs = new RecordSet();
            rs.setParameter("iddoc", ((Ref)this.getRef()).id);
            rs.executeUpdate(query);
            ArrayList<Property> cProperties = new ArrayList<Property>();
            int line = 1;
            Iterator<DocumentString> k = this.details.iterator();
            while (k.hasNext()) {
                query = "insert into $\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0421\u0442\u0440\u043e\u043a\u0438." + meta.getName() + " " + "(iddoc,lineno_";
                String strValues = "," + line++;
                DocumentString row = k.next();
                for (Property property : row.attributes.values()) {
                    cProperties.add(property);
                    query = String.valueOf(query) + ",sp" + property.getId();
                    strValues = String.valueOf(strValues) + ",'" + property.toInnerValue() + "'";
                    if (!property.isUndefine()) continue;
                    query = String.valueOf(query) + ",tsp" + property.getId();
                    strValues = String.valueOf(strValues) + ",'" + property.getTSP() + "'";
                }
                query = String.valueOf(query) + ") values(:iddoc" + strValues + ")";
                rs.setParameter("iddoc", ((Ref)this.getRef()).id);
                rs.executeUpdate(query);
            }
            this.crdocWrite(1, this.date, this.getParentDocuments());
            this.crdocWrite(1, this.date, this.getSelectects(cProperties));
        }

        protected void closing() {
        }

        protected void setPropertyCatalog(CatalogReference catalog, String nameProperty, Object value, Date date, String nameType, int length, int precision) {
            Metadatas.Catalog meta = (Metadatas.Catalog)catalog.getMetaObject();
            Metadatas.Property property = meta.getProperty(nameProperty);
            if (property == null) {
                throw new ExceptionAPI("\u0423 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430 '" + meta.getName() + "' \u043d\u0435\u0442 \u0440\u0435\u043a\u0432\u0438\u0437\u0438\u0442\u0430 '" + nameProperty + "'");
            }
            if (!property.isPeriodical()) {
                throw new ExceptionAPI("\u0423 \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a\u0430 '" + meta.getName() + "' \u0440\u0435\u043a\u0432\u0438\u0437\u0438\u0442 '" + nameProperty + "' \u043d\u0435 \u044f\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u043f\u0435\u0440\u0438\u043e\u0434\u0438\u0447\u0435\u0441\u043a\u0438\u043c");
            }
            if (this.closing) {
                throw new ExceptionAPI("\u041c\u0435\u0442\u043e\u0434 \u043c\u043e\u0436\u043d\u043e \u0432\u044b\u0437\u044b\u0432\u0430\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u0438\u0437 \u043c\u043e\u0434\u0443\u043b\u044f \u043f\u0440\u043e\u0432\u0435\u0434\u0435\u043d\u0438\u044f");
            }
            String query = "update _1sjourn set appcode=appcode|8\ninsert into _1sconst (objid, id, date, value, docid, time, actno, lineno_,tvalue)\nvalues (:objid,:id,:date~~,'" + property.toInnerValue(value) + "',:docid,:time,:actno,:row,'   ')";
            RecordSet rs = new RecordSet();
            rs.setParameter("objid", catalog);
            rs.setParameter("id", property.getId());
            rs.setParameter("date", date);
            rs.setParameter("docid", this.getRef());
            rs.setParameter("time", this.getPosition().getSeconds());
            rs.setParameter("actno", ++this.action);
            rs.setParameter("row", this.row);
            rs.executeUpdate(query);
            this.isPeriodic = true;
        }

        public void close() {
            Metadatas.Document meta = (Metadatas.Document)this.getMetaObject();
            if (this.getRef() instanceof Null) {
                throw new ExceptionAPI("\u041e\u0431\u044a\u0435\u043a\u0442 \u043d\u0435 \u0441\u043f\u043e\u0437\u0438\u0446\u0438\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d");
            }
            if (this.isMark()) {
                throw new ExceptionAPI("\u0423\u0434\u0430\u043b\u0435\u043d\u043d\u044b\u0439 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u043d\u0435 \u043c\u043e\u0436\u0435\u0442 \u0431\u044b\u0442\u044c \u043f\u0440\u043e\u0432\u0435\u0434\u0435\u043d");
            }
            if (!meta.isPermitClose()) {
                throw new ExceptionAPI("\u0417\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e \u043f\u0440\u043e\u0432\u0435\u0434\u0435\u043d\u0438\u0435 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430");
            }
            this.startTransaction();
            this.blockX("_1sjourn");
            if (this.isClosed && meta.isAutoDeleteMovements()) {
                this._deleteMovements();
            }
            if (meta.isAccountingRecording()) {
                this.block("_1soper");
                if (this.operation instanceof Null && meta.getCreateOperation() == 2 || meta.getCreateOperation() == 1 && this.createOperation) {
                    OperationObject operObj = new OperationObject(this);
                    operObj._write();
                    this.operation = (OperationReference)operObj.getRef();
                }
            }
            if (meta.isOperativeRecording()) {
                this.block("_1ssystem");
            }
            meta.isStaffRecording();
            this.closing = true;
            this.closing();
            this.closing = false;
            this.isClosed = true;
            this.journUpdate();
            this.systemUpdate();
            this.streamUpdate();
            this.commitTransaction();
            this.notifyClients();
        }

        private void systemUpdate() {
            RecordSet rs = new RecordSet();
            ResultSet result = rs.executeQuery("select * from _1ssystem(nolock)");
            result.next();
            Date curDate = result.getDate("curdate");
            int curTime = result.getInt("curtime") / 10000;
            Position pos1 = new Position(((Ref)this.getRef()).getId(), curDate, curTime, 0);
            Position pos2 = new Position(((Ref)this.getRef()).getId(), this.getDate(), 0);
            if (pos2.after(pos1)) {
                rs.setParameter("curdate", pos2.getBeginningDay());
                rs.setParameter("curtime", pos2.getSeconds() * 10000);
                rs.setParameter("id", this.getRef());
                rs.executeUpdate("update _1ssystem set curdate=:curdate~~, curtime=:curtime, eventidta=:id");
            }
        }

        private void streamUpdate() {
            List strems = V7.this.metaData.selectTypes("\u041f\u043e\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c");
            for (Metadatas.Stream stream : strems) {
                if (!stream.documents.contains(this.getMetaObject())) continue;
                RecordSet rs = new RecordSet();
                rs.setParameter("id", stream.getId());
                ResultSet result = rs.executeQuery("select * from _1sstream(nolock) where id=:id");
                if (result.next()) {
                    Position posStream = new Position(result.getString("date_time_docid"));
                    if (this.getPosition().after(posStream)) {
                        return;
                    }
                }
                if (!this.existMoves(stream)) continue;
                rs.setParameter("doc", this.getRef());
                rs.setParameter("id", stream.getId());
                rs.executeUpdate("Update _1SSTREAM set DATE_TIME_DOCID=:doc~~~~ where ID=:id; If @@ROWCOUNT = 0 Insert into _1SSTREAM (ID, DATE_TIME_DOCID) values(:id, :doc~~~~)");
            }
        }

        private boolean existMoves(Metadatas.Stream stream) {
            Iterator<Metadatas.Register> r = this.movementRegisters.iterator();
            while (r.hasNext()) {
                Iterator<Metadatas.Dimension> d = r.next().getDimensions().iterator();
                while (d.hasNext()) {
                    if (!stream.getRegisters().contains(d.next())) continue;
                    return true;
                }
            }
            if (!(this.operation instanceof Null)) {
                List<Entry> entrys = this.operation.getEntrys();
                for (Entry entry : entrys) {
                    AccountReference accRef = entry.getDebit().getAccount();
                    if (accRef.defineConfiguration() && stream.registers.contains(accRef.getMetaAccount())) {
                        return true;
                    }
                    accRef = entry.getKredit().getAccount();
                    if (!accRef.defineConfiguration() || !stream.registers.contains(accRef.getMetaAccount())) continue;
                    return true;
                }
            }
            return false;
        }

        public void cancelClose() {
            Metadatas.Document meta = (Metadatas.Document)this.getMetaObject();
            if (this.getRef() instanceof Null) {
                throw new ExceptionAPI("\u041e\u0431\u044a\u0435\u043a\u0442 \u043d\u0435 \u0441\u043f\u043e\u0437\u0438\u0446\u0438\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d");
            }
            if (!this.isClosed()) {
                throw new ExceptionAPI("\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u043d\u0435 \u043f\u0440\u043e\u0432\u0435\u0434\u0435\u043d");
            }
            this.startTransaction();
            this.blockX("_1sjourn");
            this._deleteMovements();
            if (meta.isAccountingRecording()) {
                this.block("_1soper");
                if (!(this.operation instanceof Null) && meta.getCreateOperation() == 2 || meta.getCreateOperation() == 1 && !this.createOperation) {
                    OperationObject operObj = new OperationObject(this);
                    operObj.delete();
                    this.operation = new NullOperationReference();
                }
            }
            if (meta.isOperativeRecording()) {
                this.block("_1ssystem");
            }
            meta.isStaffRecording();
            this.isClosed = false;
            this.action = 0;
            this.journUpdate();
            this.streamUpdate();
            this.commitTransaction();
            this.notifyClients();
        }

        @Override
        String getPrefix() {
            String prefix;
            Metadatas.Document meta = (Metadatas.Document)this.getMetaObject();
            Calendar cal = Calendar.getInstance();
            cal.setTime(this.date);
            switch (meta.getPeriodicalCode()) {
                case 0: {
                    prefix = String.format("%1$10d%2$8S", meta.id, "");
                    break;
                }
                case 1: {
                    prefix = String.format("%1$10d%2$-8d", meta.id, cal.get(1));
                    break;
                }
                case 2: {
                    prefix = String.format("%1$10d%2$4d%3$02d  ", meta.id, cal.get(1), cal.get(2) / 3 + 1);
                    break;
                }
                case 3: {
                    prefix = String.format("%1$10d%2$4d%3$02d  ", meta.id, cal.get(1), cal.get(2) + 1);
                    break;
                }
                case 4: {
                    prefix = String.format("%1$10d%2$4d%3$02d%4$02d", meta.id, cal.get(1), cal.get(2) + 1, cal.get(5));
                    break;
                }
                default: {
                    throw new ExceptionAPI("\u041d\u0435\u043e\u0436\u0438\u0434\u0430\u043d\u043d\u0430\u044f \u043f\u0435\u0440\u0438\u043e\u0434\u0438\u0447\u043d\u043e\u0441\u0442\u044c \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430");
                }
            }
            return prefix;
        }

        private String createNewId() {
            String query = "select max(row_id),left(max(iddoc),6) from _1sjourn with (nolock)";
            RecordSet rs = new RecordSet();
            ResultSet result = rs.executeQuery(query);
            int maxRowId = 0;
            int maxIdJourn = 0;
            result.next();
            maxRowId = result.getInt(1);
            maxIdJourn = Integer.valueOf(result.getString(2).trim(), 36);
            query = "declare @iddoc char(9)\ndeclare @dbsign char(3)\nset @iddoc = null\nset @dbsign = null\nexec  _1sp__1SUIDCTL_GetMaxID 0, @iddoc output\nselect @dbsign=dbsign from _1ssystem\nselect @iddoc, @dbsign";
            result = rs.executeQuery(query);
            int maxIdDctl = 0;
            String dbsign = null;
            result.next();
            maxIdDctl = Integer.valueOf(result.getString(1).substring(0, 6).trim(), 36);
            dbsign = result.getString(2);
            int id = maxIdJourn;
            if (id < maxRowId) {
                id = maxRowId;
            }
            if (id < maxIdDctl) {
                id = maxIdDctl;
            }
            return String.format("%1$6S%2$3S", Integer.toString(++id, 36), dbsign);
        }

        private void dhInsert() {
            String query = "insert into $\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442." + this.meta.getName() + "(iddoc";
            String strValues = ":iddoc";
            ArrayList<Property> cProperties = new ArrayList<Property>();
            for (Property property : this.cAttributes.values()) {
                if (((Metadatas.CommonProperty)property.getMetaObject()).isSelection()) continue;
                cProperties.add(property);
                query = String.valueOf(query) + ",sp" + property.getId();
                strValues = String.valueOf(strValues) + ",'" + property.toInnerValue() + "'";
                if (!property.isUndefine()) continue;
                query = String.valueOf(query) + ",tsp" + property.getId();
                strValues = String.valueOf(strValues) + ",'" + property.getTSP() + "'";
            }
            for (Property property : this.attributes.values()) {
                cProperties.add(property);
                query = String.valueOf(query) + ",sp" + property.getId();
                strValues = String.valueOf(strValues) + ",'" + property.toInnerValue() + "'";
                if (!property.isUndefine()) continue;
                query = String.valueOf(query) + ",tsp" + property.getId();
                strValues = String.valueOf(strValues) + ",'" + property.getTSP() + "'";
            }
            for (Metadatas.TableProperty tableProperty : this.meta.detail) {
                if (!tableProperty.isTotal()) continue;
                query = String.valueOf(query) + ",sp" + tableProperty.id;
                strValues = String.valueOf(strValues) + "," + this.total(tableProperty.getName());
            }
            query = String.valueOf(query) + ") values(" + strValues + ")";
            RecordSet rs = new RecordSet();
            rs.setParameter("iddoc", ((Ref)this.getRef()).id);
            rs.executeUpdate(query);
            this.crdocWrite(1, this.date, this.getParentDocuments());
            this.crdocWrite(1, this.date, this.getSelectects(cProperties));
        }

        public BigDecimal total(String name) {
            Metadatas.Document meta = (Metadatas.Document)this.getMetaObject();
            Metadatas.TableProperty property = meta.getPropertyDetail(name);
            if (property == null) {
                throw new ExceptionAPI("\u0420\u0435\u043a\u0432\u0438\u0437\u0438\u0442 \u0442\u0430\u0431\u043b\u0438\u0447\u043d\u043e\u0439 \u0447\u0430\u0441\u0442\u0438 \u0441 \u0438\u043c\u0435\u043d\u0435\u043c '" + name + "' \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442");
            }
            if (!property.isTotal()) {
                throw new ExceptionAPI("\u0423 \u0440\u0435\u043a\u0432\u0438\u0437\u0438\u0442 \u0442\u0430\u0431\u043b\u0438\u0447\u043d\u043e\u0439 \u0447\u0430\u0441\u0442\u0438 \u0441 \u0438\u043c\u0435\u043d\u0435\u043c '" + name + "' \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0441\u0432\u043e\u0439\u0441\u0442\u0432\u043e \u0440\u0430\u0441\u0447\u0435\u0442\u0430 \u043f\u043e \u043a\u043e\u043b\u043e\u043d\u043a\u0435");
            }
            BigDecimal total = BigDecimal.valueOf(0L);
            for (DocumentString row : this.details) {
                BigDecimal value = (BigDecimal)row.getAttribute(property.getName());
                total.add(value);
            }
            return total;
        }

        private void journInsert() {
            RecordSet rs = new RecordSet();
            rs.setRPC(true);
            String newId = this.createNewId();
            Metadatas.Document meta = (Metadatas.Document)this.getMetaObject();
            String query = "insert into _1sjourn (idjournal,iddoc,iddocdef,appcode,date_time_iddoc,dnprefix,docno,closed,ismark,actcnt,verstamp";
            String strValues = ":journal,:iddoc,:iddocdef,:appcode,:position~,:prefix,:number,:closed,:ismark,:actcnt,:verstamp";
            List registers = V7.this.metaData.selectTypes("\u0420\u0435\u0433\u0438\u0441\u0442\u0440");
            List streams = V7.this.metaData.selectTypes("\u041f\u043e\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u044c");
            for (Metadatas.Reference reg : registers) {
                query = String.valueOf(query) + ",rf" + reg.id;
                strValues = String.valueOf(strValues) + ",0";
            }
            ArrayList<Property> cPropertys = new ArrayList<Property>();
            for (Property property : this.cAttributes.values()) {
                if (!((Metadatas.CommonProperty)property.getMetaObject()).isSelection()) continue;
                cPropertys.add(property);
            }
            for (Property property : cPropertys) {
                query = String.valueOf(query) + ",sp" + property.getId();
                strValues = String.valueOf(strValues) + ",'" + property.toInnerValue() + "'";
                if (!property.isUndefine()) continue;
                query = String.valueOf(query) + ",tsp" + property.getTSP();
                strValues = String.valueOf(strValues) + ",'" + property.getTSP() + "'";
            }
            for (Metadatas.Stream stream : streams) {
                query = String.valueOf(query) + ",ds" + stream.id;
                strValues = String.valueOf(strValues) + "," + (stream.documents.contains(meta) ? "1" : "0");
            }
            query = String.valueOf(query) + ") values(" + strValues + ")";
            rs.setParameter("iddoc", newId);
            rs.setParameter("position", new Position(newId, this.getDate(), 0));
            rs.setParameter("appcode", this.getAppCode());
            rs.setParameter("prefix", this.getPrefix());
            rs.setParameter("iddocdef", meta.getId());
            rs.setParameter("journal", meta.getJournal());
            rs.setParameter("number", this.number);
            rs.setParameter("closed", this.getClose());
            rs.setParameter("actcnt", 0);
            rs.setParameter("verstamp", 0);
            rs.setParameter("ismark", 0);
            rs.executeUpdate(query);
            rs.setRPC(false);
            rs.setParameter("iddoc", newId);
            rs.executeUpdate("exec _1sp__1SUIDCTL_SetMaxID 0, :iddoc");
            rs.setParameter("iddoc", newId);
            ResultSet result = rs.executeQuery("exec _1sp__1SJOURN_ByIDDOC :iddoc");
            result.next();
            super.setRef((Ref)result.getRef("iddoc", (Metadatas.Reference)this.getMetaObject()));
            this.crdocWrite(1, this.date, this.getParentDocuments());
            this.crdocWrite(1, this.date, this.getSelectects(cPropertys));
        }

        public void write() {
            if (this.newObject) {
                this.releaseNumber(this.number);
            }
            this.startTransaction();
            this.blockX("_1sjourn");
            this.block("_1soper");
            if (this.newObject) {
                this.journInsert();
                this.dhInsert();
                this.newObject = false;
            } else if (!(this.getRef() instanceof Null)) {
                this.journUpdate();
                this.dhUpdate();
            } else {
                throw new ExceptionAPI("\u041e\u0431\u044a\u0435\u043a\u0442 \u043d\u0435 \u0441\u043f\u043e\u0437\u0438\u0446\u0438\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d");
            }
            this.dtUpdate();
            Metadatas.Document meta = (Metadatas.Document)this.getMetaObject();
            if (meta.isAccountingRecording() && this.operation instanceof Null && (meta.getCreateOperation() == 0 || meta.getCreateOperation() == 1 && this.createOperation)) {
                OperationObject operObj = new OperationObject(this);
                operObj.newObject = true;
                operObj._write();
                this.operation = (OperationReference)operObj.getRef();
            }
            this.commitTransaction();
            this.notifyClients();
        }

        public void setAttribute(String name, Object value) {
            Metadatas.CommonProperty cProperty = V7.this.metaData.getCommonProperty(name);
            if (cProperty != null) {
                this.cAttributes.get(name).setValue(value);
                return;
            }
            Metadatas.Document meta = (Metadatas.Document)this.getMetaObject();
            Metadatas.Qualifier property = meta.getProperty(name);
            if (property != null) {
                this.attributes.get(name).setValue(value);
                return;
            }
            throw new ExceptionAPI("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e\u0435 \u0438\u043c\u044f \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u0430");
        }

        @Override
        public Object getAttribute(String name) {
            Metadatas.CommonProperty cProperty = V7.this.metaData.getCommonProperty(name);
            if (cProperty != null) {
                return this.cAttributes.get(name).getValue();
            }
            Metadatas.Document meta = (Metadatas.Document)this.getMetaObject();
            Metadatas.Qualifier property = meta.getProperty(name);
            if (property != null) {
                return this.attributes.get(name).getValue();
            }
            throw new ExceptionAPI("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e\u0435 \u0438\u043c\u044f \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u0430");
        }

        @Override
        public boolean isMark() {
            return this.isMark;
        }

        @Override
        public Date getDate() {
            return this.date;
        }

        @Override
        public String getNumber() {
            return this.number;
        }

        public String toString() {
            String name = ((Metadatas.Reference)this.getMetaObject()).getSynonym().trim();
            if (name.length() == 0) {
                name = ((Metadatas.Reference)this.getMetaObject()).getName();
            }
            return String.valueOf(name) + " " + this.number.trim() + " (" + String.format("%1$td.%1$tm.%1$tY", this.date) + ")";
        }

        @Override
        public Position getPosition() {
            return new Position(this, 0);
        }

        protected RegisterObject getRegisterObject(String name) {
            return new RegisterObject(this, name);
        }

        public OperationReference getOperation() {
            Metadatas.Document meta = (Metadatas.Document)this.getMetaObject();
            if (!meta.isAccountingRecording()) {
                throw new ExceptionAPI("\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u043d\u0435 \u043f\u0440\u0438\u043d\u0430\u0434\u043b\u0435\u0436\u0438\u0442 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u043c\u0443 \u0443\u0447\u0435\u0442\u0443");
            }
            if (!this.closing) {
                throw new ExceptionAPI("\u041e\u0431\u0440\u0430\u0449\u0435\u043d\u0438\u0435 \u043a \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0442\u043e\u043b\u044c\u043a\u043e \u0438\u0437 \u043c\u043e\u0434\u0443\u043b\u044f \u043f\u0440\u043e\u0432\u0435\u0434\u0435\u043d\u0438\u044f");
            }
            if (this.operation instanceof Null) {
                throw new ExceptionAPI("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430 \u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430");
            }
            return this.operation;
        }

        protected OperationObject getOperationObject() {
            Metadatas.Document meta = (Metadatas.Document)this.getMetaObject();
            if (!meta.isAccountingRecording()) {
                throw new ExceptionAPI("\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u043d\u0435 \u043f\u0440\u0438\u043d\u0430\u0434\u043b\u0435\u0436\u0438\u0442 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u043c\u0443 \u0443\u0447\u0435\u0442\u0443");
            }
            if (!this.closing) {
                throw new ExceptionAPI("\u041e\u0431\u0440\u0430\u0449\u0435\u043d\u0438\u0435 \u043a \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0442\u043e\u043b\u044c\u043a\u043e \u0438\u0437 \u043c\u043e\u0434\u0443\u043b\u044f \u043f\u0440\u043e\u0432\u0435\u0434\u0435\u043d\u0438\u044f");
            }
            if (this.operation instanceof Null) {
                throw new ExceptionAPI("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430 \u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430");
            }
            OperationObject oper = new OperationObject(this);
            oper.readAttributes();
            return oper;
        }

        public void delete(boolean completely) {
            if (this.getRef() instanceof Null) {
                throw new ExceptionAPI("\u041e\u0431\u044a\u0435\u043a\u0442 \u043d\u0435 \u0441\u043f\u043e\u0437\u0438\u0446\u0438\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d");
            }
            Metadatas.Document meta = (Metadatas.Document)this.getMetaObject();
            if (this.isClosed()) {
                this.cancelClose();
            }
            this.startTransaction();
            this.blockX("_1sjourn");
            if (meta.isAccountingRecording()) {
                this.block("_1soper");
            }
            RecordSet rs = new RecordSet();
            rs.setParameter("id", this.getRef());
            if (completely) {
                rs.executeUpdate("delete from _1sjourn where iddoc=:id");
                rs.executeUpdate("delete from dh" + meta.getId() + " where iddoc=:id");
                rs.executeUpdate("delete from dt" + meta.getId() + " where iddoc=:id");
                rs.executeUpdate("delete from _1scrdoc where right(child_date_time_iddoc=:id,9) or substring(parentval,7,9)=:id");
                rs.executeUpdate("delete from _1soper where docid=:id");
            } else {
                rs.executeUpdate("update _1sjourn set appcode=appcode&119, ismark=ismark|1, closed=0 where iddoc=:id");
                this.isMark = true;
            }
            this.commitTransaction();
            this.notifyClients();
        }

        public void cancelDelete() {
            if (!this.isMark()) {
                throw new ExceptionAPI("\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u043d\u0435 \u043f\u043e\u043c\u0435\u0447\u0435\u043d \u043d\u0430 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0435");
            }
            this.startTransaction();
            this.blockX("_1sjourn");
            this.isMark = false;
            this.journUpdate();
            this.commitTransaction();
            this.notifyClients();
        }

        private int deleteRegisterMovements(Metadatas.Register reg) {
            Metadatas.Document meta = (Metadatas.Document)this.getMetaObject();
            if (meta.isOperativeRecording()) {
                this.block("_1ssystem");
                RecordSet rs = new RecordSet();
                rs.setParameter("id", ((Ref)this.getRef()).getId());
                rs.setParameter("DocDate", this.getDate());
                rs.setParameter("CurPeriod", this.getBeginOfPeriod(this.getDate()));
                rs.setParameter("RepeatToTM", 0);
                rs.setParameter("SaveTurnsWithMonth", 0);
                rs.setParameter("Direct", 1);
                rs.executeUpdate("_1sp_ra" + reg.getId() + "_ClearRecalcDocActs :id, :DocDate~~, :CurPeriod~~, :RepeatToTM, :SaveTurnsWithMonth, :Direct");
                rs.executeUpdate("delete ra" + reg.getId() + " where iddoc=:id");
                this.movementRegisters.remove(reg);
                return 2;
            }
            return 0;
        }

        private int deleteEntryMovements() {
            Metadatas.Document meta = (Metadatas.Document)this.getMetaObject();
            if (meta.isAccountingRecording()) {
                RecordSet rs = new RecordSet();
                rs.setParameter("date", this.getDate());
                ResultSet result = rs.executeQuery("declare @CurDate datetime\nexec _1sp_GetNextPeriod :date~~, 'Q', @CurDate OUTPUT\nselect @CurDate");
                result.next();
                Date curPeriod = result.getDate(1);
                rs.setParameter("id", this.getRef());
                result = rs.executeQuery("Select * from _1SENTRY(NOLOCK INDEX=DOCIDNUMBER) where DOCID=:id order by DOCID,NUMBER,CORNO");
                this.block("_1sentry");
                while (result.next()) {
                    rs.setParameter("date", curPeriod);
                    rs.setParameter("rowid", result.getInt("row_id"));
                    rs.executeUpdate("exec _1sp__1SENTRY_NewEntry :date~~, :rowid, 1, 0, 0, 0");
                }
                rs.setParameter("id", this.getRef());
                rs.executeUpdate("delete from _1ssbsel where docid=:id\ndelete from _1saccsel where docid=:id\ndelete from _1sentry where docid=:id");
                return 8;
            }
            return 0;
        }

        private int deleteCatalogMovements() {
            this.block("_1sconst");
            RecordSet rs = new RecordSet();
            rs.setParameter("docid", this.getRef());
            rs.executeUpdate("delete _1sconst where docid=:docid");
            return 1;
        }

        protected void deleteMovements(String name) {
            Metadatas.Document meta = (Metadatas.Document)this.getMetaObject();
            if (meta.isAutoDeleteMovements()) {
                throw new ExceptionAPI("\u041c\u0435\u0442\u043e\u0434 \u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d \u0442\u043e\u043b\u044c\u043a\u043e \u043f\u0440\u0438 \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d\u043d\u043e\u043c \u0432 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u0444\u043b\u0430\u0433\u0435 '\u0410\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u043e\u0435 \u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0434\u0432\u0438\u0436\u0435\u043d\u0438\u0439'");
            }
            if (!this.closing) {
                throw new ExceptionAPI("\u041c\u0435\u0442\u043e\u0434 \u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d \u0442\u043e\u043b\u044c\u043a\u043e \u0432 \u043c\u043e\u0434\u0443\u043b\u0435 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430 \u0432 \u043f\u0440\u0435\u0434\u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u043e\u0446\u0435\u0434\u0443\u0440\u0435 processing");
            }
            if (name == null) {
                this._deleteMovements();
            } else {
                int flags = 0;
                String[] strObjects = name.split(";");
                int i = 0;
                while (i < strObjects.length) {
                    String[] strParts = strObjects[i].split("\\.");
                    if (strParts.length != 2) {
                        throw new ExceptionAPI("\u041d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0437\u0430\u0434\u0430\u043d\u044b \u0432\u0438\u0434\u044b \u0434\u0432\u0438\u0436\u0435\u043d\u0438\u0439 '" + strObjects[i] + "'");
                    }
                    if (strParts[0].equalsIgnoreCase("\u0420\u0435\u0433\u0438\u0441\u0442\u0440")) {
                        Metadatas.Register reg = V7.this.metaData.getRegister(strParts[1]);
                        if (reg == null) {
                            throw new ExceptionAPI("\u0412 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u043e\u0442\u0441\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0440\u0435\u0433\u0438\u0441\u0442\u0440 '" + strParts[1] + "'");
                        }
                        flags ^= this.deleteRegisterMovements(reg);
                        continue;
                    }
                    if (strParts[0].equalsIgnoreCase("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f")) {
                        flags ^= this.deleteEntryMovements();
                        continue;
                    }
                    if (!strParts[0].equalsIgnoreCase("\u0421\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a")) continue;
                    flags ^= this.deleteCatalogMovements();
                }
                RecordSet rs = new RecordSet();
                rs.setParameter("id", this.getRef());
                rs.executeUpdate("Update _1SCRDOC set FLAGS=FLAGS&~" + flags + " where CHILDID=:id; If @@ROWCOUNT>0 Delete from _1SCRDOC where CHILDID=:id and FLAGS=0");
            }
        }

        private void _deleteMovements() {
            int flags = 0;
            Iterator<Metadatas.Register> r = this.movementRegisters.iterator();
            while (r.hasNext()) {
                flags ^= this.deleteRegisterMovements(r.next());
            }
            flags ^= this.deleteEntryMovements();
            if (this.isPeriodic) {
                flags ^= this.deleteCatalogMovements();
            }
            RecordSet rs = new RecordSet();
            rs.setParameter("id", this.getRef());
            rs.executeUpdate("Update _1SCRDOC set FLAGS=FLAGS&~" + flags + " where CHILDID=:id; If @@ROWCOUNT>0 Delete from _1SCRDOC where CHILDID=:id and FLAGS=0");
        }

        private Date getBeginOfPeriod(Date date) {
            String query = "declare @snapShper char(1)\ndeclare @NewDate datetime\nselect @snapShper=snapshper from _1SSYSTEM(NOLOCK)\nexec _1sp_GetBeginOfPeriod :BaseDate~~, @snapShper, @NewDate output\nselect @NewDate";
            RecordSet rs = new RecordSet();
            rs.setParameter("BaseDate", date);
            ResultSet result = rs.executeQuery(query);
            result.next();
            return result.getDate(1);
        }

        @Override
        public boolean isClosed() {
            return this.isClosed;
        }
    }

    public class DocumentReference
    extends Ref
    implements Document {
        DocumentReference(String id, Metadatas.Reference metaObject) {
            super(id, metaObject);
        }

        public List<DocumentString> getRows() {
            ArrayList<DocumentString> rows = new ArrayList<DocumentString>();
            if (((Metadatas.Document)this.getMetaObject()).getDetail().size() == 0) {
                return rows;
            }
            RecordSet rs = new RecordSet();
            rs.setParameter("iddoc", this);
            ResultSet result = rs.executeQuery("select * from $\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0421\u0442\u0440\u043e\u043a\u0438." + ((Metadatas.Reference)this.getMetaObject()).getName() + " (nolock) where iddoc=:iddoc");
            while (result.next()) {
                DocumentString row = new DocumentString((Metadatas.Document)this.getMetaObject());
                row.readAttributes(result);
                rows.add(row);
            }
            return Collections.unmodifiableList(rows);
        }

        @Override
        public Object getAttribute(String name) {
            String query;
            RecordSet rs = new RecordSet();
            Metadatas.Document meta = (Metadatas.Document)this.getMetaObject();
            Metadatas.Qualifier property = meta.getProperty(name);
            rs.setParameter("id", this);
            if (property == null) {
                property = V7.this.metaData.getCommonProperty(name);
                if (property == null) {
                    throw new ExceptionAPI("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e\u0435 \u0438\u043c\u044f \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u0430");
                }
                query = ((Metadatas.CommonProperty)property).isSelection() ? "select *  from _1sjourn (nolock) where iddoc=:id" : "select * from $\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442." + meta.getName() + " (nolock) where iddoc=:id";
            } else {
                query = "select * from $\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442." + meta.getName() + " (nolock) where iddoc=:id";
            }
            ResultSet result = rs.executeQuery(query);
            result.next();
            return result.getRef("sp" + property.getId(), (Metadatas.Reference)property);
        }

        @Override
        public boolean isMark() {
            return false;
        }

        @Override
        public Date getDate() {
            RecordSet rs = new RecordSet();
            String query = "select date_time_iddoc from _1sjourn with (nolock) where iddoc=:id";
            rs.setParameter("id", this);
            ResultSet result = rs.executeQuery(query);
            result.next();
            return new Position(result.getString(1)).getDate();
        }

        @Override
        public String getNumber() {
            RecordSet rs = new RecordSet();
            String query = "select docno from _1sjourn with (nolock) where iddoc=:id";
            rs.setParameter("id", this);
            ResultSet result = rs.executeQuery(query);
            result.next();
            return result.getString(1);
        }

        public OperationReference getOperation() {
            Metadatas.Document meta = (Metadatas.Document)this.getMetaObject();
            if (meta.isAccountingRecording()) {
                throw new ExceptionAPI("\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u043d\u0435 \u043f\u0440\u0438\u043d\u0430\u0434\u043b\u0435\u0436\u0438\u0442 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u043c\u0443 \u0443\u0447\u0435\u0442\u0443");
            }
            return new OperationReference(this.getId());
        }

        public String toString() {
            String query = "select rtrim(j.docno)+' ('+convert(varchar(10),cast (left(j.date_time_iddoc,8) as datetime),104)+')' as str\nfrom _1sjourn as j with (nolock)\nwhere j.iddoc=:id";
            RecordSet rs = V7.this.getRecordSet();
            rs.setParameter("id", this);
            ResultSet result = rs.executeQuery(query);
            String name = ((Metadatas.Reference)this.getMetaObject()).getSynonym();
            if (name.trim().length() == 0) {
                name = ((Metadatas.Reference)this.getMetaObject()).getName();
            }
            if (result.next()) {
                return String.valueOf(name) + " " + result.getString(1);
            }
            return "<\u041e\u0431\u044a\u0435\u043a\u0442 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d>(" + this.getId() + ")";
        }

        @Override
        public Position getPosition() {
            return new Position(this, 0);
        }

        public DocumentObject getObj() {
            DocumentObject doc = new DocumentObject((Metadatas.Reference)this.getMetaObject());
            doc.setRef(this);
            return doc;
        }

        @Override
        public boolean isClosed() {
            RecordSet rs = new RecordSet();
            String query = "select t.closed from _1sjourn with (nolock) where iddoc=:id";
            rs.setParameter("id", this);
            ResultSet result = rs.executeQuery(query);
            result.next();
            return result.getBoolean(1);
        }

        @Override
        String getTypeId() {
            return "O1";
        }

        @Override
        String getVidId() {
            return String.format("%1$4S", Integer.toString(((Metadatas.Reference)this.getMetaObject()).getId(), 36));
        }
    }

    public final class DocumentString {
        private final Metadatas.Document metaObject;
        private Hashtable<String, Property> attributes;

        private DocumentString(Metadatas.Document metaDoc) {
            this.metaObject = metaDoc;
            this.initAttribute();
        }

        private void readAttributes(ResultSet result) {
            this.attributes.clear();
            for (Metadatas.TableProperty property : this.metaObject.detail) {
                this.attributes.put(property.getName(), result.getProperty("sp" + property.getId(), (Metadatas.Qualifier)property));
            }
        }

        private void initAttribute() {
            this.attributes = new Hashtable();
            for (Metadatas.TableProperty property : this.metaObject.getDetail()) {
                this.attributes.put(property.getName(), new Property(property));
            }
        }

        public <T> T getAttribute(String name) {
            Property property = this.attributes.get(name);
            if (property == null) {
                throw new ExceptionAPI("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e\u0435 \u0438\u043c\u044f \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u0430");
            }
            return (T)property.getValue();
        }

        public void setAttribute(String name, Object value) {
            Property property = this.attributes.get(name);
            if (property == null) {
                throw new ExceptionAPI("\u041d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e\u0435 \u0438\u043c\u044f \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u0430");
            }
            property.setValue(value);
        }
    }

    public final class Entry {
        private int doclineno;
        private Correspondence debit;
        private Correspondence kredit;
        private CatalogReference currency;
        private BigDecimal sum;
        private BigDecimal currencySum;
        private BigDecimal amount;
        private boolean active;
        private HashMap<String, Property> attributes = new HashMap();

        private Entry() {
            this.initAttrubutes();
        }

        private Correspondence createCorresponence(char s, ResultSet result) {
            Correspondence cor = new Correspondence();
            AccountReference acc = V7.this.getAccount(result.getString("acc" + s + "tid"));
            cor.setAccount(acc);
            int i = 0;
            while (i < acc.amountSubconto()) {
                Metadatas.SubcontoKind subcontoKind = (Metadatas.SubcontoKind)V7.this.metaData.getType(result.getInt("v" + s + "tsc" + i));
                result.setLabel(String.valueOf(s) + "tsc" + i);
                cor.setSubconto(i, result.getRef(subcontoKind));
                ++i;
            }
            return cor;
        }

        private void readAttributes(ResultSet result) {
            this.doclineno = result.getInt("doclineno");
            this.debit = this.createCorresponence('d', result);
            this.kredit = this.createCorresponence('k', result);
            this.sum = result.getBigDecimal("sum_");
            this.currencySum = result.getBigDecimal("cursum");
            this.amount = result.getBigDecimal("amount");
            this.active = result.getString("active").equals("*");
            this.currency = (CatalogReference)result.getRef("currid", (Metadatas.Reference)V7.this.metaData.getCurrencyCatalog());
            this.attributes.clear();
            for (Metadatas.EntryProperty property : V7.this.metaData.getEntryPropertys()) {
                this.attributes.put(property.getName(), result.getProperty("sp" + property.getId(), (Metadatas.Qualifier)property));
            }
        }

        public void setActive(boolean sign) {
            this.active = sign;
        }

        public boolean getActive() {
            return this.active;
        }

        private void initAttrubutes() {
            this.debit = new Correspondence();
            this.kredit = new Correspondence();
            this.sum = BigDecimal.valueOf(0L);
            this.currencySum = BigDecimal.valueOf(0L);
            this.amount = BigDecimal.valueOf(0L);
            this.active = true;
            Metadatas.Catalog cur = V7.this.metaData.getCurrencyCatalog();
            this.currency = cur != null ? new NullCatalogReference(cur) : new NullCatalogReference((Metadatas.Reference)V7.this.metaData.getType('B', 0));
            this.attributes.clear();
            for (Metadatas.EntryProperty property : V7.this.metaData.getEntryPropertys()) {
                this.attributes.put(property.getName(), new Property(property));
            }
        }

        public Correspondence getDebit() {
            return this.debit;
        }

        public Correspondence getKredit() {
            return this.kredit;
        }

        public BigDecimal getCurrencySum() {
            return this.currencySum;
        }

        public BigDecimal getAmount() {
            return this.amount;
        }

        public void setAmount(BigDecimal amount) {
            this.amount = amount;
        }

        public CatalogReference getCurrency() {
            return this.currency;
        }

        public void setCurrency(CatalogReference currency) {
            Metadatas.Catalog metaCurrency = V7.this.metaData.getCurrencyCatalog();
            if (!metaCurrency.equals(currency.getMetaObject())) {
                throw new ExceptionAPI("\u0414\u043b\u044f \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438 \u0432\u0430\u043b\u044e\u0442\u044b \u043f\u0440\u043e\u0432\u043e\u0434\u043a\u0438 \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0441\u043f\u0440\u0430\u0432\u043e\u0447\u043d\u0438\u043a '" + metaCurrency.getName() + "'");
            }
            this.currency = currency;
        }

        public BigDecimal getSum() {
            return this.sum;
        }

        public void setSum(BigDecimal sum) {
            this.sum = sum;
        }

        public void setSum(int sum) {
            this.sum = BigDecimal.valueOf(sum);
        }

        public void setCurrencySum(BigDecimal sum) {
            this.sum = sum;
        }

        public void setAttribute(String name, Object value) {
            Metadatas.EntryProperty property = V7.this.metaData.getEntryProperty(name);
            if (property == null) {
                throw new ExceptionAPI("\u041d\u0435\u0442 \u0440\u0435\u043a\u0432\u0438\u0437\u0438\u0442\u0430 \u0441 \u0438\u043c\u0435\u043d\u0435\u043c '" + name + "'");
            }
            this.attributes.get(name).setValue(value);
        }

        public Object getProperty(String name) {
            Metadatas.EntryProperty property = V7.this.metaData.getEntryProperty(name);
            if (property == null) {
                throw new ExceptionAPI("\u041d\u0435\u0442 \u0440\u0435\u043a\u0432\u0438\u0437\u0438\u0442\u0430 \u0441 \u0438\u043c\u0435\u043d\u0435\u043c '" + name + "'");
            }
            return this.attributes.get(name).getValue();
        }

        public final class Correspondence {
            private AccountReference account;
            private HashMap<Integer, Property> subcontos;

            public Correspondence() {
                this.account = new NullAccountReference();
                this.subcontos = new HashMap();
                this.setAccount(this.account);
            }

            public AccountReference getAccount() {
                return this.account;
            }

            public void setAccount(AccountReference account) {
                this.account = account;
                this.subcontos.clear();
                List<SubcontoKindReference> sample = account.getSubcontoKinds();
                int number = 0;
                for (SubcontoKindReference subcontoRef : sample) {
                    this.subcontos.put(number, new Property((Metadatas.SubcontoKind)subcontoRef.getMetaObject()));
                    ++number;
                }
            }

            public Object getSubconto(int number) {
                if (this.account == null) {
                    throw new ExceptionAPI("\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0441\u043d\u0430\u0447\u0430\u043b\u0430 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0441\u0447\u0435\u0442 \u043a\u043e\u0440\u0440\u0435\u0441\u043f\u043e\u043d\u0434\u0435\u043d\u0446\u0438\u0438");
                }
                return this.subcontos.get(number).getValue();
            }

            public Object getSubconto(SubcontoKindReference subcontoKind) {
                if (this.account == null) {
                    throw new ExceptionAPI("\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0441\u043d\u0430\u0447\u0430\u043b\u0430 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0441\u0447\u0435\u0442 \u043a\u043e\u0440\u0440\u0435\u0441\u043f\u043e\u043d\u0434\u0435\u043d\u0446\u0438\u0438");
                }
                List<SubcontoKindReference> sample = this.account.getSubcontoKinds();
                int number = 0;
                for (SubcontoKindReference subcontoRef : sample) {
                    if (subcontoRef.equals(subcontoKind)) {
                        return this.subcontos.get(number).getValue();
                    }
                    ++number;
                }
                return null;
            }

            public void setSubconto(int number, Object value) {
                if (this.account == null) {
                    throw new ExceptionAPI("\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0441\u043d\u0430\u0447\u0430\u043b\u0430 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0441\u0447\u0435\u0442 \u043a\u043e\u0440\u0440\u0435\u0441\u043f\u043e\u043d\u0434\u0435\u043d\u0446\u0438\u0438");
                }
                SubcontoKindReference subcontoKind = this.account.getSubcontoKind(number);
                this.subcontos.put(number, new Property((Metadatas.SubcontoKind)subcontoKind.getMetaObject(), value));
            }

            public void setSubconto(SubcontoKindReference subcontoKind, Object value) {
                if (this.account == null) {
                    throw new ExceptionAPI("\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0441\u043d\u0430\u0447\u0430\u043b\u0430 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c \u0441\u0447\u0435\u0442 \u043a\u043e\u0440\u0440\u0435\u0441\u043f\u043e\u043d\u0434\u0435\u043d\u0446\u0438\u0438");
                }
                List<SubcontoKindReference> sample = this.account.getSubcontoKinds();
                int number = 0;
                for (SubcontoKindReference subcontoKind_ : sample) {
                    if (subcontoKind.equals(subcontoKind_)) {
                        this.subcontos.put(number, new Property((Metadatas.SubcontoKind)subcontoKind.getMetaObject(), value));
                    }
                    ++number;
                }
            }
        }
    }

    public class EnumerationManager
    extends Manager {
        public EnumerationManager(String name) {
            super(V7.this.metaData.getEnumeration(name));
        }

        public EnumerationReference getValueByIdentifier(String name) {
            Metadatas.Enumeration meta = (Metadatas.Enumeration)this.getMetaObject();
            Metadatas.Reference property = meta.getProperty(name);
            return new EnumerationReference(property.getId36(), this.metaObject);
        }

        public EnumerationReference getValueByNumber(int number) {
            Metadatas.Enumeration meta = (Metadatas.Enumeration)this.getMetaObject();
            Metadatas.Reference property = meta.getProperty(number);
            if (property == null) {
                throw new ExceptionAPI("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u043f\u0435\u0440\u0435\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f");
            }
            return new EnumerationReference(property.getId36(), meta);
        }

        public List<EnumerationReference> selectRefs() {
            ArrayList<EnumerationReference> sampleRef = new ArrayList<EnumerationReference>();
            List<Metadatas.Reference> sampleMet = ((Metadatas.Enumeration)this.metaObject).getPropertys();
            for (Metadatas.Reference property : sampleMet) {
                EnumerationReference v = new EnumerationReference(property.getId36(), this.metaObject);
                sampleRef.add(v);
            }
            return Collections.unmodifiableList(sampleRef);
        }

        public int size() {
            Metadatas.Enumeration meta = (Metadatas.Enumeration)this.getMetaObject();
            return meta.propertys.size();
        }
    }

    public class EnumerationReference
    extends Ref {
        EnumerationReference(String id, Metadatas.Reference metaObject) {
            super(id, metaObject);
        }

        public String toString() {
            Metadatas.Enumeration meta = (Metadatas.Enumeration)this.getMetaObject();
            List<Metadatas.Reference> propertys = meta.getPropertys();
            for (Metadatas.Reference property : propertys) {
                if (!property.getId36().equals(this.getId())) continue;
                return property.getName();
            }
            return null;
        }

        @Override
        String getTypeId() {
            return "E1";
        }

        @Override
        String getVidId() {
            return String.format("%1$4S", Integer.toString(((Metadatas.Reference)this.getMetaObject()).getId(), 36));
        }
    }

    public abstract class Manager {
        final Metadatas.Reference metaObject;

        Manager(Metadatas.Reference metaObject) {
            this.metaObject = metaObject;
            if (this.metaObject == null) {
                throw new ExceptionAPI("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u043e\u0431\u044a\u0435\u043a\u0442 - \u043f\u043e\u043f\u044b\u0442\u043a\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \u0441 \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u043c\u0438 \u043c\u0435\u0442\u0430\u0434\u0430\u043d\u043d\u044b\u043c\u0438");
            }
        }

        public <T extends Metadatas.Reference> T getMetaObject() {
            return (T)this.metaObject;
        }
    }

    public static interface Null {
    }

    public final class NullAccountReference
    extends AccountReference
    implements Null {
        NullAccountReference() {
            super("     0   ", V7.this.metaData.getMainPlan());
        }

        @Override
        public String toString() {
            return "";
        }
    }

    public final class NullAlgorithmReference
    extends AlgorithmReference
    implements Null {
        NullAlgorithmReference() {
            super(0);
        }

        @Override
        public String toString() {
            return "";
        }
    }

    public final class NullCalendarReference
    extends CalendarReference
    implements Null {
        NullCalendarReference() {
            super(0);
        }

        @Override
        public String toString() {
            return "";
        }
    }

    public final class NullCatalogReference
    extends CatalogReference
    implements Null {
        public NullCatalogReference(Metadatas.Reference metaObject) {
            super("     0   ", metaObject);
        }

        @Override
        public String toString() {
            return "";
        }
    }

    public final class NullDocumentReference
    extends DocumentReference
    implements Null {
        NullDocumentReference(Metadatas.Reference metaObject) {
            super("     0   ", metaObject);
        }

        @Override
        public String toString() {
            return "";
        }
    }

    public final class NullEnumerationReference
    extends EnumerationReference
    implements Null {
        NullEnumerationReference() {
            super("     0   ", (Metadatas.Reference)V7.this.metaData.getType('E', 0));
        }

        @Override
        public String toString() {
            return "";
        }
    }

    public final class NullOperationReference
    extends OperationReference
    implements Null {
        NullOperationReference() {
            super("     0   ");
        }

        @Override
        public String toString() {
            return "";
        }
    }

    public final class NullPlanReference
    extends PlanReference
    implements Null {
        NullPlanReference() {
            super(0);
        }

        @Override
        public String toString() {
            return "";
        }
    }

    public final class NullSubcontoKindReference
    extends SubcontoKindReference
    implements Null {
        NullSubcontoKindReference() {
            super(0);
        }

        @Override
        public String toString() {
            return "";
        }
    }

    public final class NullUndefineReference
    extends Ref
    implements Null {
        NullUndefineReference() {
            super("     0   ", (Metadatas.Reference)V7.this.metaData.getType('U', 0));
        }

        @Override
        String getTypeId() {
            return "U1";
        }

        @Override
        String getVidId() {
            return "   0";
        }

        public String toString() {
            return "";
        }
    }

    public abstract class Obj {
        private Ref ref = null;
        HashSet<String> blocks = new HashSet();
        final Metadatas.Reference metaObject;

        void block(String block) {
            String _block = block.toUpperCase();
            if (!this.blocks.contains(_block)) {
                new RecordSet().executeUpdate("exec _1sp_" + _block + "_TLock");
                this.blocks.add(_block);
            }
        }

        void blockX(String block) {
            String _block = block.toUpperCase();
            if (!this.blocks.contains(_block)) {
                new RecordSet().executeUpdate("exec _1sp_" + _block + "_TLockX");
                this.blocks.add(_block);
            }
        }

        final void startTransaction() {
            RecordSet rs = new RecordSet();
            rs.executeUpdate("set implicit_transactions on");
        }

        final void commitTransaction() {
            RecordSet rs = new RecordSet();
            rs.executeUpdate("IF @@TRANCOUNT > 0 COMMIT TRAN\nset implicit_transactions off");
            this.blocks.clear();
        }

        List<Map.Entry<Integer, Property>> getSelectects(Collection<Property> propertys) {
            ArrayList<AbstractMap.SimpleEntry<Integer, Property>> result = new ArrayList<AbstractMap.SimpleEntry<Integer, Property>>();
            List<Metadatas.GrafSelect> grafs = V7.this.metaData.getGrafSelects();
            for (Metadatas.GrafSelect graf : grafs) {
                for (Property property : propertys) {
                    if (!graf.getRefers().contains(property.getMetaObject()) || !graf.isSelectEmpty() && property.isNull()) continue;
                    boolean exist = false;
                    for (Map.Entry entry : result) {
                        if (!((Integer)entry.getKey()).equals(graf.getId()) || !((Property)entry.getValue()).equals(property)) continue;
                        exist = true;
                        break;
                    }
                    AbstractMap.SimpleEntry<Integer, Property> map = new AbstractMap.SimpleEntry<Integer, Property>(graf.getId(), property);
                    if (exist) continue;
                    result.add(map);
                }
            }
            return Collections.unmodifiableList(result);
        }

        void crdocWrite(int flag, Date date, List<Map.Entry<Integer, Property>> list) {
            if (list.size() > 0) {
                RecordSet rs = new RecordSet();
                rs.setParameter("pos", new Position(this.ref.id, date, 0));
                rs.setParameter("id", this.getRef());
                rs.setParameter("flags", flag);
                for (Map.Entry<Integer, Property> map : list) {
                    rs.setParameter("parent", map.getValue());
                    rs.setParameter("mdid", map.getKey());
                    rs.executeUpdate("exec _1sp__1SCRDOC_Write :mdid, :parent~~, :pos~, :id, :flags");
                }
            }
        }

        public abstract void newObject();

        public void setRef(Ref ref) {
            if (ref == null) {
                throw new ExceptionAPI("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438 null \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u0441\u0441\u044b\u043b\u043a\u0435 \u043e\u0431\u044a\u0435\u043a\u0442\u0430");
            }
            if (!((Metadatas.Reference)ref.getMetaObject()).equals(this.metaObject)) {
                throw new ExceptionAPI("\u0423\u043f\u0441 - \u0443 \u0441\u0441\u044b\u043b\u043a\u0438 \u0438 \u043e\u0431\u044a\u0435\u043a\u0442\u0430 \u0440\u0430\u0437\u043d\u044b\u0435 \u043c\u0435\u0442\u0430\u0434\u0430\u043d\u043d\u044b\u0435");
            }
            this.ref = ref;
        }

        Obj(Metadatas.Reference metaObject) {
            this.metaObject = metaObject;
            if (this.metaObject == null) {
                throw new ExceptionAPI("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u043e\u0431\u044a\u0435\u043a\u0442 \u0441 \u043d\u0435\u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u043d\u044b\u043c\u0438 \u043c\u0435\u0442\u0430\u0434\u0430\u043d\u043d\u044b\u043c\u0438");
            }
            this.ref = (Ref)this.metaObject.NullValue();
        }

        public <T extends Ref> T getRef() {
            return (T)this.ref;
        }

        final void releaseNumber(String number) {
            RecordSet rs = new RecordSet();
            rs.setParameter("prefix", this.getPrefix());
            rs.setParameter("number", number);
            rs.executeUpdate("delete from _1sdnlock where dnprefix=:prefix and docno=:number");
        }

        String generateNewNumber(String source) {
            StringBuffer buf = new StringBuffer(source);
            char[] chars = new char[]{' ', '0', '1', '2', '3', '4', '6', '7', '8', '9'};
            int start = 0;
            int pos = 0;
            boolean flag = true;
            int i = 0;
            while (i < source.length() && flag) {
                int c = 0;
                while (c < chars.length && flag) {
                    if (source.charAt(i) == chars[c]) {
                        start = i;
                        flag = false;
                    }
                    ++c;
                }
                ++i;
            }
            i = source.length() - 1;
            while (i >= 0 && pos == 0) {
                if (source.charAt(i) != ' ') {
                    pos = i;
                }
                --i;
            }
            while (pos > start) {
                char symbol = source.charAt(pos);
                switch (symbol) {
                    case '9': {
                        buf.replace(pos, pos + 1, "0");
                        --pos;
                        break;
                    }
                    case ' ': {
                        buf.replace(pos, pos + 1, "0");
                        pos = 0;
                        break;
                    }
                    default: {
                        symbol = (char)(symbol + '\u0001');
                        buf.replace(pos, pos + 1, String.valueOf(symbol));
                        pos = 0;
                    }
                }
            }
            RecordSet rs = new RecordSet();
            rs.setParameter("prefix", this.getPrefix());
            rs.setParameter("source", buf.toString());
            rs.executeUpdate("insert _1sdnlock values(:prefix,:source)");
            return buf.toString();
        }

        final String generateNewNumber_(String source) {
            String query = "declare @err int\ndeclare @source char(24)\nset @source=:source\nset lock_timeout 0\nset @err=-1\nwhile @err <> 0\nbegin\n\tdeclare @pos tinyint\n\tdeclare @start tinyint\n\tdeclare @c char(1)\n\tset @pos=len(rtrim(@source))\n\tset @start=patindex('%['' '',0-9]%',@source)-1\n\twhile @pos>@start\n\tbegin\t\tset @c=substring(@source,@pos,1)\n\t\tif ascii(@c)=57\n\t\tbegin\n\t\t\tset @source=STUFF(@source,@pos,1,'0')\n\t\t\tset @pos=@pos-1\n\t\tend\t\telse if ascii(@c)=32\n\t\tbegin\n\t\t\tset @source=STUFF(@source,@pos,1,'0')\n\t\t\tset @pos=0\n\t\tend\n\t\telse\n\t\tbegin\n\t\t\tset @source=STUFF(@source,@pos,1,char(ascii(@c)+1))\t\t\tset @pos=0\n\t\tend\n\tend\n\tinsert _1sdnlock values(:prefix,@source)\n\tset @err = @@error\nend\nset lock_timeout -1\nselect @source";
            RecordSet rs = new RecordSet();
            rs.setParameter("prefix", this.getPrefix());
            rs.setParameter("source", source);
            ResultSet result = rs.executeQuery(query);
            result.next();
            return result.getString(1);
        }

        abstract String getPrefix();

        void notifyClients() {
            String query = "update _1susers\nset netchgcn = netchgcn + 1\nif @@rowcount=0 insert _1susers (usrscnt, netchgcn) VALUES (1,1)\n";
            RecordSet rs = new RecordSet();
            rs.executeUpdate(query);
        }

        public <T extends Metadatas.Reference> T getMetaObject() {
            return (T)this.metaObject;
        }
    }

    public final class OperationManager
    extends Manager {
        public OperationManager() {
            super(V7.this.metaData.getDocument("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f"));
        }

        public <T extends Ref> List<T> selectObjects(Date from, Date to) {
            RecordSet rs = new RecordSet();
            ArrayList<OperationReference> sample = new ArrayList<OperationReference>();
            rs.setParameter("from", from);
            rs.setParameter("to", to);
            ResultSet result = rs.executeQuery("select * from _1soper (nolock) where date_time_docid > :from and date_time_docid< :to~");
            while (result.next()) {
                sample.add(new OperationReference(result.getString("docid")));
            }
            return Collections.unmodifiableList(sample);
        }

        public <T extends Ref> List<T> selectRefs() {
            try {
                Date from = new SimpleDateFormat("yyyyMMdd").parse("17530101");
                Date to = Calendar.getInstance().getTime();
                return this.selectObjects(from, to);
            }
            catch (ParseException e) {
                throw new ExceptionAdapter(e);
            }
        }
    }

    public final class OperationObject
    extends Obj {
        private boolean newObject;
        private Date date;
        private String content;
        private BigDecimal sum;
        private boolean active;
        private DocumentObject docContext;
        private HashMap<String, Property> attributes;
        private ArrayList<Entry> entrys;

        public boolean isActive() {
            return this.active;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public void setDate(Date date) {
            this.date = date;
        }

        public BigDecimal getSum() {
            return this.sum;
        }

        public Date getDate() {
            return this.date;
        }

        public List<Entry> getEntrys() {
            this.entrys.clear();
            OperationReference operRef = (OperationReference)this.getRef();
            this.entrys.addAll(operRef.getEntrys());
            return Collections.unmodifiableList(this.entrys);
        }

        @Override
        String getPrefix() {
            String prefix;
            Metadatas.Document meta = (Metadatas.Document)this.getMetaObject();
            Calendar cal = Calendar.getInstance();
            cal.setTime(this.date);
            switch (meta.getPeriodicalCode()) {
                case 0: {
                    prefix = String.format("%1$10d%2$8S", meta.id, "");
                    break;
                }
                case 1: {
                    prefix = String.format("%1$10d%2$-8d", meta.id, cal.get(1));
                    break;
                }
                case 2: {
                    prefix = String.format("%1$10d%2$4d%3$02d  ", meta.id, cal.get(1), cal.get(2) / 3 + 1);
                    break;
                }
                case 3: {
                    prefix = String.format("%1$10d%2$4d%3$02d  ", meta.id, cal.get(1), cal.get(2) + 1);
                    break;
                }
                case 4: {
                    prefix = String.format("%1$10d%2$4d%3$02d%4$02d", meta.id, cal.get(1), cal.get(2) + 1, cal.get(5));
                    break;
                }
                default: {
                    throw new ExceptionAPI("\u041d\u0435\u043e\u0436\u0438\u0434\u0430\u043d\u043d\u0430\u044f \u043f\u0435\u0440\u0438\u043e\u0434\u0438\u0447\u043d\u043e\u0441\u0442\u044c \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430");
                }
            }
            return prefix;
        }

        @Override
        public void newObject() {
            this.setRef(new NullOperationReference());
            this.newObject = true;
            this.docContext = new DocumentObject("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f");
            this.docContext.newObject();
            this.docContext.setCreateOperation(true);
        }

        public void setSum(BigDecimal sum) {
            this.sum = sum;
        }

        private void operInsert() {
            RecordSet rs = new RecordSet();
            rs.setParameter("id", ((Ref)this.docContext.getRef()).getId());
            rs.setParameter("position", this.docContext.getPosition());
            rs.setParameter("active", this.isActive() ? " " : "*");
            rs.setParameter("descr", this.getContent());
            rs.setParameter("sum", this.getSum());
            String query = "insert into _1soper (docid, date_time_docid, active, descr, sum_";
            String strValues = ":id,:position~,:active,:descr,:sum";
            for (Property property : this.attributes.values()) {
                query = String.valueOf(query) + ",sp" + property.getId();
                strValues = String.valueOf(strValues) + ",'" + property.toInnerValue() + "'";
                if (!property.isUndefine()) continue;
                query = String.valueOf(query) + ",tsp" + property.getTSP();
                strValues = String.valueOf(strValues) + ",'" + property.getTSP() + "'";
            }
            query = String.valueOf(query) + ") values(" + strValues + ")";
            rs.executeUpdate(query);
            rs.executeUpdate("Update _1SCRDOC set FLAGS=FLAGS&~4 where CHILDID=:id; If @@ROWCOUNT>0 Delete from _1SCRDOC where CHILDID=:id and FLAGS=0");
            super.setRef(new OperationReference(((Ref)this.docContext.getRef()).getId()));
            this.crdocWrite(4, this.date, this.getSelectects(this.attributes.values()));
        }

        private void operUpdate() {
            RecordSet rs = new RecordSet();
            String query = "update _1soper set docid=:docid,date_time_docid=:position~,active=:active,sum_=:sum";
            for (Property property : this.attributes.values()) {
                query = String.valueOf(query) + ",sp" + property.getId() + "='" + property.toInnerValue() + "'";
                if (!property.isUndefine()) continue;
                query = String.valueOf(query) + ",tsp" + property.getId() + "='" + property.getTSP() + "'";
            }
            query = String.valueOf(query) + "\nwhere docid=:docid";
            rs.setParameter("docid", this.docContext.getRef());
            rs.setParameter("position", this.docContext.getPosition());
            rs.setParameter("active", this.isActive() ? " " : "*");
            rs.setParameter("descr", this.getContent());
            rs.setParameter("sum", this.getSum());
            rs.executeUpdate(query);
            rs.executeUpdate("Update _1SCRDOC set FLAGS=FLAGS&~4 where CHILDID=:docid; If @@ROWCOUNT>0 Delete from _1SCRDOC where CHILDID=:docid and FLAGS=0");
            this.crdocWrite(4, this.date, this.getSelectects(this.attributes.values()));
        }

        private void delete() {
            RecordSet rs = new RecordSet();
            rs.setParameter("id", this.getRef());
            rs.executeUpdate("delete from _1soper where docid=:id");
            rs.executeUpdate("Update _1SCRDOC set FLAGS=FLAGS&~12 where CHILDID=:id; If @@ROWCOUNT>0 Delete from _1SCRDOC where CHILDID=:id");
        }

        public void write() {
            if (((Metadatas.Reference)this.docContext.getMetaObject()).getName().equals("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f")) {
                this.docContext.write();
                super.setRef(this.docContext.operation);
            } else {
                this._write();
            }
            this.writeEntrys();
            this.docContext.writeOperation = true;
        }

        void _write() {
            if (this.newObject) {
                this.operInsert();
                this.newObject = false;
            } else if (!(this.getRef() instanceof Null)) {
                this.operUpdate();
            } else {
                throw new ExceptionAPI("\u041e\u0431\u044a\u0435\u043a\u0442 \u043d\u0435 \u0441\u043f\u043e\u0437\u0438\u0446\u0438\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d");
            }
        }

        public String toString() {
            return this.getRef().toString();
        }

        public void writeEntrys() {
            RecordSet rs = new RecordSet();
            ArrayList<Property> cPropertys = new ArrayList<Property>();
            int number = 0;
            Iterator<Entry> e = this.entrys.iterator();
            while (e.hasNext()) {
                this.docContext.block("_1sentry");
                Entry entry = e.next();
                if (!entry.getDebit().getAccount().getPlan().equals(entry.getKredit().getAccount().getPlan())) {
                    throw new ExceptionAPI("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0437\u0430\u043f\u0438\u0441\u0438 " + number + " \u043f\u0440\u043e\u0432\u043e\u0434\u043a\u0438: \u043d\u0435\u043b\u044c\u0437\u044f \u0437\u0430\u043f\u0438\u0441\u044b\u0432\u0430\u0442\u044c \u043f\u0440\u043e\u0432\u043e\u0434\u043a\u0443 \u0441\u043e \u0441\u0447\u0435\u0442\u0430\u043c\u0438 \u0438\u0437 \u0440\u0430\u0437\u043d\u044b\u0445 \u043f\u043b\u0430\u043d\u043e\u0432 \u0441\u0447\u0435\u0442\u043e\u0432");
                }
                String query = "insert into _1sentry (docid,number,corno,date_time_docid,accdtid,accktid,sum_,currid,cursum,amount,provkind,active,dtflags,ktflags,doclineno";
                for (Property property : entry.attributes.values()) {
                    query = String.valueOf(query) + ",sp" + property.getId();
                    if (!property.isUndefine()) continue;
                    query = String.valueOf(query) + ",tsp" + property.getId();
                }
                int i = 0;
                while (i < V7.this.metaData.getMaxSubconto()) {
                    query = String.valueOf(query) + ",dtsc" + i + ",vdtsc" + i + ",odtsc" + i + ",ktsc" + i + ",vktsc" + i + ",oktsc" + i;
                    ++i;
                }
                query = String.valueOf(query) + ") values (:docid,:number,:corno,:date_time_docid~~~~,:accdtid,:accktid,:sum_,:currid,:cursum,:amount,:provkind,:active,:dtflags,:ktflags,:doclineno";
                for (Property property : entry.attributes.values()) {
                    cPropertys.add(property);
                    query = String.valueOf(query) + ",'" + property.toInnerValue() + "'";
                    if (!property.isUndefine()) continue;
                    query = String.valueOf(query) + ",'" + property.getTSP() + "'";
                }
                i = 0;
                while (i < V7.this.metaData.getMaxSubconto()) {
                    String value;
                    Property property;
                    Metadatas.SubcontoKind subconto;
                    Entry.Correspondence corresp = entry.getDebit();
                    AccountReference account = corresp.getAccount();
                    int isOnlyTurnover = 0;
                    if (i < account.amountSubconto()) {
                        subconto = (Metadatas.SubcontoKind)account.getSubcontoKind(i).getMetaObject();
                        property = (Property)corresp.subcontos.get(i);
                        cPropertys.add(property);
                        value = property.toInnerValue();
                        isOnlyTurnover = account.isOnlyTurnover(i) ? 1 : 0;
                    } else {
                        subconto = (Metadatas.SubcontoKind)V7.this.metaData.getType('K', 0);
                        value = "";
                        isOnlyTurnover = 0;
                    }
                    query = String.valueOf(query) + ",'" + value + "','" + subconto.getId() + "'," + isOnlyTurnover;
                    corresp = entry.getKredit();
                    account = corresp.getAccount();
                    if (i < account.amountSubconto()) {
                        subconto = (Metadatas.SubcontoKind)account.getSubcontoKind(i).getMetaObject();
                        property = (Property)corresp.subcontos.get(i);
                        cPropertys.add(property);
                        value = property.toInnerValue();
                        isOnlyTurnover = account.isOnlyTurnover(i) ? 1 : 0;
                    } else {
                        subconto = (Metadatas.SubcontoKind)V7.this.metaData.getType('K', 0);
                        value = "";
                        isOnlyTurnover = 0;
                    }
                    query = String.valueOf(query) + ",'" + value + "','" + subconto.getId() + "'," + isOnlyTurnover;
                    ++i;
                }
                query = String.valueOf(query) + ")";
                rs.setParameter("docid", this.docContext.getRef());
                rs.setParameter("number", number);
                rs.setParameter("corno", 0);
                rs.setParameter("date_time_docid", this.docContext.getRef());
                rs.setParameter("accdtid", entry.getDebit().getAccount());
                rs.setParameter("accktid", entry.getKredit().getAccount());
                rs.setParameter("sum_", entry.getSum());
                rs.setParameter("currid", entry.getCurrency());
                rs.setParameter("cursum", entry.getCurrencySum());
                rs.setParameter("amount", entry.getAmount());
                rs.setParameter("provkind", " ");
                rs.setParameter("active", entry.getActive() ? " " : "*");
                rs.setParameter("dtflags", this.accauntFlags(entry.getDebit().getAccount()));
                rs.setParameter("ktflags", this.accauntFlags(entry.getKredit().getAccount()));
                rs.setParameter("doclineno", entry.doclineno);
                rs.executeUpdate(query);
                ResultSet result = rs.executeQuery("declare @P1 int\nexec _1sp__1SENTRY_MaxRowID @P1 output\nselect @P1");
                result.next();
                rs.setParameter("rowid", result.getInt(1));
                rs.setParameter("curdate", V7.this._1ssystem.getAccdate());
                rs.executeUpdate("exec _1sp__1SENTRY_NewEntry :curdate~~, :rowid, 1, 1, 1, 1");
                ++number;
            }
            this.crdocWrite(8, this.date, this.getSelectects(cPropertys));
        }

        private int accauntFlags(AccountReference account) {
            int result = 0;
            if (account.isCurrency()) {
                ++result;
            }
            if (account.isAmount()) {
                result += 2;
            }
            if (account.isSingle()) {
                result += 4;
            }
            return result;
        }

        public Entry newEntry() {
            return new Entry();
        }

        public String getContent() {
            return this.content;
        }

        public void setContent(String content) {
            this.content = content;
        }

        public OperationObject() {
            super(V7.this.metaData.getDocument("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f"));
            this.attributes = new HashMap();
            this.entrys = new ArrayList();
            this.initAttributes();
        }

        OperationObject(DocumentObject doc) {
            super(V7.this.metaData.getDocument("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f"));
            this.attributes = new HashMap();
            this.entrys = new ArrayList();
            this.docContext = doc;
            this.setRef(doc.operation);
        }

        private boolean exist() {
            RecordSet rs = new RecordSet();
            rs.setParameter("docid", this.getRef());
            ResultSet result = rs.executeQuery("select * from _1soper (nolock) where docid=:docid");
            return result.next();
        }

        @Override
        public void setRef(Ref ref) {
            super.setRef(ref);
            if (ref instanceof Null) {
                this.initAttributes();
            } else {
                this.readAttributes();
            }
        }

        public void setDocument(DocumentReference doc) {
            this.setRef(doc.getOperation());
            if (this.getRef() instanceof NullOperationReference) {
                throw new ExceptionAPI("\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430");
            }
        }

        private void initAttributes() {
            this.date = new Date(System.currentTimeMillis());
            this.content = "";
            this.active = true;
            this.sum = BigDecimal.valueOf(0L);
            this.attributes.clear();
            for (Metadatas.EntryProperty property : V7.this.metaData.getOperPropertys()) {
                this.attributes.put(property.getName(), new Property(property));
            }
        }

        private void readAttributes() {
            RecordSet rs = new RecordSet();
            rs.setParameter("docid", this.getRef());
            ResultSet result = rs.executeQuery("select * from _1soper (nolock) where docid=:docid");
            result.next();
            this.date = new Position(result.getString("date_time_docid")).getDate();
            this.content = result.getString("descr");
            this.active = !result.getString("active").equals("*");
            this.sum = result.getBigDecimal("sum_");
            this.attributes.clear();
            for (Metadatas.EntryProperty property : V7.this.metaData.getOperPropertys()) {
                this.attributes.put(property.getName(), new Property(property, result.getRef("sp" + property.getId(), (Metadatas.Reference)property)));
            }
        }

        public void setProperty(String name, Object value) {
            Metadatas.EntryProperty property = V7.this.metaData.getOperProperty(name);
            if (property == null) {
                throw new ExceptionAPI("\u041d\u0435\u0442 \u0440\u0435\u043a\u0432\u0438\u0437\u0438\u0442\u0430 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438 \u0441 \u0438\u043c\u0435\u043d\u0435\u043c '" + name + "'");
            }
            this.attributes.get(property.getName()).setValue(value);
        }

        public void put(Entry entry) {
            this.entrys.add(entry);
        }

        public void clearEntrys() {
            this.entrys.clear();
        }
    }

    public class OperationReference
    extends Ref {
        OperationReference(String id) {
            super(id, V7.this.metaData.getDocument("\u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f"));
        }

        @Override
        String getTypeId() {
            return "O1";
        }

        @Override
        String getVidId() {
            return String.format("%1$4S", Integer.toString(((Metadatas.Reference)this.getMetaObject()).getId(), 36));
        }

        public List<Entry> getEntrys() {
            ArrayList<Entry> sample = new ArrayList<Entry>();
            RecordSet rs = new RecordSet();
            rs.setParameter("id", this.getId());
            ResultSet result = rs.executeQuery("Select * from _1SENTRY(NOLOCK INDEX=DOCIDNUMBER) where DOCID=:id order by DOCID,NUMBER,CORNO");
            while (result.next()) {
                Entry entry = new Entry();
                entry.readAttributes(result);
                sample.add(entry);
            }
            return Collections.unmodifiableList(sample);
        }

        public String toString() {
            RecordSet rs = V7.this.getRecordSet();
            rs.setParameter("id", this);
            ResultSet result = rs.executeQuery("select * from _1sjourn (nolock) where iddoc=:id");
            String name = ((Metadatas.Reference)this.getMetaObject()).getSynonym();
            if (name.trim().length() == 0) {
                name = ((Metadatas.Reference)this.getMetaObject()).getName();
            }
            if (result.next()) {
                return String.valueOf(name) + " " + result.getString("docno").trim();
            }
            return "<\u041e\u0431\u044a\u0435\u043a\u0442 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d>(" + this.getId() + ")";
        }
    }

    public class PlanReference
    extends Ref {
        PlanReference(int id) {
            super(String.format("%1$4S     ", Integer.toString(id, 36)), (Metadatas.Reference)V7.this.metaData.getType('P', 0));
        }

        @Override
        String getTypeId() {
            return "P1";
        }

        @Override
        String getVidId() {
            return "   0";
        }

        public String toString() {
            return ((Metadatas.Reference)V7.this.metaData.getType('T', Integer.valueOf(this.getId().trim(), 36))).getName();
        }
    }

    final class Property {
        private Object value;
        private Date date;
        private DocumentReference document;
        private final Metadatas.Qualifier metaObject;
        private boolean modified;

        public Property(Metadatas.Qualifier meta) {
            this.metaObject = meta;
            this.value = this.metaObject.NullValue();
        }

        public String toString() {
            return this.value.toString();
        }

        public Metadatas.Qualifier getMetaObject() {
            return this.metaObject;
        }

        public Property(Metadatas.Qualifier meta, Object value) {
            this.metaObject = meta;
            this.value = value;
        }

        public DocumentReference getDocument() {
            return this.document;
        }

        public int getId() {
            return this.metaObject.getId();
        }

        public String getName() {
            return this.metaObject.getName();
        }

        public Date getDate() {
            return this.date;
        }

        public boolean isPeriodical() {
            return this.metaObject.isPeriodical();
        }

        public void setValue(Object value, Date date, DocumentReference document) {
            this.document = document;
            this.setValue(value, date);
        }

        public void setValue(Object value, Date date) {
            if (!this.metaObject.isPeriodical()) {
                throw new ExceptionAPI("\u041c\u0435\u0442\u043e\u0434 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u0434\u043b\u044f \u043f\u0435\u0440\u0438\u043e\u0434\u0438\u0447\u0435\u0441\u043a\u0438\u0445 \u0440\u0435\u043a\u0432\u0438\u0437\u0438\u0442\u043e\u0432");
            }
            if (date == null) {
                throw new ExceptionAPI("\u041d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430 \u0434\u0430\u0442\u0430 \u043f\u0435\u0440\u0438\u043e\u0434\u0438\u0447\u0435\u0441\u043a\u043e\u0433\u043e \u0430\u0442\u0440\u0438\u0431\u0443\u0442\u0430");
            }
            this.date = date;
            this._setValue(value);
        }

        public boolean isNull() {
            return this.metaObject.NullValue().equals(this.value);
        }

        private void _setValue(Object value) {
            Object inputMeta;
            if (value instanceof String) {
                this.value = value;
                inputMeta = V7.this.metaData.getType(((V7)V7.this).metaData.STRING, 0);
            } else if (value instanceof Integer) {
                this.value = BigDecimal.valueOf(((Integer)value).intValue());
                inputMeta = V7.this.metaData.getType(((V7)V7.this).metaData.NUMERIC, 0);
            } else if (value instanceof BigDecimal) {
                this.value = value;
                ((BigDecimal)this.value).setScale(this.metaObject.precision, 4);
                inputMeta = V7.this.metaData.getType(((V7)V7.this).metaData.NUMERIC, 0);
            } else if (value instanceof Date) {
                this.value = value;
                inputMeta = V7.this.metaData.getType(((V7)V7.this).metaData.DATE, 0);
            } else {
                this.value = value;
                inputMeta = ((Ref)value).getMetaObject();
            }
            if (!this.metaObject.type.equals(inputMeta)) {
                throw new ExceptionAPI("\u0423\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u0435\u043c\u044b\u0439 \u0442\u0438\u043f \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f \u043d\u0435 \u0441\u043e\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0442\u0438\u043f\u0443 \u0440\u0435\u043a\u0432\u0438\u0437\u0438\u0442\u0430");
            }
            this.modified = true;
        }

        public void setValue(Object value) {
            if (this.metaObject.isPeriodical()) {
                throw new ExceptionAPI("\u041c\u0435\u0442\u043e\u0434 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u0434\u043b\u044f \u043d\u0435 \u043f\u0435\u0440\u0438\u043e\u0434\u0438\u0447\u0435\u0441\u043a\u0438\u0445 \u0440\u0435\u043a\u0432\u0438\u0437\u0438\u0442\u043e\u0432");
            }
            this._setValue(value);
        }

        public Object getValue() {
            return this.value;
        }

        public boolean isModified() {
            return this.modified;
        }

        public String toInnerValue() {
            if (this.metaObject instanceof Metadatas.SubcontoKind) {
                return ((Metadatas.SubcontoKind)this.metaObject).type.toInnerValue(this.value);
            }
            return this.metaObject.toInnerValue(this.value);
        }

        public String toInnerValue23() {
            Object undefine = V7.this.metaData.getType('U', 0);
            return ((Metadatas.Reference)undefine).toInnerValue(this.value);
        }

        public boolean isUndefine() {
            return this.metaObject.type instanceof Metadatas.Undefine;
        }

        public String getTSP() {
            if (!(this.metaObject.type instanceof Metadatas.Undefine)) {
                return "   ";
            }
            if (this.value instanceof BigDecimal) {
                int len = ((BigDecimal)this.value).toPlainString().length() - 1;
                int prec = ((BigDecimal)this.value).precision();
                return String.format("%1$X%2$X ", Integer.toString(len, 36), Integer.toString(prec, 36));
            }
            if (this.value instanceof Integer) {
                int len = this.value.toString().length();
                return String.format("%1$X  ", Integer.toString(len, 36));
            }
            if (this.value instanceof Date) {
                return "   ";
            }
            if (this.value instanceof String) {
                int len = ((String)this.value).trim().length();
                return String.format("$1%3X", len);
            }
            if (this.value instanceof Ref) {
                Ref ref = (Ref)this.value;
                if (ref.getVidId() == "   0") {
                    return "0  ";
                }
                return "1  ";
            }
            return "   ";
        }
    }

    public class RecordSet {
        private boolean debug;
        private final Statement statement;
        public static final int TYPE_FORWARD_ONLY = 1003;
        public static final int TYPE_SCROLL_INSENSITIVE = 1004;
        public static final int TYPE_SCROLL_SENSITIVE = 1005;
        public static final int CONCUR_READ_ONLY = 1007;
        public static final int CONCUR_UPDATABLE = 1008;
        private boolean modRPC;
        private HashMap<String, Object> textParameters = new HashMap();

        public RecordSet() {
            try {
                this.statement = V7.this.cn.createStatement();
            }
            catch (SQLException e) {
                throw new ExceptionAdapter(e);
            }
        }

        public void setDebug(boolean mode) {
            this.debug = mode;
        }

        public RecordSet(int resultSetType, int resultSetConcurrency) {
            try {
                this.statement = V7.this.cn.createStatement(resultSetType, resultSetConcurrency);
            }
            catch (SQLException e) {
                throw new ExceptionAdapter(e);
            }
        }

        public void close() {
            try {
                this.statement.close();
            }
            catch (SQLException e) {
                throw new ExceptionAdapter(e);
            }
        }

        private String parseMetaName(String key) {
            return (String)V7.this.metaName.get(key.toLowerCase());
        }

        public void setRPC(boolean modRPC) {
            this.modRPC = modRPC;
        }

        public String parse(String textQuery) {
            String virtual;
            String probKey;
            String parseQuery = textQuery;
            int flags = 98;
            Pattern p = Pattern.compile("\\$(([\u0430-\u044f0-9_a-z]*)[\u0430-\u044f0-9\\._a-z]*)", flags);
            Matcher m = p.matcher(textQuery);
            while (m.find()) {
                try {
                    String replace;
                    if (m.group(2).equalsIgnoreCase("\u041f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0435\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435") || m.group(2).equalsIgnoreCase("\u041f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0435\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435\u0422\u0438\u043f") || (replace = this.parseMetaName(m.group(1))) == null) continue;
                    parseQuery = this.replaceMetaString(parseQuery, "\\$" + m.group(1) + "(?=$|[^a-z_0-9\u0430-\u044f])", replace);
                }
                catch (Exception e) {
                    throw new ExceptionAPI("\u041d\u0435 \u0440\u0430\u0437\u0440\u0435\u0448\u0438\u043c\u043e\u0435 \u043c\u0435\u0442\u0430\u0438\u043c\u044f: '" + m.group(1) + "'");
                }
            }
            p = Pattern.compile("([^\\$\\s]+?)\\s+AS\\s+([a-z_\u0430-\u044f][0-9a-z_\u0430-\u044f]*)", flags);
            m = p.matcher(textQuery);
            while (m.find()) {
                String pattern = "\\$_ALIACE_\\.([^\\$\\s]+?)(?:\\s|$)";
                pattern = pattern.replace("_ALIACE_", m.group(2));
                Pattern p2 = Pattern.compile(pattern, flags);
                Matcher m2 = p2.matcher(textQuery);
                while (m2.find()) {
                    String probKey2 = String.valueOf(m.group(1)) + "." + m2.group(1);
                    try {
                        parseQuery = this.replaceMetaString(parseQuery, "\\$" + m.group(2) + "\\." + m2.group(1) + "(?=$|[^a-z_0-9\u0430-\u044f])", String.valueOf(m.group(2)) + "." + this.parseMetaName(probKey2));
                    }
                    catch (Exception e) {
                        throw new ExceptionAPI("\u041d\u0435 \u0440\u0430\u0437\u0440\u0435\u0448\u0438\u043c\u043e\u0435 \u043c\u0435\u0442\u0430\u0438\u043c\u044f '" + probKey2 + "'");
                    }
                }
            }
            p = Pattern.compile("(\\$\u041f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0435\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435\\.([^\\$\\s]+?)\\.([^\\$\\s]+?)\\s?\\(([^,\\s]+)\\s?,\\s?([^\\s]+?)\\s?\\))", flags);
            m = p.matcher(textQuery);
            while (m.find()) {
                probKey = "\u041f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0435\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435." + m.group(2) + "." + m.group(3);
                try {
                    virtual = this.parseMetaName(probKey);
                    virtual = virtual.replace("arg1_vv", m.group(4));
                    virtual = virtual.replace("arg2_vv", m.group(5));
                    parseQuery = parseQuery.replace(m.group(1), virtual);
                }
                catch (Exception e) {
                    throw new ExceptionAPI("\u041d\u0435 \u0440\u0430\u0437\u0440\u0435\u0448\u0438\u043c\u043e\u0435 \u043c\u0435\u0442\u0430\u0438\u043c\u044f '" + probKey + "'");
                }
            }
            p = Pattern.compile("(\\$\u041f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0435\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435\u0422\u0438\u043f\\.([^\\$\\s]+?)\\.([^\\$\\s]+?)\\s?\\(([^,\\s]+)\\s?,\\s?([^\\s]+?)\\s?\\))", flags);
            m = p.matcher(textQuery);
            while (m.find()) {
                probKey = "\u041f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0435\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435\u0422\u0438\u043f." + m.group(2) + "." + m.group(3);
                try {
                    virtual = this.parseMetaName(probKey);
                    virtual = virtual.replace("arg1_vv", m.group(4));
                    virtual = virtual.replace("arg2_vv", m.group(5));
                    parseQuery = parseQuery.replace(m.group(1), virtual);
                }
                catch (Exception e) {
                    throw new ExceptionAPI("\u041d\u0435 \u0440\u0430\u0437\u0440\u0435\u0448\u0438\u043c\u043e\u0435 \u043c\u0435\u0442\u0430\u0438\u043c\u044f '" + probKey + "'");
                }
            }
            p = Pattern.compile("(\\$\u041e\u0431\u0449\u0438\u0439\u0420\u0435\u043a\u0432\u0438\u0437\u0438\u0442\\.([^\\$\\s]+))", flags);
            m = p.matcher(textQuery);
            while (m.find()) {
                probKey = "\u041e\u0431\u0449\u0438\u0439\u0420\u0435\u043a\u0432\u0438\u0437\u0438\u0442." + m.group(2);
                try {
                    parseQuery = parseQuery.replace(m.group(1), this.parseMetaName(probKey));
                }
                catch (Exception e) {
                    throw new ExceptionAPI("\u041d\u0435 \u0440\u0430\u0437\u0440\u0435\u0448\u0438\u043c\u043e\u0435 \u043c\u0435\u0442\u0430\u0438\u043c\u044f '" + probKey + "'");
                }
            }
            p = Pattern.compile("(\\$\u041e\u0431\u0449\u0438\u0439\u0420\u0435\u043a\u0432\u0438\u0437\u0438\u0442\u0422\u0438\u043f\\.([^\\$\\s]+))", flags);
            m = p.matcher(textQuery);
            while (m.find()) {
                probKey = "\u041e\u0431\u0449\u0438\u0439\u0420\u0435\u043a\u0432\u0438\u0437\u0438\u0442\u0422\u0438\u043f." + m.group(2);
                try {
                    parseQuery = parseQuery.replace(m.group(1), this.parseMetaName(probKey));
                }
                catch (Exception e) {
                    throw new ExceptionAPI("\u041d\u0435 \u0440\u0430\u0437\u0440\u0435\u0448\u0438\u043c\u043e\u0435 \u043c\u0435\u0442\u0430\u0438\u043c\u044f '" + probKey + "'");
                }
            }
            p = Pattern.compile("(\\$[\u0430-\u044fa-z0-9_\\.]*)", flags);
            m = p.matcher(parseQuery);
            HashSet<String> unknowMetaName = new HashSet<String>();
            while (m.find()) {
                unknowMetaName.add(m.group(1));
            }
            if (unknowMetaName.size() > 0) {
                String errorMesage = "\u041d\u0435 \u0440\u0430\u0437\u0440\u0435\u0448\u0438\u043c\u044b\u0435 \u043c\u0435\u0442\u0430\u0438\u043c\u0435\u043d\u0430:";
                Iterator i = unknowMetaName.iterator();
                while (i.hasNext()) {
                    errorMesage = String.valueOf(errorMesage) + "\n " + (String)i.next();
                }
                if (this.debug) {
                    errorMesage = String.valueOf(errorMesage) + "\nsource query:\n" + textQuery;
                    errorMesage = String.valueOf(errorMesage) + "\nresult query:\n" + parseQuery;
                }
                throw new ExceptionAPI(errorMesage);
            }
            ArrayList<AbstractMap.SimpleEntry<String, String>> RPCParams = new ArrayList<AbstractMap.SimpleEntry<String, String>>();
            p = Pattern.compile("(:([\u0430-\u044f_a-z0-9]+)(~{0,4}))", flags);
            m = p.matcher(textQuery);
            while (m.find()) {
                String nameParameter = m.group(1);
                if (this.textParameters.containsKey(m.group(2))) {
                    int mod;
                    Object value = this.textParameters.get(m.group(2));
                    AbstractMap.SimpleEntry<String, String> map = this.toInnerValue(value, mod = m.group(3).length());
                    if (map.getValue() != null) {
                        if (this.modRPC) {
                            RPCParams.add(map);
                            parseQuery = this.replaceMetaString(parseQuery, String.valueOf(nameParameter) + "(?=$|[^a-z_0-9\u0430-\u044f])", "@P" + RPCParams.size());
                            continue;
                        }
                        parseQuery = this.replaceMetaString(parseQuery, String.valueOf(nameParameter) + "(?=$|[^a-z_0-9\u0430-\u044f])", "'" + map.getValue() + "'");
                        continue;
                    }
                    throw new ExceptionAPI("\u041d\u0435 \u0441\u043c\u043e\u0433\u043b\u0438 \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u0442\u044c \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 '" + nameParameter + "': " + textQuery);
                }
                throw new ExceptionAPI("\u041d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043e \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430 '" + nameParameter + "': " + textQuery);
            }
            if (this.modRPC) {
                String vars = "";
                String values = "";
                int k = 1;
                for (Map.Entry entry : RPCParams) {
                    vars = String.valueOf(vars) + "@P" + k + " " + (String)entry.getKey() + ",";
                    values = String.valueOf(values) + "'" + (String)entry.getValue() + "',";
                    ++k;
                }
                vars = vars.substring(0, vars.length() - 1);
                values = values.substring(0, values.length() - 1);
                parseQuery = "exec sp_executesql N'" + parseQuery + "'" + ",N'" + vars + "'," + values;
                return parseQuery;
            }
            return parseQuery;
        }

        private String replaceMetaString(String text, String pattern, String replace) {
            Pattern p = Pattern.compile(pattern, 98);
            Matcher m = p.matcher(text);
            return m.replaceAll(replace);
        }

        private AbstractMap.SimpleEntry<String, String> toInnerValue(Object value, int mod) {
            String innerValue = null;
            String typeSQL = null;
            switch (mod) {
                case 0: {
                    if (value instanceof String) {
                        innerValue = value.toString();
                        int len = ((String)value).length();
                        len = len > 8000 ? 8000 : len;
                        typeSQL = "char(" + len + ")";
                        break;
                    }
                    if (value instanceof Integer) {
                        innerValue = value.toString();
                        typeSQL = "numeric(" + ((Integer)value).toString().length() + ",0)";
                        break;
                    }
                    if (value instanceof BigDecimal) {
                        innerValue = ((BigDecimal)value).toPlainString();
                        typeSQL = "numeric(" + (((BigDecimal)value).toPlainString().length() - 1) + "," + ((BigDecimal)value).precision() + ")";
                        break;
                    }
                    if (value instanceof Date) {
                        innerValue = String.format("%1$tY%1$tm%1$td", (Date)value);
                        typeSQL = "char(8)";
                        break;
                    }
                    if (value instanceof Ref) {
                        innerValue = ((Ref)value).getId();
                        typeSQL = "char(9)";
                        break;
                    }
                    if (!(value instanceof Property)) break;
                    Property property = (Property)value;
                    innerValue = property.toInnerValue();
                    typeSQL = property.getMetaObject().typeSQL();
                    break;
                }
                case 1: {
                    if (value instanceof Date) {
                        innerValue = String.format("%1$tY%1$tm%1$tdZ", (Date)value);
                        typeSQL = "char(9)";
                        break;
                    }
                    if (value instanceof Position) {
                        innerValue = ((Position)value).toString();
                        typeSQL = "char(23)";
                        break;
                    }
                    if (!(value instanceof Ref)) break;
                    Ref ref = (Ref)value;
                    innerValue = String.format("%1$4S%2$9S", ref.getVidId(), ref.getId());
                    typeSQL = "char(13)";
                    break;
                }
                case 2: {
                    if (value instanceof Date) {
                        innerValue = new SimpleDateFormat("yyyyMMdd HH:mm:ss").format(value);
                        typeSQL = "datetime";
                        break;
                    }
                    if (value instanceof Ref) {
                        Ref ref = (Ref)value;
                        innerValue = String.format("%1$2S%2$4S%3$9S", ref.getTypeId(), ref.getVidId(), ref.getId());
                        typeSQL = "char(15)";
                        break;
                    }
                    if (!(value instanceof Property)) break;
                    Property property = (Property)value;
                    innerValue = property.toInnerValue23();
                    typeSQL = "char(23)";
                    break;
                }
                case 3: {
                    if (!(value instanceof Ref)) break;
                    if (V7.this.isSQLFormat()) {
                        innerValue = "" + Integer.valueOf(((Ref)value).getVidId(), 36);
                        typeSQL = "char(4)";
                        break;
                    }
                    innerValue = ((Ref)value).getVidId();
                    typeSQL = "int";
                    break;
                }
                case 4: {
                    if (!(value instanceof DocumentReference)) break;
                    innerValue = ((DocumentReference)value).getPosition().toString();
                    typeSQL = "char(23)";
                    break;
                }
                default: {
                    throw new ExceptionAPI("\u041d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u043e\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043c\u043e\u0434\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u043e\u0432");
                }
            }
            return new AbstractMap.SimpleEntry<Object, String>(typeSQL, innerValue);
        }

        public void setParameter(String key, Object value) {
            this.textParameters.put(key, value);
        }

        public Object getParameter(String key) {
            return this.textParameters.get(key);
        }

        public int executeUpdate(String sql) {
            String parseSQL = this.parse(sql);
            if (this.debug) {
                System.out.println(parseSQL);
            }
            try {
                return this.statement.executeUpdate(parseSQL);
            }
            catch (SQLException e) {
                throw new ExceptionAPI(String.valueOf(e.getMessage()) + "\n" + parseSQL);
            }
        }

        public int getUpdateCount() {
            try {
                return this.statement.getUpdateCount();
            }
            catch (SQLException e) {
                throw new ExceptionAdapter(e);
            }
        }

        public ResultSet executeQuery(String sql) {
            if (this.debug) {
                System.out.println(sql);
            }
            String parseSQL = this.parse(sql);
            if (this.debug) {
                System.out.println(parseSQL);
            }
            try {
                return new ResultSet(this.statement.executeQuery(parseSQL));
            }
            catch (SQLException e) {
                throw new ExceptionAPI(String.valueOf(e.getMessage()) + "\n" + parseSQL);
            }
        }
    }

    public abstract class Ref {
        private final String id;
        private final Metadatas.Reference metaObject;

        String getId() {
            return this.id;
        }

        Ref(String id, Metadatas.Reference metaObject) {
            this.id = id;
            this.metaObject = metaObject;
            if (this.id == null) {
                throw new ExceptionAPI("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043a\u0438 null \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044e id \u0441\u0441\u044b\u043b\u043a\u0438");
            }
            if (this.metaObject == null) {
                throw new ExceptionAPI("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u0441\u043e\u0437\u0434\u0430\u0442\u044c \u043e\u0431\u044a\u0435\u043a\u0442 \u0441 \u043d\u0435\u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u043d\u044b\u043c\u0438 \u043c\u0435\u0442\u0430\u0434\u0430\u043d\u043d\u044b\u043c\u0438");
            }
        }

        public <T extends Metadatas.Reference> T getMetaObject() {
            return (T)this.metaObject;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Ref)) {
                return false;
            }
            return this.getVidId().equals(((Ref)obj).getVidId()) && this.getId().equals(((Ref)obj).getId());
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        abstract String getTypeId();

        abstract String getVidId();
    }

    public final class RegisterObject {
        private final DocumentObject docContext;
        private final Metadatas.Register metaObject;
        private ArrayList<Advance> advances = new ArrayList();

        private RegisterObject(DocumentObject doc, String name) {
            if (doc == null) {
                throw new ExceptionAPI("\u041f\u043e\u043f\u044b\u0442\u043a\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430 \u0441 null \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435\u043c \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430");
            }
            this.docContext = doc;
            Metadatas.Document metaDoc = (Metadatas.Document)this.docContext.getMetaObject();
            if (!metaDoc.isOperativeRecording()) {
                throw new ExceptionAPI("\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u043d\u0435 \u0443\u0447\u0430\u0441\u0442\u0432\u0443\u0435\u0442 \u0432 \u043e\u043f\u0435\u0440\u0430\u0442\u0438\u0432\u043d\u043e\u043c \u0443\u0447\u0435\u0442\u0435");
            }
            this.metaObject = V7.this.metaData.getRegister(name);
            if (this.metaObject == null) {
                throw new ExceptionAPI("\u041d\u0435\u0443\u0434\u0430\u0447\u043d\u0430\u044f \u043f\u043e\u043f\u044b\u0442\u043a\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430 '" + name + "'");
            }
        }

        public List<Advance> getAdvances() {
            return Collections.unmodifiableList(this.advances);
        }

        public Advance createAdvance() {
            return new Advance(this.metaObject, (DocumentReference)this.docContext.getRef());
        }

        private void readAttibute() {
            RecordSet rs = new RecordSet();
            rs.setParameter("iddoc", this.docContext.getRef());
            ResultSet result = rs.executeQuery("select * from ra" + this.metaObject.getId() + " (nolock) where iddoc=:iddoc");
            this.advances.clear();
            while (result.next()) {
                Advance advance = new Advance(this.metaObject, (DocumentReference)this.docContext.getRef());
                advance.readAttribute(result);
                this.advances.add(advance);
            }
        }

        public void put(Advance advance) {
            advance.lineno = this.docContext.row;
            this.advances.add(advance);
        }

        public void write() {
            ArrayList<Property> cPropertys = new ArrayList<Property>();
            for (Advance advance : this.advances) {
                RecordSet rs = new RecordSet();
                String query = "exec _1sp_RA" + this.metaObject.getId() + "_WriteDocAct :id, :row, :action, :direction";
                if (this.metaObject.isFastHandling()) {
                    query = String.valueOf(query) + ", :docdef, :position~";
                }
                for (Property dimension : advance.dimensions.values()) {
                    cPropertys.add(dimension);
                    query = String.valueOf(query) + ", '" + dimension.toInnerValue() + "'";
                }
                for (Property figure : advance.figures.values()) {
                    query = String.valueOf(query) + ", " + figure.toInnerValue();
                }
                for (Property field : advance.fields.values()) {
                    cPropertys.add(field);
                    query = String.valueOf(query) + ", '" + field.toInnerValue() + "'";
                }
                query = String.valueOf(query) + ", :date~~, :curPeriod~~, :RepeatToTM, :SaveTurnsWithMonth";
                Date curDate = this.docContext.getBeginOfPeriod(this.docContext.getDate());
                rs.setParameter("id", ((Ref)this.docContext.getRef()).getId());
                rs.setParameter("row", this.docContext.row);
                DocumentObject documentObject = this.docContext;
                int n = documentObject.action + 1;
                documentObject.action = n;
                rs.setParameter("action", n);
                rs.setParameter("direction", advance.getDebkred());
                rs.setParameter("docdef", this.docContext.metaObject.getId());
                rs.setParameter("position", this.docContext.getPosition());
                rs.setParameter("date", this.docContext.getDate());
                rs.setParameter("curPeriod", curDate);
                rs.setParameter("RepeatToTM", 0);
                rs.setParameter("SaveTurnsWithMonth", 0);
                rs.executeUpdate(query);
            }
            this.docContext.crdocWrite(2, this.docContext.date, this.docContext.getSelectects(cPropertys));
            this.docContext.movementRegisters.add(this.metaObject);
        }
    }

    public class ResultSet {
        private static final boolean DEBAG = false;
        private final java.sql.ResultSet result;
        private String label;
        private int index;
        private Metadatas.Qualifier qualifier;

        public void close() {
            try {
                this.result.close();
            }
            catch (Exception e) {
                throw new ExceptionAdapter(e);
            }
        }

        public boolean previous() {
            try {
                return this.result.previous();
            }
            catch (Exception e) {
                throw new ExceptionAdapter(e);
            }
        }

        Metadatas.Qualifier getQualifier() {
            return this.qualifier;
        }

        void setQualifier(Metadatas.Qualifier qualifier) {
            this.qualifier = qualifier;
        }

        private void setLabel(String label) {
            ResultSetMetaData meta;
            try {
                meta = this.result.getMetaData();
            }
            catch (SQLException e) {
                throw new ExceptionAPI("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043a \u0431\u0430\u0437\u0435 \u0434\u0430\u043d\u043d\u044b\u0445 \u0438\u043b\u0438 \u043a\u0443\u0440\u0441\u043e\u0440 \u043d\u0435 \u043e\u0442\u043a\u0440\u044b\u0442");
            }
            try {
                int i = 1;
                while (i <= meta.getColumnCount()) {
                    if (meta.getColumnLabel(i).equalsIgnoreCase(label)) {
                        this.label = label;
                        this.index = i;
                        return;
                    }
                    ++i;
                }
            }
            catch (SQLException e) {
                throw new ExceptionAPI("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043a \u0431\u0430\u0437\u0435 \u0434\u0430\u043d\u043d\u044b\u0445");
            }
            throw new ExceptionAPI("\u041f\u043e\u043b\u0435 '" + label + "' \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0432 \u0432\u044b\u0431\u043e\u0440\u043a\u0435");
        }

        String getLabel() {
            return this.label;
        }

        int getIndex() {
            return this.index;
        }

        private void setIndex(int index) {
            ResultSetMetaData meta;
            try {
                meta = this.result.getMetaData();
            }
            catch (SQLException e) {
                throw new ExceptionAPI("\u041e\u0448\u0438\u0431\u043a\u0430 \u0437\u0430\u043f\u0440\u043e\u0441\u0430 \u043a \u0431\u0430\u0437\u0435 \u0434\u0430\u043d\u043d\u044b\u0445 \u0438\u043b\u0438 \u043a\u0443\u0440\u0441\u043e\u0440 \u043d\u0435 \u043e\u0442\u043a\u0440\u044b\u0442");
            }
            try {
                this.label = meta.getColumnName(index);
            }
            catch (SQLException e) {
                throw new ExceptionAPI("\u041d\u043e\u043c\u0435\u0440 '" + index + "' \u043f\u043e\u043b\u044f \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0432 \u0432\u044b\u0431\u043e\u0440\u043a\u0435");
            }
            this.index = index;
        }

        public ResultSetMetaData getMetaData() {
            try {
                return this.result.getMetaData();
            }
            catch (SQLException e) {
                throw new ExceptionAdapter(e);
            }
        }

        private ResultSet(java.sql.ResultSet result) {
            this.result = result;
        }

        public boolean next() {
            try {
                return this.result.next();
            }
            catch (SQLException e) {
                throw new ExceptionAdapter(e);
            }
        }

        String getString() {
            try {
                return this.result.getString(this.index);
            }
            catch (SQLException e) {
                throw new ExceptionAdapter(e);
            }
        }

        public String getString(int columnIndex) {
            this.setIndex(columnIndex);
            return this.getString();
        }

        public String getString(String columnLabel) {
            this.setLabel(columnLabel);
            return this.getString();
        }

        boolean getBoolean() {
            try {
                return this.result.getBoolean(this.index);
            }
            catch (SQLException e) {
                throw new ExceptionAdapter(e);
            }
        }

        public boolean getBoolean(int columnIndex) {
            this.setIndex(columnIndex);
            return this.getBoolean();
        }

        public boolean getBoolean(String columnLabel) {
            this.setLabel(columnLabel);
            return this.getBoolean();
        }

        BigDecimal getBigDecimal() {
            try {
                return this.result.getBigDecimal(this.index);
            }
            catch (SQLException e) {
                throw new ExceptionAdapter(e);
            }
        }

        public BigDecimal getBigDecimal(int columnIndex) {
            this.setIndex(columnIndex);
            return this.getBigDecimal();
        }

        public BigDecimal getBigDecimal(String columnLabel) {
            this.setLabel(columnLabel);
            return this.getBigDecimal();
        }

        int getInt() {
            try {
                return this.result.getInt(this.index);
            }
            catch (SQLException e) {
                throw new ExceptionAdapter(e);
            }
        }

        public int getInt(int columnIndex) {
            this.setIndex(columnIndex);
            return this.getInt();
        }

        public int getInt(String columnLabel) {
            this.setLabel(columnLabel);
            return this.getInt();
        }

        public Date getDate(String columnLabel) {
            this.setLabel(columnLabel);
            return this.getDate();
        }

        Date getDate() {
            try {
                return this.result.getDate(this.index);
            }
            catch (SQLException e) {
                throw new ExceptionAdapter(e);
            }
        }

        public Date getDate(int columnIndex) {
            this.setIndex(columnIndex);
            return this.getDate();
        }

        Property getProperty(Metadatas.Qualifier qualifier) {
            return new Property(qualifier, this.getRef(qualifier));
        }

        public Property getProperty(int columnIndex, Metadatas.Qualifier qualifier) {
            this.setIndex(columnIndex);
            return this.getProperty(qualifier);
        }

        public Property getProperty(String columnLabel, Metadatas.Qualifier qualifier) {
            this.setLabel(columnLabel);
            return this.getProperty(qualifier);
        }

        public Object getRef(Metadatas.Reference meta) {
            return meta.fromInnerValue(this);
        }

        public <T> T getRef(int columnIndex, Metadatas.Reference meta) {
            this.setIndex(columnIndex);
            return (T)this.getRef(meta);
        }

        public <T> T getRef(String columnLabel, Metadatas.Reference meta) {
            this.setLabel(columnLabel);
            return (T)this.getRef(meta);
        }

        public <T> T getRef(int columnIndex, String metaName) {
            this.setIndex(columnIndex);
            return (T)this.getRef((Metadatas.Reference)V7.this.metaData.selectTypes(metaName).get(0));
        }

        public <T> T getRef(String columnLabel, String metaName) {
            this.setLabel(columnLabel);
            return (T)this.getRef((Metadatas.Reference)V7.this.metaData.selectTypes(metaName).get(0));
        }
    }

    public class SubcontoKindManager
    extends Manager {
        SubcontoKindManager(Metadatas.Reference metaObject) {
            super(metaObject);
        }

        public SubcontoKindReference getValueByIdentifier(String name) {
            List sample = V7.this.metaData.selectTypes("\u0412\u0438\u0434\u0421\u0443\u0431\u043a\u043e\u043d\u0442\u043e");
            for (Metadatas.SubcontoKind property : sample) {
                if (!property.getName().equalsIgnoreCase(name)) continue;
                return new SubcontoKindReference(property.getId());
            }
            return null;
        }

        public List<SubcontoKindReference> selectRefs() {
            ArrayList<SubcontoKindReference> result = new ArrayList<SubcontoKindReference>();
            List sample = V7.this.metaData.selectTypes("\u0412\u0438\u0434\u0421\u0443\u0431\u043a\u043e\u043d\u0442\u043e");
            for (Metadatas.SubcontoKind property : sample) {
                SubcontoKindReference ref = new SubcontoKindReference(property.getId());
                result.add(ref);
            }
            return Collections.unmodifiableList(result);
        }
    }

    public class SubcontoKindReference
    extends Ref {
        SubcontoKindReference(int idSubconto) {
            super(String.format("%1$4S     ", Integer.toString(((Metadatas.Reference)V7.this.metaData.getType('K', idSubconto)).getId(), 36)), (Metadatas.Reference)V7.this.metaData.getType('K', idSubconto));
        }

        @Override
        String getTypeId() {
            return "K1";
        }

        @Override
        String getVidId() {
            return "   0";
        }

        public String toString() {
            return ((Metadatas.Reference)this.getMetaObject()).getName();
        }
    }

    final class _1SSystem {
        private String dbsign;
        private String dbsetuuid;
        private char snapshper;
        private Date accdate;

        public _1SSystem() {
            RecordSet rs = new RecordSet();
            ResultSet result = rs.executeQuery("select * from _1ssystem (nolock)");
            result.next();
            this.dbsign = result.getString("dbsign");
            this.dbsetuuid = result.getString("dbsetuuid");
            this.snapshper = result.getString("snapshper").charAt(0);
            this.accdate = result.getDate("accdate");
        }

        public String getDbsign() {
            return this.dbsign;
        }

        public String getDbsetuuid() {
            return this.dbsetuuid;
        }

        public char getSnapshper() {
            return this.snapshper;
        }

        public Date getAccdate() {
            return this.accdate;
        }
    }
}

