#!/usr/bin/env python
# -*- coding: utf-8 -*-

"""
m-py platform
"""

import sys, imp, os

from PyQt4.QtCore import *
from PyQt4.QtGui import *

# globally accessible object for user modules
app = None
m_main_window = None
m_message_window = None
m_status_bar = None
global_module = None
form_module_index = 0
m_home_path = os.path.dirname ( os.path.abspath ( sys.argv [ 0 ] ) )
sys.path.append ( os.path.join ( m_home_path,  'm_widgets/' ) )

def open_form ( fileName ) :
        fileName = str ( fileName )
        ui_filename = os.path.join ( os.path.dirname ( fileName ), "form.ui" )
        
        form_class, base_class = uic.loadUiType ( ui_filename )
        class m_form_class ( base_class, form_class ) : # base_class must be QDialog 
            def __init__ ( self, parent ) :
                base_class.__init__ ( self, parent )
                self.setupUi ( self )
                if self.minimumSizeHint().isEmpty () :
                    self.setMinimumSize ( self.width (), self.height () )
                self.setLayout ( self.gridLayout ) # form should have QLayout widget with name 'layout'
                #change size policy if layout is given?
                self.finished.connect ( self._finished )
            def _finished ( self ) :
                self.close ()
            def closeEvent ( self,  event ) :
                print ("12")
                try :
                    res = self.Module.on_Form_close ()
                    if res == False :
                        event.ignore()
                        self.show()
                        return
                except AttributeError :
                    print ("Procedure on_Form_close() not found")
                self.parentWidget().close() # close sub window
                #print sys.getrefcount ( self.module ) # http://stackoverflow.com/questions/437589/how-do-i-unload-reload-a-python-module/487718#487718
                for k, v in sys.modules.iteritems() :
                    if v == self.Module :
                        del sys.modules [ k ]
                        del self.Module
                        break

        global form_module_index
        form_module_index += 1
        
        try :
            module = imp.load_source ( "form_module_" + str ( form_module_index ), fileName )
            module.Gm = global_module

            try :
                if module.on_Module_load () == False : # был СтатусВозврата (0)
                    return 
            except AttributeError :
                print ("Procedure on_Module_load() not found")

            widget = m_form_class ( m_app.m_main_window.mdi_area )

            window = QMdiSubWindow ()
            window.setAttribute ( Qt.WA_DeleteOnClose )
            window.setWidget ( widget )
            m_app.m_main_window.mdi_area.addSubWindow ( window )
            window.show ()

            try :
                module.Form = widget
                widget.Module = module
                module.on_Form_load ()
            except AttributeError :
                print ("Procedure on_form_load() not found")
            
            children = widget.children()
            for child in children :
                child_type = child.metaObject().className() # widget type
                child_name = child.objectName()

                def bind ( signal_name ) :
                    try :
                        getattr ( child,  signal_name ).connect ( getattr ( module, "on_{0}_{1}".format( child_name, signal_name ) ) )
                    except Exception, err:
                        print ('Binding signals error: %s\n' % str(err))

                if child_type == 'QTextEdit' :
                    bind ( "textChanged" )
                elif child_type == 'QCheckBox' :
                    bind ( "stateChanged" )
                elif child_type == 'QLineEdit' :
                    bind ( "textEdited" )
                elif child_type == 'QPushButton' :
                    bind ( "clicked" )

        except Exception, err:
            print ('Module import error: %s\n' % str(err))
            return

def load_global_module () :

    global global_module,  m_home_path
    filename = m_home_path + "/global_module.py"
    global_module = imp.load_source ( "global_module", filename )
    global_module.m_app = m_app
    global_module.m_message_window = m_message_window
    global_module.open_form = open_form
    global_module.m_status_bar = m_status_bar

    try :
        if global_module.on_system_start () == False : # был СтатусВозврата (0)
            return 
    except AttributeError :
        print ("Global module: on_system_start() not found")


def main () :
    
    import m_main_window_class, m_messages_window_class
    global app, m_message_window, m_status_bar
    app = QApplication ( sys.argv )
    
    m_app.m_main_window = m_main_window_class.m_main_window_class ()

    m_app.m_main_window.signalFileOpen.connect ( open_form )
    m_status_bar = m_app.m_main_window.statusBar ()
    
    m_app.m_status_bar = m_status_bar
    m_app.m_main_window.show()

    m_message_window = m_messages_window_class.m_messages_window_class ( m_app.m_main_window )

   
    QTimer.singleShot ( 0, load_global_module )

    res = m_app.exec_ () # start the event loop

    for k, v in sys.modules.items() :
        if k.find ( "form_module" ) >= 0 : print "garbage module: " + k # modules which were not unloaded as they should

    sys.exit ( res )


if __name__ == '__main__' : main()
