# -*- coding: utf-8 -*-

from PyQt4.QtCore import *
from PyQt4.QtGui import *

COLUMNS = ['File Name','Machine', 'Energy', 'Field Size']

class metadata_tree ( QTreeView ) :
    """
    This tree shows metadata tree
    """
    def __init__ ( self, parent = None ) :
        QTreeView.__init__ ( parent )
        self.setSelectionBehavior ( QTreeView.SelectItems)
        #self.setUniformRowHeights(True)
        #self.setSortingEnabled(True)
        
        model = Model.TreeModel(COLUMNS, self)
        
        #The ProxyModel acts as a wrapper to the underlying
        #tree model and enables custom sorting of tree columns.
        #For example, it can sort field sizes by equivalent 
        #square instead of strictly alphabetically.
        proxy = Model.ProxyModel(self)
        proxy.setDynamicSortFilter(True)
        proxy.setSourceModel(model)
        self.setModel(proxy)

        
        self.connect(self, SIGNAL("activated(QModelIndex)"),
                     self.activated)
        self.connect(self, SIGNAL("expanded(QModelIndex)"),
                     self.expanded)
        self.expanded()

    def load(self, filename):
        #Passes lists of scans to tree model class.
        nesting = len(COLUMNS)
        try:
            self.model().load(filename, nesting, COLUMNS)
        except IOError, e:
            QMessageBox.warning(self, "Server Info - Error",
                                unicode(e))
            
    def currentFields(self):
        return self.model().asRecord(self.currentIndex())


    def activated(self, index):
        self.emit(SIGNAL("activated"), self.model().asRecord(index))


    def expanded(self):
        for column in range(self.model().columnCount(QModelIndex())):
            self.resizeColumnToContents(column)
