# -*- coding: utf-8 -*-

from PyQt4.QtCore import *
from PyQt4.QtGui import *

class m_main_window_class ( QMainWindow ) : # http://radpy.googlecode.com/svn/trunk/RadPy/src/RadPy.py
    signalFileOpen = pyqtSignal ( QString )

    def __init__ ( self, parent = None ) :
        QMainWindow.__init__ ( self, parent )

        self.mdi_area = QMdiArea ()
        self.mdi_area.setVerticalScrollBarPolicy ( Qt.ScrollBarAsNeeded )
        self.mdi_area.setHorizontalScrollBarPolicy ( Qt.ScrollBarAsNeeded )

        self.setCentralWidget ( self.mdi_area )

        #Create menu
        fileOpenAction = self.createAction ( "Open...", self.fileOpen, QKeySequence.Open, "folder-open-document", "Open a module" )
        fileQuitAction = self.createAction ( "Quit", self.close, "Ctrl+Q", None, "Close the Application" )

        self.windowNextAction = self.createAction ( "&Next", self.mdi_area.activateNextSubWindow, QKeySequence.NextChild )
        self.windowPrevAction = self.createAction ( "&Previous", self.mdi_area.activatePreviousSubWindow, QKeySequence.PreviousChild )
        self.windowCascadeAction = self.createAction ( "Casca&de", self.mdi_area.cascadeSubWindows )
        self.windowTileAction = self.createAction ( "&Tile", self.mdi_area.tileSubWindows )
        self.windowRestoreAction = self.createAction ( "&Restore All", self.windowRestoreAll )
        self.windowMinimizeAction = self.createAction ( "&Iconize All", self.windowMinimizeAll )
        self.windowCloseAction = self.createAction ( "&Close", self.mdi_area.closeActiveSubWindow, QKeySequence.Close )

        helpAboutAction = self.createAction ( "About program", self.helpAbout )

        self.fileMenu = self.menuBar().addMenu ( "&File" )
        self.addActions ( self.fileMenu, ( fileOpenAction, fileQuitAction ) )

        self.windowMenu = self.menuBar().addMenu("&Window")
        
        self.helpMenu = self.menuBar().addMenu("&Help")
        self.addActions ( self.helpMenu, ( helpAboutAction, ) )

        #Before window menu is shown, update the menu with the titles of each open window.
        self.windowMenu.aboutToShow.connect ( self.updateWindowMenu )
        self.updateWindowMenu()

        #For future use.  This section will write the main window
        #size and position (possibly other settings) to a file,
        #so that reopening the program will restore those settings.
        settings = QSettings()
        size = settings.value("MainWindow/Size", QVariant(QSize(1024, 768))).toSize()
        self.resize(size)
        position = settings.value("MainWindow/Position", QVariant(QPoint(0, 0))).toPoint()
        self.move(position)

        self.setWindowTitle ( "m-py" )
        
    def closeEvent ( self, event ) :
        self.mdi_area.closeAllSubWindows () #Passes a close event from main window to all subwindows.

    def fileOpen ( self ) :
        fname = QFileDialog.getOpenFileName ( self,
                            "Choose module", ".", "Modules *.py (*.py);;All files *.* (*.*)" )
        if fname : self.signalFileOpen.emit ( fname )

    def helpAbout ( self ) :
        import platform
        QMessageBox.about ( self, "About m-py", 
            """<h2>A few words about this platform.</h2>
            <p>blah-blah-blah
            <p>This application uses <i>Fugue Icons</i> (<a href="http://www.pinvoke.com/">http://www.pinvoke.com/</a>).
            <p>System info: <br>
            Python {0} - Qt {1} - PyQt {2} on {3}""".format ( platform.python_version(),
            QT_VERSION_STR, PYQT_VERSION_STR, platform.system() ) )
        
    def createAction (self, text, slot = None, shortcut = None, icon = None,
                     tip = None, checkable = False, signal = "triggered()" ) :
        #Convenience function to create PyQt actions.
        action = QAction ( text, self )
        if icon is not None : action.setIcon ( QIcon ( "icons/{0}.png".format ( icon ) ) )
        if shortcut is not None : action.setShortcut ( shortcut )
        if tip is not None : 
            action.setToolTip ( tip )
            action.setStatusTip ( tip )
        if slot is not None : self.connect ( action, SIGNAL ( signal ), slot )
        if checkable : action.setCheckable ( True )
        return action

    def addActions(self, target, actions):
        #Add multiple actions to a menu
        for action in actions:
            if action is None:
                target.addSeparator()
            else:
                target.addAction(action)

    def windowRestoreAll(self):
        for window in self.mdi_area.subWindowList():
            window.widget().showNormal()

    def windowMinimizeAll(self):
        for window in self.mdi_area.subWindowList():
            window.widget().showMinimized()

    def updateWindowMenu(self):
        #Creates a window menu with actions to jump to any open subwindow.
        self.windowMenu.clear()
        self.addActions(self.windowMenu, (self.windowNextAction,
            self.windowPrevAction, self.windowCascadeAction,
            self.windowTileAction, self.windowRestoreAction,
            self.windowMinimizeAction, #self.windowArrangeIconsAction,
            None, self.windowCloseAction))
        windows = self.mdi_area.subWindowList()
        if not windows : return
        self.windowMenu.addSeparator()
        i = 1
        menu = self.windowMenu
        for window in windows:
            title = window.windowTitle()
            if i == 10:
                self.windowMenu.addSeparator()
                menu = menu.addMenu("&More")
            accel = ""
            if i < 10:
                accel = "&%d " % i
            elif i < 36:
                accel = "&%c " % chr(i + ord("@") - 9)
            action = menu.addAction("%s%s" % (accel, title))
            self.connect(action, SIGNAL("triggered()"),
                         lambda w = window : self.mdi_area.setActiveSubWindow(w)) # example of how to call procedures-slots with parameters
            i += 1

    def picked(self):
        return None #self.treeWidget.currentFields()

    def activated(self, record):
        #Retrieves scan data from active item and plots it.
        #Adds plot to active sub window.
        label, beam = record

        x = self.mdi_area.activeSubWindow()
        self.mdi_area.activeSubWindow().widget().add_plot(label, beam)
