# -*- coding: utf-8 -*-

from PyQt4.QtCore import *
from PyQt4.QtGui import *

class m_messages_window_class ( QObject ) :
    qTextEdit_Widget = None # widget on which the text of messages is shown
    qDock_Widget = None # QDockWidget o which qLabel_Widget resides
    def __init__ ( self,  m_main_window ) :
        QObject.__init__ ( self )

        self.qDock_Widget = QDockWidget ( u"Окно сообщений", m_main_window )

        self.qTextEdit_Widget = QTextEdit ( self.qDock_Widget )
        self.qTextEdit_Widget.setAcceptRichText ( False )
        self.qTextEdit_Widget.setLineWrapMode ( QTextEdit.NoWrap )
        self.qTextEdit_Widget.setReadOnly ( True )

        # create the context menu for Message Window
        self.__menu = QMenu ( self.qTextEdit_Widget )
        self.__menu.addAction ( 'Clear', self.clear )
        self.__menu.addAction ( 'Copy', self.qTextEdit_Widget.copy )
        self.__menu.addAction ( 'Select All', self.qTextEdit_Widget.selectAll )
        
        self.qTextEdit_Widget.setContextMenuPolicy ( Qt.CustomContextMenu )
        self.qTextEdit_Widget.customContextMenuRequested.connect ( self.__handleShowContextMenu )

        self.qDock_Widget.setWidget ( self.qTextEdit_Widget )
        m_main_window.addDockWidget ( Qt.BottomDockWidgetArea, self.qDock_Widget )

    def __handleShowContextMenu ( self, coord ) :
        coord = self.qTextEdit_Widget.mapToGlobal (coord )
        self.__menu.popup ( coord )

    def clear ( self, clearByScrolling = False ) :
        self.qTextEdit_Widget.clear ()

    def printMessage ( self,  txt,  showDateTime = False ) :
        tc = self.qTextEdit_Widget.textCursor ()
        tc.movePosition ( QTextCursor.End )
        self.qTextEdit_Widget.setTextCursor ( tc )
        if showDateTime : self.qTextEdit_Widget.insertHtml ( QDateTime.currentDateTime().toString( "yyyy/MM/dd hh:mm:ss " ) )
        self.qTextEdit_Widget.insertHtml ( txt + "<br>" )
        self.qTextEdit_Widget.ensureCursorVisible ()
