#!/usr/bin/env python
# -*- coding: utf-8 -*-

"""
m-py platform
"""

import sys, os, imp, traceback

from PyQt4.QtCore import *
from PyQt4.QtGui import *

def excepthook ( excType, excValue, tracebackobj ) : # Global function to catch unhandled exceptions.
    info = "".join ( traceback.format_exception ( excType, excValue,  tracebackobj ) )
    if m_ :
        m_.message_window.printMessage ( info.replace ('\n', '<br>') )
    else :
        print ( info )
    
def load_global_module () :
    filename = os.path.join ( m_.conf_dir, "global_module.py" )
    global_module = imp.load_source ( "global_module", filename )
    global_module.m_ = m_
    m_.global_module = global_module
    exec "from PyQt4.QtCore import *; from PyQt4.QtGui import *" in global_module.__dict__
    try :
        if global_module.on_system_start () == False : # был СтатусВозврата (0)
            return 
    except AttributeError :
        m_.message_window.printMessage ( "Global module: on_system_start() not found" )


def load_conf ( conf_dir ) : # load configuration
    m_.conf_dir = conf_dir
    load_global_module ()

def load_test_conf () : # load default test configuration
    load_conf ( os.path.join ( m_.app_dir, "conf/" ) )

def main () :
    
    import m_app_class, m_main_window_class, m_messages_window_class

    global m_
    import m_
    
    sys.path.append ( os.path.join ( m_.app_dir,  'm_widgets' ) ) # path for searching custom widgets modules
    m_.app = m_app_class.m_app_class ( sys.argv )
    m_.app.main_window = m_main_window_class.m_main_window_class ()

    m_.app.main_window.signalFileOpen.connect ( m_.open_form )
    m_.app.main_window.show()
    m_.status_bar = m_.app.main_window.statusBar ()

    m_.message_window = m_messages_window_class.m_messages_window_class ( m_.app.main_window )

    QTimer.singleShot ( 0, load_test_conf )
    sys.excepthook = excepthook

    res = m_.app.exec_ () # start the event loop

    for k, v in sys.modules.items() :
        if k.find ( "form_module" ) >= 0 : print "garbage module: " + k # modules which were not unloaded as they should

    sys.exit ( res )


if __name__ == '__main__' : 
    main()
