#! /usr/bin/env python
# -*- coding: utf-8 -*-

import sys

from PyQt4.QtGui import *
from PyQt4.QtCore import *

class m_DecimalEdit ( QLineEdit ) :
    """
    """
    def __init__ ( self, parent = None ):
        QLineEdit.__init__ ( self,  parent )
        self.setAlignment ( Qt.AlignRight )
        self.textEdited.connect ( self.on_textEdited )
        self.DIGITS_AFTER_DOT = 2
        self.TOTAL_DIGITS = 12
        self.DOT_SYMBOL = "."
        self.THOUSANDS_SEPARATOR = ","

    def keyPressEvent ( self, event ) :
        key = event.key ()
        if event.modifiers () == Qt.NoModifier :
            if ( ( key == Qt.Key_Backspace ) or ( key == Qt.Key_Delete ) ) and ( self.hasSelectedText () == False ) :
                txt = self.text ()
                cur_pos = self.cursorPosition ()
                if key == Qt.Key_Backspace :
                    pos_next = cur_pos - 1 # position to check for character
                    pos_move = cur_pos - 1 # position to move to
                elif key == Qt.Key_Delete :
                    pos_next = cur_pos
                    pos_move = cur_pos + 1
                if ( pos_next >= 0 ) and ( pos_next < len ( txt ) ) :
                    char_next = txt [ pos_next ] 
                    if ( char_next == self.DOT_SYMBOL ) or ( char_next == self.THOUSANDS_SEPARATOR ) : # the cursor is on next to a dot or thousands separator
                        self.setCursorPosition ( pos_move ) # "skip" dot on delete
        QLineEdit.keyPressEvent ( self, event )
    
    def mouseDoubleClickEvent ( self, event ) :
        self.selectAll () # select all on double click, otherwise only group of digits will be selected

    def showEvent ( self, event ) :
        self.on_textEdited ( self.text () ) # show initital value
        QLineEdit.showEvent ( self, event )

    def on_textEdited ( self,  _txt ) :
        txt = list ( str ( _txt ) + self.DOT_SYMBOL + "00" )
        cur_pos = self.cursorPosition ()
        dot_pos = -1
        i = 0
        Minus = False
        while i < len ( txt ) :
            _i = txt [ i ]
            _del = False # delete current symbol
            if _i == self.DOT_SYMBOL :
                if dot_pos == -1 : # found first fot
                    dot_pos = i
                else: _del = True # found next dot
            elif ( i == 0 ) and ( _i == "0" ) : _del = True # leading zero
            elif _i == "-" : 
                Minus = not Minus
                _del = True
            elif _i.isdigit() == False : _del = True # non-digit
            elif dot_pos != -1 :
                if i > dot_pos + self.DIGITS_AFTER_DOT : _del = True # digits number before dot limit reached
            elif i >= self.TOTAL_DIGITS - self.DIGITS_AFTER_DOT : _del = True # dot should already be present
            
            if _del == True : # delete current symbol
                del txt [ i ]
                if i < cur_pos : cur_pos -= 1
            else : i += 1
            
        i = dot_pos
        while True :
            i -= 3
            if i <= 0 : break
            txt.insert ( i, self.THOUSANDS_SEPARATOR )
            if i < cur_pos : cur_pos += 1
        if Minus : 
            txt.insert ( 0, "-" )
            cur_pos += 1
            self.setStyleSheet ( "color: red" );
        else :
            self.setStyleSheet ( "color: black" );
        self.setText ( "".join(txt) )
        self.setCursorPosition ( cur_pos )

app = QApplication(sys.argv)
widget = m_DecimalEdit ()

widget.show()
app.exec_()

