#include "myhashstr.hpp"

namespace hashstr{

char lowerTable[0x100];

void Init()
{
	for (UINT n=0;n<0x100;n++) 
		lowerTable[n]=_mbctolower(n);
}

// **************************************************************************

#pragma warning(disable: 4035)

__declspec(naked) LPCSTR __cdecl FindChar(LPCSTR Str/*esp+4*/,CHAR Char/*esp+8*/)
{
	_asm
	{
		mov eax,/*Source*/[esp+4 + 0]
		mov dl,/*Char*/[esp+8 + 0]
__loop:
		mov cl,[eax]
		test cl,cl
		je short __end
		inc eax
		cmp cl,dl
		jne short __loop
		dec eax
__end:
		ret
	}
}

__declspec(naked) LPSTR __cdecl IntToBin(DWORD Value/*esp+4*/)
{
	static CHAR Buffer[0x30] = {0};
	_asm
	{
		mov edx,/*Value*/[esp+4 + 0]
		mov eax,offset Buffer+0x20
__loop:
		dec eax
		shr edx,1
		jc short __one
		mov byte ptr [eax],'0'
		jmp short __cont
__one:
		mov byte ptr [eax],'1'
__cont:
		cmp eax,offset Buffer
		ja short __loop
		ret
	}
}

UINT QuasiSimple[0x20] = {1,1,1,1,3,1,5,1,5,3,3,9,3,1,3,19,15,1,5,1,3,9,3,15,3,39,3,3,3,3,3,3};

__declspec(naked) DWORD __cdecl NextQuasiSimple(DWORD n/*esp+4*/)
{
	_asm
	{
		mov edx,/*n*/[esp+4 + 0]
		mov eax,1
		mov ecx,0
__loop:
		inc ecx
		shl eax,1
		shr	edx,1
		jne short __loop

		sub eax,QuasiSimple[ecx*4]
		ret
	}
}

__declspec(naked) DWORD __cdecl ReverseBits(DWORD n/*esp+4*/)
{
	_asm
	{
		mov edx,/*n*/[esp+4 + 0]
		mov ecx,0x20
__loop:
		shr edx,1
		rcl eax,1
		loop __loop

		ret
	}
}

// **************************************************************************

#ifdef _HASH_MIN_COLLISIONS
	int Shift_1=5;
	int Shift_2=1;
	int Shift_3=2;
#endif

/*
5 1 2
Count 1 RealCount 1 HashCount 3 Collisions 0 (0%) MaxDepth 1 (0)
Count 3 RealCount 3 HashCount 7 Collisions 0 (0%) MaxDepth 1 (1.58496)
Count 6 RealCount 6 HashCount 13 Collisions 0 (0%) MaxDepth 1 (2.58496)
Count 15 RealCount 15 HashCount 31 Collisions 4 (26.6667%) MaxDepth 2 (3.90689)
Count 29 RealCount 29 HashCount 59 Collisions 4 (13.7931%) MaxDepth 2 (4.85798)
Count 63 RealCount 63 HashCount 127 Collisions 9 (14.2857%) MaxDepth 2 (5.97728)
Count 125 RealCount 125 HashCount 251 Collisions 16 (12.8%) MaxDepth 2 (6.96578)
Count 254 RealCount 254 HashCount 509 Collisions 53 (20.8661%) MaxDepth 4 (7.98868)
Count 510 RealCount 510 HashCount 1021 Collisions 93 (18.2353%) MaxDepth 4 (8.99435)
Count 1019 RealCount 1019 HashCount 2039 Collisions 205 (20.1178%) MaxDepth 4 (9.99294)
Count 2046 RealCount 2046 HashCount 4093 Collisions 319 (15.5914%) MaxDepth 4 (10.9986)
3 1 4
Count 1 RealCount 1 HashCount 3 Collisions 0 (0%) MaxDepth 1 (0)
Count 3 RealCount 3 HashCount 7 Collisions 1 (33.3333%) MaxDepth 2 (1.58496)
Count 6 RealCount 6 HashCount 13 Collisions 0 (0%) MaxDepth 1 (2.58496)
Count 15 RealCount 15 HashCount 31 Collisions 2 (13.3333%) MaxDepth 2 (3.90689)
Count 29 RealCount 29 HashCount 59 Collisions 5 (17.2414%) MaxDepth 2 (4.85798)
Count 63 RealCount 63 HashCount 127 Collisions 23 (36.5079%) MaxDepth 4 (5.97728) !!!!!!!!!!!!!!!
Count 125 RealCount 125 HashCount 251 Collisions 14 (11.2%) MaxDepth 3 (6.96578)
Count 254 RealCount 254 HashCount 509 Collisions 40 (15.748%) MaxDepth 3 (7.98868)
Count 510 RealCount 510 HashCount 1021 Collisions 105 (20.5882%) MaxDepth 4 (8.99435)
Count 1019 RealCount 1019 HashCount 2039 Collisions 235 (23.0618%) MaxDepth 4 (9.99294)
Count 2046 RealCount 2046 HashCount 4093 Collisions 347 (16.9599%) MaxDepth 4 (10.9986)
*/

__declspec(naked) DWORD __cdecl GetHash(LPCSTR Source/*esp+4*/)
{
	_asm
	{
#ifndef _HASH_MIN_COLLISIONS
// ******************************************************
		push esi

		mov esi,/*Source*/[esp+4 + 4]
		xor edx,edx
		xor ecx,ecx
		xor eax,eax
		jmp short __start
__loop:
		xor edx,eax
		ror edx,5
		xor ecx,edx
		ror ecx,1
		xor edx,ecx
		ror ecx,2
__start:
		lodsb
		test al,al
		jne short __loop

		mov eax,edx

		pop esi
		ret
// ******************************************************
#else 
// ******************************************************
		push esi
		push edi

		mov esi,/*Source*/[esp+4 + 8]
		xor edx,edx
		xor edi,edi
		xor eax,eax
		jmp short __start
__loop:
		xor edx,eax
		
		mov ecx,Shift_1
		ror edx,cl

		xor edi,edx

		mov ecx,Shift_2
		ror edi,cl

		xor edx,edi

		mov ecx,Shift_3
		ror edi,cl
__start:
		lodsb
		test al,al
		jne short __loop

		mov eax,edx

		pop edi
		pop esi
		ret
// ******************************************************
#endif
	}
}

//  DestSize=0,    Dest   (  4)      Source

__declspec(naked) DWORD __cdecl GetHashAndLower(LPCSTR Source/*esp+4*/,LPSTR Dest/*esp+8*/,DWORD DestSize/*esp+12*/)
{
	_asm
	{
		push esi
		push edi
		push ebx

		mov esi,/*Source*/[esp+4 + 12]
		mov edi,/*Dest*/[esp+8 + 12]
		mov ebx,/*DestSize*/[esp+12 + 12]

		xor edx,edx
		xor ecx,ecx
		xor eax,eax
		jmp short __start
__loop:
		mov al,lowerTable[eax]
		stosb

		xor ecx,eax
		rol edx,3
		xor ecx,edx
		ror ecx,5
		xor edx,ecx
__start:
		dec ebx
		je short __end2

		lodsb
		test al,al
		jne short __loop
__end:
		stosb
		mov eax,ecx

		pop ebx
		pop edi
		pop esi
		ret
__end2:
		xor al,al
		jmp short __end
	}
}

// **************************************************************************

__declspec(naked) LPVOID CMapIterator::GetNext()
{
	_asm
	{
		mov eax,[ecx].CMapIterator_Next
		test eax,eax
		jne __found
		
		push ebx
		mov ebx,[ecx].CMapIterator_MapPos
		mov edx,[ecx].CMapIterator_MapEnd
__loop:
		cmp ebx,edx
		jae __end

		mov eax,[ebx]
		add ebx,4 // CMapIterator_MapPos++
		test eax,eax
		je __loop

		mov [ecx].CMapIterator_MapPos,ebx
		pop ebx
__found:
		mov edx,[eax] // Next
		mov [ecx].CMapIterator_Next,edx
		ret
__end:
		xor eax,eax
		pop ebx
		ret
	}
}

// **************************************************************************

void __fastcall FREE(LPVOID Ptr)
{
	free(Ptr);
	if (!Ptr) FREE(Ptr);
}

__declspec(naked) CMemoryManager::~CMemoryManager()
{
	_asm
	{
		push esi
		sub esp,4

		mov esi,[ecx].CMemoryManager_Block
		jmp short __start
__loop:
		mov [esp],esi
		mov esi,[esi] // Next
	#ifdef _AFXDLL
		call dword ptr free
	#else
		call free
	#endif
__start:
		test esi,esi
		jne short __loop

		add esp,4
		pop esi
		ret
	}
}

LPVOID CMemoryManager::Alloc(UINT Size)
{
	PBlock Block=(PBlock)malloc(Size+sizeof(CBlock));
	Block->Next=CMemoryManager_Block,CMemoryManager_Block=Block;
	return Block->GetData();
}

__declspec(naked) LPVOID __cdecl CMemoryManager::BuildChain(LPVOID Chunk/*esp+4*/,DWORD ChunkSize/*esp+8*/,LPVOID Block/*esp+12*/,DWORD BlockSize/*esp+16*/)
{
	_asm
	{
		push ebx

		mov edx,/*Chunk*/[esp+4 + 4]
		mov ecx,/*ChunkSize*/[esp+8 + 4]

		mov ebx,/*Block*/[esp+12 + 4]
		mov eax,/*BlockSize*/[esp+16 + 4]

		add eax,ebx	// Block+BlockSize
		add	ebx,ecx	// Block+ChunkSize
		jmp short __start
__loop:
		sub eax,ecx
		mov [eax],edx // Next
		mov edx,eax
__start:
		cmp eax,ebx
		jae __loop

		pop ebx
		ret
	}
}

} // namespace hashstr
