// mltrade2.cpp

#include "stdafx.h"
#include "../_mycommon/mycontimpl.hpp"
#include "../_mycommon/myhashstr.hpp"
#include "../_mycommon/mytraps.hpp"
#include "../_mycommon/zlibeng.tlh"

using namespace hashstr;

IStorage *OpenStorage(LPCSTR FileName)
{
/*
	HRESULT StgOpenStorage(
	  _In_   const WCHAR *pwcsName,
	  _In_   IStorage *pstgPriority,	//  ,       ,   IStorage 
	  _In_   DWORD grfMode,				//    STGM_SHARE_DENY_WRITE,      
	  _In_   SNB snbExclude,
	  _In_   DWORD reserved,
	  _Out_  IStorage **ppstgOpen
	);
*/
	IStorage *Storage;
	if (AssertRes(StgOpenStorage(CWideString(FileName),0,STGM_READ|STGM_SHARE_DENY_WRITE,0,0,&Storage),
		"OpenStorage> StgOpenStorage failed (0x%08X)")) return 0;
	return Storage;
}

IStream *OpenStream(IStorage *Storage,LPCWSTR Name)
{
/*
	HRESULT OpenStream(
	  [in]   const WCHAR *pwcsName,
	  [in]   void *reserved1,
	  [in]   DWORD grfMode,				// Other modes you choose must at least specify STGM_SHARE_EXCLUSIVE when calling this method in the compound file implementation
	  [in]   DWORD reserved2,
	  [out]  IStream **ppstm
	);
*/
	IStream *Stream;
	if (AssertRes(Storage->OpenStream(Name,0,STGM_READ|STGM_SHARE_EXCLUSIVE,0,&Stream),
		"OpenStream> Storage::OpenStream failed (0x%08X)")) return 0;
	return Stream;
}

IStream *OpenMemStream()
{
/*
	WINOLEAPI CreateStreamOnHGlobal(
	  _In_   HGLOBAL hGlobal,			//  NULL,  
	  _In_   BOOL fDeleteOnRelease,		//  TRUE,    HGLOBAL
	  _Out_  LPSTREAM *ppstm
	);
*/
	IStream *Stream;
	if (AssertRes(CreateStreamOnHGlobal(NULL,TRUE,&Stream),
		"OpenMemStream> CreateStreamOnHGlobal failed (0x%08X)")) return 0;
	return Stream;
}

int StreamToString(IStream *Stream,CString &String)
{
	STATSTG State;
	if (AssertRes(Stream->Stat(&State,STATFLAG_NONAME),
		"StreamToValue> Stream::Stat failed (0x%08X)")) return 0;
	if (Assert(State.cbSize.HighPart>0,
		"StreamToValue> Stream too long")) return 0;

	LPSTR Buffer;
	if (AssertPtr(Buffer=static_cast<CStringEx&>(String).AllocBuffer(State.cbSize.LowPart),
		"StreamToValue> Out of memory")) return 0;

/*
	HRESULT Seek(
	  [in]   LARGE_INTEGER dlibMove,
	  [in]   DWORD dwOrigin,			// STREAM_SEEK_SET, STREAM_SEEK_CUR, STREAM_SEEK_END
	  [out]  ULARGE_INTEGER *plibNewPosition
	);
*/
	LARGE_INTEGER Pos={0};
	if (AssertRes(Stream->Seek(Pos,STREAM_SEEK_SET,0),
		"StreamToValue> Stream::Seek failed (0x%08X)")) return 0;

/*
	HRESULT Read(
	  [out]  void *pv,
	  [in]   ULONG cb,
	  [out]  ULONG *pcbRead
	);
*/
	if (AssertRes(Stream->Read(Buffer,State.cbSize.LowPart,&Pos.LowPart),
		"StreamToValue> Stream::Read failed (0x%08X)")) return 0;
	
	Buffer[Pos.LowPart]=0;
	return 1;
}

int LoadModuleToString(LPCSTR FileName,CString &String)
{
	IStoragePtr Storage(OpenStorage(FileName),false);
	if (!(LPVOID)Storage) return 0;

	IStreamPtr StreamIn(OpenStream(Storage,L"MD Programm text"),false);
	if (!(LPVOID)StreamIn) return 0;

	IStreamPtr StreamOut(OpenMemStream(),false);
	if (!(LPVOID)StreamOut) return 0;

	if (AssertRes(zlib->pkDecompress(StreamIn,StreamOut),
		"LoadObject> zlibEngine::pkDecompress failed (0x%08X)")) return 0;

	return StreamToString(StreamOut,String);
}

// **************************************************************************

class CRepModule: public CBLModule7
{
protected:
	CString FileName;

	virtual int OnSyntaxError(void)
	{
		CString Str,Msg(GetSyntaxErrMarkedLine());
		Msg.TrimLeft();
		Msg.TrimRight();
		Msg+="\r\n{";
		Msg+=FileName;
		Str.Format("(%i)}: ",GetSyntaxErrLineNum());
		Msg+=Str;
		GetSyntaxErrDescr(GetSyntaxErrCode(),Str);
		Msg+=Str;

		LPCSTR Ident=GetSyntaxErrIdent();
		if (Ident && SYMB(*Ident))
		{
			Msg+=" (";
			Msg+=Ident;
			Msg+=")";
		}

		CBLModule7::OnErrorMessageEx(Msg,-1,FileName,GetSyntaxErrLineNum());
		return 1;
	}
	virtual int OnRuntimeError(void)
	{
		CString Str,Msg;
		GetRuntimeErrSourceLine(Msg);
		Msg.TrimLeft();
		Msg.TrimRight();
		Msg+="\r\n{";
		Msg+=FileName;
		Str.Format("(%i)}: ",GetRuntimeErrLineNum());
		Msg+=Str;
		GetRuntimeErrDescr(GetRuntimeErrCode(),Str);
		Msg+=Str;

		LPCSTR Ident=GetRuntimeErrIdent();
		if (Ident && SYMB(*Ident))
		{
			Msg+=" (";
			Msg+=Ident;
			Msg+=")";
		}

		CBLModule7::OnErrorMessageEx(Msg,-1,FileName,GetRuntimeErrLineNum());
		return 0;
	}

public:
	CRepModule():CBLModule7(0,0) {}

	int LoadFromFile(CString const &aFileName)
	{
		CString ModuleText;
		if (LoadModuleToString(aFileName,ModuleText))
		{
			FileName=aFileName;
			FileName.MakeUpper();
			AssignSource(ModuleText);
			if (Compile() && Execute())
				return 1;
		}
		return 0;
	}
};

class CObjectModule: public CContextImpl<CObjectModule>
{
protected:
	CRepModule *Module;

	int VarIndex;
	CBLVarInfo VarInfo;
	void GetVarInfo(int Index)
	{
		if (VarIndex!=Index)
			Module->GetStaticVarDescr(VarIndex=Index,VarInfo);
	}

	int ProcIndex;
	CBLProcInfo ProcInfo;
	void GetProcInfo(int Index)
	{
		if (ProcIndex!=Index)
			Module->GetProcInfo(ProcIndex=Index,ProcInfo);
	}

	void OnModuleChange()
	{
		ProcIndex=VarIndex=META_NOINDEX;
	}

public:
	CObjectModule():Module(new CRepModule)
	{
		OnModuleChange();
	}
	~CObjectModule()
	{
		delete Module;
	}

	BL_BEGIN_CONTEXT("ObjectModule", "")
		BL_FUNC(Module_Open, "_", 1)
		{
			OnModuleChange();
			if (Module->LoadFromFile(Params[0]->GetString()))
				Value=1L,RemoveStatItems();
			else
				Value=0L;
		}

		//  

		DYN_PROP_COUNT()	{return Module->GetNStaticVars();}
		DYN_PROP_RA()		{return 1;}
		DYN_PROP_R()		{return Module->GetStaticVarValue(Index,Value,0);}
		DYN_PROP_WA()		{return 1;}
		DYN_PROP_W()		{return Module->SetStaticVarValue(Index,Value,0);}
#if 0
		DYN_PROP_INDEX()	{return Module->FindStaticVar(Name);}
#else
		DYN_PROP_INDEX() //    
		{
			int Index;
			if ((Index=Module->FindStaticVar(Name))<0)
				return META_NOINDEX;

			GetVarInfo(Index);
			return VarInfo.IsExported() ? Index : META_NOINDEX;
		}
#endif
		DYN_PROP_NAME()
		{
			GetVarInfo(Index);
			return VarInfo.GetName();
		}

		//  

		DYN_METH_COUNT()	{return Module->GetNProcs();}
		DYN_METH_GETDEF()	{return TRUE;}
#if 0
		DYN_METH_INDEX()	{int Index;return (Index=Module->FindFunc(Name))<0 ? Module->FindProc(Name,0) : Index;}
#else
		DYN_METH_INDEX() //    
		{
			int Index;
			if ((Index=Module->FindFunc(Name))<0)
			if ((Index=Module->FindProc(Name,0))<0)
				return META_NOINDEX;

			GetProcInfo(Index);
			return ProcInfo.IsExported() ? Index : META_NOINDEX;
		}
#endif
		DYN_METH_NAME()
		{
			GetProcInfo(Index);
			return ProcInfo.GetName();
		}
		DYN_METH_PCOUNT()
		{
			GetProcInfo(Index);
			return ProcInfo.GetNParams();
		}
		DYN_METH_RA()
		{
			GetProcInfo(Index);
			return ProcInfo.HasRetVal(); 
		}
		DYN_CALL_PROC()
		{
			GetProcInfo(Index);
			return Module->CallAsProc(Index,ProcInfo.GetNParams(),Params);
		}
		DYN_CALL_FUNC()
		{
			GetProcInfo(Index);
			return Module->CallAsFunc(Index,Value,ProcInfo.GetNParams(),Params);
		}
	BL_END_CONTEXT()
};

BL_INIT_CONTEXT(CObjectModule);

// **************************************************************************
// **************************************************************************
// **************************************************************************

typedef CCollection<CStringKey,CStringKey&,class CRefValue,CValue&> CValueList;

#if 0
	// CRefList
	//  ,       
	//       ,      

	//  1               CBLContext::m_Array
	//      DecrRef(),            (     )
	//  CBLContext      CValue,    .      ,
	//    ,    ,         CValue,
	//       ,       (  
	//  ,   CValue  CBLContext::m_Array,       )

	#define indexProcGetRefs 0x70000001

	static LPCSTR nameProcGetRefs = "";

	class CRefKey
	{
	protected:
		DWORD Hash;

	public:
		CRefKey(LPVOID Ref):
			Hash(PtrHash(Ref)) {}
		CRefKey(CRefKey const &Source):
			Hash(Source.Hash) {}
		int Compare(CRefKey const &Source)
		{
			return Hash-Source.Hash;
		}
		DWORD GetHash()
		{
			return Hash;
		}
	};

	class CRefList: public CHashMap<CRefKey,CRefKey&,class CRefValue&,class CRefValue&>
	{
	public:
		~CRefList();
	};

	class CRefValue
	{
	protected:
		CValue Value;
		CRefList *Refs;

	public:
		CRefValue(CValue const &aValue):
			Value(aValue),Refs(0) {}
		~CRefValue()
		{
			ClearUnlocked();
		}
		void operator =(CValue const &aValue)
		{
			ClearUnlocked();
			Value=aValue;
		}
		operator CValue&()
		{
			return Value;
		}
		void Unlock()
		{
			CBLContext *Context;
			if (!Refs) //    
			if (Context=Value.GetContext())
			if (Context->m_RefCount>1) //         Context,  Unlock()   Value.Reset()
			if (Context->CallAsProc(Context->FindMethod(nameProcGetRefs),(CValue**)&Refs) && Refs)
			{
				Refs->Add(CRefKey(this),*this);
				
				//       ,    ,
				//       CValue  CBLContext::m_Array,   
				// Context   ,    m_RefCount

				Context->m_RefCount++;
				Value.Reset();
				Context->m_RefCount--;

				//      Context   CValue,   1   
				//          Context.m_Array     
				//     m_RefCount,      

				Value.SetType(Context->GetValueType());
				Value.m_Context=Context;
			}
		}
		void ClearUnlocked()
		{
			if (Refs)
			{
				Refs->Remove(CRefKey(this));
				OnDestroyContext();
			}
		}
		void OnDestroyContext()
		{
			Refs=0;
			Value.m_Context=0; //    ,  Value     (     )
			Value.SetTypeCode(0);
		}
	};

	CRefList::~CRefList()
	{
		CMapIterator Iter;
		IterOpen(Iter);
		PAssoc Assoc;
		while (Assoc=IterNext(Iter))
			Assoc->Value.OnDestroyContext();
	}
#else
	//     (.  )   ,  CRefList   ,   CRefValue,
	//   1     CValue    (     !)
	//  ,           ,       CRefList

	class CRefValue
	{
	protected:
		CValue Value;
		int Unlocked;

	public:
		CRefValue(CValue const &aValue):
			Value(aValue),Unlocked(0) {}
		~CRefValue()
		{
			ClearUnlocked();
		}
		void operator =(CValue const &aValue)
		{
			ClearUnlocked();
			Value=aValue;
		}
		operator CValue&()
		{
			return Value;
		}
		void Unlock()
		{
			CBLContext *Context;
			if (Context=Value.GetContext())
			{
				Unlocked=1;
				Context->DecrRef();
			}
		}
		void ClearUnlocked()
		{
			if (Unlocked)
			{
				Unlocked=0;
				CBLContext *Context;
				if (Context=Value.GetContext())
				{
					Context->m_RefCount+=2;	//     
					Value.Reset(); //   m_RefCount--
					Context->m_RefCount--; //  ,     
				}
			}
		}
	};
#endif

// **************************************************************************

class CExtStructure: public CContextImpl<CExtStructure>
{
protected:
	typedef CValueList::PAssoc PAssoc;

	CValueList Values;
	#ifdef indexProcGetRefs
		CRefList Refs; // ,  CRefList   ,           OnDestroyContext()
	#endif

public:
	#ifdef __DEBUG
		~CExtStructure()
		{
			Debug("~CExtStructure %i:refs %s\n",m_RefCount,(LPCSTR)DebInfo);
		}
	#endif

	BL_BEGIN_CONTEXT("ExtStructure", "");
		#ifdef __DEBUG
			BL_PROP_RW(DebInfo, "")	{Value=DebInfo;}
			BL_PROP_W(DebInfo)	{DebInfo=Value.GetString();}
		#endif

		PAssoc Set(CValue &KeyVal,CValue &Value)
		{
			PAssoc Assoc;
			CStringKey Key(KeyVal.GetString(),false);
			if (Assoc=Values.FindAssoc(Key))
				return Assoc->Value.Value=Value,Assoc;
			else
				return Values.Add(Key,Value);
		}

		BL_PROC_DEF(Insert, "", 2)
			{Set(*Params[0],*Params[1]);}
		BL_GETDEF(Insert)
			{return Index==1 ? Value.Reset(),1 : 0;}

		BL_PROC_DEF(InsertNoLock, "", 2)
			{Set(*Params[0],*Params[1])->Value.Value.Unlock();}
		BL_GETDEF(InsertNoLock)
			{return Index==1 ? Value.Reset(),1 : 0;}

		BL_FUNC_DEF(Property, "", 2)
		{
			PAssoc Assoc;
			if (Assoc=Values.FindAssoc(CStringKey(Params[0]->GetString(),false)))
				*Params[1]=Assoc->Value.Value,Value=1L;
			else
				Value=0L;
		}
		BL_GETDEF(Property)
			{return Index==1 ? Value.Reset(),1 : 0;}

		BL_FUNC_DEF(Get, "", 2)
		{
			int Index=Params[0]->GetNumeric();
			if (Index>0 && Index<=Values.GetCount())
			{
				PAssoc Assoc=Values.GetAssoc(Index-1);
				*Params[1]=Assoc->Key.GetData();
				Value=Assoc->Value.Value;
			}
			else
				//Value.Reset();
				SRuntimeError("  !");
		}
		BL_GETDEF(Get)
			{return Index==1 ? Value.Reset(),1 : 0;}

		BL_FUNC(Count, "", 0)
			{Value=Values.GetCount();}

		BL_PROC(Delete, "", 1)
			{Values.Remove(CStringKey(Params[0]->GetString(),false));}

		BL_PROC(Clear, "", 0)
			{Values.RemoveAll();}

		//  

		DYN_PROP_COUNT()	{return Values.GetCount();}
		DYN_PROP_RA()		{return 1;}
		DYN_PROP_WA()		{return 1;}
		DYN_PROP_INDEX()
		{
			PAssoc Assoc;
			return (Assoc=Values.FindAssoc(CStringKey(Name,false))) ? Assoc->Value.GetIndex() : META_NOINDEX;
		}
		DYN_PROP_R()
		{
			if (Index>=0 && Index<Values.GetCount())
				return Value=Values.GetAssoc(Index)->Value.Value,1;
			return 0;
		}
		DYN_PROP_W()
		{
			if (Index>=0 && Index<Values.GetCount())
				return Values.GetAssoc(Index)->Value.Value=Value,1;
			return 0;
		}
		DYN_PROP_NAME()
		{
			if (Index>=0 && Index<Values.GetCount())
				return Values.GetAssoc(Index)->Key.GetData();
			return 0;
		}

		//      ,    ,     CRefList

		#ifdef indexProcGetRefs
			DYN_METH_INDEX()
				{return Name==nameProcGetRefs ? indexProcGetRefs : META_NOINDEX;}
			DYN_CALL_PROC()
				{return Index==indexProcGetRefs ? Params[0]=(CValue*)&Refs,1 : 0;}
		#endif
	BL_END_CONTEXT()
};

BL_INIT_CONTEXT(CExtStructure);

// **************************************************************************

class CExtAssocList: public CContextImpl<CExtAssocList>
{
protected:
	typedef CValueList::PAssoc PAssoc;

	CValueList Values;
	#ifdef indexProcGetRefs
		CRefList Refs; // ,  CRefList   ,           OnDestroyContext()
	#endif

	int CaseSens;
	DWORD Hash;

public:
	CExtAssocList():
		CaseSens(true),Hash(0x10000000) {}

	BL_BEGIN_CONTEXT("ExtValueList", "");
		BL_PROC(CaseSensitivity, "", 1)
			{CaseSens=Params[0]->GetNumeric();}
		
		BL_FUNC(Get, "", 1)
		{
			PAssoc Assoc;
			if (Assoc=Values.FindAssoc(CStringKey(Params[0]->GetString(),CaseSens)))
				Value=Assoc->Value.Value;
			else
				Value.Reset();
		}

		BL_FUNC(Remove, "", 1)
			{Values.Remove(CStringKey(Params[0]->GetString(),CaseSens));}

		PAssoc Set(CStringKey &Key,CValue &Value)
		{
			PAssoc Assoc;
			if (Assoc=Values.FindAssoc(Key))
				return Assoc->Value.Value=Value,Assoc;
			else
				return Values.Add(Key,Value);
		}

		PAssoc Set(CValue &KeyVal,CValue &Value)
		{
			return Set(CStringKey(KeyVal.GetString(),CaseSens),Value);
		}

		PAssoc Add(CValue &KeyVal,CValue &Value)
		{
			if (KeyVal.GetTypeCode())
				return Set(KeyVal,Value);
			else
				return Set(CStringKey(Hash++),Value);
		}

		BL_PROC_DEF(AddValue, "", 2)
			{Add(*Params[1],*Params[0]);}
		BL_GETDEF(AddValue)
			{return Index==1 ? Value.Reset(),1 : 0;}
		
		BL_PROC_DEF(AddValueNoLock, "", 2)
			{Add(*Params[1],*Params[0])->Value.Value.Unlock();}
		BL_GETDEF(AddValueNoLock)
			{return Index==1 ? Value.Reset(),1 : 0;}

		BL_PROC(Set, "", 2)
			{Set(*Params[0],*Params[1]);}

		BL_PROC(SetNoLock, "", 2)
			{Set(*Params[0],*Params[1])->Value.Value.Unlock();}

		BL_PROC(RemoveValue, "", 1)
		{
			int Index=Params[0]->GetNumeric();
			if (Index>0 && Index<=Values.GetCount())
				Values.Delete(Index-1);
			else
				SRuntimeError("  !");
		}

		BL_FUNC_DEF(GetValue, "", 2)
		{
			int Index=Params[0]->GetNumeric();
			if (Index>0 && Index<=Values.GetCount())
			{
				PAssoc Assoc=Values.GetAssoc(Index-1);
				*Params[1]=Assoc->Key.GetData();
				Value=Assoc->Value.Value;
			}
			else
				SRuntimeError("  !");
		}
		BL_GETDEF(GetValue)
			{return Index==1 ? Value.Reset(),1 : 0;}

		BL_FUNC(GetListSize, "", 0)
			{Value=Values.GetCount();}

		BL_PROC(RemoveAll, "", 0)
			{Values.RemoveAll();}

		//      ,    ,     CRefList

		#ifdef indexProcGetRefs
			DYN_METH_INDEX()
				{return Name==nameProcGetRefs ? indexProcGetRefs : META_NOINDEX;}
			DYN_CALL_PROC()
				{return Index==indexProcGetRefs ? Params[0]=(CValue*)&Refs,1 : 0;}
		#endif
	BL_END_CONTEXT()
};

BL_INIT_CONTEXT(CExtAssocList);

// **************************************************************************
// **************************************************************************
// **************************************************************************
/*
class CTest: public CContextImpl<CTest>
{
public:
BL_BEGIN_CONTEXT("Test", "")

	BL_PROP_RO(Test, "")
	{
		Value="<prop>";
	}

	BL_PROC_DEF(Test, "", 1)
	{
		SMessage(Params[0]->GetString());
	}
	BL_GETDEF(Test)
	{
		if (Index==0)
		{
			Value="<default>";
			return TRUE;
		}
		return FALSE;
	}

	BL_FUNC(Func, "", 0)
	{
		Value="<func>";
	}

	BL_PROC(Icons, "", 0)
	{
		#define TestIcon(Icon) SMessage(Icon,#Icon)
		TestIcon(mmBlackErr);
		TestIcon(mmRedErr);
		TestIcon(mmMetaData);
		TestIcon(mmUnderlinedErr);
		#undef TestIcon
	}

	BL_FUNC(ProgramText, "", 1)
	{
		if (LoadModuleToString(Params[0]->GetString(),Value.m_String))
			Value.SetTypeCode(2);
		else
			Value=0L;
	}

BL_END_CONTEXT()
};

BL_INIT_CONTEXT(CTest);

// **************************************************************************

class CTest2: public CContextImpl<CTest2, CCreateObject<CTest2>, CTest>
{
public:
BL_BEGIN_CONTEXT("Test2", "2");

	BL_PROP_RO(Test, "")
	{
		Base::getTest(Value);
		Value=Value.GetString()+".<prop2>";
	}

BL_END_CONTEXT()
};

BL_INIT_CONTEXT(CTest2);

// **************************************************************************

class CTest3: public CContextImpl<CTest3, CCreateObject<CTest3>, CTest2>
{
public:
BL_BEGIN_CONTEXT("Test3", "3");

	BL_PROP_RO(Test, "")
	{
		Base::getTest(Value);
		Value=Value.GetString()+".<prop3>";
	}

BL_END_CONTEXT()
};

BL_INIT_CONTEXT(CTest3);

// **************************************************************************

class CTest4: public CContextImpl<CTest4, CCreateObject<CTest4>, CTest3>
{
public:
BL_BEGIN_CONTEXT("Test4", "4");

	BL_PROP_RO(Test, "")
	{
		Base::getTest(Value);
		Value=Value.GetString()+".<prop4>";
	}

	DYN_PROP_INDEX()
	{
		if (strcmpi(Name,"")==0) return 0;
		return META_NOINDEX;
	}
	DYN_PROP_RA()
	{
		if (Index==0) return TRUE;
		return 0;
	}
	DYN_PROP_R()
	{
		if (Index==0) return Value="<dyna.prop>",TRUE;
		return 0;
	}

BL_END_CONTEXT()
};

BL_INIT_CONTEXT(CTest4);

// **************************************************************************

class trapCBLModule: public	CBLModule
{
public:
	int ExecuteBatch(char const *a,CValue * *b)
	{
		return CBLModule::ExecuteBatch(a,b);
	}
};

template <typename PClassMeth>
	inline LPVOID GetClassMethAddr(PClassMeth Meth)
{
	return *(LPVOID*)&Meth;
}
*/
extern "C" int APIENTRY DllMain(HINSTANCE hInstance, DWORD dwReason, LPVOID)
{
	switch (dwReason)
	{
	case DLL_PROCESS_ATTACH:
		DisableThreadLibraryCalls(hInstance);

		//static traps::CTrapJump *Trap;
		//Trap=new traps::CTrapJump(GetClassMethAddr(&CBLModule::ExecuteBatch),GetClassMethAddr(&trapCBLModule::ExecuteBatch));

		if (!Init1CGlobal()) return 0;
		CContextBase::InitAllContextClasses();
		break;

	case DLL_PROCESS_DETACH:
		CContextBase::DoneAllContextClasses();
		Done1CGlobal();

		//delete Trap;
		break;
	}
	return 1;
}
