// testdll.cpp

#include "stdafx.h"
#include "../_mycommon/mycontimpl.hpp"

//using namespace hashstr;

class CTest: public CContextImpl<CTest>
{
public:
	BL_BEGIN_CONTEXT("Test", "")
		BL_PROP_RO(Test, "")
		{
			Value="<prop>";
		}

		BL_PROC_DEF(Test, "", 1)
		{
			SMessage(Params[0]->GetString());
		}
		BL_GETDEF(Test)
		{
			if (Index==0)
			{
				Value="<default>";
				return TRUE;
			}
			return FALSE;
		}

		BL_FUNC(Func, "", 0)
		{
			Value="<func>";
		}

		BL_PROC(Icons, "", 0)
		{
			#define TestIcon(Icon) SMessage(Icon,#Icon)
			TestIcon(mmBlackErr);
			TestIcon(mmRedErr);
			TestIcon(mmMetaData);
			TestIcon(mmUnderlinedErr);
			#undef TestIcon
		}
	BL_END_CONTEXT()
};

BL_INIT_CONTEXT(CTest);

// **************************************************************************

class CTest2: public CContextImpl<CTest2, CCreateObject<CTest2>, CTest>
{
public:
	BL_BEGIN_CONTEXT("Test2", "2");
		BL_PROP_RO(Test, "")
		{
			Base::getTest(Value);
			Value=Value.GetString()+".<prop2>";
		}
	BL_END_CONTEXT()
};

BL_INIT_CONTEXT(CTest2);

// **************************************************************************

class CTest3: public CContextImpl<CTest3, CCreateObject<CTest3>, CTest2>
{
public:
	BL_BEGIN_CONTEXT("Test3", "3");
		BL_PROP_RO(Test, "")
		{
			Base::getTest(Value);
			Value=Value.GetString()+".<prop3>";
		}
	BL_END_CONTEXT()
};

BL_INIT_CONTEXT(CTest3);

// **************************************************************************

class CTest4: public CContextImpl<CTest4, CCreateObject<CTest4>, CTest3>
{
public:
	BL_BEGIN_CONTEXT("Test4", "4");
		BL_PROP_RO(Test, "")
		{
			Base::getTest(Value);
			Value=Value.GetString()+".<prop4>";
		}

		BL_FUNC(Func, "", 0)
		{
			Base::callFunc(Params,Value);
			Value=Value.GetString()+".<func4>";
		}

		DYN_PROP_INDEX()
		{
			if (strcmpi(Name,"")==0) return 0;
			return META_NOINDEX;
		}
		DYN_PROP_RA()
		{
			if (Index==0) return TRUE;
			return 0;
		}
		DYN_PROP_R()
		{
			if (Index==0) return Value="<dyna.prop>",TRUE;
			return 0;
		}
	BL_END_CONTEXT()
};

BL_INIT_CONTEXT(CTest4);

// **************************************************************************

extern "C" int APIENTRY DllMain(HINSTANCE hInstance, DWORD dwReason, LPVOID)
{
	switch (dwReason)
	{
	case DLL_PROCESS_ATTACH:
		DisableThreadLibraryCalls(hInstance);

		if (!Init1CGlobal()) return 0;
		CContextBase::InitAllContextClasses();
		break;

	case DLL_PROCESS_DETACH:
		CContextBase::DoneAllContextClasses();
		Done1CGlobal();
		break;
	}
	return 1;
}
