// chmcolreg.cpp : Defines the entry point for the application.
//

#include "stdafx.h"
LPCSTR	strCollName = "OpenV7";			//     col-.
LPCSTR	strMasterFile = "openv7.chm";	//    .
LPCSTR	strProcessDirectory = NULL;		//  

HANDLE	hFileDat,						//    dat-
		hFileCol,						//    col-
		hStdOut;						//  

char	strColFilePath[MAX_PATH],		//   col-
		strMasterFilePath[MAX_PATH];	//   - 

DWORD	dwColID = 0,					//   
		dw,								//    WriteFile
		dwLoSymbols[256],				//   
		dwBackUp = 0;					//    . (0 -  , 1 -  appdata, 2 -  windows\help

#define TAG(par, str) const char par[] = str; const DWORD par##Len = sizeof(par) - 1

TAG(tagColsOpen,	"<Collections>");
TAG(tagColsClose,	"</Collections>");
TAG(tagColOpen,		"<Collection>");
TAG(tagColClose,	"</Collection>");
TAG(tagDCsOpen,		"<DocCompilations>");
TAG(tagDCsClose,	"</DocCompilations>");
TAG(tagDCOpen,		"<DocCompilation>");
TAG(tagDCClose,		"</DocCompilation>");
TAG(tagColName,		"<ColName value=");
TAG(tagColNum,		"<ColNum value=");
TAG(tagNextColID,	"<NextCollectionId value=");
TAG(tagCloseColFile,"</Folders>\r\n</HTMLHelpCollection>\r\n</XML>");
TAG(tagCloseDatFile,"</DocCompilations>\r\n</HTMLHelpDocInfo>\r\n</XML>");


__forceinline DWORD sym(LPCSTR ptr){return static_cast<DWORD>(static_cast<BYTE>(*ptr));}

LPCSTR GetNextArg(LPSTR& ptr)
{
	while(sym(ptr) && sym(ptr) <= ' ')
		ptr++;
	if(!sym(ptr))
		return NULL;

	LPCSTR pStart = ptr;
	DWORD delim = ' ';
	if(sym(ptr) == '\"')
	{
		delim = '\"';
		pStart++;
		ptr++;
	}

	while(sym(ptr) && sym(ptr) != delim)
		ptr++;
	if(sym(ptr))
	{
		*ptr++ = 0;
		while(sym(ptr) && sym(ptr) <= ' ')
			ptr++;
	}
	return pStart;
}

BOOL ShowError(LPCSTR format,...)
{
	char buf[1000];
	va_list arg;
	va_start(arg, format);
	DWORD len = wvsprintf(buf, format, arg);
	CharToOem(buf, buf);
	WriteFile(hStdOut, buf, len, &dw, 0);
	return FALSE;
}

LPCSTR strstri(LPCSTR str1, LPCSTR str2, LPCSTR pEnd)
{
	LPCSTR cp = str1, s1, s2;
	while(cp < pEnd)
	{
		s1 = cp;
		s2 = str2;
		while(s1 < pEnd && sym(s2) && !(dwLoSymbols[sym(s1)] - dwLoSymbols[sym(s2)]))
			s1++, s2++;
		if(!sym(s2))
			return cp;
		cp++;
	}
	return NULL;
}

struct SFileMapping
{
	HANDLE hFile, hMapping;
	LPCSTR pStart, pEnd;
	SFileMapping(LPCSTR strFilePath)
	{
		pStart = pEnd = NULL;
		hMapping = NULL;
		hFile = CreateFile(strFilePath, GENERIC_READ, FILE_SHARE_READ, 0, OPEN_EXISTING, 0, 0);
		if(INVALID_HANDLE_VALUE == hFile)
			return;
		hMapping = CreateFileMapping(hFile, 0, PAGE_READONLY, 0, 0, 0);
		if(!hMapping)
			return;
		pStart = static_cast<LPCSTR>(MapViewOfFile(hMapping, FILE_MAP_READ, 0, 0, 0));
		if(!pStart)
			return;
		pEnd = pStart + GetFileSize(hFile, NULL);
		return;
	}
	void Close()
	{
		if(pStart)
			UnmapViewOfFile(pStart);
		if(hMapping)
			CloseHandle(hMapping);
		if(INVALID_HANDLE_VALUE != hFile)
			CloseHandle(hFile);
	}

	struct guard
	{
		SFileMapping* pMapping;
		guard(SFileMapping& m) : pMapping(&m){}
		~guard()
		{
			if(pMapping)
				pMapping->Close();
		}
		void Detach(){pMapping=NULL;}
	};
};

struct STempFile
{
	HANDLE hFile;
	char path[MAX_PATH];

	STempFile()
	{
		char strTempPath[MAX_PATH];
		GetTempPath(MAX_PATH, strTempPath);
		if(GetTempFileName(strTempPath, "chr", 0, path))
			hFile = CreateFile(path, GENERIC_WRITE, 0, 0, CREATE_ALWAYS, 0, 0);
		else
			hFile = INVALID_HANDLE_VALUE;
	}
	void Close()
	{
		if(INVALID_HANDLE_VALUE != hFile)
			CloseHandle(hFile);
	}
	void Delete()
	{
		DeleteFile(path);
	}
	struct guard
	{
		STempFile* pTemp;
		guard(STempFile& t) : pTemp(&t){}
		~guard()
		{
			if(pTemp && INVALID_HANDLE_VALUE != pTemp->hFile)
			{
				pTemp->Close();
				pTemp->Delete();
			}
		}
		void Detach(){pTemp = NULL;}
	};
};

struct SBlock
{
	LPCSTR pStart;
	LPCSTR pEnd;
};

template<typename Open, typename Close>
void FindBlock(SBlock& block, Open& open, Close& close, LPCSTR pStart, LPCSTR pEnd)
{
	block.pStart = strstri(pStart, open, pEnd);
	if(block.pStart)
		block.pEnd = strstri(block.pStart + sizeof(open) - 1, close, pEnd);
}

DWORD FindColNum(SBlock& block, DWORD offset)
{
	DWORD ret = 0;
	LPCSTR pColNum = strstri(block.pStart + offset, tagColNum, block.pEnd);
	if(pColNum)
	{
		pColNum += tagColNumLen;
		while(sym(pColNum)<=' ')
			pColNum++;
		if(sym(pColNum)=='\"')
			pColNum++;
		while(sym(pColNum)>='0' && sym(pColNum)<='9')
			ret = ret * 10 + *pColNum++ - '0'; 
	}
	return ret;
}

BOOL ReplaceDatFile(STempFile& tmpFile, SFileMapping& mapping, LPCSTR path, DWORD dwBackUpFlag)
{
	mapping.Close();
	tmpFile.Close();

	BOOL bCopied;
	if(GetFileAttributes(path) == -1 || dwBackUpFlag == dwBackUp)
		bCopied = TRUE;
	else
	{
		char strBackUpPath[MAX_PATH];
		strcpy(strBackUpPath, path);
		strcat(strBackUpPath, ".orig");
		bCopied = CopyFile(path, strBackUpPath, FALSE);
		if(bCopied)
			dwBackUp = dwBackUpFlag;
	}

	if(bCopied)
	{
		if(CopyFile(tmpFile.path, path, FALSE))
		{
			tmpFile.Delete();
			return TRUE;
		}
	}
	return FALSE;
}

BOOL RemoveCollection(LPCSTR strDatFile, LPCSTR strCollFile, DWORD dwBackUpFlag)
{
	SFileMapping mapping(strDatFile);
	if(!mapping.pStart)
		return FALSE;
	SFileMapping::guard mg(mapping);	//        - 

	//      Collections
	SBlock colls;
	FindBlock(colls, tagColsOpen, tagColsClose, mapping.pStart, mapping.pEnd);
	if(!(colls.pStart && colls.pEnd))
		return FALSE;
	//   Collections,    Collection
	char strSearch[MAX_PATH * 2];
	wsprintf(strSearch, "<ColName value=\"%s\"/>", strCollFile);
	
	SBlock col;
	for(LPCSTR ptr = colls.pStart + tagColsOpenLen;;)
	{
		 FindBlock(col, tagColOpen, tagColClose, ptr, colls.pEnd);
		 if(col.pStart)
		 {
			 if(col.pEnd)	//   Collection
			 {
				 //    
				 if(strstri(col.pStart + tagColOpenLen, strSearch, col.pEnd))
				 {
					 dwColID = FindColNum(col,tagColOpenLen);
					 break;
				 }
				 ptr = col.pEnd + tagColCloseLen;
			 }
			 else
				 return FALSE;	//     -  
		 }
		 else
			 return FALSE;	//   
	}

	//   ,       dat 
	STempFile tmpFile;
	if(tmpFile.hFile == INVALID_HANDLE_VALUE)
		return FALSE;
	STempFile::guard tg(tmpFile);
	
	//          
	WriteFile(tmpFile.hFile, mapping.pStart, col.pStart - mapping.pStart, &dw, 0);
	//            
	LPCSTR pColEnd = col.pEnd + tagColCloseLen, pColsEnd = colls.pEnd + tagColsCloseLen;
	if(pColEnd[0]=='\r' && pColEnd[1]=='\n')
		pColEnd += 2;
	WriteFile(tmpFile.hFile, pColEnd, pColsEnd - pColEnd, &dw, 0);
	//    DocCompilation,     ,
	//    ,  
	SBlock dc;
	for(;;)
	{
		FindBlock(dc, tagDCOpen, tagDCClose, pColsEnd, mapping.pEnd);
		if(dc.pStart && dc.pEnd)
		{
			//   DocCompilation. ,    
			LPCSTR pDCEnd = dc.pEnd + tagDCCloseLen;
			if(FindColNum(dc, tagDCOpenLen) != dwColID)
				WriteFile(tmpFile.hFile, pColsEnd, pDCEnd - pColsEnd, &dw, 0);
			pColsEnd = pDCEnd;
		}
		else
			break;
	}
	//   
	WriteFile(tmpFile.hFile, pColsEnd, mapping.pEnd - pColsEnd, &dw, 0);
	mg.Detach();
	tg.Detach();
	//   dat-      
	if(ReplaceDatFile(tmpFile, mapping, strDatFile, dwBackUpFlag))
		return TRUE;
	tmpFile.Delete();
	return FALSE;
}

/*
 .
  .col
   hhcolreg.dat
  doccompilation  hhcolreg.dat,    
*/
void UnregCollection()
{
	DeleteFile(strColFilePath);
	
	char strDatFile[MAX_PATH];
	if(GetEnvironmentVariable("ALLUSERSPROFILE", strDatFile, MAX_PATH))
	{
		strcat(strDatFile, "\\Application Data\\Microsoft\\HTML Help\\hhcolreg.dat");
		if(RemoveCollection(strDatFile, strColFilePath, 1))
			return;
	}
	GetWindowsDirectory(strDatFile, MAX_PATH);
	strcat(strDatFile, "\\help\\hhcolreg.dat");
	RemoveCollection(strDatFile, strColFilePath, 2);
}

DWORD GetDatFilePath(LPSTR strDatFile)
{
	if(GetEnvironmentVariable("ALLUSERSPROFILE", strDatFile, MAX_PATH))
	{

		strcat(strDatFile, "\\Application Data\\Microsoft\\HTML Help");
		if((GetFileAttributes(strDatFile) & (0x80000000 | FILE_ATTRIBUTE_DIRECTORY)) == FILE_ATTRIBUTE_DIRECTORY)
		{
			strcat(strDatFile, "\\hhcolreg.dat");
			return 1;
		}
	}
	GetWindowsDirectory(strDatFile, MAX_PATH);
	strcat(strDatFile, "\\help");
	if(CreateDirectory(strDatFile, NULL) || ERROR_ALREADY_EXISTS == GetLastError())
		strcat(strDatFile, "\\hhcolreg.dat");
	else
		strDatFile[0] = 0;
	return 2;
}

struct SInfo;
struct SDirProcessData
{
	char strDirPath[MAX_PATH];
	char strFndMask[MAX_PATH];
	HANDLE hFind;
	WIN32_FIND_DATA fnd;
	SInfo* pEntries;
	int level;
};

struct SInfo
{
	SInfo* prev;
	BOOL bFolder;
	char strName[MAX_PATH];
	char strPath[MAX_PATH];
	SDirProcessData* pDirData;
};

void InsertInfo(SInfo& info, SInfo** pprev)
{
	while(*pprev)
	{
		if(lstrcmpi((*pprev)->strName, info.strName) > 0)
			break;
		pprev = &(*pprev)->prev;
	}
	info.prev = *pprev;
	*pprev = &info;
}

void BeginProcessDirectory(LPCSTR path, int level);

void EndProcessDirectory(SDirProcessData* pData)
{
	FindClose(pData->hFind);
	char tabs[MAX_PATH];
	for(int i = 0; i < pData->level; i++)
		tabs[i] = '\t';
	tabs[i] = 0;
	for(SInfo* pInfo = pData->pEntries;pInfo;pInfo = pInfo->prev)
	{
		if(pInfo->bFolder)
		{
			char buf[MAX_PATH * 2];
			LPCSTR pName = strstri(pInfo->strName, "~", pInfo->strName + strlen(pInfo->strName));
			if(!pName)
				pName = pInfo->strName;
			else
				pName++;
			DWORD len = wsprintf(buf,
				"%s<Folder>\r\n"
				"%s\t<TitleString value=\"%s\"/>\r\n"
				"%s\t<LangId value=\"1049\"/>\r\n", tabs, tabs, pName, tabs);
			WriteFile(hFileCol, buf, len, &dw, 0);
			BeginProcessDirectory(pInfo->strPath, pData->level + 1);
			len = wsprintf(buf, "%s</Folder>\r\n", tabs);
			WriteFile(hFileCol, buf, len, &dw, 0);
		}
		else
		{
			char buf[MAX_PATH * 4];
			DWORD len = wsprintf(buf,
				"%s<Folder>\r\n"
				"%s\t<TitleString value=\"=%s\"/>\r\n"
				"%s\t<LangId value=\"1049\"/>\r\n"
				"%s</Folder>\r\n", tabs, tabs, pInfo->strPath, tabs, tabs);
			WriteFile(hFileCol, buf, len, &dw, NULL);

			char strIdxFile[MAX_PATH];
			len = strlen(pInfo->strPath);
			memcpy(strIdxFile, pInfo->strPath, len - 1);
			strIdxFile[len-1] = 'i';
			strIdxFile[len] = 0;
			LPCSTR strIdxPath = (GetFileAttributes(strIdxFile) & FILE_ATTRIBUTE_DIRECTORY) ? pInfo->strPath : strIdxFile;

			len = wsprintf(buf,
				"<DocCompilation>\r\n"
				"\t<DocCompId value=\"%s\"/>\r\n"
				"\t<DocCompLanguage value=1049/>\r\n"
				"\t<LocationHistory>\r\n"
				"\t\t<ColNum value=\"%i\"/>\r\n"
				"\t\t<TitleLocation value=\"%s\"/>\r\n"
				"\t\t<IndexLocation value=\"%s\"/>\r\n"
				"\t\t<QueryLocation value=\"\"/>\r\n"
				"\t\t<LocationRef value=\"\"/>\r\n"
				"\t\t<Version value=0/>\r\n"
				"\t\t<LastPromptedVersion value=0/>\r\n"
				"\t\t<TitleSampleLocation value=\"\"/>\r\n"
				"\t\t<TitleQueryLocation value=\"\"/>\r\n"
				"\t\t<SupportsMerge value=0/>\r\n"
				"\t</LocationHistory>\r\n"
				"</DocCompilation>\r\n", pInfo->strPath, dwColID, pInfo->strPath, strIdxPath);
			WriteFile(hFileDat, buf, len, &dw, NULL);
		}
	}
}

void ProcessEntry(SDirProcessData* pData)
{
	SInfo info;
	BOOL bInsert = TRUE;
	BOOL bDir = FALSE;
	if(pData->fnd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)
	{
		if(pData->fnd.cFileName[0]=='.' && (pData->fnd.cFileName[1]==0 ||
			(pData->fnd.cFileName[1]=='.' && pData->fnd.cFileName[2]==0)))
			bInsert = FALSE;
		else
			bDir = TRUE;
	}
	else
	{
		int len = strlen(pData->fnd.cFileName);
		if(len>3)
		{
			if(!strstri(pData->fnd.cFileName + len - 4, ".chm", pData->fnd.cFileName + len))
				bInsert = FALSE;
		}
	}
	if(bInsert)
	{
		info.bFolder = bDir;
		info.pDirData = pData;
		strcpy(info.strName, pData->fnd.cFileName);
		wsprintf(info.strPath, "%s\\%s", pData->strDirPath, pData->fnd.cFileName);
		if(!bDir)
		{
			if(!lstrcmpi(info.strPath, strMasterFilePath))
			{
				char strNewName[MAX_PATH];
				strNewName[0]=1;
				strNewName[1]='#';
				strcpy(strNewName + 2, info.strName);
				strcpy(info.strName, strNewName);
			}
		}
		InsertInfo(info, &pData->pEntries);
	}
	if(FindNextFile(pData->hFind, &pData->fnd))
		ProcessEntry(pData);
	else
		EndProcessDirectory(pData);
}

void BeginProcessDirectory(LPCSTR path, int level)
{
	SDirProcessData data;
	data.level = level;
	data.pEntries = NULL;
	strcpy(data.strDirPath, path);
	strcpy(data.strFndMask, path);
	strcat(data.strFndMask, "\\*");
	data.hFind = FindFirstFile(data.strFndMask, &data.fnd);
	if(INVALID_HANDLE_VALUE != data.hFind)
		ProcessEntry(&data);
}

BOOL RegCollection()
{
	wsprintf(strMasterFilePath, "%s\\%s", strProcessDirectory, strMasterFile);
	if(GetFileAttributes(strMasterFilePath) & FILE_ATTRIBUTE_DIRECTORY)
		return ShowError("  - : %s", strMasterFilePath);

	char strDatFilePath[MAX_PATH];
	DWORD dwBackUpFlag = GetDatFilePath(strDatFilePath);
	if(!strDatFilePath[0])
		return ShowError(" ");

	STempFile tmpFile;
	if(INVALID_HANDLE_VALUE == tmpFile.hFile)
		return ShowError("   : %s", tmpFile.path);
	STempFile::guard tg(tmpFile);

	hFileDat = tmpFile.hFile;

	SFileMapping mapping(strDatFilePath);
	SFileMapping::guard mg(mapping);

	LPCSTR pDocsEnd = NULL;

	if(mapping.pEnd != mapping.pStart)	//  dat- - 
	{
		SBlock cols;
		FindBlock(cols, tagColsOpen, tagColsClose, mapping.pStart, mapping.pEnd);
		if(cols.pStart && cols.pEnd)
		{
			pDocsEnd = strstri(cols.pEnd + tagColsCloseLen, tagDCsClose, mapping.pEnd);
			if(!pDocsEnd)
				return ShowError("   %s", tagDCsClose);
			
			if(!dwColID || dwBackUp != dwBackUpFlag)
			{
				LPCSTR pCollID = strstri(mapping.pStart, tagNextColID, cols.pStart);
				if(!pCollID)
					return ShowError("    ");
				pCollID += tagNextColIDLen;
				while(*pCollID<=' ')
					pCollID++;
				if(*pCollID == '\"')
					pCollID++;
				char strNextColId[20];
				LPCSTR pRead = pCollID;
				
				dwColID = 0;
				while(sym(pRead)>='0' && sym(pRead)<='9')
					dwColID = dwColID * 10 + *pRead++ - '0';
				DWORD len = wsprintf(strNextColId, "%i", dwColID + 1);

				WriteFile(tmpFile.hFile, mapping.pStart, pCollID - mapping.pStart, &dw, NULL);
				WriteFile(tmpFile.hFile, strNextColId, len, &dw, NULL);
				WriteFile(tmpFile.hFile, pRead, cols.pEnd - pRead, &dw, NULL);
			}
			else
				WriteFile(tmpFile.hFile, mapping.pStart, cols.pEnd - mapping.pStart, &dw, NULL);

			char buf[MAX_PATH * 4];
			DWORD len = wsprintf(buf,
				"<Collection>\r\n"
				"\t<ColNum value=\"%i\"/>\r\n"
				"\t<ColName value=\"%s\"/>\r\n"
				"</Collection>\r\n", dwColID, strColFilePath);
			WriteFile(tmpFile.hFile, buf, len, &dw, NULL);
			WriteFile(tmpFile.hFile, cols.pEnd, pDocsEnd - cols.pEnd, &dw, NULL);
		}
		else
			return ShowError("   Collections");
	}
	else	//  dat-  
	{
		char buf[MAX_PATH * 2];
		DWORD len = wsprintf(buf,
			"<XML>\r\n"
			"<HTMLHelpDocInfo>\r\n"
			"<NextCollectionId value=2/>\r\n"
			"<Collections>\r\n"
			"<Collection>\r\n"
			"\t<ColNum value=1/>\r\n"
			"\t<ColName value=\"%s\"/>\r\n"
			"</Collection>\r\n"
			"</Collections>\r\n"
			"<Locations>\r\n"
			"</Locations>\r\n"
			"<DocCompilations>\r\n", strColFilePath);
		WriteFile(hFileDat, buf, len, &dw, NULL);
		dwColID = 1;
	}
	
	hFileCol = CreateFile(strColFilePath, GENERIC_WRITE, 0, 0, CREATE_ALWAYS, 0, 0);
	if(INVALID_HANDLE_VALUE == hFileCol)
		return ShowError("   : %s", strColFilePath);

	char buf[MAX_PATH * 4];
	DWORD len = wsprintf(buf,
		"<XML>\r\n"
		"<HTMLHelpCollection>\r\n"
		"<masterchm value=\"%s\"/>\r\n"
		"<masterlangid value=\"1049\"/>\r\n"
		"<samplelocation value=""/>\r\n"
		"<collectionnum value=\"%i\"/>\r\n"
		"<refcount value=\"0\"/>\r\n"
		"<version value=\"0\"/>\r\n"
		"<Folders>\r\n", strMasterFilePath, dwColID);
	WriteFile(hFileCol, buf, len, &dw, NULL);

	BeginProcessDirectory(strProcessDirectory, 0);

	WriteFile(hFileCol,  tagCloseColFile, tagCloseColFileLen, &dw, NULL);
	
	CloseHandle(hFileCol);

	if(pDocsEnd)
		WriteFile(tmpFile.hFile, pDocsEnd, mapping.pEnd - pDocsEnd, &dw, NULL);
	else
		WriteFile(tmpFile.hFile, tagCloseDatFile, tagCloseDatFileLen, &dw, NULL);
	mg.Detach();
	tg.Detach();
	if(ReplaceDatFile(tmpFile, mapping, strDatFilePath, dwBackUpFlag))
		return !ShowError(" ");
	tmpFile.Delete();
	return ShowError("    %s", strDatFilePath);
}

int Main()
{
	LPSTR lpCL = GetCommandLine();
	char strCurDir[MAX_PATH];
	GetCurrentDirectory(MAX_PATH, strCurDir);
	strProcessDirectory = strCurDir;

	GetNextArg(lpCL);
	BOOL bUnregOnly = FALSE, bShowHelp = FALSE, bChangeDir=FALSE;

	for(LPCSTR strCmdArg;;)
	{
		strCmdArg = GetNextArg(lpCL);
		if(!strCmdArg)
			break;
		if(!strcmp("-d", strCmdArg))
			strProcessDirectory = GetNextArg(lpCL), bChangeDir = TRUE;
		else if(!strcmp("-m", strCmdArg))
			strMasterFile = GetNextArg(lpCL);
		else if(!strcmp("-n", strCmdArg))
			strCollName = GetNextArg(lpCL);
		else if(!strcmp("-u", strCmdArg))
			bUnregOnly = TRUE;
		else if(!strcmp("-h", strCmdArg))
			bShowHelp = TRUE;
	}

	if(bShowHelp || !strProcessDirectory || !strCollName || !strMasterFile)
	{
		return !ShowError(":\nchmcolreg.exe []\n"
			"-d \" \" (  )\n"
			"-m \"- \" (  OpenV7.chm)\n"
			"-n \"   col \" (  OpenV7)\n"
			"-u -    \n"
			"-h -   ");
	}
	if(bChangeDir)
	{
		if(!SetCurrentDirectory(strProcessDirectory))
			return !ShowError("  : %s", strProcessDirectory);
		GetCurrentDirectory(MAX_PATH, strCurDir);
		strProcessDirectory = strCurDir;
	}

	BOOL bBadDir = FALSE;
	if(strProcessDirectory[0]=='\\' && strProcessDirectory[1]=='\\')
		bBadDir = TRUE;
	else
	{
		char drive[4];
		*(DWORD*)drive = *(DWORD*)strProcessDirectory;
		drive[3] = 0;
		UINT driveType = GetDriveType(drive);
		if(driveType == DRIVE_REMOTE)
			bBadDir = TRUE;
	}
	if(bBadDir)
		return !ShowError("chm      ");

	for(int i=0;i<256;i++)
		dwLoSymbols[i] =reinterpret_cast<DWORD>(CharLower(reinterpret_cast<LPSTR>(i)));
	
	wsprintf(strColFilePath, "%s\\%s.col", strProcessDirectory, strCollName);

	UnregCollection();
	if(!bUnregOnly)
		RegCollection();
	return 0;
}

#pragma comment(linker, "/entry:Start")
#pragma comment(linker, "/filealign:512")

void Start()
{
	hStdOut = GetStdHandle(STD_OUTPUT_HANDLE);
	ExitProcess(Main());
}
