// common.h
#pragma once
#include "common_api.h"

void COMMON_API __stdcall LinkPath(cstr strStartDir, cstr path, CString& strResult);
BOOL COMMON_API __stdcall CreateDirs(cstr path);
//    Windows   .  err==0,    GetLastError
CString COMMON_API __stdcall GetErrDescription(DWORD err = 0);
//    {xxxx}  CLSID
BOOL COMMON_API __stdcall Str2Clsid(cstr str, CLSID& clsid);
//    Dispatch
void COMMON_API __stdcall ExtractMacroses(IDispatchPtr& pDisp, CStringArray& names);
//    Dispatch
BOOL COMMON_API __stdcall InvokeMacros(IDispatchPtr& pDisp, cstr Macros);

class CVersionInfo
{
public:
	COMMON_API CVersionInfo(LPCSTR strFilePath, BOOL bFull);
	
	CVersionInfo(HINSTANCE hInst, BOOL bFull) : m_pData(NULL)
	{
		if(hInst)
			Init(hInst, bFull);
	}

	COMMON_API ~CVersionInfo();

	struct SBlockInfo
	{
		DWORD dwLangCP;
		CStringArray vals;
		CStringArray names;
		CMapStringToString Names2Vals;
		void COMMON_API GetStrLanguage(CString& str) const;
	};
	
	BOOL IsLoaded() const {return m_pData!=NULL;}
	const WORD* GetFileVersion() const {return m_wFileVersion;}
	const WORD* GetProdVersion() const {return m_wProdVersion;}
	DWORD GetBlocksCount() const {return m_blocks.GetSize();}
	const SBlockInfo* GetBlock(DWORD dwIdx) const {return m_blocks[dwIdx];}
	
protected:
	void COMMON_API Init(HINSTANCE hInst, BOOL bFull);
	char* m_pData;
	CTypedPtrArray<CPtrArray, SBlockInfo*> m_blocks;
	WORD m_wFileVersion[4];
	WORD m_wProdVersion[4];
};


