// splash'n'main.cpp
#include "StdAfx.h"
#include "splash'n'main.h"
#include "../com_interfaces/COMOpenV7.h"
#include "mainframetrap.h"

HHOOK hHookCBT;
DWORD pSplashVtbl;

//  -     CreateSplashWnd
struct EventCreateSplashWnd : CCOMOpenV7::EventParam<CCOMOpenV7::idCreateSplashWnd, 2>
{
	BOOL bCancel;
	CIWrapRefParam* pWrap;

	EventCreateSplashWnd(HWND hWnd) : bCancel(FALSE)
	{
		pWrap = new CIWrapRefParam;
		pWrap->value = 0;
		pVars[1].vt = VT_I4;
		pVars[1].lVal = (long)hWnd;
		pVars[0].vt = VT_DISPATCH;
		pVars[0].pdispVal = pWrap;
	}

	void AfterInvoke()
	{
		if(pWrap->value)
		{
			bCancel = TRUE;
			pWrap->value = 0;
		}
	}
};

//      ,
//    ,    ,
//    .      .
LRESULT CALLBACK CBTProc(int nCode, WPARAM wParam, LPARAM lParam)
{
	LRESULT lRes = CallNextHookEx(hHookCBT, nCode, wParam, lParam);
	if(HCBT_CREATEWND == nCode)
	{
		if(CWnd* pWnd = CWnd::FromHandlePermanent((HWND)wParam))
		{
			if(*reinterpret_cast<DWORD*>(pWnd) == pSplashVtbl)
			{
				//  resource handle
				h1CResource = AfxGetResourceHandle();
				RaiseCppEvent(etCreateSplashWnd, onwnd_handler(pWnd));
				
				EventCreateSplashWnd event((HWND)wParam);
				CCOMOpenV7::Get()->RaiseEvent(event);
				if(event.bCancel)
					return TRUE;
			}
			else if(pWnd->GetRuntimeClass()->IsDerivedFrom(RUNTIME_CLASS(SECMDIFrameWnd)))
			{
				CMainFrameTrap::Init(pWnd);
				UnhookWindowsHookEx(hHookCBT);
			}
		}
	}
	return lRes;
}

void SplashAndMainWndCreateTrap::Init()
{
	//        CSplash,
	//    ,    .
	DWORD buf[sizeof(CDialog)];	//     4- 
	reinterpret_cast<CSplash*>(buf)->CSplash::CSplash(NULL);
	pSplashVtbl = buf[0];
	reinterpret_cast<CSplash*>(buf)->CSplash::~CSplash();
	//     
	hHookCBT = SetWindowsHookEx(WH_CBT, CBTProc, NULL, GetCurrentThreadId());
}
