// userhotkey.cpp
#include "StdAfx.h"
#include "userhotkey.h"
#include "../addin_work/addinmgr.h"
#include "../ov7.h"
#include "../com_interfaces/hotkeys.h"
#include "../com_interfaces/COMOpenV7.h"

CTrapVirtual trPreTranslate;
BOOL CHotKeyTrap::bCancelHotKey;
CMapPtrToPtr CHotKeyTrap::Keys2Data;
CTypedPtrArray<CPtrArray, CHotKeyTrap::SKeyData*> CHotKeyTrap::Keys;


void CHotKeyTrap::Init()
{
	trPreTranslate.SetTrap(pMainFrame, 0x98/4, &CHotKeyTrap::PreTranslateMainFrameMsg);
}

BOOL CHotKeyTrap::PreTranslateMainFrameMsg(MSG* pMsg)
{
	if(pMsg->message == WM_KEYDOWN || pMsg->message == WM_SYSKEYDOWN)
	{
		DWORD key = (pMsg->wParam & 0xFFFF)	|
			(DWORD(GetKeyState(VK_SHIFT)   & 0x8000) << 1)	|
			(DWORD(GetKeyState(VK_CONTROL) & 0x8000) << 2)	|
			(DWORD(GetKeyState(VK_MENU)    & 0x8000) << 3);
		SKeyData* pData;
		if(Keys2Data.Lookup((void*)key, (void*&)pData))
		{
			if(AddinStore* pStore = addin_mgr::GetByUniqueName(pData->addin))
			{
				if(AddinMacroses* pMacroses = (AddinMacroses*)pStore->GetAddin()->Cast(aiMacroses))
				{
					bCancelHotKey = FALSE;
					CIHotKeys* pKeys;
					CCOMOpenV7::Get()->get_HotKeys((IHotKeys**)&pKeys);
					if(pMacroses->Invoke(pData->macros))
					{
						if(!bCancelHotKey)
							return TRUE;
					}
					else
						DoMsgLine("    \"%s\"   \"%s\"", mmRedErr, pData->macros, pData->addin);
				}
				else
					DoMsgLine(" \"%s\"    ", mmRedErr,(LPCSTR)pData->addin);
			}
			else
				DoMsgLine("   \"%s\"  .", mmRedErr, (LPCSTR)pData->addin);
		}
	}
	return (this->*mf_cast<BOOL(CWnd::*)(MSG*)>(trPreTranslate.m_dwRealAdress))(pMsg);
}

void CHotKeyTrap::RemoveKey(DWORD idx)
{
	SKeyData* pKey = Keys[idx];
	Keys2Data.RemoveKey((void*)pKey->GetKey());
	Keys.RemoveAt(idx);
	if(pKey->pComObject)
		pKey->pComObject->m_pKey = NULL;
	delete pKey;
}

CHotKeyTrap::SKeyData* CHotKeyTrap::AddKey(DWORD key, cstr a, cstr m)
{
	SKeyData* pData = FindKey(key);
	if(pData)
	{
		strOV7Error = "   ";
		return NULL;
	}
	pData = new SKeyData(a, m, key);
	Keys2Data[(void*)key] = pData;
	Keys.Add(pData);
	return pData;
}

void CHotKeyTrap::ClearAll()
{
	Keys2Data.RemoveAll();
	SKeyData** ppData = (SKeyData**)Keys.GetData();
	for(DWORD s = Keys.GetSize() ; s-- ;)
		delete *ppData++;
	Keys.RemoveAll();
}

BOOL CHotKeyTrap::SKeyData::SetKey(DWORD k)
{
	if(SKeyData* pData = CHotKeyTrap::FindKey(k))
	{
		if(pData == this)
			return TRUE;
		strOV7Error = "   ";
		return FALSE;
	}
	CHotKeyTrap::Keys2Data.RemoveKey((void*)key);
	key = k;
	CHotKeyTrap::Keys2Data[(void*)key] = this;
	return TRUE;
}

void CHotKeyTrap::SKeyData::GetString(CString& str)
{
	str.Empty();
	if(key & hkCtrl)
		str+="Ctrl + ";
	if(key & hkAlt)
		str+="Alt + ";
	if(key & hkShift)
		str+="Shift + ";
	char buf[30];
	DWORD k = key & 0xFFFF,
		sc = MapVirtualKey(k, 0)<<16;
	if(k < VK_NUMPAD0)
		sc |= 1<<24;
	if(GetKeyNameText(sc, buf, 29))
		str+=buf;
}
