// addinmgriml.h
#pragma once
#include "addinmgr.h"

class AddinGroupReal : public AddinGroup
{
public:
	AddinGroupReal(cstr Name) : AddinGroup(Name), pComGroup(NULL), hItem(NULL) {}
	AddinGroupReal(cstr Name, AddinGroup* p) : AddinGroup(Name, p), pComGroup(NULL), hItem(NULL) {}
	~AddinGroupReal();

	class CIAddinGroup* pComGroup;
	HTREEITEM hItem;

	static AddinGroup* CreateGroup(cstr Name)
	{
		return new AddinGroupReal(Name);
	}
	static void AddAddinToGroup(AddinStore* pStore, AddinGroup* pGroup)
	{
		pGroup->m_Addins.Add(pStore);
	}
	void RemoveAddin(AddinStore* pStore)
	{
		for(DWORD i = 0, s = m_Addins.GetSize(); i<s ;i++)
		{
			if(m_Addins[i] == pStore)
			{
				m_Addins.RemoveAt(i);
				break;
			}
		}
	}
};

struct AddinWndSite
{
	virtual void DestroyWnd() = 0;
	virtual BOOL CreateWnd(Addin* pAddin) = 0;
};

class AddinStoreReal : public AddinStore
{
public:
	AddinStoreReal(Addin* pA, AddinGroup* pG) : AddinStore(pA, pG)
	{
		pComAddin = NULL;
		pWndSite = NULL;
		hItem = NULL;
	}
	~AddinStoreReal();
	class CIAddin* pComAddin;
	AddinWndSite* pWndSite;
	HTREEITEM hItem;
};



namespace addin_mgr{

typedef CNoCaseMap<AddinLoader*> LoadersMap;
typedef CNoCaseMap<AddinStore*> AddinIdx;

extern LoadersMap Loaders;
extern AddinIdx idxByUniqueName;
extern AddinIdx idxByFullPath;

static inline cstr GetModeName()
{
	return Addins[1]->GetAddin()->UniqueName();
}


namespace impl{
	BOOL __declspec(selectany) bAddinReload = FALSE;
	AddinGroup* CreateGroup(cstr Name);
	void DoLoadAddins(cstr strFolder, cstr strSection);
	void AddinMgrInit(Addin* pModeAddin);
	void AddinMgrOnWinInit();
	void AddinMgrDone();
	AddinStore* RegisterAddin(Addin* pAddin, AddinGroup* pGroup);
	void UnRegisterAddin(AddinStore* pStore);
}//namespace impl
}//namespace addin_mgr