// enumvariant.hpp
#pragma once

class CEnumVariant : public IEnumVARIANT
{
public:
	CEnumVariant(DWORD dwSize, DWORD dwCurIdx)
	{
		m_dwRef = 1, m_dwSize = dwSize, m_dwCurIdx = dwCurIdx;
		m_pValues = m_dwSize ? new VARIANT[m_dwSize] : NULL;
	}
	~CEnumVariant()
	{
		for(DWORD idx = 0; idx < m_dwSize; idx++)
			VariantClear(m_pValues + idx);
		delete [] m_pValues;
	}
	// IEnumVariant
	STDMETHOD(Next)(ULONG celt, VARIANT* rgVar, ULONG* pCeltFetched)
	{
		if(!rgVar)
			return E_POINTER;
		HRESULT hRes = S_OK;
		DWORD dwMax = m_dwSize - m_dwCurIdx;
		if(celt > dwMax)
			celt = dwMax, hRes = S_FALSE;
		if(pCeltFetched)
			*pCeltFetched = celt;
		for(DWORD idx = 0; idx < celt; idx++)
			VariantCopy(rgVar + idx, m_pValues + m_dwCurIdx++);

		return hRes;
	}
	STDMETHOD(Skip)(ULONG celt)
	{
		m_dwCurIdx += celt;
		if(m_dwCurIdx > m_dwSize)
		{
			m_dwCurIdx = m_dwSize;
			return S_FALSE;
		}
		return S_OK;
	}
	STDMETHOD(Reset)()
	{
		m_dwCurIdx = 0;
		return S_OK;
	}
	STDMETHOD(Clone)(IEnumVARIANT** ppEnum)
	{
		if(!ppEnum)
			return E_POINTER;
		CEnumVariant* pNewEnum = new CEnumVariant(m_dwSize, m_dwCurIdx);
		for(DWORD idx = 0; idx < m_dwSize ; idx++)
			VariantCopy(m_pValues + idx, pNewEnum->m_pValues + idx);
		*ppEnum = pNewEnum;
		return S_OK;
	}

	// IUnknown
	STDMETHOD(QueryInterface)(REFIID riid, void **ppvObject)
	{
		if(!ppvObject)
			return E_POINTER;
		*ppvObject = NULL;
		if(riid == IID_IEnumVARIANT)
			*ppvObject = static_cast<IEnumVARIANT*>(this);
		else if(riid == IID_IUnknown)
			*ppvObject= this;
		else
			return E_NOINTERFACE;
		m_dwRef++;
		return S_OK;
	}
	virtual ULONG STDMETHODCALLTYPE AddRef(){return ++m_dwRef;}
	virtual ULONG STDMETHODCALLTYPE Release()
	{
		ULONG dwRef = m_dwRef;
		if(!--dwRef)
			delete this;
		else
			m_dwRef = dwRef;
		return dwRef;
	}
	
	VARIANT* m_pValues;
	DWORD m_dwSize, m_dwCurIdx, m_dwRef;
};
